/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URL;
import java.util.logging.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import uk.ac.starlink.fits.FitsTableBuilder;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.RowListStarTable;
import uk.ac.starlink.table.RowStore;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.TableSink;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.PipeReaderThread;
import uk.ac.starlink.util.URLUtils;
import uk.ac.starlink.votable.Base64InputStream;
import uk.ac.starlink.votable.BinaryRowStepper;
import uk.ac.starlink.votable.CustomDOMBuilder;
import uk.ac.starlink.votable.Decoder;
import uk.ac.starlink.votable.FieldElement;
import uk.ac.starlink.votable.TableBodies;
import uk.ac.starlink.votable.TableElement;
import uk.ac.starlink.votable.VOStarTable;

class VOTableDOMBuilder
extends CustomDOMBuilder {
    private final ContentHandler basicHandler = new BasicContentHandler();
    private final ContentHandler defaultHandler = new CustomDOMBuilder.DefaultContentHandler();
    private final StoragePolicy storagePolicy;
    private String systemId;
    private TableElement tableEl;
    private static Logger logger = Logger.getLogger("uk.ac.starlink.votable");
    static /* synthetic */ Class class$uk$ac$starlink$votable$VOTableDOMBuilder;

    public VOTableDOMBuilder(StoragePolicy storagePolicy, boolean strict) {
        super(strict);
        this.storagePolicy = storagePolicy;
        this.setCustomHandler(this.basicHandler);
    }

    private static Decoder[] getDecoders(FieldElement[] fields) {
        int ncol = fields.length;
        Decoder[] decoders = new Decoder[ncol];
        int icol = 0;
        while (icol < ncol) {
            decoders[icol] = fields[icol].getDecoder();
            ++icol;
        }
        return decoders;
    }

    private RowStore makeRowStore() {
        return this.storagePolicy.makeRowStore();
    }

    private RowStore makeConfiguredRowStore(FieldElement[] fields) {
        int ncol = fields.length;
        ColumnInfo[] colinfos = new ColumnInfo[ncol];
        int icol = 0;
        while (icol < ncol) {
            colinfos[icol] = new ColumnInfo(VOStarTable.getValueInfo(fields[icol]));
            ++icol;
        }
        RowListStarTable dummyTable = new RowListStarTable(colinfos){

            public long getRowCount() {
                return -1L;
            }
        };
        return this.storagePolicy.makeConfiguredRowStore(dummyTable);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class InlineFITSStreamHandler
    extends CustomDOMBuilder.NullContentHandler {
        final PipeReaderThread reader;
        final Writer out;
        final RowStore rowStore;

        public InlineFITSStreamHandler(String extnum) throws IOException {
            if (extnum != null && !extnum.matches("[0-9]+")) {
                extnum = null;
            }
            String ihdu = extnum;
            this.rowStore = VOTableDOMBuilder.this.makeRowStore();
            this.reader = new PipeReaderThread(this, ihdu){
                private final /* synthetic */ String val$ihdu;
                private final /* synthetic */ InlineFITSStreamHandler this$1;
                {
                    this.this$1 = this$1;
                    this.val$ihdu = val$ihdu;
                }

                protected void doReading(InputStream datain) throws IOException {
                    Base64InputStream in = new Base64InputStream(new BufferedInputStream(datain));
                    RowStore sink = this.this$1.rowStore;
                    new FitsTableBuilder().streamStarTable((InputStream)in, (TableSink)sink, this.val$ihdu);
                }
            };
            OutputStream b64out = this.reader.getOutputStream();
            this.out = new OutputStreamWriter(new BufferedOutputStream(b64out));
            this.reader.start();
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            String tagName = VOTableDOMBuilder.this.getTagName(namespaceURI, localName, qName);
            throw new SAXParseException("Unwelcome child <" + tagName + "> of STREAM", VOTableDOMBuilder.this.getLocator());
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            try {
                this.out.write(ch, start, length);
            }
            catch (IOException e) {
                throw (SAXParseException)new SAXParseException(e.getMessage(), VOTableDOMBuilder.this.getLocator(), e).initCause(e);
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            String tagName = VOTableDOMBuilder.this.getTagName(namespaceURI, localName, qName);
            if ("STREAM".equals(tagName)) {
                VOTableDOMBuilder.this.defaultHandler.endElement(namespaceURI, localName, qName);
                VOTableDOMBuilder.this.setCustomHandler(VOTableDOMBuilder.this.basicHandler);
                try {
                    this.out.close();
                    this.reader.finishReading();
                }
                catch (IOException e) {
                    throw (SAXException)new SAXParseException(e.getMessage(), VOTableDOMBuilder.this.getLocator(), e).initCause(e);
                }
                TableBodies.StarTableTabularData tdata = new TableBodies.StarTableTabularData(this.rowStore.getStarTable());
                VOTableDOMBuilder.this.tableEl.setData(tdata);
            }
        }
    }

    class InlineBinaryStreamHandler
    extends CustomDOMBuilder.NullContentHandler {
        final PipeReaderThread reader;
        final Writer out;
        final RowStore rowStore;

        public InlineBinaryStreamHandler() throws IOException {
            FieldElement[] fields = VOTableDOMBuilder.this.tableEl.getFields();
            Decoder[] decoders = VOTableDOMBuilder.getDecoders(fields);
            this.rowStore = VOTableDOMBuilder.this.makeConfiguredRowStore(fields);
            this.reader = new PipeReaderThread(this, decoders){
                private final /* synthetic */ Decoder[] val$decoders;
                private final /* synthetic */ InlineBinaryStreamHandler this$1;
                {
                    this.this$1 = this$1;
                    this.val$decoders = val$decoders;
                }

                /*
                 * WARNING - void declaration
                 */
                protected void doReading(InputStream datain) throws IOException {
                    Object[] row;
                    BufferedInputStream in = new BufferedInputStream(datain);
                    BinaryRowStepper rstep = new BinaryRowStepper(this.val$decoders, in, "base64");
                    while ((row = rstep.nextRow()) != null) {
                        void var4_4;
                        this.this$1.rowStore.acceptRow((Object[])var4_4);
                    }
                }
            };
            OutputStream b64out = this.reader.getOutputStream();
            this.out = new OutputStreamWriter(new BufferedOutputStream(b64out));
            this.reader.start();
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            String tagName = VOTableDOMBuilder.this.getTagName(namespaceURI, localName, qName);
            throw new SAXParseException("Unwelcome child <" + tagName + "> of STREAM", VOTableDOMBuilder.this.getLocator());
        }

        public void characters(char[] ch, int start, int length) throws SAXException {
            try {
                this.out.write(ch, start, length);
            }
            catch (IOException e) {
                throw (SAXException)new SAXParseException(e.getMessage(), VOTableDOMBuilder.this.getLocator(), e).initCause(e);
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            String tagName = VOTableDOMBuilder.this.getTagName(namespaceURI, localName, qName);
            if ("STREAM".equals(tagName)) {
                VOTableDOMBuilder.this.defaultHandler.endElement(namespaceURI, localName, qName);
                VOTableDOMBuilder.this.setCustomHandler(VOTableDOMBuilder.this.basicHandler);
                try {
                    this.out.close();
                    this.reader.finishReading();
                    this.rowStore.endRows();
                }
                catch (IOException e) {
                    throw (SAXException)new SAXParseException(e.getMessage(), VOTableDOMBuilder.this.getLocator(), e).initCause(e);
                }
                TableBodies.StarTableTabularData tdata = new TableBodies.StarTableTabularData(this.rowStore.getStarTable());
                VOTableDOMBuilder.this.tableEl.setData(tdata);
            }
        }
    }

    class HrefFITSStreamHandler
    extends CustomDOMBuilder.NullContentHandler {
        HrefFITSStreamHandler(String href, String extnum) throws IOException {
            URL url = URLUtils.makeURL(VOTableDOMBuilder.this.systemId, href);
            DataSource datsrc = DataSource.makeDataSource(url);
            datsrc.setPosition(extnum);
            StarTable startab = new FitsTableBuilder().makeStarTable(datsrc, false, VOTableDOMBuilder.this.storagePolicy);
            TableBodies.StarTableTabularData tdata = new TableBodies.StarTableTabularData(startab);
            VOTableDOMBuilder.this.tableEl.setData(tdata);
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            String tagName = VOTableDOMBuilder.this.getTagName(namespaceURI, localName, qName);
            if ("STREAM".equals(tagName)) {
                VOTableDOMBuilder.this.defaultHandler.endElement(namespaceURI, localName, qName);
                VOTableDOMBuilder.this.setCustomHandler(VOTableDOMBuilder.this.basicHandler);
            }
        }
    }

    class HrefBinaryStreamHandler
    extends CustomDOMBuilder.NullContentHandler {
        HrefBinaryStreamHandler(String href, String encoding) {
            URL url = URLUtils.makeURL(VOTableDOMBuilder.this.systemId, href);
            FieldElement[] fields = VOTableDOMBuilder.this.tableEl.getFields();
            TableBodies.HrefBinaryTabularData tdata = new TableBodies.HrefBinaryTabularData(VOTableDOMBuilder.getDecoders(fields), url, encoding);
            VOTableDOMBuilder.this.tableEl.setData(tdata);
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            String tagName = VOTableDOMBuilder.this.getTagName(namespaceURI, localName, qName);
            if ("STREAM".equals(tagName)) {
                VOTableDOMBuilder.this.defaultHandler.endElement(namespaceURI, localName, qName);
                VOTableDOMBuilder.this.setCustomHandler(VOTableDOMBuilder.this.basicHandler);
            }
        }
    }

    class TabledataHandler
    extends CustomDOMBuilder.NullContentHandler {
        final Decoder[] decoders;
        final int ncol;
        StringBuffer cell;
        Object[] row;
        int icol;
        boolean inCell;
        RowStore rowStore;

        TabledataHandler() {
            FieldElement[] fields = VOTableDOMBuilder.this.tableEl.getFields();
            this.ncol = fields.length;
            this.decoders = VOTableDOMBuilder.getDecoders(fields);
            this.rowStore = VOTableDOMBuilder.this.makeConfiguredRowStore(fields);
            this.cell = new StringBuffer();
            Element tabledataEl = (Element)VOTableDOMBuilder.this.getNewestNode();
            String comment = "Invisible data nodes were parsed directly";
            tabledataEl.appendChild(tabledataEl.getOwnerDocument().createComment(comment));
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
            String tagName = VOTableDOMBuilder.this.getTagName(namespaceURI, localName, qName);
            if ("TD".equals(tagName)) {
                this.cell.setLength(0);
                this.inCell = true;
            } else if ("TR".equals(tagName)) {
                this.row = new Object[this.ncol];
                this.icol = 0;
            }
        }

        public void characters(char[] ch, int start, int length) {
            if (this.inCell) {
                this.cell.append(ch, start, length);
            }
        }

        public void ignorableWhitespace(char[] ch, int start, int length) {
            if (this.inCell) {
                this.cell.append(ch, start, length);
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            String tagName = VOTableDOMBuilder.this.getTagName(namespaceURI, localName, qName);
            if (this.inCell && "TD".equals(tagName) && this.icol < this.ncol) {
                this.row[this.icol] = this.cell.length() > 0 ? this.decoders[this.icol].decodeString(this.cell.toString()) : null;
                ++this.icol;
                this.inCell = false;
            } else if ("TR".equals(tagName)) {
                try {
                    this.rowStore.acceptRow(this.row);
                }
                catch (IOException e) {
                    throw new SAXParseException("Error writing to row store", VOTableDOMBuilder.this.getLocator(), e);
                }
            }
            if ("TABLEDATA".equals(tagName)) {
                VOTableDOMBuilder.this.defaultHandler.endElement(namespaceURI, localName, qName);
                VOTableDOMBuilder.this.setCustomHandler(VOTableDOMBuilder.this.basicHandler);
                try {
                    this.rowStore.endRows();
                }
                catch (IOException e) {
                    throw new SAXParseException("Error terminating row store", VOTableDOMBuilder.this.getLocator(), e);
                }
                TableBodies.StarTableTabularData tdata = new TableBodies.StarTableTabularData(this.rowStore.getStarTable());
                VOTableDOMBuilder.this.tableEl.setData(tdata);
            }
        }
    }

    class IgnoreContentHandler
    extends CustomDOMBuilder.NullContentHandler {
        int level;
        String tagName;
        static final /* synthetic */ boolean $assertionsDisabled;

        IgnoreContentHandler(String tagName) {
            this.tagName = tagName;
            this.level = 1;
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
            ++this.level;
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            if (--this.level == 0) {
                if (!$assertionsDisabled && !this.tagName.equals(VOTableDOMBuilder.this.getTagName(namespaceURI, localName, qName))) {
                    throw new AssertionError();
                }
                VOTableDOMBuilder.this.basicHandler.endElement(namespaceURI, localName, qName);
                VOTableDOMBuilder.this.setCustomHandler(VOTableDOMBuilder.this.basicHandler);
            }
        }

        static {
            $assertionsDisabled = !(class$uk$ac$starlink$votable$VOTableDOMBuilder == null ? (class$uk$ac$starlink$votable$VOTableDOMBuilder = VOTableDOMBuilder.class$("uk.ac.starlink.votable.VOTableDOMBuilder")) : class$uk$ac$starlink$votable$VOTableDOMBuilder).desiredAssertionStatus();
        }
    }

    class BasicContentHandler
    extends CustomDOMBuilder.DefaultContentHandler {
        BasicContentHandler() {
        }

        public void startDocument() throws SAXException {
            super.startDocument();
            VOTableDOMBuilder.this.systemId = VOTableDOMBuilder.this.getLocator().getSystemId();
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            super.startElement(namespaceURI, localName, qName, atts);
            String tagName = VOTableDOMBuilder.this.getTagName(namespaceURI, localName, qName);
            if ("TABLE".equals(tagName)) {
                VOTableDOMBuilder.this.tableEl = (TableElement)VOTableDOMBuilder.this.getNewestNode();
            } else if ("DATA".equals(tagName)) {
                if (VOTableDOMBuilder.this.storagePolicy == StoragePolicy.DISCARD) {
                    Node dataNode = VOTableDOMBuilder.this.getNewestNode();
                    dataNode.getParentNode().removeChild(dataNode);
                    VOTableDOMBuilder.this.setCustomHandler(new IgnoreContentHandler(tagName));
                }
            } else if ("TABLEDATA".equals(tagName)) {
                VOTableDOMBuilder.this.setCustomHandler(new TabledataHandler());
            } else if ("STREAM".equals(tagName)) {
                Element parent = (Element)VOTableDOMBuilder.this.getNewestNode().getParentNode();
                String parentName = parent.getTagName();
                String href = VOTableDOMBuilder.this.getAttribute(atts, "href");
                String encoding = VOTableDOMBuilder.this.getAttribute(atts, "encoding");
                try {
                    if (parentName.equals("BINARY")) {
                        if (href != null) {
                            VOTableDOMBuilder.this.setCustomHandler(new HrefBinaryStreamHandler(href, encoding));
                        } else {
                            VOTableDOMBuilder.this.setCustomHandler(new InlineBinaryStreamHandler());
                        }
                    } else if (parentName.equals("FITS")) {
                        String extnum;
                        String string = extnum = parent.hasAttribute("extnum") ? parent.getAttribute("extnum") : null;
                        if (href != null) {
                            VOTableDOMBuilder.this.setCustomHandler(new HrefFITSStreamHandler(href, extnum));
                        } else {
                            VOTableDOMBuilder.this.setCustomHandler(new InlineFITSStreamHandler(extnum));
                        }
                    }
                }
                catch (IOException e) {
                    throw (SAXException)new SAXException("Trouble setting up data handler", e).initCause(e);
                }
            }
        }

        public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
            super.endElement(namespaceURI, localName, qName);
            String tagName = VOTableDOMBuilder.this.getTagName(namespaceURI, localName, qName);
            if ("TABLE".equals(tagName)) {
                VOTableDOMBuilder.this.tableEl = null;
            }
        }
    }
}

