/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable.dom;

import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import uk.ac.starlink.votable.dom.DelegatingDocument;

public class DelegatingNode
implements Node {
    private final Node base_;
    private DelegatingDocument doc_;

    protected DelegatingNode(Node base, DelegatingDocument doc) {
        this.base_ = base;
        this.setDocument(doc);
    }

    DelegatingNode(Node base) {
        this.base_ = base;
    }

    void setDocument(DelegatingDocument doc) {
        if (this.base_ instanceof DelegatingNode && ((DelegatingNode)this.base_).doc_ == this) {
            throw new IllegalArgumentException("Attempt to use delegating node as delegate in same document");
        }
        this.doc_ = doc;
    }

    static Node getBaseNode(Node node, Document doc) {
        if (node == null) {
            return null;
        }
        if (node instanceof DelegatingNode) {
            DelegatingNode dnode = (DelegatingNode)node;
            if (dnode.doc_ == doc || doc == null) {
                return dnode.base_;
            }
            throw new DOMException(4, "Wrong document");
        }
        throw new DOMException(4, "Not a delegating node " + node + " (" + node.getClass().getName() + ")");
    }

    public String getNodeName() {
        return this.base_.getNodeName();
    }

    public String getNodeValue() {
        return this.base_.getNodeValue();
    }

    public void setNodeValue(String nodeValue) {
        this.base_.setNodeValue(nodeValue);
    }

    public short getNodeType() {
        return this.base_.getNodeType();
    }

    public Node getParentNode() {
        return this.doc_.getDelegator(this.base_.getParentNode());
    }

    public NodeList getChildNodes() {
        return this.doc_.createDelegatingNodeList(this.base_.getChildNodes());
    }

    public Node getFirstChild() {
        return this.doc_.getDelegator(this.base_.getFirstChild());
    }

    public Node getLastChild() {
        return this.doc_.getDelegator(this.base_.getLastChild());
    }

    public Node getPreviousSibling() {
        return this.doc_.getDelegator(this.base_.getPreviousSibling());
    }

    public Node getNextSibling() {
        return this.doc_.getDelegator(this.base_.getNextSibling());
    }

    public NamedNodeMap getAttributes() {
        return this.doc_.createDelegatingNamedNodeMap(this.base_.getAttributes());
    }

    public Document getOwnerDocument() {
        return this == this.doc_ ? null : this.doc_;
    }

    public Node insertBefore(Node newChild, Node refChild) {
        Node newChildBase = DelegatingNode.getBaseNode(newChild, this.doc_);
        Node refChildBase = DelegatingNode.getBaseNode(refChild, null);
        return this.doc_.getDelegator(this.base_.insertBefore(newChildBase, refChildBase));
    }

    public Node replaceChild(Node newChild, Node oldChild) {
        Node newChildBase = DelegatingNode.getBaseNode(newChild, this.doc_);
        Node oldChildBase = DelegatingNode.getBaseNode(oldChild, null);
        return this.doc_.getDelegator(this.base_.replaceChild(newChildBase, oldChildBase));
    }

    public Node removeChild(Node oldChild) {
        Node oldChildBase = DelegatingNode.getBaseNode(oldChild, null);
        return this.doc_.getDelegator(this.base_.removeChild(oldChildBase));
    }

    public Node appendChild(Node newChild) {
        Node newChildBase = DelegatingNode.getBaseNode(newChild, this.doc_);
        return this.doc_.getDelegator(this.base_.appendChild(newChildBase));
    }

    public boolean hasChildNodes() {
        return this.base_.hasChildNodes();
    }

    public Node cloneNode(boolean deep) {
        return this.doc_.getDelegator(this.base_.cloneNode(deep));
    }

    public void normalize() {
        this.base_.normalize();
    }

    public boolean isSupported(String feature, String version) {
        return this.base_.isSupported(feature, version);
    }

    public String getNamespaceURI() {
        return this.base_.getNamespaceURI();
    }

    public String getPrefix() {
        return this.base_.getPrefix();
    }

    public void setPrefix(String prefix) {
        this.base_.setPrefix(prefix);
    }

    public String getLocalName() {
        return this.base_.getLocalName();
    }

    public boolean hasAttributes() {
        return this.base_.hasAttributes();
    }
}

