/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable.tools;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.SAXException;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.votable.DataFormat;
import uk.ac.starlink.votable.VOElementFactory;
import uk.ac.starlink.votable.tools.DOMWriter;

public class Copy {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        String outName;
        String cmdname = "votcopy";
        String usage = cmdname + " [-h[elp]]" + " [-disk]" + " [-base name]" + " [-f[ormat] tabledata|binary|fits|none]" + " [<in> [<out>]]";
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        DataFormat format = DataFormat.TABLEDATA;
        File base = null;
        StoragePolicy storagePolicy = StoragePolicy.getDefaultPolicy();
        Iterator it = argList.iterator();
        while (it.hasNext()) {
            String arg = (String)it.next();
            if (arg.equals("-f") || arg.equals("-format")) {
                it.remove();
                if (!it.hasNext()) continue;
                String fname = (String)it.next();
                it.remove();
                if (fname.equalsIgnoreCase("tabledata")) {
                    format = DataFormat.TABLEDATA;
                    continue;
                }
                if (fname.equalsIgnoreCase("fits")) {
                    format = DataFormat.FITS;
                    continue;
                }
                if (fname.equalsIgnoreCase("binary")) {
                    format = DataFormat.BINARY;
                    continue;
                }
                if (fname.equalsIgnoreCase("none")) {
                    format = null;
                    continue;
                }
                System.err.println(usage);
                System.exit(1);
                continue;
            }
            if (arg.equals("-base")) {
                it.remove();
                if (it.hasNext() && base == null) {
                    base = new File((String)it.next());
                    it.remove();
                    continue;
                }
                System.err.println(usage);
                System.exit(1);
                continue;
            }
            if (arg.equals("-disk")) {
                it.remove();
                storagePolicy = StoragePolicy.PREFER_DISK;
                continue;
            }
            if (arg.equals("-h") || arg.equals("-help")) {
                System.out.println(usage);
                System.exit(0);
                continue;
            }
            if (!arg.startsWith("-") || arg.length() <= 1) continue;
            System.err.println(usage);
            System.exit(1);
        }
        String inName = argList.isEmpty() ? "-" : (String)argList.remove(0);
        String string = outName = argList.isEmpty() ? "-" : (String)argList.remove(0);
        if (!argList.isEmpty()) {
            System.err.println(usage);
            System.exit(1);
        }
        String systemId = inName.equals("-") ? "." : inName;
        InputStream in = null;
        OutputStream out = null;
        try {
            in = DataSource.getInputStream(inName);
            out = outName.equals("-") ? System.out : new FileOutputStream(outName);
            in = new BufferedInputStream(in);
            out = new BufferedOutputStream(out);
            Copy.copyVOTable(systemId, in, out, format, storagePolicy, base);
            out.flush();
        }
        catch (IOException e) {
            System.err.println(e.toString());
            System.exit(1);
        }
        catch (SAXException e) {
            System.err.println(e.toString());
            System.exit(1);
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyVOTable(String systemId, InputStream in, OutputStream out, DataFormat format, StoragePolicy policy, File base) throws IOException, SAXException {
        if (format == null) {
            policy = StoragePolicy.DISCARD;
        }
        DOMSource dsrc = new VOElementFactory(policy).transformToDOM(new StreamSource(in, systemId), false);
        DOMWriter writer = new DOMWriter(out, format, base);
        try {
            writer.writeNode(dsrc.getNode());
            Object var9_8 = null;
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            writer.close();
            throw throwable;
        }
        writer.close();
    }
}

