/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.votable.tools;

import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Text;
import uk.ac.starlink.votable.DataFormat;
import uk.ac.starlink.votable.TableElement;
import uk.ac.starlink.votable.VOSerializer;
import uk.ac.starlink.votable.VOStarTable;

class DOMWriter {
    private final BufferedWriter out_;
    private final DataFormat format_;
    private final File base_;
    private static final int INDENT = 2;
    private int iTable_ = 0;
    public static Charset ENCODING;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$uk$ac$starlink$votable$tools$DOMWriter;

    public DOMWriter(OutputStream out, DataFormat format, File base) {
        this.out_ = new BufferedWriter(new OutputStreamWriter(out));
        this.format_ = format;
        this.base_ = base;
    }

    public void close() throws IOException {
        this.out_.write("\n");
        this.out_.flush();
    }

    public void writeNode(Node node) throws IOException {
        if (node instanceof Document) {
            this.writeDocument((Document)node);
        } else if (node instanceof Element) {
            this.writeElement((Element)node);
        } else if (node instanceof Text) {
            this.writeText((Text)node);
        } else if (node instanceof Comment) {
            this.writeComment((Comment)node);
        }
    }

    public void writeDocument(Document doc) throws IOException {
        this.out_.write("<?xml");
        this.out_.write(VOSerializer.formatAttribute("version", "1.0"));
        this.out_.write(VOSerializer.formatAttribute("encoding", ENCODING.name()));
        this.out_.write("?>");
        this.writeElement(doc.getDocumentElement());
    }

    public void writeText(Text text) throws IOException {
        this.out_.write(text.getData());
    }

    public void writeComment(Comment comment) throws IOException {
        this.out_.write("<!-- ");
        this.out_.write(comment.getData());
        this.out_.write("-->");
    }

    public void writeElement(Element el) throws IOException {
        if (el.getTagName().equals("DATA") && el.getParentNode() instanceof TableElement) {
            this.writeData((TableElement)el.getParentNode());
            return;
        }
        ArrayList<Node> children = new ArrayList<Node>();
        int nEl = 0;
        int nOther = 0;
        Node ch = el.getFirstChild();
        while (ch != null) {
            if (ch instanceof Element) {
                ++nEl;
                children.add(ch);
            } else if (ch instanceof Text) {
                ++nOther;
                children.add(ch);
            }
            ch = ch.getNextSibling();
        }
        int level = 0;
        Node ancestor = el.getParentNode();
        while (ancestor instanceof Element) {
            ++level;
            ancestor = ancestor.getParentNode();
        }
        char[] spaces = new char[level * 2];
        Arrays.fill(spaces, ' ');
        String prefix = new String(spaces);
        this.out_.write(10);
        this.out_.write(prefix);
        this.out_.write(60);
        this.out_.write(el.getTagName());
        NamedNodeMap atts = el.getAttributes();
        if (atts != null) {
            int i = 0;
            while (i < atts.getLength()) {
                Attr att = (Attr)atts.item(i);
                this.out_.write(VOSerializer.formatAttribute(att.getName(), att.getValue()));
                ++i;
            }
        }
        if (children.isEmpty()) {
            this.out_.write("/>");
        } else {
            this.out_.write(">");
            Iterator it = children.iterator();
            while (it.hasNext()) {
                this.writeNode((Node)it.next());
            }
            if (nEl > 0) {
                this.out_.write(10);
                this.out_.write(prefix);
            }
            this.out_.write("</");
            this.out_.write(el.getTagName());
            this.out_.write(">");
        }
    }

    private void writeData(TableElement tableEl) throws IOException {
        ++this.iTable_;
        if (this.format_ != null) {
            this.out_.write(10);
            VOStarTable st = new VOStarTable(tableEl);
            VOSerializer vser = VOSerializer.makeSerializer(this.format_, st);
            if (this.base_ == null || this.format_ == DataFormat.TABLEDATA) {
                vser.writeInlineDataElement(this.out_);
            } else {
                String suffix;
                if (this.format_ == DataFormat.FITS) {
                    suffix = ".fits";
                } else if (this.format_ == DataFormat.BINARY) {
                    suffix = ".bin";
                } else {
                    suffix = null;
                    if (!$assertionsDisabled) {
                        throw new AssertionError();
                    }
                }
                File dest = new File(this.base_.getPath() + "-" + this.iTable_ + suffix);
                DataOutputStream dataOut = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(dest)));
                vser.writeHrefDataElement(this.out_, dest.getPath(), dataOut);
                dataOut.flush();
                dataOut.close();
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$uk$ac$starlink$votable$tools$DOMWriter == null ? (class$uk$ac$starlink$votable$tools$DOMWriter = DOMWriter.class$("uk.ac.starlink.votable.tools.DOMWriter")) : class$uk$ac$starlink$votable$tools$DOMWriter).desiredAssertionStatus();
        ENCODING = Charset.forName("UTF-8");
    }
}

