/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ast;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import javax.swing.JFrame;
import javax.swing.JPanel;
import uk.ac.starlink.ast.AstException;
import uk.ac.starlink.ast.AstObject;
import uk.ac.starlink.ast.Frame;
import uk.ac.starlink.ast.FrameSet;
import uk.ac.starlink.ast.Grf;
import uk.ac.starlink.ast.Mapping;
import uk.ac.starlink.ast.grf.DefaultGrf;

public class Plot
extends FrameSet {
    private Grf grfobj;

    public Plot(Frame frame, Rectangle2D graphrect, double[] basebox) {
        this(frame, graphrect, basebox, 0, 0, 0, 0);
    }

    public Plot(Frame frame, Rectangle2D graphrect, double[] basebox, int lgap, int rgap, int bgap, int tgap) {
        if ((double)(lgap + rgap) >= graphrect.getWidth() || lgap < 0 || rgap < 0 || (double)(tgap + bgap) >= graphrect.getHeight() || tgap < 0 || bgap < 0) {
            throw new AstException("Gaps leave no space for the plot");
        }
        float[] graphbox = new float[]{(float)(graphrect.getX() + (double)lgap), (float)(graphrect.getY() + graphrect.getHeight() - (double)bgap), (float)(graphrect.getX() + graphrect.getWidth() - (double)rgap), (float)(graphrect.getY() + (double)tgap)};
        this.construct(frame, graphbox, basebox);
        JFrame toplevel = new JFrame();
        JPanel comp = new JPanel();
        comp.setPreferredSize(new Dimension(graphrect.getBounds().width, graphrect.getBounds().height));
        toplevel.getContentPane().add(comp);
        toplevel.pack();
        comp.getGraphics().setClip(graphrect);
        this.grfobj = new DefaultGrf(comp);
    }

    private native void construct(Frame var1, float[] var2, double[] var3);

    public void paint(Graphics g) {
        this.grfobj.paint(g);
    }

    public void clear() {
        this.grfobj.clear();
    }

    public Grf getGrf() {
        return this.grfobj;
    }

    public void setGrf(Grf grf) {
        this.grfobj = grf;
    }

    public AstObject copy() {
        AstObject copy = super.copy();
        ((Plot)copy).grfobj = this.grfobj;
        return copy;
    }

    public Object clone() {
        Object clone = super.clone();
        ((Plot)clone).grfobj = this.grfobj;
        return clone;
    }

    public native String getC(String var1);

    public native double getD(String var1);

    public native float getF(String var1);

    public native long getL(String var1);

    public native int getI(String var1);

    public native void setC(String var1, String var2);

    public native void setD(String var1, double var2);

    public native void setF(String var1, float var2);

    public native void setL(String var1, long var2);

    public native void setI(String var1, int var2);

    public native boolean test(String var1);

    public native void set(String var1);

    public native void border();

    public native Rectangle2D boundingBox();

    public native void clip(int var1, double[] var2, double[] var3);

    public native void curve(double[] var1, double[] var2);

    public native void genCurve(Mapping var1);

    public native void grid();

    public native void gridLine(int var1, double[] var2, double var3);

    public native void mark(int var1, int var2, double[][] var3, int var4);

    public native void polyCurve(int var1, int var2, double[][] var3);

    public native void text(String var1, double[] var2, float[] var3, String var4);

    public boolean getBorder() {
        return this.getB("Border");
    }

    public void setBorder(boolean border) {
        this.setB("Border", border);
    }

    public boolean getClipOp() {
        return this.getB("ClipOp");
    }

    public void setClipOp(boolean clipOp) {
        this.setB("ClipOp", clipOp);
    }

    public int getColour(String element) {
        if (element == null || element.equals("")) {
            return this.getI("Colour");
        }
        return this.getI("Colour( " + element + ")");
    }

    public void setColour(String element, int colour) {
        if (element == null || element.equals("")) {
            this.setI("Colour", colour);
        } else {
            this.setI("Colour(" + element + ")", colour);
        }
    }

    public void setColour(int colour) {
        this.setI("Colour", colour);
    }

    public boolean getDrawAxes(int axis) {
        int naxes = this.getNaxes();
        if (axis >= 1 && axis <= naxes) {
            return this.getB("DrawAxes(" + axis + ")");
        }
        throw new IndexOutOfBoundsException("axis value " + axis + " is not in the range 1.." + naxes);
    }

    public void setDrawAxes(int axis, boolean drawAxes) {
        int naxes = this.getNaxes();
        if (axis < 1 || axis > naxes) {
            throw new IndexOutOfBoundsException("axis " + axis + " value is not in the range 1.." + naxes);
        }
        this.setB("DrawAxes(" + axis + ")", drawAxes);
    }

    public boolean getDrawAxes() {
        return this.getB("DrawAxes");
    }

    public void setDrawAxes(boolean drawAxes) {
        this.setB("DrawAxes", drawAxes);
    }

    public boolean getDrawTitle() {
        return this.getB("DrawTitle");
    }

    public void setDrawTitle(boolean drawTitle) {
        this.setB("DrawTitle", drawTitle);
    }

    public String getEdge(int axis) {
        int naxes = this.getNaxes();
        if (axis >= 1 && axis <= naxes) {
            return this.getC("Edge(" + axis + ")");
        }
        throw new IndexOutOfBoundsException("axis value " + axis + " is not in the range 1.." + naxes);
    }

    public void setEdge(int axis, String edge) {
        int naxes = this.getNaxes();
        if (axis < 1 || axis > naxes) {
            throw new IndexOutOfBoundsException("axis " + axis + " value is not in the range 1.." + naxes);
        }
        this.setC("Edge(" + axis + ")", edge);
    }

    public boolean getEscape() {
        return this.getB("Escape");
    }

    public void setEscape(boolean escape) {
        this.setB("Escape", escape);
    }

    public int getFont(String element) {
        if (element == null || element.equals("")) {
            return this.getI("Font");
        }
        return this.getI("Font( " + element + ")");
    }

    public void setFont(String element, int font) {
        if (element == null || element.equals("")) {
            this.setI("Font", font);
        } else {
            this.setI("Font(" + element + ")", font);
        }
    }

    public int getFont() {
        return this.getI("Font");
    }

    public void setFont(int font) {
        this.setI("Font", font);
    }

    public double getGap(int axis) {
        int naxes = this.getNaxes();
        if (axis >= 1 && axis <= naxes) {
            return this.getD("Gap(" + axis + ")");
        }
        throw new IndexOutOfBoundsException("axis value " + axis + " is not in the range 1.." + naxes);
    }

    public void setGap(int axis, double gap) {
        int naxes = this.getNaxes();
        if (axis < 1 || axis > naxes) {
            throw new IndexOutOfBoundsException("axis " + axis + " value is not in the range 1.." + naxes);
        }
        this.setD("Gap(" + axis + ")", gap);
    }

    public void setGap(double gap) {
        this.setD("Gap", gap);
    }

    public boolean getGrid() {
        return this.getB("Grid");
    }

    public void setGrid(boolean grid) {
        this.setB("Grid", grid);
    }

    public boolean getInvisible() {
        return this.getB("Invisible");
    }

    public void setInvisible(boolean invisible) {
        this.setB("Invisible", invisible);
    }

    public double getLabelAt(int axis) {
        int naxes = this.getNaxes();
        if (axis >= 1 && axis <= naxes) {
            return this.getD("LabelAt(" + axis + ")");
        }
        throw new IndexOutOfBoundsException("axis value " + axis + " is not in the range 1.." + naxes);
    }

    public void setLabelAt(int axis, double labelAt) {
        int naxes = this.getNaxes();
        if (axis < 1 || axis > naxes) {
            throw new IndexOutOfBoundsException("axis " + axis + " value is not in the range 1.." + naxes);
        }
        this.setD("LabelAt(" + axis + ")", labelAt);
    }

    public boolean getLabelUnits(int axis) {
        int naxes = this.getNaxes();
        if (axis >= 1 && axis <= naxes) {
            return this.getB("LabelUnits(" + axis + ")");
        }
        throw new IndexOutOfBoundsException("axis value " + axis + " is not in the range 1.." + naxes);
    }

    public void setLabelUnits(int axis, boolean labelUnits) {
        int naxes = this.getNaxes();
        if (axis < 1 || axis > naxes) {
            throw new IndexOutOfBoundsException("axis " + axis + " value is not in the range 1.." + naxes);
        }
        this.setB("LabelUnits(" + axis + ")", labelUnits);
    }

    public void setLabelUnits(boolean labelUnits) {
        this.setB("LabelUnits", labelUnits);
    }

    public boolean getLabelUp(int axis) {
        int naxes = this.getNaxes();
        if (axis >= 1 && axis <= naxes) {
            return this.getB("LabelUp(" + axis + ")");
        }
        throw new IndexOutOfBoundsException("axis value " + axis + " is not in the range 1.." + naxes);
    }

    public void setLabelUp(int axis, boolean labelUp) {
        int naxes = this.getNaxes();
        if (axis < 1 || axis > naxes) {
            throw new IndexOutOfBoundsException("axis " + axis + " value is not in the range 1.." + naxes);
        }
        this.setB("LabelUp(" + axis + ")", labelUp);
    }

    public void setLabelUp(boolean labelUp) {
        this.setB("LabelUp", labelUp);
    }

    public String getLabelling() {
        return this.getC("Labelling");
    }

    public void setLabelling(String labelling) {
        this.setC("Labelling", labelling);
    }

    public double getLogGap(int axis) {
        int naxes = this.getNaxes();
        if (axis >= 1 && axis <= naxes) {
            return this.getD("LogGap(" + axis + ")");
        }
        throw new IndexOutOfBoundsException("axis value " + axis + " is not in the range 1.." + naxes);
    }

    public void setLogGap(int axis, double logGap) {
        int naxes = this.getNaxes();
        if (axis < 1 || axis > naxes) {
            throw new IndexOutOfBoundsException("axis " + axis + " value is not in the range 1.." + naxes);
        }
        this.setD("LogGap(" + axis + ")", logGap);
    }

    public void setLogGap(double logGap) {
        this.setD("LogGap", logGap);
    }

    public boolean getLogLabel(int axis) {
        int naxes = this.getNaxes();
        if (axis >= 1 && axis <= naxes) {
            return this.getB("LogLabel(" + axis + ")");
        }
        throw new IndexOutOfBoundsException("axis value " + axis + " is not in the range 1.." + naxes);
    }

    public void setLogLabel(int axis, boolean logLabel) {
        int naxes = this.getNaxes();
        if (axis < 1 || axis > naxes) {
            throw new IndexOutOfBoundsException("axis " + axis + " value is not in the range 1.." + naxes);
        }
        this.setB("LogLabel(" + axis + ")", logLabel);
    }

    public void setLogLabel(boolean logLabel) {
        this.setB("LogLabel", logLabel);
    }

    public boolean getLogPlot(int axis) {
        int naxes = this.getNaxes();
        if (axis >= 1 && axis <= naxes) {
            return this.getB("LogPlot(" + axis + ")");
        }
        throw new IndexOutOfBoundsException("axis value " + axis + " is not in the range 1.." + naxes);
    }

    public void setLogPlot(int axis, boolean logPlot) {
        int naxes = this.getNaxes();
        if (axis < 1 || axis > naxes) {
            throw new IndexOutOfBoundsException("axis " + axis + " value is not in the range 1.." + naxes);
        }
        this.setB("LogPlot(" + axis + ")", logPlot);
    }

    public void setLogPlot(boolean logPlot) {
        this.setB("LogPlot", logPlot);
    }

    public boolean getLogTicks(int axis) {
        int naxes = this.getNaxes();
        if (axis >= 1 && axis <= naxes) {
            return this.getB("LogTicks(" + axis + ")");
        }
        throw new IndexOutOfBoundsException("axis value " + axis + " is not in the range 1.." + naxes);
    }

    public void setLogTicks(int axis, boolean logTicks) {
        int naxes = this.getNaxes();
        if (axis < 1 || axis > naxes) {
            throw new IndexOutOfBoundsException("axis " + axis + " value is not in the range 1.." + naxes);
        }
        this.setB("LogTicks(" + axis + ")", logTicks);
    }

    public void setLogTicks(boolean logTicks) {
        this.setB("LogTicks", logTicks);
    }

    public double getMajTickLen(int axis) {
        int naxes = this.getNaxes();
        if (axis >= 1 && axis <= naxes) {
            return this.getD("MajTickLen(" + axis + ")");
        }
        throw new IndexOutOfBoundsException("axis value " + axis + " is not in the range 1.." + naxes);
    }

    public void setMajTickLen(int axis, double majTickLen) {
        int naxes = this.getNaxes();
        if (axis < 1 || axis > naxes) {
            throw new IndexOutOfBoundsException("axis " + axis + " value is not in the range 1.." + naxes);
        }
        this.setD("MajTickLen(" + axis + ")", majTickLen);
    }

    public void setMajTickLen(double majTickLen) {
        this.setD("MajTickLen", majTickLen);
    }

    public double getMinTickLen(int axis) {
        int naxes = this.getNaxes();
        if (axis >= 1 && axis <= naxes) {
            return this.getD("MinTickLen(" + axis + ")");
        }
        throw new IndexOutOfBoundsException("axis value " + axis + " is not in the range 1.." + naxes);
    }

    public void setMinTickLen(int axis, double minTickLen) {
        int naxes = this.getNaxes();
        if (axis < 1 || axis > naxes) {
            throw new IndexOutOfBoundsException("axis " + axis + " value is not in the range 1.." + naxes);
        }
        this.setD("MinTickLen(" + axis + ")", minTickLen);
    }

    public void setMinTickLen(double minTickLen) {
        this.setD("MinTickLen", minTickLen);
    }

    public int getMinTick(int axis) {
        int naxes = this.getNaxes();
        if (axis >= 1 && axis <= naxes) {
            return this.getI("MinTick(" + axis + ")");
        }
        throw new IndexOutOfBoundsException("axis value " + axis + " is not in the range 1.." + naxes);
    }

    public void setMinTick(int axis, int minTick) {
        int naxes = this.getNaxes();
        if (axis < 1 || axis > naxes) {
            throw new IndexOutOfBoundsException("axis " + axis + " value is not in the range 1.." + naxes);
        }
        this.setI("MinTick(" + axis + ")", minTick);
    }

    public void setMinTick(int minTick) {
        this.setI("MinTick", minTick);
    }

    public boolean getNumLab(int axis) {
        int naxes = this.getNaxes();
        if (axis >= 1 && axis <= naxes) {
            return this.getB("NumLab(" + axis + ")");
        }
        throw new IndexOutOfBoundsException("axis value " + axis + " is not in the range 1.." + naxes);
    }

    public void setNumLab(int axis, boolean numLab) {
        int naxes = this.getNaxes();
        if (axis < 1 || axis > naxes) {
            throw new IndexOutOfBoundsException("axis " + axis + " value is not in the range 1.." + naxes);
        }
        this.setB("NumLab(" + axis + ")", numLab);
    }

    public void setNumLab(boolean numLab) {
        this.setB("NumLab", numLab);
    }

    public double getNumLabGap(int axis) {
        int naxes = this.getNaxes();
        if (axis >= 1 && axis <= naxes) {
            return this.getD("NumLabGap(" + axis + ")");
        }
        throw new IndexOutOfBoundsException("axis value " + axis + " is not in the range 1.." + naxes);
    }

    public void setNumLabGap(int axis, double numLabGap) {
        int naxes = this.getNaxes();
        if (axis < 1 || axis > naxes) {
            throw new IndexOutOfBoundsException("axis " + axis + " value is not in the range 1.." + naxes);
        }
        this.setD("NumLabGap(" + axis + ")", numLabGap);
    }

    public void setNumLabGap(double numLabGap) {
        this.setD("NumLabGap", numLabGap);
    }

    public double getSize(String element) {
        if (element == null || element.equals("")) {
            return this.getD("Size");
        }
        return this.getD("Size( " + element + ")");
    }

    public void setSize(String element, double size) {
        if (element == null || element.equals("")) {
            this.setD("Size", size);
        } else {
            this.setD("Size(" + element + ")", size);
        }
    }

    public double getSize() {
        return this.getD("Size");
    }

    public void setSize(double size) {
        this.setD("Size", size);
    }

    public int getStyle(String element) {
        if (element == null || element.equals("")) {
            return this.getI("Style");
        }
        return this.getI("Style( " + element + ")");
    }

    public void setStyle(String element, int style) {
        if (element == null || element.equals("")) {
            this.setI("Style", style);
        } else {
            this.setI("Style(" + element + ")", style);
        }
    }

    public void setStyle(int style) {
        this.setI("Style", style);
    }

    public boolean getTextLab(int axis) {
        int naxes = this.getNaxes();
        if (axis >= 1 && axis <= naxes) {
            return this.getB("TextLab(" + axis + ")");
        }
        throw new IndexOutOfBoundsException("axis value " + axis + " is not in the range 1.." + naxes);
    }

    public void setTextLab(int axis, boolean textLab) {
        int naxes = this.getNaxes();
        if (axis < 1 || axis > naxes) {
            throw new IndexOutOfBoundsException("axis " + axis + " value is not in the range 1.." + naxes);
        }
        this.setB("TextLab(" + axis + ")", textLab);
    }

    public void setTextLab(boolean textLab) {
        this.setB("TextLab", textLab);
    }

    public double getTextLabGap(int axis) {
        int naxes = this.getNaxes();
        if (axis >= 1 && axis <= naxes) {
            return this.getD("TextLabGap(" + axis + ")");
        }
        throw new IndexOutOfBoundsException("axis value " + axis + " is not in the range 1.." + naxes);
    }

    public void setTextLabGap(int axis, double textLabGap) {
        int naxes = this.getNaxes();
        if (axis < 1 || axis > naxes) {
            throw new IndexOutOfBoundsException("axis " + axis + " value is not in the range 1.." + naxes);
        }
        this.setD("TextLabGap(" + axis + ")", textLabGap);
    }

    public void setTextLabGap(double textLabGap) {
        this.setD("TextLabGap", textLabGap);
    }

    public boolean getTickAll() {
        return this.getB("TickAll");
    }

    public void setTickAll(boolean tickAll) {
        this.setB("TickAll", tickAll);
    }

    public double getTitleGap() {
        return this.getD("TitleGap");
    }

    public void setTitleGap(double titleGap) {
        this.setD("TitleGap", titleGap);
    }

    public double getTol() {
        return this.getD("Tol");
    }

    public void setTol(double tol) {
        this.setD("Tol", tol);
    }

    public double getWidth(String element) {
        if (element == null || element.equals("")) {
            return this.getD("Width");
        }
        return this.getD("Width( " + element + ")");
    }

    public void setWidth(String element, double width) {
        if (element == null || element.equals("")) {
            this.setD("Width", width);
        } else {
            this.setD("Width(" + element + ")", width);
        }
    }

    public void setWidth(double width) {
        this.setD("Width", width);
    }
}

