/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ast.grf;

import java.awt.Graphics2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class DefaultGrfMarker {
    public static final int DOT = 0;
    public static final int CROSS = 1;
    public static final int PLUS = 2;
    public static final int SQUARE = 3;
    public static final int STAR = 4;
    public static final int CIRCLE = 5;
    public static final int DIAMOND = 6;
    public static final int UPTRIANGLE = 7;
    public static final int DOWNTRIANGLE = 8;
    public static final int FILLEDSQUARE = 9;
    public static final int FILLEDCIRCLE = 10;
    public static final int FILLEDDIAMOND = 11;
    public static final int FILLEDUPTRIANGLE = 12;
    public static final int FILLEDDOWNTRIANGLE = 13;
    private static final String[] descriptions = new String[]{"dot", "cross", "plus", "square", "star", "circle", "diamond", "up triangle", "down triangle", "filled square", "filled circle", "filled diamond", "filled up triangle", "filled down triangle"};

    public static void draw(Graphics2D g2, int type, double x, double y, double size) {
        switch (type) {
            case 0: {
                DefaultGrfMarker.drawDot(g2, x, y, size);
                break;
            }
            case 1: {
                DefaultGrfMarker.drawCross(g2, x, y, size);
                break;
            }
            case 2: {
                DefaultGrfMarker.drawPlus(g2, x, y, size);
                break;
            }
            case 3: {
                DefaultGrfMarker.drawSquare(g2, x, y, size, false);
                break;
            }
            case 4: {
                DefaultGrfMarker.drawStar(g2, x, y, size);
                break;
            }
            case 5: {
                DefaultGrfMarker.drawCircle(g2, x, y, size, false);
                break;
            }
            case 6: {
                DefaultGrfMarker.drawDiamond(g2, x, y, size, false);
                break;
            }
            case 7: {
                DefaultGrfMarker.drawTriangle(g2, x, y, size, true, false);
                break;
            }
            case 8: {
                DefaultGrfMarker.drawTriangle(g2, x, y, size, false, false);
                break;
            }
            case 9: {
                DefaultGrfMarker.drawSquare(g2, x, y, size, true);
                break;
            }
            case 10: {
                DefaultGrfMarker.drawCircle(g2, x, y, size, true);
                break;
            }
            case 11: {
                DefaultGrfMarker.drawDiamond(g2, x, y, size, true);
                break;
            }
            case 12: {
                DefaultGrfMarker.drawTriangle(g2, x, y, size, true, true);
                break;
            }
            case 13: {
                DefaultGrfMarker.drawTriangle(g2, x, y, size, false, true);
                break;
            }
            default: {
                DefaultGrfMarker.drawCircle(g2, x, y, size, true);
            }
        }
    }

    public static String getDescription(int type) {
        return descriptions[type];
    }

    public static int getNumMarkers() {
        return descriptions.length;
    }

    protected static void drawDot(Graphics2D g2, double x, double y, double size) {
        DefaultGrfMarker.drawSquare(g2, x, y, 1.0, true);
    }

    protected static void drawCross(Graphics2D g2, double x, double y, double size) {
        double half = size * 0.5 * 0.7071;
        g2.draw(new Line2D.Double(x - half, y + half, x + half, y - half));
        g2.draw(new Line2D.Double(x - half, y - half, x + half, y + half));
    }

    protected static void drawPlus(Graphics2D g2, double x, double y, double size) {
        double half = size * 0.5;
        g2.draw(new Line2D.Double(x - half, y, x + half, y));
        g2.draw(new Line2D.Double(x, y - half, x, y + half));
    }

    protected static void drawSquare(Graphics2D g2, double x, double y, double size, boolean filled) {
        double half = size * 0.5;
        Rectangle2D.Double square = new Rectangle2D.Double(x - half, y - half, size, size);
        g2.draw(square);
        if (filled) {
            g2.fill(square);
        }
    }

    protected static void drawStar(Graphics2D g2, double x, double y, double size) {
        DefaultGrfMarker.drawCross(g2, x, y, size);
        DefaultGrfMarker.drawPlus(g2, x, y, size);
    }

    protected static void drawCircle(Graphics2D g2, double x, double y, double size, boolean filled) {
        double half = size * 0.5;
        Ellipse2D.Double circle = new Ellipse2D.Double(x - half, y - half, size, size);
        g2.draw(circle);
        if (filled) {
            g2.fill(circle);
        }
    }

    protected static void drawDiamond(Graphics2D g2, double x, double y, double size, boolean filled) {
        GeneralPath path = new GeneralPath();
        double half = size * 0.5;
        path.moveTo((float)(x - half), (float)y);
        path.lineTo((float)x, (float)(y - half));
        path.lineTo((float)(x + half), (float)y);
        path.lineTo((float)x, (float)(y + half));
        path.lineTo((float)(x - half), (float)y);
        g2.draw(path);
        if (filled) {
            g2.fill(path);
        }
    }

    protected static void drawTriangle(Graphics2D g2, double x, double y, double size, boolean up, boolean filled) {
        GeneralPath path = new GeneralPath();
        double half = 0.5 * size;
        double quar = 0.5 * half;
        double delt = 0.433 * size;
        if (up) {
            path.moveTo((float)x, (float)(y - half));
            path.lineTo((float)(x - delt), (float)(y + quar));
            path.lineTo((float)(x + delt), (float)(y + quar));
            path.lineTo((float)x, (float)(y - half));
        } else {
            path.moveTo((float)x, (float)(y + half));
            path.lineTo((float)(x + delt), (float)(y - quar));
            path.lineTo((float)(x - delt), (float)(y - quar));
            path.lineTo((float)x, (float)(y + half));
        }
        g2.draw(path);
        if (filled) {
            g2.fill(path);
        }
    }
}

