/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.Complex;
import JSci.maths.ComplexMapping;
import JSci.maths.DoubleVector;
import JSci.maths.IntegerVector;
import JSci.maths.MathDouble;
import JSci.maths.MathInteger;
import JSci.maths.MathVector;
import JSci.maths.VectorDimensionException;
import JSci.maths.algebras.HilbertSpace;
import JSci.maths.algebras.Module;
import JSci.maths.algebras.VectorSpace;
import JSci.maths.fields.Field;
import JSci.maths.fields.Ring;
import JSci.maths.groups.AbelianGroup;

public class ComplexVector
extends MathVector
implements HilbertSpace.Member {
    protected static final int ARRAY_1D = 1;
    protected double[] vectorRe;
    protected double[] vectorIm;

    protected ComplexVector(int n, int n2) {
        super(n);
        this.storageFormat = n2;
    }

    public ComplexVector(int n) {
        this(n, 1);
        this.vectorRe = new double[n];
        this.vectorIm = new double[n];
    }

    public ComplexVector(double[] dArray, double[] dArray2) {
        this(dArray.length, 1);
        this.vectorRe = dArray;
        this.vectorIm = dArray2;
    }

    public ComplexVector(Complex[] complexArray) {
        this(complexArray.length);
        int n = 0;
        while (n < this.N) {
            this.vectorRe[n] = complexArray[n].real();
            this.vectorIm[n] = complexArray[n].imag();
            ++n;
        }
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof ComplexVector && this.N == ((ComplexVector)object).N) {
            ComplexVector complexVector = (ComplexVector)object;
            int n = 0;
            while (n < this.N) {
                if (!complexVector.getComponent(n).equals(this.vectorRe[n], this.vectorIm[n])) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.N);
        int n = 0;
        while (n < this.N - 1) {
            stringBuffer.append(Complex.toString(this.vectorRe[n], this.vectorIm[n]));
            stringBuffer.append(',');
            ++n;
        }
        stringBuffer.append(Complex.toString(this.vectorRe[n], this.vectorIm[n]));
        return stringBuffer.toString();
    }

    public int hashCode() {
        return (int)Math.exp(this.norm());
    }

    public DoubleVector real() {
        return new DoubleVector(this.vectorRe);
    }

    public DoubleVector imag() {
        return new DoubleVector(this.vectorIm);
    }

    public Complex getComponent(int n) {
        if (n >= 0 && n < this.N) {
            return new Complex(this.vectorRe[n], this.vectorIm[n]);
        }
        throw new VectorDimensionException(MathVector.getInvalidComponentMsg(n));
    }

    public void setComponent(int n, Complex complex) {
        if (n < 0 || n >= this.N) {
            throw new VectorDimensionException(MathVector.getInvalidComponentMsg(n));
        }
        this.vectorRe[n] = complex.real();
        this.vectorIm[n] = complex.imag();
    }

    public void setComponent(int n, double d, double d2) {
        if (n < 0 || n >= this.N) {
            throw new VectorDimensionException(MathVector.getInvalidComponentMsg(n));
        }
        this.vectorRe[n] = d;
        this.vectorIm[n] = d2;
    }

    public double norm() {
        double d = this.vectorRe[0] * this.vectorRe[0] + this.vectorIm[0] * this.vectorIm[0];
        int n = 1;
        while (n < this.N) {
            d += this.vectorRe[n] * this.vectorRe[n] + this.vectorIm[n] * this.vectorIm[n];
            ++n;
        }
        return Math.sqrt(d);
    }

    public void normalize() {
        double d = this.norm();
        int n = 0;
        while (n < this.N) {
            int n2 = n;
            this.vectorRe[n2] = this.vectorRe[n2] / d;
            int n3 = n++;
            this.vectorIm[n3] = this.vectorIm[n3] / d;
        }
    }

    public double infNorm() {
        double d = this.vectorRe[0] * this.vectorRe[0] + this.vectorIm[0] * this.vectorIm[0];
        int n = 1;
        while (n < this.N) {
            double d2 = this.vectorRe[n] * this.vectorRe[n] + this.vectorIm[n] * this.vectorIm[n];
            if (d2 > d) {
                d = d2;
            }
            ++n;
        }
        return Math.sqrt(d);
    }

    public AbelianGroup.Member negate() {
        double[] dArray = new double[this.N];
        double[] dArray2 = new double[this.N];
        dArray[0] = -this.vectorRe[0];
        dArray2[0] = -this.vectorIm[0];
        int n = 1;
        while (n < this.N) {
            dArray[n] = -this.vectorRe[n];
            dArray2[n] = -this.vectorIm[n];
            ++n;
        }
        return new ComplexVector(dArray, dArray2);
    }

    public ComplexVector conjugate() {
        double[] dArray = new double[this.N];
        dArray[0] = -this.vectorIm[0];
        int n = 1;
        while (n < this.N) {
            dArray[n] = -this.vectorIm[n];
            ++n;
        }
        return new ComplexVector(this.vectorRe, dArray);
    }

    public AbelianGroup.Member add(AbelianGroup.Member member) {
        if (member instanceof ComplexVector) {
            return this.add((ComplexVector)member);
        }
        if (member instanceof DoubleVector) {
            return this.add((DoubleVector)member);
        }
        if (member instanceof IntegerVector) {
            return this.add((IntegerVector)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public ComplexVector add(ComplexVector complexVector) {
        switch (complexVector.storageFormat) {
            case 1: {
                return this.rawAdd(complexVector);
            }
        }
        if (this.N == complexVector.N) {
            double[] dArray = new double[this.N];
            double[] dArray2 = new double[this.N];
            dArray[0] = this.vectorRe[0] + complexVector.getComponent(0).real();
            dArray2[0] = this.vectorIm[0] + complexVector.getComponent(0).imag();
            int n = 1;
            while (n < this.N) {
                dArray[n] = this.vectorRe[n] + complexVector.getComponent(n).real();
                dArray2[n] = this.vectorIm[n] + complexVector.getComponent(n).imag();
                ++n;
            }
            return new ComplexVector(dArray, dArray2);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    private ComplexVector rawAdd(ComplexVector complexVector) {
        if (this.N == complexVector.N) {
            double[] dArray = new double[this.N];
            double[] dArray2 = new double[this.N];
            dArray[0] = this.vectorRe[0] + complexVector.vectorRe[0];
            dArray2[0] = this.vectorIm[0] + complexVector.vectorIm[0];
            int n = 1;
            while (n < this.N) {
                dArray[n] = this.vectorRe[n] + complexVector.vectorRe[n];
                dArray2[n] = this.vectorIm[n] + complexVector.vectorIm[n];
                ++n;
            }
            return new ComplexVector(dArray, dArray2);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public ComplexVector add(DoubleVector doubleVector) {
        switch (doubleVector.storageFormat) {
            case 1: {
                return this.rawAdd(doubleVector);
            }
        }
        if (this.N == doubleVector.N) {
            double[] dArray = new double[this.N];
            dArray[0] = this.vectorRe[0] + doubleVector.getComponent(0);
            int n = 1;
            while (n < this.N) {
                dArray[n] = this.vectorRe[n] + doubleVector.getComponent(n);
                ++n;
            }
            return new ComplexVector(dArray, this.vectorIm);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    private ComplexVector rawAdd(DoubleVector doubleVector) {
        if (this.N == doubleVector.N) {
            double[] dArray = new double[this.N];
            dArray[0] = this.vectorRe[0] + doubleVector.vector[0];
            int n = 1;
            while (n < this.N) {
                dArray[n] = this.vectorRe[n] + doubleVector.vector[n];
                ++n;
            }
            return new ComplexVector(dArray, this.vectorIm);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public ComplexVector add(IntegerVector integerVector) {
        switch (integerVector.storageFormat) {
            case 1: {
                return this.rawAdd(integerVector);
            }
        }
        if (this.N == integerVector.N) {
            double[] dArray = new double[this.N];
            dArray[0] = this.vectorRe[0] + (double)integerVector.getComponent(0);
            int n = 1;
            while (n < this.N) {
                dArray[n] = this.vectorRe[n] + (double)integerVector.getComponent(n);
                ++n;
            }
            return new ComplexVector(dArray, this.vectorIm);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    private ComplexVector rawAdd(IntegerVector integerVector) {
        if (this.N == integerVector.N) {
            double[] dArray = new double[this.N];
            dArray[0] = this.vectorRe[0] + (double)integerVector.vector[0];
            int n = 1;
            while (n < this.N) {
                dArray[n] = this.vectorRe[n] + (double)integerVector.vector[n];
                ++n;
            }
            return new ComplexVector(dArray, this.vectorIm);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public AbelianGroup.Member subtract(AbelianGroup.Member member) {
        if (member instanceof ComplexVector) {
            return this.subtract((ComplexVector)member);
        }
        if (member instanceof DoubleVector) {
            return this.subtract((DoubleVector)member);
        }
        if (member instanceof IntegerVector) {
            return this.subtract((IntegerVector)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public ComplexVector subtract(ComplexVector complexVector) {
        switch (complexVector.storageFormat) {
            case 1: {
                return this.rawSubtract(complexVector);
            }
        }
        if (this.N == complexVector.N) {
            double[] dArray = new double[this.N];
            double[] dArray2 = new double[this.N];
            dArray[0] = this.vectorRe[0] - complexVector.getComponent(0).real();
            dArray2[0] = this.vectorIm[0] - complexVector.getComponent(0).imag();
            int n = 1;
            while (n < this.N) {
                dArray[n] = this.vectorRe[n] - complexVector.getComponent(n).real();
                dArray2[n] = this.vectorIm[n] - complexVector.getComponent(n).imag();
                ++n;
            }
            return new ComplexVector(dArray, dArray2);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    private ComplexVector rawSubtract(ComplexVector complexVector) {
        if (this.N == complexVector.N) {
            double[] dArray = new double[this.N];
            double[] dArray2 = new double[this.N];
            dArray[0] = this.vectorRe[0] - complexVector.vectorRe[0];
            dArray2[0] = this.vectorIm[0] - complexVector.vectorIm[0];
            int n = 1;
            while (n < this.N) {
                dArray[n] = this.vectorRe[n] - complexVector.vectorRe[n];
                dArray2[n] = this.vectorIm[n] - complexVector.vectorIm[n];
                ++n;
            }
            return new ComplexVector(dArray, dArray2);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public ComplexVector subtract(DoubleVector doubleVector) {
        switch (doubleVector.storageFormat) {
            case 1: {
                return this.rawSubtract(doubleVector);
            }
        }
        if (this.N == doubleVector.N) {
            double[] dArray = new double[this.N];
            dArray[0] = this.vectorRe[0] - doubleVector.getComponent(0);
            int n = 1;
            while (n < this.N) {
                dArray[n] = this.vectorRe[n] - doubleVector.getComponent(n);
                ++n;
            }
            return new ComplexVector(dArray, this.vectorIm);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    private ComplexVector rawSubtract(DoubleVector doubleVector) {
        if (this.N == doubleVector.N) {
            double[] dArray = new double[this.N];
            dArray[0] = this.vectorRe[0] - doubleVector.vector[0];
            int n = 1;
            while (n < this.N) {
                dArray[n] = this.vectorRe[n] - doubleVector.vector[n];
                ++n;
            }
            return new ComplexVector(dArray, this.vectorIm);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public ComplexVector subtract(IntegerVector integerVector) {
        switch (integerVector.storageFormat) {
            case 1: {
                return this.rawSubtract(integerVector);
            }
        }
        if (this.N == integerVector.N) {
            double[] dArray = new double[this.N];
            dArray[0] = this.vectorRe[0] - (double)integerVector.getComponent(0);
            int n = 1;
            while (n < this.N) {
                dArray[n] = this.vectorRe[n] - (double)integerVector.getComponent(n);
                ++n;
            }
            return new ComplexVector(dArray, this.vectorIm);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    private ComplexVector rawSubtract(IntegerVector integerVector) {
        if (this.N == integerVector.N) {
            double[] dArray = new double[this.N];
            dArray[0] = this.vectorRe[0] - (double)integerVector.vector[0];
            int n = 1;
            while (n < this.N) {
                dArray[n] = this.vectorRe[n] - (double)integerVector.vector[n];
                ++n;
            }
            return new ComplexVector(dArray, this.vectorIm);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public Module.Member scalarMultiply(Ring.Member member) {
        if (member instanceof Complex) {
            return this.scalarMultiply((Complex)member);
        }
        if (member instanceof MathDouble) {
            return this.scalarMultiply(((MathDouble)member).value());
        }
        if (member instanceof MathInteger) {
            return this.scalarMultiply(((MathInteger)member).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public ComplexVector scalarMultiply(Complex complex) {
        double d = complex.real();
        double d2 = complex.imag();
        double[] dArray = new double[this.N];
        double[] dArray2 = new double[this.N];
        dArray[0] = this.vectorRe[0] * d - this.vectorIm[0] * d2;
        dArray2[0] = this.vectorRe[0] * d2 + this.vectorIm[0] * d;
        int n = 1;
        while (n < this.N) {
            dArray[n] = this.vectorRe[n] * d - this.vectorIm[n] * d2;
            dArray2[n] = this.vectorRe[n] * d2 + this.vectorIm[n] * d;
            ++n;
        }
        return new ComplexVector(dArray, dArray2);
    }

    public ComplexVector scalarMultiply(double d) {
        double[] dArray = new double[this.N];
        double[] dArray2 = new double[this.N];
        dArray[0] = d * this.vectorRe[0];
        dArray2[0] = d * this.vectorIm[0];
        int n = 1;
        while (n < this.N) {
            dArray[n] = d * this.vectorRe[n];
            dArray2[n] = d * this.vectorIm[n];
            ++n;
        }
        return new ComplexVector(dArray, dArray2);
    }

    public VectorSpace.Member scalarDivide(Field.Member member) {
        if (member instanceof Complex) {
            return this.scalarDivide((Complex)member);
        }
        if (member instanceof MathDouble) {
            return this.scalarDivide(((MathDouble)member).value());
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public ComplexVector scalarDivide(Complex complex) {
        double d = complex.real();
        double d2 = complex.imag();
        double[] dArray = new double[this.N];
        double[] dArray2 = new double[this.N];
        if (Math.abs(d) < Math.abs(d2)) {
            double d3 = d / d2;
            double d4 = d * d3 + d2;
            int n = 0;
            while (n < this.N) {
                dArray[n] = (this.vectorRe[n] * d3 + this.vectorIm[n]) / d4;
                dArray2[n] = (this.vectorIm[n] * d3 - this.vectorRe[n]) / d4;
                ++n;
            }
        } else {
            double d5 = d2 / d;
            double d6 = d + d2 * d5;
            int n = 0;
            while (n < this.N) {
                dArray[n] = (this.vectorRe[n] + this.vectorIm[n] * d5) / d6;
                dArray2[n] = (this.vectorIm[n] - this.vectorRe[n] * d5) / d6;
                ++n;
            }
        }
        return new ComplexVector(dArray, dArray2);
    }

    public ComplexVector scalarDivide(double d) {
        double[] dArray = new double[this.N];
        double[] dArray2 = new double[this.N];
        dArray[0] = this.vectorRe[0] / d;
        dArray2[0] = this.vectorIm[0] / d;
        int n = 1;
        while (n < this.N) {
            dArray[n] = this.vectorRe[n] / d;
            dArray2[n] = this.vectorIm[n] / d;
            ++n;
        }
        return new ComplexVector(dArray, dArray2);
    }

    public Complex scalarProduct(HilbertSpace.Member member) {
        if (member instanceof ComplexVector) {
            return this.scalarProduct((ComplexVector)member);
        }
        throw new IllegalArgumentException("Member class not recognised by this method.");
    }

    public Complex scalarProduct(ComplexVector complexVector) {
        switch (complexVector.storageFormat) {
            case 1: {
                return this.rawScalarProduct(complexVector);
            }
        }
        if (this.N == complexVector.N) {
            Complex complex = complexVector.getComponent(0);
            double d = this.vectorRe[0] * complex.real() + this.vectorIm[0] * complex.imag();
            double d2 = this.vectorIm[0] * complex.real() - this.vectorRe[0] * complex.imag();
            int n = 1;
            while (n < this.N) {
                complex = complexVector.getComponent(n);
                d += this.vectorRe[n] * complex.real() + this.vectorIm[n] * complex.imag();
                d2 += this.vectorIm[n] * complex.real() - this.vectorRe[n] * complex.imag();
                ++n;
            }
            return new Complex(d, d2);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    private Complex rawScalarProduct(ComplexVector complexVector) {
        if (this.N == complexVector.N) {
            double d = this.vectorRe[0] * complexVector.vectorRe[0] + this.vectorIm[0] * complexVector.vectorIm[0];
            double d2 = this.vectorIm[0] * complexVector.vectorRe[0] - this.vectorRe[0] * complexVector.vectorIm[0];
            int n = 1;
            while (n < this.N) {
                d += this.vectorRe[n] * complexVector.vectorRe[n] + this.vectorIm[n] * complexVector.vectorIm[n];
                d2 += this.vectorIm[n] * complexVector.vectorRe[n] - this.vectorRe[n] * complexVector.vectorIm[n];
                ++n;
            }
            return new Complex(d, d2);
        }
        throw new VectorDimensionException("Vectors are different sizes.");
    }

    public ComplexVector mapComponents(ComplexMapping complexMapping) {
        Complex[] complexArray = new Complex[this.N];
        complexArray[0] = complexMapping.map(this.vectorRe[0], this.vectorIm[0]);
        int n = 1;
        while (n < this.N) {
            complexArray[n] = complexMapping.map(this.vectorRe[n], this.vectorIm[n]);
            ++n;
        }
        return new ComplexVector(complexArray);
    }
}

