/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.DoubleSquareMatrix;
import JSci.maths.DoubleVector;
import JSci.maths.LinearMath;
import JSci.maths.MaximumIterationsExceededException;

public final class KarhunenLoeve {
    double[][] data;

    public KarhunenLoeve(double[][] dArray) {
        this.setData(dArray);
    }

    public double[][] getProductMatrix() {
        return KarhunenLoeve.getProductMatrix(this.data);
    }

    private static double[][] vectorToSquare(double[] dArray) {
        double[][] dArray2 = new double[dArray.length][dArray.length];
        int n = 0;
        while (n < dArray.length) {
            int n2 = 0;
            while (n2 < dArray.length) {
                dArray2[n2][n] = dArray[n] * dArray[n2];
                ++n2;
            }
            ++n;
        }
        return dArray2;
    }

    private static void add(double[][] dArray, double d, double[][] dArray2) {
        int n = 0;
        while (n < dArray.length) {
            int n2 = 0;
            while (n2 < dArray[n].length) {
                double[] dArray3 = dArray[n];
                int n3 = n2;
                dArray3[n3] = dArray3[n3] + dArray2[n][n2] * d;
                ++n2;
            }
            ++n;
        }
    }

    public static double[][] getProductMatrix(double[][] dArray) {
        double[][] dArray2 = new double[dArray[0].length][dArray[0].length];
        int n = 0;
        while (n < dArray.length) {
            KarhunenLoeve.add(dArray2, 1.0 / (double)dArray.length, KarhunenLoeve.vectorToSquare(dArray[n]));
            ++n;
        }
        return dArray2;
    }

    public static double[][] getProductMatrix(double[] dArray) {
        return KarhunenLoeve.vectorToSquare(dArray);
    }

    public double[][] getData() {
        return this.data;
    }

    public void setData(double[][] dArray) {
        this.data = dArray;
    }

    public double[][] getEigenvectors() throws MaximumIterationsExceededException {
        double[][] dArray = KarhunenLoeve.getProductMatrix(this.data);
        DoubleSquareMatrix doubleSquareMatrix = new DoubleSquareMatrix(dArray);
        DoubleVector[] doubleVectorArray = new DoubleVector[this.data[0].length];
        double[] dArray2 = LinearMath.eigenSolveSymmetric(doubleSquareMatrix, doubleVectorArray);
        KarhunenLoeve.tri(dArray2, doubleVectorArray);
        double[][] dArray3 = new double[doubleVectorArray.length][doubleVectorArray[0].dimension()];
        int n = 0;
        while (n < doubleVectorArray.length) {
            int n2 = 0;
            while (n2 < doubleVectorArray[n].dimension()) {
                dArray3[n][n2] = doubleVectorArray[n].getComponent(n2);
                ++n2;
            }
            ++n;
        }
        return dArray3;
    }

    private static void tri(double[] dArray, DoubleVector[] doubleVectorArray) {
        boolean bl = true;
        while (bl) {
            bl = false;
            int n = 0;
            while (n < dArray.length - 1) {
                if (dArray[n] < dArray[n + 1]) {
                    double d = dArray[n + 1];
                    dArray[n + 1] = dArray[n];
                    dArray[n] = d;
                    bl = true;
                    DoubleVector doubleVector = doubleVectorArray[n + 1];
                    doubleVectorArray[n + 1] = doubleVectorArray[n];
                    doubleVectorArray[n] = doubleVector;
                }
                ++n;
            }
        }
    }
}

