/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ndx;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.logging.Logger;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import uk.ac.starlink.array.AccessMode;
import uk.ac.starlink.array.NDArray;
import uk.ac.starlink.array.NDArrayFactory;
import uk.ac.starlink.ast.AstPackage;
import uk.ac.starlink.ast.FrameSet;
import uk.ac.starlink.ast.xml.XAstReader;
import uk.ac.starlink.ast.xml.XAstWriter;
import uk.ac.starlink.hdx.AbstractHdxFacade;
import uk.ac.starlink.hdx.ElementValidator;
import uk.ac.starlink.hdx.HdxDocument;
import uk.ac.starlink.hdx.HdxException;
import uk.ac.starlink.hdx.HdxFacade;
import uk.ac.starlink.hdx.HdxResourceFactory;
import uk.ac.starlink.hdx.HdxResourceType;
import uk.ac.starlink.hdx.PluginException;
import uk.ac.starlink.ndx.DomNdxImpl;
import uk.ac.starlink.ndx.Ndx;
import uk.ac.starlink.ndx.NdxImpl;
import uk.ac.starlink.ndx.Ndxs;
import uk.ac.starlink.util.SourceReader;
import uk.ac.starlink.util.URLUtils;

public class BridgeNdx
implements Ndx {
    private static Logger logger;
    private final NdxImpl impl;
    private FrameSet ast;
    private String title;
    private String label;
    private String units;
    private Boolean hasEtc;
    private Boolean hasTitle;
    private Boolean hasLabel;
    private Boolean hasUnits;
    private Boolean hasVariance;
    private Boolean hasQuality;
    private Boolean hasWCS;
    private Integer badbits;
    private NDArray image;
    private NDArray variance;
    private NDArray quality;
    protected Document ndxDocumentCache;
    private static final String XMLNAME_IMAGE = "image";
    private static final String XMLNAME_VARIANCE = "variance";
    private static final String XMLNAME_QUALITY = "quality";
    private static final String XMLNAME_TITLE = "title";
    private static final String XMLNAME_LABEL = "label";
    private static final String XMLNAME_UNITS = "units";
    private static final String XMLNAME_BADBITS = "badbits";
    private static final String XMLNAME_WCS = "wcs";
    private static final String XMLNAME_ETC = "etc";
    private static HdxResourceType ndxType;
    static /* synthetic */ Class class$uk$ac$starlink$ndx$BridgeNdx;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$java$lang$Object;

    public BridgeNdx(NdxImpl impl) {
        this.impl = impl;
    }

    public NDArray getImage() {
        if (this.image == null) {
            this.image = this.impl.getImage();
        }
        return this.image;
    }

    public NDArray getVariance() {
        if (!this.hasVariance()) {
            throw new UnsupportedOperationException("No variance component");
        }
        if (this.variance == null) {
            this.variance = this.impl.getVariance();
        }
        return this.variance;
    }

    public NDArray getQuality() {
        if (!this.hasQuality()) {
            throw new UnsupportedOperationException("No quality component");
        }
        if (this.quality == null) {
            this.quality = this.impl.getQuality();
        }
        return this.quality;
    }

    public boolean hasVariance() {
        if (this.hasVariance == null) {
            this.hasVariance = this.impl.hasVariance();
        }
        return this.hasVariance;
    }

    public boolean hasQuality() {
        if (this.hasQuality == null) {
            this.hasQuality = this.impl.hasQuality();
        }
        return this.hasQuality;
    }

    public boolean hasTitle() {
        if (this.hasTitle == null) {
            this.hasTitle = this.impl.hasTitle();
        }
        return this.hasTitle;
    }

    public boolean hasLabel() {
        if (this.hasLabel == null) {
            this.hasLabel = this.impl.hasLabel();
        }
        return this.hasLabel;
    }

    public boolean hasUnits() {
        if (this.hasUnits == null) {
            this.hasUnits = this.impl.hasUnits();
        }
        return this.hasUnits;
    }

    public boolean hasEtc() {
        if (this.hasEtc == null) {
            this.hasEtc = this.impl.hasEtc();
        }
        return this.hasEtc;
    }

    public boolean hasWCS() {
        if (this.hasWCS == null) {
            this.hasWCS = AstPackage.isAvailable() && this.impl.hasWCS();
        }
        return this.hasWCS;
    }

    public String getTitle() {
        if (!this.hasTitle()) {
            throw new UnsupportedOperationException("No title component");
        }
        if (this.title == null) {
            this.title = this.impl.getTitle();
        }
        return this.title;
    }

    public String getLabel() {
        if (!this.hasLabel()) {
            throw new UnsupportedOperationException("No label component");
        }
        if (this.label == null) {
            this.label = this.impl.getLabel();
        }
        return this.label;
    }

    public String getUnits() {
        if (!this.hasUnits()) {
            throw new UnsupportedOperationException("No units component");
        }
        if (this.units == null) {
            this.units = this.impl.getUnits();
        }
        return this.units;
    }

    public Source getEtc() {
        if (!this.hasEtc()) {
            throw new UnsupportedOperationException("No Etc component");
        }
        return this.impl.getEtc();
    }

    public int getBadBits() {
        if (this.badbits == null) {
            this.badbits = new Integer(this.impl.getBadBits());
        }
        return this.badbits;
    }

    public FrameSet getAst() {
        if (!this.hasWCS()) {
            throw new UnsupportedOperationException("No WCS component");
        }
        if (this.ast == null) {
            try {
                Object fsobj = this.impl.getWCS();
                if (fsobj instanceof FrameSet) {
                    this.ast = (FrameSet)fsobj;
                } else if (fsobj instanceof Element) {
                    this.ast = BridgeNdx.makeAst(new DOMSource((Element)fsobj));
                } else if (fsobj instanceof Source) {
                    this.ast = BridgeNdx.makeAst((Source)fsobj);
                } else {
                    logger.warning("Unknown WCS object type " + fsobj);
                }
            }
            catch (IOException e) {
                logger.warning("Error retrieving WCS: " + e);
            }
            if (this.ast == null) {
                this.ast = Ndxs.getDefaultAst(this);
            }
        }
        return this.ast;
    }

    public boolean isPersistent() {
        return !(this.getImage().getURL() == null || this.hasVariance() && this.getVariance().getURL() == null || this.hasQuality() && this.getQuality().getURL() == null);
    }

    private static FrameSet makeAst(Source astsrc) throws IOException {
        Element astnode;
        try {
            astnode = new SourceReader().getElement(astsrc);
        }
        catch (TransformerException e) {
            throw (IOException)new IOException(e.toString()).initCause(e);
        }
        if (astnode instanceof Element && astnode.getNodeName().equals(XMLNAME_WCS)) {
            Element astel = astnode;
            if (astel.getAttribute("encoding").equals("AST-XML")) {
                Node child = astel.getFirstChild();
                while (child != null) {
                    if (child instanceof Element && ((Element)child).getTagName().equals("FrameSet")) {
                        return (FrameSet)new XAstReader().makeAst((Element)child);
                    }
                    child = child.getNextSibling();
                }
                throw new IOException("No <FrameSet> element in <wcs>");
            }
            throw new IOException("Unsupported encoding on <wcs> element");
        }
        throw new IOException("XML does not represent <wcs> element");
    }

    public Source toXML(URL base) {
        try {
            return this.getHdxFacade().getSource(URLUtils.urlToUri((URL)base));
        }
        catch (HdxException ex) {
            throw new PluginException((Exception)((Object)ex));
        }
        catch (MalformedURLException ex) {
            throw new PluginException((Exception)ex);
        }
    }

    public static HdxResourceType getHdxResourceType() {
        return ndxType;
    }

    private Node importNode(Document doc, Node inode) {
        if (inode instanceof DocumentFragment) {
            DocumentFragment onode = doc.createDocumentFragment();
            Node ichild = inode.getFirstChild();
            while (ichild != null) {
                Node ochild = doc.importNode(ichild, true);
                onode.appendChild(ochild);
                ichild = ichild.getNextSibling();
            }
            return onode;
        }
        if (inode instanceof Document) {
            Element rootnode = ((Document)inode).getDocumentElement();
            return doc.importNode(rootnode, true);
        }
        return doc.importNode(inode, true);
    }

    private Element adornDOM(Element ndxEl, HdxDocument doc, URI base) throws MalformedURLException {
        block29: {
            URI baseUri;
            if (base != null) {
                try {
                    String scheme = base.getScheme();
                    String auth = base.getAuthority();
                    String path = base.getPath();
                    if (path == null) {
                        path = "";
                    }
                    path = path.replaceFirst("[^/]*$", "");
                    baseUri = new URI(scheme, auth, path, "", "");
                }
                catch (URISyntaxException e) {
                    baseUri = null;
                }
            } else {
                baseUri = null;
            }
            if (this.hasTitle()) {
                Element titleEl = doc.createElement(XMLNAME_TITLE);
                titleEl.setAttribute("value", this.getTitle());
                ndxEl.appendChild(titleEl);
            }
            if (this.hasLabel()) {
                Element labelEl = doc.createElement(XMLNAME_LABEL);
                labelEl.setAttribute("value", this.getLabel());
                ndxEl.appendChild(labelEl);
            }
            if (this.hasUnits()) {
                Element unitsEl = doc.createElement(XMLNAME_UNITS);
                unitsEl.setAttribute("value", this.getUnits());
                ndxEl.appendChild(unitsEl);
            }
            HdxResourceType type = HdxResourceType.match((String)XMLNAME_IMAGE);
            if (!$assertionsDisabled && type == HdxResourceType.NONE) {
                throw new AssertionError();
            }
            Element imEl = doc.createElement(this.getImage().getHdxFacade(type));
            ndxEl.appendChild(imEl);
            if (this.getImage().getURL() != null) {
                URI iuri = URLUtils.urlToUri((URL)this.getImage().getURL());
                if (baseUri != null) {
                    iuri = baseUri.relativize(iuri);
                }
                imEl.setAttribute("uri", iuri.toString());
            } else {
                Comment imComm = doc.createComment("Image array is virtual");
                imEl.appendChild(imComm);
            }
            if (this.hasVariance()) {
                type = HdxResourceType.match((String)XMLNAME_VARIANCE);
                if (!$assertionsDisabled && type == HdxResourceType.NONE) {
                    throw new AssertionError();
                }
                Element varEl = doc.createElement(this.getVariance().getHdxFacade(type));
                ndxEl.appendChild(varEl);
                if (this.getVariance().getURL() != null) {
                    URI vuri = URLUtils.urlToUri((URL)this.getVariance().getURL());
                    if (baseUri != null) {
                        vuri = baseUri.relativize(vuri);
                    }
                    varEl.setAttribute("uri", vuri.toString());
                } else {
                    Comment varComm = doc.createComment("Variance array is virtual");
                    varEl.appendChild(varComm);
                }
            }
            if (this.hasQuality()) {
                type = HdxResourceType.match((String)XMLNAME_QUALITY);
                if (!$assertionsDisabled && type == HdxResourceType.NONE) {
                    throw new AssertionError();
                }
                Element qualEl = doc.createElement(this.getQuality().getHdxFacade(type));
                ndxEl.appendChild(qualEl);
                if (this.getQuality().getURL() != null) {
                    URI quri = URLUtils.urlToUri((URL)this.getQuality().getURL());
                    if (baseUri != null) {
                        quri = baseUri.relativize(quri);
                    }
                    qualEl.setAttribute("uri", quri.toString());
                } else {
                    Comment qualComm = doc.createComment("Quality array is virtual");
                    qualEl.appendChild(qualComm);
                }
            }
            if (this.getBadBits() != 0) {
                String bbrep = "0x" + Integer.toHexString(this.getBadBits());
                Element bbEl = doc.createElement(XMLNAME_BADBITS);
                bbEl.setAttribute("value", bbrep);
                ndxEl.appendChild(bbEl);
            }
            if (this.hasWCS()) {
                FrameSet wfset = this.getAst();
                Source wcsSource = new XAstWriter().makeSource(wfset);
                try {
                    Node wcsContent = new SourceReader().getDOM(wcsSource);
                    wcsContent = this.importNode((Document)doc, wcsContent);
                    Element wcsEl = doc.createElement(XMLNAME_WCS);
                    wcsEl.setAttribute("encoding", "AST-XML");
                    wcsEl.appendChild(wcsContent);
                    ndxEl.appendChild(wcsEl);
                }
                catch (TransformerException e) {
                    logger.warning("Trouble transforming WCS: " + e.getMessage());
                    ndxEl.appendChild(doc.createComment("Broken WCS"));
                }
            }
            if (!this.hasEtc()) break block29;
            try {
                Source etcSrc = this.getEtc();
                Node etcEl = new SourceReader().getDOM(etcSrc);
                etcEl = this.importNode((Document)doc, etcEl);
                if (etcEl instanceof Element && ((Element)etcEl).getTagName() == XMLNAME_ETC) {
                    ndxEl.appendChild(etcEl);
                    break block29;
                }
                logger.warning("Badly-formed Etc component from impl " + this.impl + "  - not added");
                ndxEl.appendChild(doc.createComment("Broken ETC"));
            }
            catch (TransformerException e) {
                logger.warning("Error transforming Etc component - not added");
                ndxEl.appendChild(doc.createComment("Broken ETC"));
            }
        }
        return ndxEl;
    }

    public HdxFacade getHdxFacade() {
        return new BridgeNdxHdxFacade();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$uk$ac$starlink$ndx$BridgeNdx == null ? (class$uk$ac$starlink$ndx$BridgeNdx = BridgeNdx.class$("uk.ac.starlink.ndx.BridgeNdx")) : class$uk$ac$starlink$ndx$BridgeNdx).desiredAssertionStatus();
        logger = Logger.getLogger("uk.ac.starlink.ndx");
        ndxType = HdxResourceType.newHdxResourceType((String)"ndx");
        if (ndxType == null) {
            throw new PluginException("Ooops: type ndx was already defined");
        }
        try {
            ndxType.registerHdxResourceFactory(new HdxResourceFactory(){
                static final /* synthetic */ boolean $assertionsDisabled;

                public Object getObject(Element el) throws HdxException {
                    String att = el.getAttribute("url");
                    if (!$assertionsDisabled && att == null) {
                        throw new AssertionError();
                    }
                    if (att.length() == 0) {
                        return new BridgeNdx(new DomNdxImpl(el));
                    }
                    return null;
                }

                static {
                    $assertionsDisabled = !(class$uk$ac$starlink$ndx$BridgeNdx == null ? (class$uk$ac$starlink$ndx$BridgeNdx = BridgeNdx.class$("uk.ac.starlink.ndx.BridgeNdx")) : class$uk$ac$starlink$ndx$BridgeNdx).desiredAssertionStatus();
                }
            });
            ndxType.setElementValidator(new ElementValidator(){

                public boolean validateElement(Element el) {
                    Node n = el.getFirstChild();
                    while (n != null) {
                        if (n.getNodeType() != 1) {
                            return false;
                        }
                        HdxResourceType t = HdxResourceType.match((Element)((Element)n));
                        if (t != HdxResourceType.NONE && !t.isValid((Element)n)) {
                            return false;
                        }
                        n = n.getNextSibling();
                    }
                    return true;
                }
            });
            ndxType.setHoistAttribute("uri");
            ndxType.setConstructedClass("uk.ac.starlink.ndx.Ndx");
            HdxResourceFactory hrf = new HdxResourceFactory(){

                public Object getObject(Element el) throws HdxException {
                    try {
                        String url = el.getAttribute("url");
                        if (url == null) {
                            return null;
                        }
                        NDArrayFactory ndaf = new NDArrayFactory();
                        return ndaf.makeNDArray(new URL(url), AccessMode.READ);
                    }
                    catch (MalformedURLException ex) {
                        throw new HdxException("Can't create URL: " + el.getAttribute("url") + " (" + ex + ")");
                    }
                    catch (IOException ex) {
                        throw new HdxException("Unexpectedly failed to read " + el.getAttribute("url") + " (" + ex + ")");
                    }
                }
            };
            String[] subtype = new String[]{XMLNAME_IMAGE, XMLNAME_VARIANCE, XMLNAME_QUALITY};
            int i = 0;
            while (i < subtype.length) {
                HdxResourceType newtype = HdxResourceType.newHdxResourceType((String)subtype[i]);
                if (newtype == null) {
                    throw new PluginException("Ooops: type " + subtype[i] + " already defined");
                }
                newtype.registerHdxResourceFactory(hrf);
                newtype.setHoistAttribute("uri");
                newtype.setElementValidator(new ElementValidator(){

                    public boolean validateElement(Element el) {
                        String uriString = el.getAttribute("uri");
                        if (uriString.length() == 0) {
                            return false;
                        }
                        try {
                            URI uri = new URI(uriString);
                            return true;
                        }
                        catch (URISyntaxException e) {
                            return false;
                        }
                    }
                });
                newtype.setConstructedClass("uk.ac.starlink.array.NDArray");
                ++i;
            }
        }
        catch (HdxException ex) {
            throw new PluginException("Failed to register types!: " + (Object)((Object)ex));
        }
    }

    protected class BridgeNdxHdxFacade
    extends AbstractHdxFacade {
        static final /* synthetic */ boolean $assertionsDisabled;

        protected BridgeNdxHdxFacade() {
        }

        public Object synchronizeElement(Element el, Object memento) throws HdxException {
            if (el.hasChildNodes()) {
                return null;
            }
            if (!el.getTagName().equals(ndxType.xmlName())) {
                throw new HdxException("synchronizeElement given element <" + el.getTagName() + ">, not <" + ndxType.xmlName() + "> as expected");
            }
            try {
                BridgeNdx.this.adornDOM(el, (HdxDocument)el.getOwnerDocument(), null);
                return null;
            }
            catch (MalformedURLException ex) {
                throw new HdxException("Failed to synchronise element (" + ex + ")");
            }
        }

        public Object getObject(Element el) throws HdxException {
            HdxResourceType t = HdxResourceType.match((Element)el);
            if (t == HdxResourceType.NONE) {
                throw new HdxException("getObject was asked to realise an unregistered Type:" + el);
            }
            String tagname = el.getTagName();
            Object ret = null;
            if (t == ndxType) {
                ret = BridgeNdx.this;
            } else if (tagname.equals(BridgeNdx.XMLNAME_IMAGE)) {
                ret = BridgeNdx.this.getImage();
            } else if (tagname.equals(BridgeNdx.XMLNAME_VARIANCE)) {
                ret = BridgeNdx.this.getVariance();
            } else if (tagname.equals(BridgeNdx.XMLNAME_QUALITY)) {
                ret = BridgeNdx.this.getQuality();
            }
            if (!$assertionsDisabled && ret == null) {
                throw new AssertionError((Object)("Ooops: surprising registered type " + t + " in Ndx"));
            }
            if (!($assertionsDisabled || t.getConstructedClass() != (class$java$lang$Object == null ? (class$java$lang$Object = BridgeNdx.class$("java.lang.Object")) : class$java$lang$Object) && t.getConstructedClass().isInstance(ret))) {
                throw new AssertionError();
            }
            return ret;
        }

        public HdxResourceType getHdxResourceType() {
            return BridgeNdx.getHdxResourceType();
        }

        static {
            $assertionsDisabled = !(class$uk$ac$starlink$ndx$BridgeNdx == null ? (class$uk$ac$starlink$ndx$BridgeNdx = BridgeNdx.class$("uk.ac.starlink.ndx.BridgeNdx")) : class$uk$ac$starlink$ndx$BridgeNdx).desiredAssertionStatus();
        }
    }
}

