/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.ndx;

import java.io.IOException;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import uk.ac.starlink.array.NDArray;
import uk.ac.starlink.ast.FrameSet;
import uk.ac.starlink.ast.xml.XAstReader;
import uk.ac.starlink.ndx.BridgeNdx;
import uk.ac.starlink.ndx.MutableNdx;
import uk.ac.starlink.ndx.Ndx;
import uk.ac.starlink.ndx.NdxImpl;
import uk.ac.starlink.ndx.WrapperNdxImpl;

public class DefaultMutableNdx
extends BridgeNdx
implements MutableNdx {
    private int badbits = 0;
    private Element etc = null;
    private FrameSet ast = null;
    private String title = null;
    private String label = null;
    private String units = null;
    private NDArray image = null;
    private NDArray variance = null;
    private NDArray quality = null;
    private boolean astSet = false;
    private boolean imageSet = false;
    private boolean varianceSet = false;
    private boolean qualitySet = false;
    private boolean badbitsSet = false;
    private boolean etcSet = false;
    private boolean titleSet = false;
    private boolean labelSet = false;
    private boolean unitsSet = false;

    public DefaultMutableNdx(NdxImpl impl) {
        super(impl);
    }

    public DefaultMutableNdx(Ndx ndx) {
        this(new WrapperNdxImpl(ndx));
    }

    public DefaultMutableNdx(final NDArray image) {
        this(new NdxImpl(){

            public NDArray getImage() {
                return image;
            }

            public boolean hasVariance() {
                return false;
            }

            public NDArray getVariance() {
                return null;
            }

            public boolean hasQuality() {
                return false;
            }

            public NDArray getQuality() {
                return null;
            }

            public int getBadBits() {
                return 0;
            }

            public boolean hasEtc() {
                return false;
            }

            public Source getEtc() {
                return null;
            }

            public boolean hasTitle() {
                return false;
            }

            public String getTitle() {
                return null;
            }

            public boolean hasLabel() {
                return false;
            }

            public String getLabel() {
                return null;
            }

            public boolean hasUnits() {
                return false;
            }

            public String getUnits() {
                return null;
            }

            public boolean hasWCS() {
                return false;
            }

            public Object getWCS() {
                return null;
            }
        });
        if (image == null) {
            throw new NullPointerException("Null image component not permitted");
        }
    }

    public void setImage(NDArray image) {
        if (image == null) {
            throw new NullPointerException("Null image array not permitted");
        }
        this.imageSet = true;
        this.image = image;
    }

    public NDArray getImage() {
        if (this.imageSet) {
            return this.image;
        }
        return super.getImage();
    }

    public void setVariance(NDArray variance) {
        this.varianceSet = true;
        this.variance = variance;
    }

    public boolean hasVariance() {
        return this.varianceSet ? this.variance != null : super.hasVariance();
    }

    public NDArray getVariance() {
        if (this.varianceSet) {
            if (this.hasVariance()) {
                return this.variance;
            }
            throw new UnsupportedOperationException("No variance component");
        }
        return super.getVariance();
    }

    public void setQuality(NDArray quality) {
        if (quality != null && quality.getType().isFloating()) {
            throw new IllegalArgumentException("Non-integer typed quality array (" + quality.getType() + ") not permitted");
        }
        this.qualitySet = true;
        this.quality = quality;
    }

    public boolean hasQuality() {
        return this.qualitySet ? this.quality != null : super.hasQuality();
    }

    public NDArray getQuality() {
        if (this.qualitySet) {
            if (this.hasQuality()) {
                return this.quality;
            }
            throw new UnsupportedOperationException("No quality component");
        }
        return super.getQuality();
    }

    public void setBadBits(int badbits) {
        this.badbitsSet = true;
        this.badbits = badbits;
    }

    public int getBadBits() {
        return this.badbitsSet ? this.badbits : super.getBadBits();
    }

    public void setTitle(String title) {
        this.titleSet = true;
        this.title = title;
    }

    public boolean hasTitle() {
        return this.titleSet ? this.title != null : super.hasTitle();
    }

    public String getTitle() {
        if (this.titleSet) {
            if (this.hasTitle()) {
                return this.title;
            }
            throw new UnsupportedOperationException("No title component");
        }
        return super.getTitle();
    }

    public void setLabel(String label) {
        this.labelSet = true;
        this.label = label;
    }

    public boolean hasLabel() {
        return this.labelSet ? this.label != null : super.hasLabel();
    }

    public String getLabel() {
        if (this.labelSet) {
            if (this.hasLabel()) {
                return this.label;
            }
            throw new UnsupportedOperationException("No label component");
        }
        return super.getLabel();
    }

    public void setUnits(String units) {
        this.unitsSet = true;
        this.units = units;
    }

    public boolean hasUnits() {
        return this.unitsSet ? this.units != null : super.hasUnits();
    }

    public String getUnits() {
        if (this.unitsSet) {
            if (this.hasUnits()) {
                return this.units;
            }
            throw new UnsupportedOperationException("No units component");
        }
        return super.getUnits();
    }

    public void setWCS(Object wcsob) {
        if (wcsob == null) {
            this.ast = null;
        } else if (wcsob instanceof FrameSet) {
            this.ast = (FrameSet)wcsob;
        } else if (wcsob instanceof Source) {
            Source wcssrc = (Source)wcsob;
            try {
                this.ast = (FrameSet)new XAstReader().makeAst(wcssrc);
            }
            catch (IOException e) {
                throw (RuntimeException)new IllegalArgumentException("Error transforming WCS Source").initCause(e);
            }
        } else {
            throw new IllegalArgumentException("Unsupported object used to set WCS:" + wcsob);
        }
        this.astSet = true;
    }

    public boolean hasWCS() {
        return this.astSet ? this.ast != null : super.hasWCS();
    }

    public FrameSet getAst() {
        if (this.astSet) {
            if (this.hasWCS()) {
                return this.ast;
            }
            throw new UnsupportedOperationException("No WCS component");
        }
        return super.getAst();
    }

    public void setEtc(Node etc) {
        Element etcel = null;
        if (etc instanceof Element) {
            etcel = (Element)etc;
        } else if (etc instanceof Document) {
            etcel = ((Document)etc).getDocumentElement();
        }
        if (etcel == null || !etcel.getTagName().equals("etc")) {
            throw new IllegalArgumentException("Supplied node is not of type <etc>");
        }
        this.etcSet = true;
        this.etc = etcel;
    }

    public boolean hasEtc() {
        return this.etcSet ? this.etc != null : super.hasEtc();
    }

    public Source getEtc() {
        if (this.etcSet) {
            if (this.hasEtc()) {
                return new DOMSource(this.etc);
            }
            throw new UnsupportedOperationException("No Etc component");
        }
        return super.getEtc();
    }
}

