/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.factory;

import java.io.IOException;
import uk.ac.starlink.datanode.factory.DataNodeBuilder;
import uk.ac.starlink.datanode.factory.DocumentDataNodeBuilder;
import uk.ac.starlink.datanode.nodes.DataNode;
import uk.ac.starlink.datanode.nodes.FITSDataNode;
import uk.ac.starlink.datanode.nodes.FITSStreamDataNode;
import uk.ac.starlink.datanode.nodes.NoSuchDataException;
import uk.ac.starlink.datanode.nodes.TarStreamDataNode;
import uk.ac.starlink.datanode.nodes.XMLDocument;
import uk.ac.starlink.datanode.nodes.ZipArchiveDataNode;
import uk.ac.starlink.datanode.nodes.ZipStreamDataNode;
import uk.ac.starlink.util.DataSource;

public class SourceDataNodeBuilder
extends DataNodeBuilder {
    private static SourceDataNodeBuilder instance = new SourceDataNodeBuilder();
    private static DocumentDataNodeBuilder docBuilder = DocumentDataNodeBuilder.getInstance();
    static /* synthetic */ Class class$uk$ac$starlink$util$DataSource;

    public static SourceDataNodeBuilder getInstance() {
        return instance;
    }

    private SourceDataNodeBuilder() {
    }

    public boolean suitable(Class objClass) {
        return (class$uk$ac$starlink$util$DataSource == null ? (class$uk$ac$starlink$util$DataSource = SourceDataNodeBuilder.class$("uk.ac.starlink.util.DataSource")) : class$uk$ac$starlink$util$DataSource).isAssignableFrom(objClass);
    }

    public DataNode buildNode(Object obj) throws NoSuchDataException {
        byte[] magic;
        DataSource datsrc = (DataSource)obj;
        try {
            magic = datsrc.getIntro();
            int minsize = magic.length;
        }
        catch (IOException e) {
            throw new NoSuchDataException(e);
        }
        if (ZipArchiveDataNode.isMagic(magic)) {
            return new ZipStreamDataNode(datsrc);
        }
        if (FITSDataNode.isMagic(magic)) {
            return new FITSStreamDataNode(datsrc);
        }
        if (TarStreamDataNode.isMagic(magic)) {
            return new TarStreamDataNode(datsrc);
        }
        if (XMLDocument.isMagic(magic)) {
            XMLDocument xdoc = new XMLDocument(datsrc);
            return docBuilder.buildNode(xdoc);
        }
        throw new NoSuchDataException("No recognised magic number");
    }

    public String toString() {
        return "SourceDataNodeBuilder(uk.ac.starlink.util.DataSource)";
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

