/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.nodes;

import java.awt.Toolkit;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.Icon;
import uk.ac.starlink.datanode.factory.CreationState;
import uk.ac.starlink.datanode.factory.DataNodeFactory;
import uk.ac.starlink.datanode.nodes.DataNode;
import uk.ac.starlink.datanode.nodes.DataObjectException;
import uk.ac.starlink.datanode.nodes.DataType;
import uk.ac.starlink.datanode.nodes.DetailViewer;
import uk.ac.starlink.datanode.nodes.IconFactory;
import uk.ac.starlink.datanode.nodes.NodeUtil;

public class DefaultDataNode
implements DataNode {
    private static DataNodeFactory defaultChildMaker;
    private String name;
    private String label;
    private String desc;
    private String nodetype = "Data node";
    private DataNodeFactory childMaker;
    private CreationState creator;
    private Object parentObject;
    private short iconID = (short)-32767;
    private Map dataMap = new HashMap();

    public DefaultDataNode() {
    }

    public DefaultDataNode(String name) {
        this();
        this.setName(name);
    }

    public boolean allowsChildren() {
        return false;
    }

    public Iterator getChildIterator() {
        throw new UnsupportedOperationException();
    }

    public Object getParentObject() {
        return this.parentObject;
    }

    public void setParentObject(Object parent) {
        this.parentObject = parent;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public String getLabel() {
        if (this.label != null) {
            return this.label;
        }
        if (this.name != null) {
            return this.name;
        }
        return "<unnamed>";
    }

    protected void setName(String name) {
        this.name = name;
        if (this.label == null && name != null) {
            this.label = name;
            this.setLabel(this.label);
        }
    }

    public String getName() {
        return this.name == null ? "..." : this.name;
    }

    public void setDescription(String desc) {
        this.desc = desc;
    }

    public String getDescription() {
        return this.desc;
    }

    public String getNodeTLA() {
        return "...";
    }

    public String getNodeType() {
        return this.nodetype;
    }

    public String toString() {
        return NodeUtil.toString(this);
    }

    protected void setIconID(short id) {
        this.iconID = id;
    }

    public Icon getIcon() {
        if (this.iconID == -32767) {
            return IconFactory.getIcon(this.allowsChildren() ? (short)102 : 101);
        }
        return IconFactory.getIcon(this.iconID);
    }

    public String getPathSeparator() {
        return ".";
    }

    public String getPathElement() {
        return this.getLabel();
    }

    public void registerDataObject(DataType type, Object data) {
        if (type != null) {
            if (type.getDataClass().isAssignableFrom(data.getClass())) {
                this.dataMap.put(type, data);
            } else {
                throw new ClassCastException("Data object is not a " + type.getDataClass());
            }
        }
    }

    public boolean hasDataObject(DataType type) {
        return this.dataMap.containsKey(type);
    }

    public Object getDataObject(DataType type) throws DataObjectException {
        if (this.hasDataObject(type) && this.dataMap.containsKey(type)) {
            return this.dataMap.get(type);
        }
        throw new IllegalArgumentException("Type " + type + " not known");
    }

    public void configureDetail(DetailViewer dv) {
    }

    public void setChildMaker(DataNodeFactory factory) {
        this.childMaker = factory;
    }

    public DataNodeFactory getChildMaker() {
        if (defaultChildMaker == null) {
            defaultChildMaker = new DataNodeFactory();
        }
        if (this.childMaker == null) {
            this.childMaker = defaultChildMaker;
        }
        return this.childMaker;
    }

    public DataNode makeChild(Object childObj) {
        return this.getChildMaker().makeChildNode(this, childObj);
    }

    public DataNode makeErrorChild(Throwable th) {
        return this.getChildMaker().makeErrorDataNode(this, th);
    }

    public void setCreator(CreationState state) {
        this.creator = state;
    }

    public CreationState getCreator() {
        return this.creator;
    }

    public static void beep() {
        Toolkit.getDefaultToolkit().beep();
    }
}

