/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.nodes;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JPanel;
import uk.ac.starlink.datanode.nodes.ComponentMaker;
import uk.ac.starlink.datanode.nodes.DataNode;
import uk.ac.starlink.datanode.nodes.DataType;
import uk.ac.starlink.datanode.nodes.DefaultDataNode;
import uk.ac.starlink.datanode.nodes.DetailViewer;
import uk.ac.starlink.datanode.nodes.ExceptionComponentMaker;
import uk.ac.starlink.datanode.nodes.NoSuchDataException;
import uk.ac.starlink.datanode.nodes.NodeUtil;
import uk.ac.starlink.datanode.viewers.TextViewer;
import uk.ac.starlink.hds.HDSException;
import uk.ac.starlink.hds.HDSObject;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.FileDataSource;

public class FileDataNode
extends DefaultDataNode {
    private String name;
    private JPanel viewPanel;
    private File file;
    private File parentFile;
    private DataSource datsrc;
    private static boolean showHidden = false;
    private static Map knowndirs = new HashMap();

    public FileDataNode(File file) throws NoSuchDataException {
        block6: {
            this.file = file;
            this.name = file.getName();
            if (this.name.length() == 0) {
                this.name = file.getAbsolutePath();
            }
            this.setLabel(this.name);
            if (!FileDataNode.existsInDirectory(file)) {
                throw new NoSuchDataException("No such file " + file);
            }
            try {
                this.parentFile = file.getCanonicalFile().getParentFile();
            }
            catch (IOException e) {
                this.parentFile = null;
            }
            this.setIconID(file.isDirectory() ? (short)106 : 105);
            if (!file.canRead() || file.isDirectory()) break block6;
            try {
                this.datsrc = new FileDataSource(file);
                this.registerDataObject(DataType.DATA_SOURCE, this.datsrc);
            }
            catch (IOException e) {}
        }
    }

    public FileDataNode(HDSObject hobj) throws NoSuchDataException {
        this(FileDataNode.getTopLevelFile(hobj));
    }

    public boolean allowsChildren() {
        return this.file.isDirectory() && this.file.canRead();
    }

    public Iterator getChildIterator() {
        Iterator<File> it;
        File[] subFiles = this.file.listFiles();
        List<File> files = Arrays.asList(this.file.listFiles());
        if (!showHidden) {
            files = new ArrayList<File>(files);
            it = files.iterator();
            while (it.hasNext()) {
                if (!it.next().isHidden()) continue;
                it.remove();
            }
        }
        Collections.sort(files);
        it = files.iterator();
        return new Iterator(){

            public boolean hasNext() {
                return it.hasNext();
            }

            public Object next() {
                File file = (File)it.next();
                DataNode child = FileDataNode.this.makeChild(file);
                child.setLabel(file.getName());
                return child;
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Object getParentObject() {
        return this.parentFile;
    }

    public String getName() {
        return this.name;
    }

    public String getPathElement() {
        return this.name;
    }

    public String getPathSeparator() {
        return File.separator;
    }

    public String getNodeTLA() {
        return this.file.isDirectory() ? "DIR" : "FILE";
    }

    public String getNodeType() {
        return this.file.isDirectory() ? "Directory" : "File";
    }

    public static void setShowHidden(boolean showHidden) {
        FileDataNode.showHidden = showHidden;
    }

    private static boolean existsInDirectory(File file) {
        boolean here;
        if (file.isDirectory()) {
            here = file.exists();
        } else {
            here = false;
            HashSet<String> knownfiles = null;
            File parent = file.getAbsoluteFile().getParentFile();
            String dirkey = parent.toString();
            if (knowndirs.containsKey(dirkey)) {
                knownfiles = (HashSet<String>)knowndirs.get(dirkey);
                here = knownfiles.contains(file.getName().intern());
            }
            if (!here) {
                String[] flist = parent.list();
                if (flist == null) {
                    return false;
                }
                knownfiles = new HashSet<String>(flist.length);
                int i = 0;
                while (i < flist.length) {
                    knownfiles.add(flist[i]);
                    ++i;
                }
                knowndirs.put(dirkey, knownfiles);
            }
            here = knownfiles.contains(file.getName().intern());
        }
        return here;
    }

    public void configureDetail(DetailViewer dv) {
        block4: {
            dv.addKeyedItem("Size", this.file.length());
            dv.addKeyedItem("Last modified", new Date(this.file.lastModified()).toString());
            dv.addKeyedItem("Read access", this.file.canRead() ? "yes" : "no");
            dv.addKeyedItem("Write access", this.file.canWrite() ? "yes" : "no");
            dv.addKeyedItem("Absolute path", this.file.getAbsolutePath());
            File[] entries = this.file.listFiles();
            if (entries != null) {
                dv.addSeparator();
                dv.addKeyedItem("Number of files", entries.length);
            }
            if (this.datsrc == null) break block4;
            try {
                byte[] intro = this.datsrc.getIntro();
                if (intro.length > 0 && NodeUtil.isASCII(intro)) {
                    dv.addPane("Text view", new ComponentMaker(){

                        public JComponent getComponent() throws IOException {
                            return new TextViewer(FileDataNode.this.datsrc.getInputStream());
                        }
                    });
                }
            }
            catch (IOException e) {
                dv.addPane("Error reading text", new ExceptionComponentMaker(e));
            }
        }
    }

    public boolean equals(Object o) {
        return o != null && this.getClass().equals(o.getClass()) && ((FileDataNode)o).file.equals(this.file);
    }

    public int hashCode() {
        return this.file.hashCode();
    }

    private static File getTopLevelFile(HDSObject hobj) throws NoSuchDataException {
        int level;
        String[] trace = new String[2];
        try {
            level = hobj.hdsTrace(trace);
        }
        catch (HDSException e) {
            throw new NoSuchDataException(e);
        }
        if (level > 1) {
            throw new NoSuchDataException("HDSObject is not at the top of container file");
        }
        return new File(trace[1]);
    }
}

