/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.nodes;

import java.util.Iterator;
import javax.swing.JComponent;
import nom.tam.fits.AsciiTableHDU;
import nom.tam.fits.BasicHDU;
import nom.tam.fits.BinaryTableHDU;
import nom.tam.fits.Header;
import nom.tam.fits.ImageHDU;
import nom.tam.fits.RandomGroupsHDU;
import uk.ac.starlink.datanode.nodes.ComponentMaker;
import uk.ac.starlink.datanode.nodes.DefaultDataNode;
import uk.ac.starlink.datanode.nodes.DetailViewer;
import uk.ac.starlink.datanode.nodes.FITSDataNode;
import uk.ac.starlink.datanode.nodes.NoSuchDataException;
import uk.ac.starlink.datanode.viewers.TextViewer;
import uk.ac.starlink.fits.FitsConstants;

public class HDUDataNode
extends DefaultDataNode {
    private String description;
    private Header header;
    private String hduType;
    private FITSDataNode.ArrayDataMaker hdudata;
    private int hduIndex;

    public HDUDataNode(Header hdr, FITSDataNode.ArrayDataMaker hdudata) throws NoSuchDataException {
        this.header = hdr;
        this.hdudata = hdudata;
        this.hduType = null;
        if (this.hduType == null) {
            try {
                if (AsciiTableHDU.isHeader((Header)hdr)) {
                    this.hduType = "ASCII table";
                }
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.hduType == null && BinaryTableHDU.isHeader((Header)hdr)) {
            this.hduType = "Binary table";
        }
        if (this.hduType == null && RandomGroupsHDU.isHeader((Header)hdr)) {
            this.hduType = "Random Groups";
        }
        if (this.hduType == null && ImageHDU.isHeader((Header)hdr)) {
            this.hduType = hdr.findKey("NAXIS") != null && hdr.getIntValue("NAXIS") > 0 ? "Image" : "Header";
        }
        if (this.hduType == null && BasicHDU.isHeader((Header)hdr)) {
            this.hduType = "Basic HDU";
        }
        if (this.hduType == null) {
            this.hduType = "???";
        }
        this.description = "(" + this.hduType + ")";
        this.setIconID((short)112);
    }

    public boolean allowsChildren() {
        return false;
    }

    public void configureDetail(DetailViewer dv) {
        dv.addKeyedItem("Number of header cards", this.header.getNumberOfCards());
        dv.addKeyedItem("Blocks in header", this.header.getSize() / 2880L);
        dv.addKeyedItem("Blocks of data", FitsConstants.getDataSize((Header)this.header) / 2880L);
        dv.addSeparator();
        dv.addKeyedItem("HDU type", this.hduType);
        dv.addPane("Header cards", new ComponentMaker(){

            public JComponent getComponent() {
                return new TextViewer((Iterator)HDUDataNode.this.header.iterator());
            }
        });
    }

    public String getDescription() {
        return this.description;
    }

    public String getNodeTLA() {
        return "HDU";
    }

    public String getNodeType() {
        return "FITS header+data unit";
    }

    public String getPathSeparator() {
        return ".";
    }

    public String getPathElement() {
        return Integer.toString(this.hduIndex);
    }

    void setHDUIndex(int hduIndex) {
        this.hduIndex = hduIndex;
    }

    public int getHDUIndex() {
        return this.hduIndex;
    }

    protected String getHduType() {
        return this.hduType;
    }

    protected Header getHeader() {
        return this.header;
    }
}

