/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.nodes;

import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import uk.ac.starlink.datanode.nodes.ComponentMaker;
import uk.ac.starlink.datanode.nodes.DefaultDataNode;
import uk.ac.starlink.datanode.nodes.DetailViewer;
import uk.ac.starlink.datanode.nodes.HDSDataNode;
import uk.ac.starlink.datanode.nodes.MetaTable;
import uk.ac.starlink.datanode.nodes.MetamapGroup;
import uk.ac.starlink.datanode.nodes.NoSuchDataException;
import uk.ac.starlink.hds.HDSException;
import uk.ac.starlink.hds.HDSObject;

public class HistoryDataNode
extends DefaultDataNode {
    private HDSObject histobj;
    private HDSObject records;
    private int nrec;
    private String name;
    private String created;

    public HistoryDataNode(HDSObject histobj) throws NoSuchDataException {
        this.histobj = histobj;
        try {
            HDSObject curobj;
            int current;
            HDSObject crobj;
            this.name = histobj.datName();
            this.setLabel(this.name);
            if (!this.name.equals("HISTORY")) {
                throw new NoSuchDataException("Not called HISTORY");
            }
            if (!histobj.datThere("RECORDS")) {
                throw new NoSuchDataException("No RECORDS element");
            }
            this.records = histobj.datFind("RECORDS");
            long[] shape = this.records.datShape();
            if (shape.length != 1) {
                throw new NoSuchDataException("RECORDS object wrong shape");
            }
            if (histobj.datThere("CREATED") && (crobj = histobj.datFind("CREATED")).datShape().length == 0) {
                this.created = crobj.datGet0c();
            }
            this.nrec = (int)shape[0];
            if (histobj.datThere("CURRENT_RECORD") && this.nrec > (current = (curobj = histobj.datFind("CURRENT_RECORD")).datGet0i())) {
                this.nrec = current;
            }
        }
        catch (HDSException e) {
            throw new NoSuchDataException("Error parsing HISTORY object", e);
        }
        this.setIconID((short)115);
    }

    public HistoryDataNode(String path) throws NoSuchDataException {
        this(HDSDataNode.getHDSFromPath(path));
    }

    public String getDescription() {
        return " (" + this.nrec + ")";
    }

    public String getNodeTLA() {
        return "HIS";
    }

    public String getNodeType() {
        return "History component of NDF";
    }

    public String getName() {
        return this.name;
    }

    public boolean allowsChildren() {
        return false;
    }

    public void configureDetail(DetailViewer dv) {
        dv.addKeyedItem("Records", this.nrec);
        if (this.created != null) {
            dv.addKeyedItem("Created", this.created);
        }
        dv.addPane("History records", new ComponentMaker(){

            public JComponent getComponent() throws HDSException {
                HistoryMetamapGroup mmg = new HistoryMetamapGroup(HistoryDataNode.this.records, HistoryDataNode.this.nrec);
                return new MetaTable(mmg);
            }
        });
    }

    private static class HistoryMetamapGroup
    extends MetamapGroup {
        private static List keyOrder = Arrays.asList("ITEM", "DATE", "COMMAND", "USER", "HOST", "DATASET", "TEXT");

        public HistoryMetamapGroup(HDSObject records, int nrec) throws HDSException {
            super(nrec);
            this.setKeyOrder(keyOrder);
            long[] pos = new long[1];
            int i = 0;
            while (i < nrec) {
                this.addEntry(i, "ITEM", Integer.toString(i + 1));
                pos[0] = pos[0] + 1L;
                HDSObject rec = records.datCell(pos);
                int ncomp = rec.datNcomp();
                int j = 0;
                while (j < ncomp) {
                    HDSObject item = rec.datIndex(j + 1);
                    String name = item.datName();
                    long[] shape = item.datShape();
                    if (shape.length == 0) {
                        this.addEntry(i, name, item.datGet0c());
                    } else if (shape.length == 1) {
                        int nline = (int)shape[0];
                        String[] lines = new String[nline];
                        long[] kpos = new long[1];
                        int k = 0;
                        while (k < nline) {
                            kpos[0] = kpos[0] + 1L;
                            HDSObject line = item.datCell(kpos);
                            lines[k] = line.datGet0c();
                            ++k;
                        }
                        this.addEntry(i, name, lines);
                    } else {
                        this.addEntry(i, name, "??");
                    }
                    ++j;
                }
                ++i;
            }
        }
    }
}

