/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.nodes;

import java.io.IOException;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import uk.ac.starlink.datanode.nodes.DetailViewer;
import uk.ac.starlink.datanode.nodes.NoSuchDataException;
import uk.ac.starlink.datanode.nodes.StarTableDataNode;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.jdbc.JDBCStarTable;

public class JDBCDataNode
extends StarTableDataNode {
    private JDBCStarTable jdbcTable;

    public JDBCDataNode(String url) throws NoSuchDataException {
        this(JDBCDataNode.makeJDBCTable(url));
    }

    public JDBCDataNode(JDBCStarTable jdbcTable) throws NoSuchDataException {
        super((StarTable)jdbcTable);
        this.jdbcTable = jdbcTable;
        DescribedValue sqlparam = jdbcTable.getParameterByName("SQL");
        if (sqlparam != null) {
            jdbcTable.getParameters().remove(sqlparam);
        }
    }

    public String getNodeTLA() {
        return "SQL";
    }

    public String getNodeType() {
        return "JDBC table";
    }

    public void configureDetail(DetailViewer dv) {
        dv.addSubHead("Database connection");
        try {
            DatabaseMetaData dbmeta = this.jdbcTable.getConnection().getMetaData();
            dv.addKeyedItem("SQL query", this.jdbcTable.getSql());
            dv.addKeyedItem("URL", dbmeta.getURL());
            dv.addKeyedItem("User", dbmeta.getUserName());
            dv.addKeyedItem("Database name", dbmeta.getDatabaseProductName());
            dv.addKeyedItem("Database version", dbmeta.getDatabaseProductVersion());
            dv.addKeyedItem("Driver name", dbmeta.getDriverName());
            dv.addKeyedItem("Driver version", dbmeta.getDriverVersion());
        }
        catch (SQLException e) {
            dv.logError(e);
        }
        dv.addSeparator();
    }

    private static JDBCStarTable makeJDBCTable(String url) throws NoSuchDataException {
        if (!url.startsWith("jdbc:")) {
            throw new NoSuchDataException("URL " + url + " doesn't start \"jdbc:\"");
        }
        try {
            return (JDBCStarTable)StarTableDataNode.getTableFactory().getJDBCHandler().makeStarTable(url, false);
        }
        catch (IOException e) {
            throw new NoSuchDataException(e);
        }
    }
}

