/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.nodes;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.Icon;
import uk.ac.starlink.array.AccessMode;
import uk.ac.starlink.array.NDShape;
import uk.ac.starlink.ast.FrameSet;
import uk.ac.starlink.datanode.factory.DataNodeFactory;
import uk.ac.starlink.datanode.nodes.DataNode;
import uk.ac.starlink.datanode.nodes.DataObjectException;
import uk.ac.starlink.datanode.nodes.DataType;
import uk.ac.starlink.datanode.nodes.DetailViewer;
import uk.ac.starlink.datanode.nodes.HDSDataNode;
import uk.ac.starlink.datanode.nodes.HistoryDataNode;
import uk.ac.starlink.datanode.nodes.IconFactory;
import uk.ac.starlink.datanode.nodes.NDArrayDataNode;
import uk.ac.starlink.datanode.nodes.NoSuchDataException;
import uk.ac.starlink.datanode.nodes.NodeUtil;
import uk.ac.starlink.datanode.nodes.WCSDataNode;
import uk.ac.starlink.hds.ArrayStructure;
import uk.ac.starlink.hds.HDSException;
import uk.ac.starlink.hds.HDSObject;
import uk.ac.starlink.hds.HDSReference;
import uk.ac.starlink.hds.NDFNdxHandler;
import uk.ac.starlink.ndx.Ndx;
import uk.ac.starlink.ndx.Ndxs;

public class NDFDataNode
extends HDSDataNode {
    private HDSObject ndfobj;
    private NDShape shape;
    private FrameSet wcsFrameSet;
    private DataNodeFactory axisChildMaker;
    private DataNodeFactory ndfChildMaker;
    private Ndx ndx;
    private static final int GRID_FRAME = 1;
    private static final int PIXEL_FRAME = 2;
    private static final int AXIS_FRAME = 3;
    private String name;
    private String title;
    private String label;
    private String units;
    private ArrayStructure dataArray;
    private ArrayStructure varianceArray;
    private ArrayStructure qualityArray;
    private byte qualityBadbits;
    private WCSDataNode wcsComponent;
    private HistoryDataNode historyComponent;
    private HDSObject axes;
    private HDSObject extensions;
    static /* synthetic */ Class class$uk$ac$starlink$datanode$nodes$NDFDataNode;
    static /* synthetic */ Class class$uk$ac$starlink$datanode$nodes$ARYDataNode;

    public NDFDataNode(HDSObject hobj) throws NoSuchDataException {
        super(hobj);
        this.ndfobj = hobj;
        try {
            this.dataArray = this.getArrayComponent("DATA_ARRAY");
            if (this.dataArray == null) {
                throw new NoSuchDataException("This has no DATA_ARRAY component");
            }
            this.name = this.ndfobj.datName();
            this.setLabel(this.name);
            this.shape = this.dataArray.getShape();
            this.varianceArray = this.getArrayComponent("VARIANCE");
            if (this.varianceArray != null && !this.varianceArray.getShape().equals((Object)this.shape)) {
                throw new NoSuchDataException("DATA and VARIANCE components have different shapes");
            }
            if (this.ndfobj.datThere("QUALITY")) {
                try {
                    HDSObject qobj = this.ndfobj.datFind("QUALITY");
                    this.qualityArray = new ArrayStructure(qobj.datFind("QUALITY"));
                    if (qobj.datThere("BADBITS")) {
                        HDSObject qbb = qobj.datFind("BADBITS");
                        this.qualityBadbits = (byte)qbb.datGet0i();
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            if (this.qualityArray != null && !this.qualityArray.getShape().equals((Object)this.shape)) {
                throw new NoSuchDataException("DATA and QUALITY components have different shapes");
            }
            this.title = this.getCharacterComponent("TITLE");
            this.label = this.getCharacterComponent("LABEL");
            this.units = this.getCharacterComponent("UNITS");
            if (this.ndfobj.datThere("AXIS")) {
                HDSObject ax = this.ndfobj.datFind("AXIS");
                this.axes = ax.datShape().length == 1 ? ax : null;
            }
            if (NodeUtil.hasAST() && this.ndfobj.datThere("WCS")) {
                try {
                    DataNode wcsnode = this.makeNDFChild(this.ndfobj.datFind("WCS"));
                    if (!(wcsnode instanceof WCSDataNode)) {
                        throw new NoSuchDataException("Not a WCSDataNode");
                    }
                    this.wcsComponent = (WCSDataNode)wcsnode;
                }
                catch (Exception e) {
                    this.wcsComponent = null;
                }
            }
            if (this.ndfobj.datThere("HISTORY")) {
                DataNode histnode = this.makeNDFChild(this.ndfobj.datFind("HISTORY"));
                this.historyComponent = histnode instanceof HistoryDataNode ? (HistoryDataNode)histnode : null;
            }
            if (this.ndfobj.datThere("MORE")) {
                HDSObject more = this.ndfobj.datFind("MORE");
                this.extensions = more.datStruc() ? more : null;
            }
        }
        catch (HDSException e) {
            throw new NoSuchDataException(e.getMessage());
        }
    }

    public NDFDataNode(File file) throws NoSuchDataException {
        this(HDSDataNode.getHDSFromFile(file));
        this.setLabel(file.getName());
    }

    public NDFDataNode(String path) throws NoSuchDataException {
        this(HDSDataNode.getHDSFromPath(path));
    }

    public boolean allowsChildren() {
        return true;
    }

    public Iterator getChildIterator() {
        ArrayList<DataNode> clist;
        block16: {
            int nChild;
            try {
                nChild = this.ndfobj.datNcomp();
            }
            catch (HDSException e) {
                return Collections.singleton(this.makeErrorChild(e)).iterator();
            }
            clist = new ArrayList<DataNode>(nChild);
            HashSet<String> used = new HashSet<String>(nChild);
            try {
                if (this.title != null) {
                    clist.add(this.makeNDFChild(this.ndfobj.datFind("TITLE")));
                    used.add("TITLE");
                }
                if (this.label != null) {
                    clist.add(this.makeNDFChild(this.ndfobj.datFind("LABEL")));
                    used.add("LABEL");
                }
                if (this.units != null) {
                    clist.add(this.makeNDFChild(this.ndfobj.datFind("UNITS")));
                    used.add("UNITS");
                }
                if (this.dataArray != null) {
                    clist.add(this.makeNDFChild(this.dataArray));
                    used.add("DATA_ARRAY");
                }
                if (this.varianceArray != null) {
                    clist.add(this.makeNDFChild(this.varianceArray));
                    used.add("VARIANCE");
                }
                if (this.qualityArray != null) {
                    clist.add(this.makeNDFChild(this.qualityArray));
                    used.add("QUALITY");
                }
                if (this.wcsComponent != null) {
                    clist.add(this.wcsComponent);
                    used.add("WCS");
                }
                if (this.historyComponent != null) {
                    clist.add(this.historyComponent);
                    used.add("HISTORY");
                }
                if (this.axes != null) {
                    DataNode axnode = this.makeNDFChild(this.ndfobj.datFind("AXIS"));
                    axnode.setChildMaker(this.getAxisChildMaker());
                    clist.add(axnode);
                    used.add("AXIS");
                }
                if (this.extensions != null) {
                    clist.add(this.makeNDFChild(this.ndfobj.datFind("MORE")));
                    used.add("MORE");
                }
                if (used.size() >= nChild) break block16;
                int i = 0;
                while (i < nChild) {
                    HDSObject hobj = this.ndfobj.datIndex(i + 1);
                    if (!used.contains(hobj.datName().toUpperCase())) {
                        clist.add(this.makeNDFChild(hobj));
                    }
                    ++i;
                }
            }
            catch (HDSException e) {
                clist.add(this.makeErrorChild(e));
            }
        }
        return clist.iterator();
    }

    public Icon getIcon() {
        return IconFactory.getIcon((short)107);
    }

    public String getDescription() {
        return NDShape.toString((NDShape)this.shape);
    }

    public String getName() {
        return this.name;
    }

    public String getNodeTLA() {
        return "NDF";
    }

    public String getNodeType() {
        return "NDF data structure";
    }

    public void configureDetail(DetailViewer dv) {
        block10: {
            int ndim = this.shape.getNumDims();
            if (this.title != null) {
                dv.addKeyedItem("Title", this.title);
            }
            if (this.label != null) {
                dv.addKeyedItem("Label", this.label);
            }
            if (this.units != null) {
                dv.addKeyedItem("Units", this.units);
            }
            dv.addSeparator();
            dv.addKeyedItem("Dimensionality", ndim);
            dv.addKeyedItem("Origin", NDShape.toString((long[])this.shape.getOrigin()));
            dv.addKeyedItem("Dimensions", NDShape.toString((long[])this.shape.getDims()));
            dv.addKeyedItem("Pixel bounds", NDArrayDataNode.boundsString(this.shape));
            this.describeArrayInDetailViewer(dv, "Data component", this.dataArray);
            this.describeArrayInDetailViewer(dv, "Variance component", this.varianceArray);
            this.describeArrayInDetailViewer(dv, "Quality component", this.qualityArray);
            if (this.qualityArray != null) {
                dv.addKeyedItem("Badbits flag", Byte.toString(this.qualityBadbits) + " (binary " + Integer.toBinaryString(this.qualityBadbits) + ")");
            }
            if (this.wcsComponent != null) {
                dv.addSubHead("World Coordinate Systems");
                try {
                    int cur = this.getWCS().getCurrent();
                    dv.addKeyedItem("Number of frames", this.getWCS().getNframe());
                    dv.addKeyedItem("Current frame", Integer.toString(cur) + " (" + this.getWCS().getFrame(cur).getDomain() + ")");
                }
                catch (IOException e) {
                    dv.addKeyedItem("Error", e.toString());
                }
            }
            if (this.extensions == null) break block10;
            dv.addSubHead("Extensions");
            try {
                int i = 0;
                while (i < this.extensions.datNcomp()) {
                    HDSObject ext = this.extensions.datIndex(i + 1);
                    dv.addText(ext.datName());
                    ++i;
                }
            }
            catch (HDSException e) {
                dv.addText(e.toString());
            }
        }
    }

    public boolean hasDataObject(DataType dtype) {
        if (dtype == DataType.NDX) {
            return true;
        }
        return super.hasDataObject(dtype);
    }

    public Object getDataObject(DataType dtype) throws DataObjectException {
        if (dtype == DataType.NDX) {
            try {
                return this.getNdx();
            }
            catch (IOException e) {
                throw new DataObjectException(e);
            }
        }
        return super.getDataObject(dtype);
    }

    public byte getQualityBadbits() {
        return this.qualityBadbits;
    }

    private FrameSet getWCS() throws IOException {
        if (this.wcsFrameSet == null) {
            this.wcsFrameSet = Ndxs.getAst((Ndx)this.getNdx());
        }
        return this.wcsFrameSet;
    }

    private Ndx getNdx() throws IOException {
        if (this.ndx == null) {
            URL ndurl;
            try {
                ndurl = new HDSReference(this.ndfobj).getURL();
            }
            catch (HDSException e) {
                ndurl = null;
            }
            try {
                this.ndx = NDFNdxHandler.getInstance().makeNdx(this.ndfobj, ndurl, AccessMode.READ);
            }
            catch (HDSException e) {
                throw (IOException)new IOException(e.getMessage()).initCause(e);
            }
        }
        return this.ndx;
    }

    public boolean isNdx() {
        return true;
    }

    public NDShape getShape() {
        return this.shape;
    }

    private DataNode makeNDFChild(Object childObj) {
        if (this.ndfChildMaker == null) {
            this.ndfChildMaker = new DataNodeFactory(this.getChildMaker());
            this.ndfChildMaker.removeNodeClass(class$uk$ac$starlink$datanode$nodes$NDFDataNode == null ? (class$uk$ac$starlink$datanode$nodes$NDFDataNode = NDFDataNode.class$("uk.ac.starlink.datanode.nodes.NDFDataNode")) : class$uk$ac$starlink$datanode$nodes$NDFDataNode);
        }
        return this.ndfChildMaker.makeChildNode(this, childObj);
    }

    private DataNodeFactory getAxisChildMaker() {
        if (this.axisChildMaker == null) {
            this.axisChildMaker = new DataNodeFactory(this.getChildMaker());
            this.axisChildMaker.removeNodeClass(class$uk$ac$starlink$datanode$nodes$NDFDataNode == null ? (class$uk$ac$starlink$datanode$nodes$NDFDataNode = NDFDataNode.class$("uk.ac.starlink.datanode.nodes.NDFDataNode")) : class$uk$ac$starlink$datanode$nodes$NDFDataNode);
            this.axisChildMaker.removeNodeClass(class$uk$ac$starlink$datanode$nodes$ARYDataNode == null ? (class$uk$ac$starlink$datanode$nodes$ARYDataNode = NDFDataNode.class$("uk.ac.starlink.datanode.nodes.ARYDataNode")) : class$uk$ac$starlink$datanode$nodes$ARYDataNode);
        }
        return this.axisChildMaker;
    }

    private void describeArrayInDetailViewer(DetailViewer dv, String name, ArrayStructure ary) {
        if (ary != null) {
            dv.addSubHead(name);
            dv.addKeyedItem("Type", ary.getType());
            dv.addKeyedItem("Variant", ary.getStorage());
        }
    }

    private String getCharacterComponent(String name) throws NoSuchDataException {
        try {
            HDSObject comp;
            if (this.ndfobj.datThere(name) && (comp = this.ndfobj.datFind(name)).datShape().length == 0 && comp.datType().startsWith("_CHAR")) {
                return comp.datGet0c();
            }
            return null;
        }
        catch (HDSException e) {
            throw new NoSuchDataException(e.getMessage());
        }
    }

    private ArrayStructure getArrayComponent(String name) throws NoSuchDataException {
        try {
            if (this.ndfobj.datThere(name)) {
                return new ArrayStructure(this.ndfobj.datFind(name));
            }
            return null;
        }
        catch (HDSException e) {
            throw new NoSuchDataException(e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

