/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.nodes;

import java.io.IOException;
import nom.tam.fits.AsciiTable;
import nom.tam.fits.AsciiTableHDU;
import nom.tam.fits.BinaryTable;
import nom.tam.fits.BinaryTableHDU;
import nom.tam.fits.FitsException;
import nom.tam.fits.Header;
import nom.tam.fits.TableData;
import nom.tam.util.ArrayDataInput;
import uk.ac.starlink.datanode.nodes.DataObjectException;
import uk.ac.starlink.datanode.nodes.DataType;
import uk.ac.starlink.datanode.nodes.FITSDataNode;
import uk.ac.starlink.datanode.nodes.HDUDataNode;
import uk.ac.starlink.datanode.nodes.NoSuchDataException;
import uk.ac.starlink.fits.FitsTableBuilder;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.util.DataSource;

public class TableHDUDataNode
extends HDUDataNode {
    private String hduType;
    private TableData tdata;
    private String description;
    private Header header;
    private FITSDataNode.ArrayDataMaker hdudata;
    private StarTable starTable;

    public TableHDUDataNode(Header header, FITSDataNode.ArrayDataMaker hdudata) throws NoSuchDataException {
        super(header, hdudata);
        this.header = header;
        this.hdudata = hdudata;
        this.hduType = this.getHduType();
        try {
            String type;
            if (BinaryTableHDU.isHeader((Header)header)) {
                this.tdata = new BinaryTable(header);
                type = "Binary";
            } else if (AsciiTableHDU.isHeader((Header)header)) {
                this.tdata = new AsciiTable(header);
                type = "ASCII";
            } else {
                throw new NoSuchDataException("Not a table");
            }
            int ncols = header.getIntValue("TFIELDS");
            int nrows = header.getIntValue("NAXIS2");
            this.description = type + " table (" + ncols + "x" + nrows + ")";
        }
        catch (FitsException e) {
            throw new NoSuchDataException(e);
        }
        this.setIconID((short)117);
    }

    public synchronized StarTable getStarTable() throws IOException {
        if (this.starTable == null) {
            try {
                ArrayDataInput istrm = this.hdudata.getArrayData();
                DataSource datsrc = this.hdudata.getDataSource();
                long offset = this.hdudata.getOffset();
                this.starTable = FitsTableBuilder.attemptReadTable((ArrayDataInput)istrm, (boolean)true, (DataSource)datsrc, (long[])new long[]{offset});
            }
            catch (FitsException e) {
                throw (IOException)new IOException(e.getMessage()).initCause(e);
            }
        }
        return this.starTable;
    }

    public boolean isStarTable() {
        return true;
    }

    public boolean allowsChildren() {
        return false;
    }

    public String getDescription() {
        return this.description;
    }

    public String getNodeTLA() {
        return "TBL";
    }

    public String getNodeType() {
        return "FITS Table HDU";
    }

    public boolean hasDataObject(DataType dtype) {
        if (dtype == DataType.TABLE) {
            return true;
        }
        return super.hasDataObject(dtype);
    }

    public Object getDataObject(DataType dtype) throws DataObjectException {
        if (dtype == DataType.TABLE) {
            try {
                return this.getStarTable();
            }
            catch (IOException e) {
                throw new DataObjectException(e);
            }
        }
        return super.getDataObject(dtype);
    }
}

