/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.nodes;

import java.io.IOException;
import java.util.Iterator;
import org.apache.tools.tar.TarEntry;
import uk.ac.starlink.datanode.nodes.DefaultDataNode;
import uk.ac.starlink.datanode.nodes.DetailViewer;
import uk.ac.starlink.datanode.nodes.TarStreamDataNode;

public class TarBranchDataNode
extends DefaultDataNode {
    private TarStreamDataNode archivenode;
    private String path;
    private String name;

    public TarBranchDataNode(TarStreamDataNode tarnode, TarEntry entry) {
        this.archivenode = tarnode;
        this.path = entry.getName();
        this.name = this.path.substring(this.path.substring(0, this.path.length() - 1).lastIndexOf(47) + 1);
        if (this.name.endsWith("/")) {
            this.name = this.name.substring(0, this.name.length() - 1);
        }
        this.setLabel(this.name);
        this.setIconID((short)133);
    }

    public String getName() {
        return this.name;
    }

    public String getPathElement() {
        return this.name;
    }

    public String getPathSeparator() {
        return "/";
    }

    public String getNodeTLA() {
        return "TRD";
    }

    public String getNodeType() {
        return "Directory in Tar archive";
    }

    public boolean allowsChildren() {
        return true;
    }

    public Iterator getChildIterator() {
        return this.archivenode.getChildIteratorAtLevel(this.path, this);
    }

    public void configureDetail(DetailViewer dv) {
        try {
            int nent = this.archivenode.getEntriesAtLevel(this.path).size();
            dv.addKeyedItem("Number of entries", nent);
        }
        catch (IOException e) {}
    }
}

