/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.nodes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import uk.ac.starlink.datanode.factory.DataNodeFactory;
import uk.ac.starlink.datanode.factory.VODataNodeBuilder;
import uk.ac.starlink.datanode.nodes.ComponentMaker;
import uk.ac.starlink.datanode.nodes.DataNode;
import uk.ac.starlink.datanode.nodes.DefaultDataNode;
import uk.ac.starlink.datanode.nodes.DetailViewer;
import uk.ac.starlink.datanode.nodes.MetaTable;
import uk.ac.starlink.datanode.nodes.MetamapGroup;
import uk.ac.starlink.datanode.nodes.NoSuchDataException;
import uk.ac.starlink.datanode.viewers.TextViewer;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.UCD;
import uk.ac.starlink.util.DOMUtils;
import uk.ac.starlink.votable.ParamElement;
import uk.ac.starlink.votable.TableElement;
import uk.ac.starlink.votable.VOElement;
import uk.ac.starlink.votable.VOElementFactory;

public class VOComponentDataNode
extends DefaultDataNode {
    private static Set voTagNames = new HashSet<String>(Arrays.asList("VOTABLE", "RESOURCE", "DESCRIPTION", "DEFINITIONS", "INFO", "PARAM", "TABLE", "FIELD", "VALUES", "MIN", "MAX", "OPTION", "LINK", "DATA", "TABLEDATA", "TR", "TD", "BINARY", "FITS", "STREAM", "COOSYS", "GROUP", "FIELDref", "PARAMref"));
    protected final VOElement vocel;
    protected final String systemId;
    private String name;
    private Object parentObj;
    private TableElement[] tables;
    private StarTable startable;
    private static VOElementFactory vofact = new VOElementFactory();

    public VOComponentDataNode(Source xsrc) throws NoSuchDataException {
        try {
            this.vocel = vofact.makeVOElement(xsrc);
        }
        catch (SAXException e) {
            throw new NoSuchDataException(e);
        }
        catch (IOException e) {
            throw new NoSuchDataException(e);
        }
        this.systemId = xsrc.getSystemId();
        if (!voTagNames.contains(this.vocel.getTagName())) {
            throw new NoSuchDataException("Not a known VOTable element");
        }
        String idval = this.vocel.getAttribute("ID");
        String nameval = this.vocel.getAttribute("name");
        this.name = this.vocel.getHandle();
        this.parentObj = VOComponentDataNode.getSource(this.vocel.getParent());
        this.setLabel(this.name);
        this.setIconID((short)141);
    }

    protected VOComponentDataNode(Source xsrc, String elname) throws NoSuchDataException {
        this(xsrc);
        if (!this.vocel.getTagName().equals(elname)) {
            throw new NoSuchDataException("Not a " + elname + " element");
        }
    }

    public String getName() {
        return this.name;
    }

    public String getNodeTLA() {
        return "VOC";
    }

    public String getNodeType() {
        return "VOTable component";
    }

    public String getPathSeparator() {
        return ".";
    }

    public Object getParentObject() {
        return this.parentObj;
    }

    public String getDescription() {
        return "";
    }

    public DataNodeFactory getChildMaker() {
        DataNodeFactory dfact = super.getChildMaker();
        if (!(dfact.getBuilders().get(0) instanceof VODataNodeBuilder)) {
            dfact = new DataNodeFactory(dfact);
            dfact.getBuilders().add(0, new VODataNodeBuilder());
        }
        return dfact;
    }

    public boolean allowsChildren() {
        String tagname = this.vocel.getTagName();
        return !tagname.equals("DEFINITIONS");
    }

    public Iterator getChildIterator() {
        ArrayList<DataNode> children = new ArrayList<DataNode>();
        Iterator it = VOComponentDataNode.getChildElements(this.vocel).iterator();
        while (it.hasNext()) {
            DOMSource xsrc = VOComponentDataNode.getSource((VOElement)it.next());
            children.add(this.makeChild(xsrc));
        }
        return children.iterator();
    }

    static List getChildElements(VOElement vocel) {
        ArrayList<VOElement> children = new ArrayList<VOElement>(Arrays.asList(vocel.getChildren()));
        Iterator it = children.iterator();
        while (it.hasNext()) {
            VOElement childEl = (VOElement)it.next();
            String childName = childEl.getTagName();
            if (!childName.equals("DESCRIPTION") && !childName.equals("INFO") && !childName.equals("PARAM") && !childName.equals("COOSYS")) continue;
            it.remove();
        }
        return children;
    }

    public void configureDetail(DetailViewer dv) {
        dv.addKeyedItem("Element name", this.vocel.getTagName());
        VOComponentDataNode.addVOComponentViews(dv, this.vocel);
    }

    VOElement getElement() {
        return this.vocel;
    }

    public static void addVOComponentViews(DetailViewer dv, final VOElement voel) {
        TreeMap<String, String> atts = new TreeMap<String, String>();
        String description = null;
        String systemId = voel.getSystemId();
        ArrayList<String> infonames = new ArrayList<String>();
        ArrayList<String> infovals = new ArrayList<String>();
        final ArrayList<ParamElement> params = new ArrayList<ParamElement>();
        ArrayList<VOElement> coosyss = new ArrayList<VOElement>();
        int ninfo = 0;
        Node child = voel.getFirstChild();
        while (child != null) {
            if (child instanceof Attr) {
                Attr att = (Attr)child;
                atts.put(att.getName(), att.getValue());
            } else if (child instanceof Element) {
                Element childEl = (Element)child;
                String elname = childEl.getTagName();
                DOMSource childSrc = new DOMSource(childEl, systemId);
                if (elname.equals("DESCRIPTION")) {
                    description = DOMUtils.getTextContent(childEl).trim();
                } else if (elname.equals("INFO")) {
                    String infohandle = vofact.makeVOElement(childEl, systemId).getHandle();
                    String infovalue = childEl.getAttribute("value");
                    infonames.add(infohandle);
                    infovals.add(infovalue);
                    ++ninfo;
                } else if (elname.equals("PARAM")) {
                    params.add((ParamElement)childEl);
                } else if (elname.equals("COOSYS")) {
                    coosyss.add((VOElement)childEl);
                }
            }
            child = child.getNextSibling();
        }
        if (systemId != null && systemId.trim().length() > 0) {
            dv.addKeyedItem("System ID", systemId);
        }
        if (atts.size() > 0) {
            dv.addSubHead("Attributes");
            Iterator it = atts.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry att = it.next();
                dv.addKeyedItem((String)att.getKey(), (String)att.getValue());
            }
            dv.addSeparator();
        }
        if (description != null && description.length() > 0) {
            dv.addSubHead("Description");
            dv.addText(description);
            dv.addSeparator();
        }
        if (coosyss.size() == 1) {
            dv.addSubHead("Coordinate system");
            VOElement coosys = (VOElement)coosyss.get(0);
            String text = DOMUtils.getTextContent((Element)coosys).trim();
            String id = coosys.getID();
            String equinox = coosys.getAttribute("equinox");
            String epoch = coosys.getAttribute("epoch");
            String system = coosys.getAttribute("system");
            if (text != null) {
                dv.addText(text);
            }
            if (id != null) {
                dv.addKeyedItem("ID", id);
            }
            if (equinox != null) {
                dv.addKeyedItem("Equinox", equinox);
            }
            if (epoch != null) {
                dv.addKeyedItem("Epoch", epoch);
            }
            if (system != null) {
                dv.addKeyedItem("System", system);
            }
        }
        if (ninfo > 0) {
            dv.addSubHead("Infos");
            int i = 0;
            while (i < ninfo) {
                dv.addKeyedItem((String)infonames.get(i), (String)infovals.get(i));
                ++i;
            }
        }
        if (params.size() > 0) {
            dv.addSubHead("Params");
            Iterator it = params.iterator();
            while (it.hasNext()) {
                ParamElement param = (ParamElement)it.next();
                String val = param.getValue();
                String unit = param.getUnit();
                if (unit != null) {
                    val = val + " " + unit;
                }
                dv.addKeyedItem(param.getHandle(), val);
            }
            dv.addPane("Params", new ComponentMaker(){

                public JComponent getComponent() {
                    return new MetaTable(new ParamMetamapGroup(params));
                }
            });
        }
        dv.addPane("XML content", new ComponentMaker(){

            public JComponent getComponent() {
                return new TextViewer(VOComponentDataNode.getSource(voel));
            }
        });
    }

    public static DOMSource getSource(VOElement voel) {
        return new DOMSource((Node)voel, voel.getSystemId());
    }

    private static class ParamMetamapGroup
    extends MetamapGroup {
        private static final String NAME_KEY = "Name";
        private static final String ID_KEY = "ID";
        private static final String VALUE_KEY = "Value";
        private static final String UNIT_KEY = "Units";
        private static final String DESCRIPTION_KEY = "Description";
        private static final String UCD_KEY = "UCD";
        private static final String UCD_DESCRIPTION_KEY = "UCD description";
        private static final String DATATYPE_KEY = "Datatype";
        private static final String PRECISION_KEY = "Precision";
        private static final String WIDTH_KEY = "Width";
        private static final String ARRAYSIZE_KEY = "Arraysize";
        private static List keyOrder = Arrays.asList("Name", "ID", "Value", "Units", "Description", "UCD", "UCD description", "Datatype", "Precision", "Width", "Arraysize");

        public ParamMetamapGroup(List params) {
            super(params.size());
            this.setKeyOrder(keyOrder);
            int np = params.size();
            int i = 0;
            while (i < np) {
                ParamElement param = (ParamElement)params.get(i);
                this.addEntry(i, ID_KEY, param.getAttribute(ID_KEY));
                this.addEntry(i, UNIT_KEY, param.getAttribute("unit"));
                this.addEntry(i, DATATYPE_KEY, param.getAttribute("datatype"));
                this.addEntry(i, PRECISION_KEY, param.getAttribute("precision"));
                this.addEntry(i, WIDTH_KEY, param.getAttribute("width"));
                this.addEntry(i, NAME_KEY, param.getAttribute("name"));
                this.addEntry(i, UCD_KEY, param.getAttribute("ucd"));
                this.addEntry(i, VALUE_KEY, param.getAttribute("value"));
                this.addEntry(i, ARRAYSIZE_KEY, param.getAttribute("arraysize"));
                this.addEntry(i, DESCRIPTION_KEY, param.getDescription());
                if (this.hasEntry(i, UCD_KEY)) {
                    UCD ucd = UCD.getUCD((String)((String)this.getEntry(i, UCD_KEY)));
                    String desc = ucd != null ? ucd.getDescription() : "<unknown UCD>";
                    this.addEntry(i, UCD_DESCRIPTION_KEY, desc);
                }
                ++i;
            }
        }
    }
}

