/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.nodes;

import java.io.StringReader;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeMap;
import javax.swing.JComponent;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Attr;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.Entity;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.Notation;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;
import uk.ac.starlink.datanode.nodes.ComponentMaker;
import uk.ac.starlink.datanode.nodes.DefaultDataNode;
import uk.ac.starlink.datanode.nodes.DetailViewer;
import uk.ac.starlink.datanode.nodes.MetaTable;
import uk.ac.starlink.datanode.nodes.MetamapGroup;
import uk.ac.starlink.datanode.nodes.NoSuchDataException;
import uk.ac.starlink.datanode.viewers.TextViewer;
import uk.ac.starlink.util.SourceReader;

public class XMLDataNode
extends DefaultDataNode {
    private final Node domNode;
    private final String systemId;
    private final String tla;
    private final String type;
    private final String description;
    private final boolean allowsChildren;
    private String sep;
    private String pathEl;
    private String name;
    public static final int MAX_LINES = 12;
    private static final String NAME_KEY = "Name";
    private static final String SID_KEY = "System ID";
    private static final String PID_KEY = "Public ID";
    private static final String NOTATION_KEY = "Notation";

    public XMLDataNode(Source xsrc) throws NoSuchDataException {
        short iconId;
        try {
            this.domNode = new SourceReader().getDOM(xsrc);
        }
        catch (TransformerException e) {
            throw new NoSuchDataException(e);
        }
        this.systemId = xsrc.getSystemId();
        this.name = this.domNode.getNodeName();
        this.pathEl = this.domNode.getNodeName();
        this.sep = ".";
        switch (this.domNode.getNodeType()) {
            case 9: {
                this.tla = "DOC";
                this.type = "XML document";
                this.allowsChildren = true;
                iconId = 120;
                this.name = '<' + ((Document)this.domNode).getDocumentElement().getTagName() + '>';
                this.description = "";
                this.sep = "#";
                break;
            }
            case 1: {
                this.tla = "ELE";
                this.type = "XML element";
                this.allowsChildren = true;
                iconId = 121;
                Element el = (Element)this.domNode;
                this.name = '<' + (el.getLocalName() == null ? el.getTagName() : el.getLocalName()) + '>';
                this.description = XMLDataNode.elementDescription(el);
                break;
            }
            case 3: 
            case 4: {
                this.tla = "TXT";
                this.type = "XML text node";
                this.allowsChildren = false;
                iconId = 126;
                this.name = "";
                this.description = XMLDataNode.contentSummary("\"", ((Text)this.domNode).getData(), "\"");
                break;
            }
            case 8: {
                this.tla = "COM";
                this.type = "XML comment node";
                this.allowsChildren = false;
                iconId = 122;
                this.name = "";
                this.description = XMLDataNode.contentSummary("<!-- ", ((Comment)this.domNode).getData(), " -->");
                break;
            }
            case 7: {
                this.tla = "XPI";
                this.type = "XML processing instruction";
                this.allowsChildren = false;
                iconId = 123;
                ProcessingInstruction pi = (ProcessingInstruction)this.domNode;
                this.name = "<?" + pi.getTarget() + "?>";
                this.description = XMLDataNode.contentSummary("\"", pi.getData(), "\"");
                break;
            }
            case 10: {
                this.tla = "DTD";
                this.type = "Document Type Declaration";
                this.allowsChildren = true;
                iconId = 127;
                DocumentType dtd = (DocumentType)this.domNode;
                this.name = "<!DOCTYPE " + dtd.getName() + ">";
                this.description = "";
                break;
            }
            default: {
                this.tla = "XML";
                this.type = "XML node";
                this.allowsChildren = true;
                iconId = 121;
                this.name = this.domNode.getNodeName();
                this.description = "";
            }
        }
        if (this.pathEl.charAt(0) == '#') {
            this.pathEl = '[' + this.pathEl.substring(1) + ']';
        }
        this.setLabel(this.name);
        this.setIconID(iconId);
    }

    public String getName() {
        return this.name;
    }

    public String getNodeTLA() {
        return this.tla;
    }

    public String getNodeType() {
        return this.type;
    }

    public String getPathElement() {
        if (this.domNode.getNodeType() == 9) {
            return this.getLabel();
        }
        return this.pathEl;
    }

    public String getPathSeparator() {
        return this.sep;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean allowsChildren() {
        return this.allowsChildren;
    }

    public Iterator getChildIterator() {
        return new Iterator(){
            private Node next;
            {
                this.next = XMLDataNode.firstUsefulSibling(XMLDataNode.this.domNode.getFirstChild());
            }

            public boolean hasNext() {
                return this.next != null;
            }

            public Object next() {
                if (this.next == null) {
                    throw new NoSuchElementException();
                }
                Node nod = this.next;
                this.next = XMLDataNode.firstUsefulSibling(this.next.getNextSibling());
                try {
                    DOMSource xsrc = new DOMSource(nod, XMLDataNode.this.systemId);
                    return XMLDataNode.this.makeChild(xsrc);
                }
                catch (Exception e) {
                    return XMLDataNode.this.makeErrorChild(e);
                }
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public void configureDetail(DetailViewer dv) {
        Element el;
        if (this.systemId != null && this.systemId.trim().length() > 0) {
            dv.addKeyedItem(SID_KEY, this.systemId);
        }
        if (this.domNode instanceof Element && (el = (Element)this.domNode).hasAttributes()) {
            NamedNodeMap atts = el.getAttributes();
            int natt = atts.getLength();
            TreeMap<String, String> amap = new TreeMap<String, String>();
            int i = 0;
            while (i < natt) {
                Attr att = (Attr)atts.item(i);
                String aname = att.getName();
                String aval = att.getValue();
                if (!att.getSpecified()) {
                    aval = aval + " (auto value)";
                }
                amap.put(aname, aval);
                ++i;
            }
            dv.addSubHead("Attributes");
            Iterator it = amap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                dv.addKeyedItem((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (this.domNode instanceof DocumentType) {
            NamedNodeMap notations;
            int nnot;
            NamedNodeMap entities;
            int nent;
            DocumentType dtd = (DocumentType)this.domNode;
            dv.addKeyedItem(SID_KEY, dtd.getSystemId());
            dv.addKeyedItem(PID_KEY, dtd.getPublicId());
            final String isubset = dtd.getInternalSubset();
            if (isubset != null && isubset.trim().length() > 0) {
                dv.addPane("Internal subset", new ComponentMaker(){

                    public JComponent getComponent() throws TransformerException {
                        StreamSource ssrc = new StreamSource(new StringReader(isubset));
                        ssrc.setSystemId(XMLDataNode.this.systemId);
                        return new TextViewer(ssrc);
                    }
                });
            }
            if ((nent = (entities = dtd.getEntities()).getLength()) > 0) {
                dv.addPane("Entities", new ComponentMaker(){

                    public JComponent getComponent() {
                        MetamapGroup mmg = new MetamapGroup(nent);
                        int i = 0;
                        while (i < nent) {
                            Entity ent = (Entity)entities.item(i);
                            mmg.addEntry(i, XMLDataNode.NAME_KEY, ent.getNodeName());
                            mmg.addEntry(i, XMLDataNode.SID_KEY, ent.getSystemId());
                            mmg.addEntry(i, XMLDataNode.PID_KEY, ent.getPublicId());
                            mmg.addEntry(i, XMLDataNode.NOTATION_KEY, ent.getNotationName());
                            ++i;
                        }
                        mmg.setKeyOrder(Arrays.asList(XMLDataNode.NAME_KEY, XMLDataNode.SID_KEY, XMLDataNode.PID_KEY, XMLDataNode.NOTATION_KEY));
                        return new MetaTable(mmg);
                    }
                });
            }
            if ((nnot = (notations = dtd.getNotations()).getLength()) > 0) {
                dv.addPane("Notations", new ComponentMaker(){

                    public JComponent getComponent() {
                        MetamapGroup mmg = new MetamapGroup(nnot);
                        int i = 0;
                        while (i < nnot) {
                            Notation not = (Notation)notations.item(i);
                            String systemId = not.getSystemId();
                            String publicId = not.getPublicId();
                            mmg.addEntry(i, XMLDataNode.NAME_KEY, not.getNodeName());
                            mmg.addEntry(i, XMLDataNode.SID_KEY, not.getSystemId());
                            mmg.addEntry(i, XMLDataNode.PID_KEY, not.getPublicId());
                            ++i;
                        }
                        mmg.setKeyOrder(Arrays.asList(XMLDataNode.NAME_KEY, XMLDataNode.SID_KEY, XMLDataNode.PID_KEY));
                        return new MetaTable(mmg);
                    }
                });
            }
        }
        String localName = this.domNode.getLocalName();
        String namespaceURI = this.domNode.getNamespaceURI();
        String prefix = this.domNode.getPrefix();
        if (localName != null || namespaceURI != null || prefix != null) {
            dv.addSubHead("Namespaces");
            if (localName != null) {
                dv.addKeyedItem("Local name", localName);
            }
            if (prefix != null) {
                dv.addKeyedItem("Prefix", prefix);
            }
            if (namespaceURI != null) {
                dv.addKeyedItem("Namespace URI", namespaceURI);
            }
        }
        dv.addPane("Full content", new ComponentMaker(){

            public JComponent getComponent() throws TransformerException {
                return new TextViewer(new DOMSource(XMLDataNode.this.domNode));
            }
        });
    }

    private static String contentSummary(String pre, String data, String post) {
        StringBuffer summ = new StringBuffer();
        summ.append(pre);
        String content = data.trim();
        if (content.length() == 0) {
            return "";
        }
        if (content.length() <= 30) {
            summ.append(content);
            summ.append(post);
        } else {
            summ.append(content.substring(0, 30));
            summ.append("...");
        }
        return summ.toString();
    }

    private static String elementDescription(Element el) {
        Text tnode;
        String val;
        boolean isEmpty;
        String desc = "";
        boolean hasAtts = el.hasAttributes();
        int natts = hasAtts ? el.getAttributes().getLength() : 0;
        int nchild = el.getChildNodes().getLength();
        boolean bl = isEmpty = nchild - natts == 0;
        if (isEmpty && natts == 1) {
            Attr att = (Attr)el.getAttributes().item(0);
            desc = att.getName() + "=\"" + att.getValue() + "\"";
        } else if (el.hasAttribute("name") && el.hasAttribute("value")) {
            desc = el.getAttribute("name") + "=\"" + el.getAttribute("value") + "\"";
        } else if (el.hasAttribute("name")) {
            desc = '\"' + el.getAttribute("name") + '\"';
        } else if (nchild - natts == 1 && el.getChildNodes().item(0) instanceof Text && (val = (tnode = (Text)el.getChildNodes().item(0)).getData().trim()).length() > 0) {
            desc = '\"' + val.substring(0, Math.min(80, val.length())) + '\"';
        }
        if (desc.length() > 42) {
            desc = desc.substring(0, 40) + "...";
        }
        return desc;
    }

    static Node firstUsefulSibling(Node sib) {
        if (sib == null) {
            return null;
        }
        if (sib instanceof Attr) {
            return XMLDataNode.firstUsefulSibling(sib.getNextSibling());
        }
        if (sib instanceof Text && ((Text)sib).getData().trim().length() == 0) {
            return XMLDataNode.firstUsefulSibling(sib.getNextSibling());
        }
        if (sib instanceof Text && sib.getNextSibling() instanceof Text) {
            StringBuffer buf = new StringBuffer();
            Node tsib = sib;
            while (tsib instanceof Text) {
                buf.append(((Text)tsib).getData());
                tsib = tsib.getNextSibling();
            }
            return sib.getOwnerDocument().createTextNode(buf.toString());
        }
        return sib;
    }
}

