/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.nodes;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import uk.ac.starlink.datanode.factory.DataNodeFactory;
import uk.ac.starlink.datanode.nodes.DataNode;
import uk.ac.starlink.datanode.nodes.DetailViewer;
import uk.ac.starlink.datanode.nodes.NoSuchDataException;
import uk.ac.starlink.datanode.nodes.ZipArchiveDataNode;
import uk.ac.starlink.datanode.nodes.ZipBranchDataNode;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.FileDataSource;

public class ZipFileDataNode
extends ZipArchiveDataNode {
    private ZipFile zfile;
    private File file;
    private List entries;

    public ZipFileDataNode(File file) throws NoSuchDataException {
        super(ZipFileDataNode.getDataSource(file));
        try {
            this.zfile = new ZipFile(file);
        }
        catch (IOException e) {
            throw new NoSuchDataException(e.getMessage());
        }
        this.file = file;
        this.setName(file.getName());
        this.setLabel(file.getName());
    }

    public Object getParentObject() {
        return this.file.getAbsoluteFile().getParentFile();
    }

    protected List getEntries() throws IOException {
        if (this.entries == null) {
            this.entries = new ArrayList();
            Enumeration<? extends ZipEntry> enEn = this.zfile.entries();
            while (enEn.hasMoreElements()) {
                this.entries.add(enEn.nextElement());
            }
        }
        return this.entries;
    }

    protected Iterator getChildIteratorAtLevel(String level, final DataNode parent) throws IOException {
        final ZipFileDataNode zadn = this;
        final DataNodeFactory childMaker = this.getChildMaker();
        final int lleng = level.length();
        final Iterator zentIt = this.getEntriesAtLevel(level).iterator();
        return new Iterator(){

            public Object next() {
                ZipEntry zent = (ZipEntry)zentIt.next();
                String subname = zent.getName().substring(lleng);
                if (zent.isDirectory()) {
                    ZipBranchDataNode dnode = new ZipBranchDataNode(zadn, zent);
                    ZipFileDataNode.this.getChildMaker().configureDataNode(dnode, parent, null);
                    dnode.setLabel(subname);
                    return dnode;
                }
                DataSource datsrc = new DataSource(this, zent){
                    private final /* synthetic */ ZipEntry val$zent;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$zent = val$zent;
                    }

                    public long getRawLength() {
                        return this.val$zent.getSize();
                    }

                    protected InputStream getRawInputStream() throws IOException {
                        return ZipFileDataNode.access$100(1.access$000(this.this$1)).getInputStream(this.val$zent);
                    }

                    public URL getURL() {
                        return null;
                    }
                };
                datsrc.setName(subname);
                DataNode node = childMaker.makeChildNode(parent, datsrc);
                node.setLabel(subname);
                return node;
            }

            public boolean hasNext() {
                return zentIt.hasNext();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            static /* synthetic */ ZipFileDataNode access$000(1 x0) {
                return x0.ZipFileDataNode.this;
            }
        };
    }

    public void configureDetail(DetailViewer dv) {
        dv.addKeyedItem("Length", this.file.length());
        dv.addKeyedItem("Number of entries", this.zfile.size());
    }

    private static DataSource getDataSource(File file) throws NoSuchDataException {
        try {
            FileDataSource datsrc = new FileDataSource(file);
            datsrc.setIntroLimit(12);
            datsrc.getIntro();
            datsrc.close();
            return datsrc;
        }
        catch (IOException e) {
            throw new NoSuchDataException(e);
        }
    }

    static /* synthetic */ ZipFile access$100(ZipFileDataNode x0) {
        return x0.zfile;
    }
}

