/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.tree;

import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

public class BasicDropHandler
extends DropTarget {
    private boolean canImport;
    private JComponent comp;

    public BasicDropHandler(JComponent comp) {
        this.comp = comp;
        this.setComponent(comp);
    }

    public void dragEnter(DropTargetDragEvent evt) {
        int dropAction = evt.getDropAction();
        this.canImport = this.getTransferHandler().canImport(this.comp, evt.getCurrentDataFlavors());
        if (this.canImport && this.actionSupported(dropAction) && this.isDropLocation(evt.getLocation())) {
            evt.acceptDrag(dropAction);
        } else {
            evt.rejectDrag();
        }
    }

    public void dragOver(DropTargetDragEvent evt) {
        int dropAction = evt.getDropAction();
        if (this.canImport && this.actionSupported(dropAction) && this.isDropLocation(evt.getLocation())) {
            evt.acceptDrag(dropAction);
        } else {
            evt.rejectDrag();
        }
    }

    public void dragExit(DropTargetEvent evt) {
    }

    public void drop(DropTargetDropEvent evt) {
        int dropAction = evt.getDropAction();
        TransferHandler importer = this.getTransferHandler();
        if (this.canImport && this.actionSupported(dropAction)) {
            evt.acceptDrop(dropAction);
            try {
                Transferable trans = evt.getTransferable();
                evt.dropComplete(importer.importData(this.comp, trans));
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                evt.dropComplete(false);
            }
        } else {
            evt.rejectDrop();
        }
    }

    private boolean actionSupported(int action) {
        return (action & 3) != 0 && this.getTransferHandler() != null;
    }

    protected boolean isDropLocation(Point loc) {
        return true;
    }

    private TransferHandler getTransferHandler() {
        return this.comp.getTransferHandler();
    }
}

