/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.tree;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import javax.xml.transform.Source;
import nom.tam.util.ArrayDataOutput;
import nom.tam.util.BufferedDataOutputStream;
import uk.ac.starlink.datanode.nodes.DataNode;
import uk.ac.starlink.datanode.nodes.DataObjectException;
import uk.ac.starlink.datanode.nodes.DataType;
import uk.ac.starlink.datanode.tree.BasicTransferable;
import uk.ac.starlink.fits.FitsNdxHandler;
import uk.ac.starlink.hdx.HdxException;
import uk.ac.starlink.ndx.Ndx;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.SourceReader;
import uk.ac.starlink.votable.DataFormat;
import uk.ac.starlink.votable.VOTableWriter;

public class DataNodeTransferable
extends BasicTransferable {
    private DataNode node;
    public static final String VOTABLE_MIMETYPE = "application/xml";

    public DataNodeTransferable(DataNode node) {
        URL url;
        this.node = node;
        if (node.hasDataObject(DataType.TABLE)) {
            try {
                StarTable table = (StarTable)node.getDataObject(DataType.TABLE);
                this.addDataSource(new VOTableDataSource(table), VOTABLE_MIMETYPE);
            }
            catch (DataObjectException e) {
                e.printStackTrace();
            }
        }
        if (node.hasDataObject(DataType.NDX)) {
            try {
                Ndx ndx = (Ndx)node.getDataObject(DataType.NDX);
                if (ndx.isPersistent()) {
                    this.addDataSource(new XmlNdxDataSource(ndx), VOTABLE_MIMETYPE);
                }
                this.addDataSource(new FitsNdxDataSource(ndx), "application/fits");
            }
            catch (DataObjectException e) {
                e.printStackTrace();
            }
        }
        if ((url = DataNodeTransferable.getURL(node)) != null) {
            this.addURL(url);
        }
    }

    public DataNode getDataNode() {
        return this.node;
    }

    private static URL getURL(DataNode node) {
        Object creator = node.getCreator().getObject();
        if (creator instanceof URL) {
            return (URL)creator;
        }
        if (creator instanceof DataSource) {
            return ((DataSource)creator).getURL();
        }
        if (creator instanceof File) {
            try {
                return ((File)creator).toURL();
            }
            catch (MalformedURLException e) {
                // empty catch block
            }
        }
        if (creator instanceof String) {
            try {
                return new URL((String)creator);
            }
            catch (MalformedURLException e) {
            }
        }
        return null;
    }

    private static class FitsNdxDataSource
    extends DataSource {
        final Ndx ndx_;

        FitsNdxDataSource(Ndx ndx) {
            this.ndx_ = ndx;
        }

        public InputStream getRawInputStream() throws IOException {
            PipedOutputStream ostrm = new PipedOutputStream();
            PipedInputStream istrm = new PipedInputStream(ostrm);
            new Thread(this, ostrm){
                private final /* synthetic */ PipedOutputStream val$ostrm;
                private final /* synthetic */ FitsNdxDataSource this$0;
                {
                    this.this$0 = this$0;
                    this.val$ostrm = val$ostrm;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                public void run() {
                    block9: {
                        URL dummyUrl = new URL("file://localhost/dummy");
                        BufferedDataOutputStream strm = new BufferedDataOutputStream((OutputStream)this.val$ostrm);
                        FitsNdxHandler.getInstance().outputNdx((ArrayDataOutput)strm, dummyUrl, this.this$0.ndx_);
                        strm.close();
                        Object var4_5 = null;
                        try {
                            this.val$ostrm.close();
                        }
                        catch (IOException e2) {}
                        break block9;
                        {
                            catch (MalformedURLException e) {
                                throw new AssertionError((Object)e);
                            }
                            catch (IOException e) {
                                Object var4_6 = null;
                                try {
                                    this.val$ostrm.close();
                                }
                                catch (IOException e2) {}
                            }
                        }
                        catch (Throwable throwable) {
                            Object var4_7 = null;
                            try {
                                this.val$ostrm.close();
                            }
                            catch (IOException e2) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                    }
                }
            }.start();
            return istrm;
        }

        public String getName() {
            return this.ndx_.hasTitle() ? this.ndx_.getTitle() : "NDX";
        }

        public URL getURL() {
            return null;
        }
    }

    private static class XmlNdxDataSource
    extends DataSource {
        final Ndx ndx_;

        XmlNdxDataSource(Ndx ndx) {
            this.ndx_ = ndx;
        }

        public InputStream getRawInputStream() throws IOException {
            try {
                Source xsrc = this.ndx_.getHdxFacade().getSource(null);
                return new SourceReader().getXMLStream(xsrc);
            }
            catch (HdxException e) {
                throw (IOException)new IOException(e.getMessage()).initCause(e);
            }
        }

        public String getName() {
            return this.ndx_.hasTitle() ? this.ndx_.getTitle() : "NDX";
        }

        public URL getURL() {
            return null;
        }
    }

    private static class VOTableDataSource
    extends DataSource {
        final StarTable table_;

        VOTableDataSource(StarTable table) {
            this.table_ = table;
        }

        public URL getURL() {
            return this.table_.getURL();
        }

        public String getName() {
            String name = this.table_.getName();
            return name == null ? "Table" : name;
        }

        public InputStream getRawInputStream() throws IOException {
            PipedOutputStream ostrm = new PipedOutputStream();
            PipedInputStream istrm = new PipedInputStream(ostrm);
            new Thread(this, ostrm){
                private final /* synthetic */ PipedOutputStream val$ostrm;
                private final /* synthetic */ VOTableDataSource this$0;
                {
                    this.this$0 = this$0;
                    this.val$ostrm = val$ostrm;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Loose catch block
                 */
                public void run() {
                    block8: {
                        VOTableWriter vosquirt = new VOTableWriter();
                        vosquirt.setDataFormat(DataFormat.BINARY);
                        vosquirt.setInline(true);
                        vosquirt.writeStarTable(this.this$0.table_, (OutputStream)this.val$ostrm, null);
                        Object var3_3 = null;
                        try {
                            this.val$ostrm.close();
                        }
                        catch (IOException e2) {}
                        break block8;
                        {
                            catch (IOException e) {
                                Object var3_4 = null;
                                try {
                                    this.val$ostrm.close();
                                }
                                catch (IOException e2) {}
                            }
                        }
                        catch (Throwable throwable) {
                            Object var3_5 = null;
                            try {
                                this.val$ostrm.close();
                            }
                            catch (IOException e2) {
                                // empty catch block
                            }
                            throw throwable;
                        }
                    }
                }
            }.start();
            return istrm;
        }
    }
}

