/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.tree;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import uk.ac.starlink.datanode.nodes.DataNode;
import uk.ac.starlink.datanode.nodes.EmptyDataNode;
import uk.ac.starlink.datanode.tree.NodeExpander;
import uk.ac.starlink.datanode.tree.TreeModelNode;

public class DataNodeTreeModel
implements TreeModel {
    private TreeModelNode root;
    private Map nodeMap = new HashMap();
    TreeModelListenerHandler listenerHandler = new TreeModelListenerHandler();

    public DataNodeTreeModel() {
        this(new EmptyDataNode());
    }

    public DataNodeTreeModel(DataNode rootDataNode) {
        this.root = this.makeModelNode(rootDataNode, null);
    }

    public Object getRoot() {
        return this.root.getDataNode();
    }

    public Object getChild(Object parentDataNode, int index) {
        TreeModelNode childModelNode = (TreeModelNode)this.getModelNode((DataNode)parentDataNode).getChildren().get(index);
        return childModelNode.getDataNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getChildCount(Object parentDataNode) {
        TreeModelNode modelNode;
        DataNode dataNode = (DataNode)parentDataNode;
        TreeModelNode treeModelNode = modelNode = this.getModelNode(dataNode);
        synchronized (treeModelNode) {
            if (modelNode.getExpander() == null) {
                final NodeExpander expander = new NodeExpander(this, modelNode);
                modelNode.setExpander(expander);
                new Thread("Node expander: " + dataNode){

                    public void run() {
                        expander.expandNode();
                    }
                }.start();
            }
            return modelNode.getChildren().size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataNode[] getCurrentChildren(DataNode dataNode) {
        TreeModelNode modelNode;
        TreeModelNode treeModelNode = modelNode = this.getModelNode(dataNode);
        synchronized (treeModelNode) {
            List childList = modelNode.getChildren();
            int nChild = childList.size();
            DataNode[] children = new DataNode[nChild];
            int i = 0;
            while (i < nChild) {
                children[i] = ((TreeModelNode)childList.get(i)).getDataNode();
                ++i;
            }
            return children;
        }
    }

    public boolean isLeaf(Object dataNode) {
        return !((DataNode)dataNode).allowsChildren();
    }

    public int getIndexOfChild(Object parentDataNode, Object childDataNode) {
        if (parentDataNode != null && childDataNode != null && this.nodeMap.containsKey(childDataNode)) {
            TreeModelNode parentModelNode = this.getModelNode((DataNode)parentDataNode);
            TreeModelNode childModelNode = this.getModelNode((DataNode)childDataNode);
            return parentModelNode.getChildren().indexOf(childModelNode);
        }
        return -1;
    }

    public void valueForPathChanged(TreePath path, Object newDataNode) {
        this.replaceNode((DataNode)path.getLastPathComponent(), (DataNode)newDataNode);
    }

    public void addTreeModelListener(TreeModelListener listener) {
        this.listenerHandler.addTreeModelListener(listener);
    }

    public void removeTreeModelListener(TreeModelListener listener) {
        this.listenerHandler.removeTreeModelListener(listener);
    }

    public int getNodeCount() {
        return this.nodeMap.size();
    }

    public boolean containsNode(DataNode node) {
        return this.nodeMap.containsKey(node);
    }

    public DataNode[] getPathToRoot(DataNode dataNode) {
        return this.nodeMap.containsKey(dataNode) ? this.getPathToRoot(this.getModelNode(dataNode)) : null;
    }

    private DataNode[] getPathToRoot(TreeModelNode modelNode) {
        ArrayList<DataNode> pathList = new ArrayList<DataNode>();
        while (modelNode != null) {
            pathList.add(modelNode.getDataNode());
            modelNode = modelNode.getParent();
        }
        Collections.reverse(pathList);
        return pathList.toArray(new DataNode[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insertNode(DataNode newChild, DataNode parent, int ipos) {
        TreeModelNode parentModelNode;
        TreeModelNode treeModelNode = parentModelNode = this.getModelNode(parent);
        synchronized (treeModelNode) {
            TreeModelNode childModelNode = this.makeModelNode(newChild, parentModelNode);
            List childList = parentModelNode.getChildren();
            childList.add(ipos, childModelNode);
            final Object[] path = this.getPathToRoot(parentModelNode);
            final int[] indices = new int[]{ipos};
            final Object[] children = new DataNode[]{newChild};
            this.invokeLater(new Runnable(){

                public void run() {
                    DataNodeTreeModel.this.listenerHandler.fireTreeNodesInserted(this, path, indices, children);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendNode(DataNode newChild, DataNode parent) {
        TreeModelNode parentModelNode;
        TreeModelNode treeModelNode = parentModelNode = this.getModelNode(parent);
        synchronized (treeModelNode) {
            int ipos = parentModelNode.getChildren().size();
            this.insertNode(newChild, parent, ipos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeNode(DataNode dataNode) {
        TreeModelNode parentModelNode;
        TreeModelNode modelNode = this.getModelNode(dataNode);
        this.discardModelNode(modelNode);
        TreeModelNode treeModelNode = parentModelNode = modelNode.getParent();
        synchronized (treeModelNode) {
            List childList = parentModelNode.getChildren();
            int index = childList.indexOf(modelNode);
            childList.remove(index);
            final Object[] path = this.getPathToRoot(parentModelNode);
            final int[] indices = new int[]{index};
            final Object[] children = new DataNode[]{dataNode};
            this.invokeLater(new Runnable(){

                public void run() {
                    DataNodeTreeModel.this.listenerHandler.fireTreeNodesRemoved(this, path, indices, children);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceNode(DataNode oldDataNode, DataNode newDataNode) {
        TreeModelNode oldModelNode = this.getModelNode(oldDataNode);
        TreeModelNode parentModelNode = oldModelNode.getParent();
        TreeModelNode newModelNode = this.makeModelNode(newDataNode, parentModelNode);
        TreeModelNode treeModelNode = parentModelNode;
        synchronized (treeModelNode) {
            List childList = parentModelNode.getChildren();
            int index = childList.indexOf(oldModelNode);
            childList.set(index, newModelNode);
            this.discardModelNode(oldModelNode);
            Object[] path = this.getPathToRoot(newDataNode);
            this.listenerHandler.fireTreeStructureChanged(this, path, null, null);
        }
    }

    public synchronized void setRoot(DataNode rootDataNode) {
        TreeModelNode newRoot;
        this.discardModelNode(this.root);
        this.root = newRoot = this.makeModelNode(rootDataNode, null);
        Object[] path = new Object[]{newRoot};
        this.listenerHandler.fireTreeStructureChanged(this, path, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refreshNode(DataNode dataNode) {
        TreeModelNode oldModelNode;
        TreeModelNode treeModelNode = oldModelNode = this.getModelNode(dataNode);
        synchronized (treeModelNode) {
            oldModelNode.setExpander(null);
            Iterator it = oldModelNode.getChildren().iterator();
            while (it.hasNext()) {
                TreeModelNode child = (TreeModelNode)it.next();
                this.discardModelNode(child);
            }
        }
        TreeModelNode parentModelNode = oldModelNode.getParent();
        TreeModelNode newModelNode = this.repackage(dataNode, parentModelNode);
        if (parentModelNode != null) {
            TreeModelNode treeModelNode2 = parentModelNode;
            synchronized (treeModelNode2) {
                List childList = parentModelNode.getChildren();
                int index = childList.indexOf(oldModelNode);
                childList.set(index, newModelNode);
            }
        }
        Object[] path = this.getPathToRoot(newModelNode);
        this.listenerHandler.fireTreeStructureChanged(this, path, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repaintNode(DataNode dataNode) {
        TreeModelNode parentModelNode;
        TreeModelNode modelNode = this.getModelNode(dataNode);
        if (modelNode != this.root && (parentModelNode = modelNode.getParent()) != null) {
            TreeModelNode treeModelNode = parentModelNode;
            synchronized (treeModelNode) {
                Object[] path = this.getPathToRoot(parentModelNode);
                int index = parentModelNode.getChildren().indexOf(modelNode);
                this.listenerHandler.fireTreeNodesChanged(this, path, new int[]{index}, new Object[]{dataNode});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopExpansion(DataNode dataNode) {
        TreeModelNode modelNode;
        TreeModelNode treeModelNode = modelNode = this.getModelNode(dataNode);
        synchronized (treeModelNode) {
            NodeExpander expander = modelNode.getExpander();
            if (expander != null && !expander.isStopped()) {
                expander.stop();
            }
        }
    }

    public TreeModelNode getModelNode(DataNode dataNode) {
        TreeModelNode modelNode = (TreeModelNode)this.nodeMap.get(dataNode);
        if (modelNode == null) {
            throw new IllegalStateException("Node " + dataNode + " does not exist in model");
        }
        return modelNode;
    }

    public TreeModelNode makeModelNode(DataNode dataNode, TreeModelNode parent) {
        if (this.nodeMap.containsKey(dataNode)) {
            throw new IllegalStateException("DataNode " + dataNode + " already exists in model");
        }
        TreeModelNode modelNode = new TreeModelNode(dataNode, parent);
        this.nodeMap.put(dataNode, modelNode);
        return modelNode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void discardModelNode(TreeModelNode node) {
        TreeModelNode treeModelNode = node;
        synchronized (treeModelNode) {
            NodeExpander expander = node.getExpander();
            if (expander != null && !expander.isStopped()) {
                expander.stop();
            }
            Iterator it = node.getChildren().iterator();
            while (it.hasNext()) {
                TreeModelNode child = (TreeModelNode)it.next();
                this.discardModelNode(child);
            }
            this.nodeMap.remove(node.getDataNode());
        }
    }

    private TreeModelNode repackage(DataNode dataNode, TreeModelNode parent) {
        if (!this.nodeMap.containsKey(dataNode)) {
            throw new IllegalStateException("DataNode " + dataNode + " does not exist in model");
        }
        TreeModelNode newModelNode = new TreeModelNode(dataNode, parent);
        this.nodeMap.put(dataNode, newModelNode);
        return newModelNode;
    }

    private void invokeLater(Runnable runnable) {
        if (SwingUtilities.isEventDispatchThread()) {
            runnable.run();
        } else {
            SwingUtilities.invokeLater(runnable);
        }
    }

    private static class TreeModelListenerHandler
    extends DefaultTreeModel {
        TreeModelListenerHandler() {
            super(new DefaultMutableTreeNode(null, false));
        }

        public void fireTreeNodesChanged(Object source, Object[] path, int[] indices, Object[] children) {
            super.fireTreeNodesChanged(source, path, indices, children);
        }

        public void fireTreeNodesInserted(Object source, Object[] path, int[] indices, Object[] children) {
            super.fireTreeNodesInserted(source, path, indices, children);
        }

        public void fireTreeNodesRemoved(Object source, Object[] path, int[] indices, Object[] children) {
            super.fireTreeNodesRemoved(source, path, indices, children);
        }

        public void fireTreeStructureChanged(Object source, Object[] path, int[] indices, Object[] children) {
            super.fireTreeStructureChanged(source, path, indices, children);
        }
    }
}

