/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.tree;

import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import uk.ac.starlink.datanode.factory.DataNodeFactory;
import uk.ac.starlink.datanode.nodes.DataNode;
import uk.ac.starlink.datanode.nodes.DataObjectException;
import uk.ac.starlink.datanode.nodes.DataType;
import uk.ac.starlink.datanode.tree.TreeNodeChooser;
import uk.ac.starlink.ndx.Ndx;
import uk.ac.starlink.util.gui.ErrorDialog;

public class NdxNodeChooser
extends TreeNodeChooser {
    private DataNodeFactory nodeFact;
    private int minDims = 1;
    private int maxDims = Integer.MAX_VALUE;
    private static List shunnedClassList;
    private static List deprecatedClassList;
    private static List preferredClassList;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$uk$ac$starlink$datanode$tree$NdxNodeChooser;
    static /* synthetic */ Class class$uk$ac$starlink$datanode$nodes$CompressedDataNode;
    static /* synthetic */ Class class$uk$ac$starlink$datanode$nodes$JDBCDataNode;
    static /* synthetic */ Class class$uk$ac$starlink$datanode$nodes$StarTableDataNode;
    static /* synthetic */ Class class$uk$ac$starlink$datanode$nodes$TableHDUDataNode;
    static /* synthetic */ Class class$uk$ac$starlink$datanode$nodes$VOComponentDataNode;
    static /* synthetic */ Class class$uk$ac$starlink$datanode$nodes$VOTableDataNode;
    static /* synthetic */ Class class$uk$ac$starlink$datanode$nodes$NDFDataNode;
    static /* synthetic */ Class class$uk$ac$starlink$datanode$nodes$HistoryDataNode;
    static /* synthetic */ Class class$uk$ac$starlink$datanode$nodes$XMLDataNode;
    static /* synthetic */ Class class$uk$ac$starlink$datanode$nodes$NdxDataNode;

    public NdxNodeChooser() {
        Action findSelectedAction = this.getSearchSelectedAction();
        Action findAllAction = this.getSearchAllAction();
        findSelectedAction.putValue("ShortDescription", "Locate all NDXs under selected node");
        findAllAction.putValue("ShortDescription", "Locate all NDXs in the tree");
        this.getButtonPanel().add(new JButton(findSelectedAction));
        this.getButtonPanel().add(Box.createHorizontalStrut(10));
        this.getButtonPanel().add(new JButton(findAllAction));
    }

    public void setRoot(DataNode root) {
        NdxNodeChooser.customiseFactory(root.getChildMaker());
        super.setRoot(root);
    }

    public synchronized DataNodeFactory getNodeMaker() {
        if (this.nodeFact == null) {
            this.nodeFact = new DataNodeFactory();
            NdxNodeChooser.customiseFactory(this.nodeFact);
        }
        return this.nodeFact;
    }

    public void setMinDims(int minDims) {
        this.minDims = minDims;
    }

    public void setMaxDims(int maxDims) {
        this.maxDims = maxDims;
    }

    protected boolean isChoosable(DataNode node) {
        return node.hasDataObject(DataType.NDX);
    }

    public Ndx chooseNdx(Component parent, String buttonText, String title) {
        DataNode node = this.chooseDataNode(parent, buttonText, title);
        try {
            return node == null ? null : this.makeNdx(node);
        }
        catch (IOException e) {
            ErrorDialog.showError(parent, "Bad NDX", (Throwable)e, "Failed to make NDX from " + node);
            return null;
        }
    }

    public Ndx chooseNdx(Component parent) {
        return this.chooseNdx(parent, "Open NDX", "NDX browser");
    }

    public Ndx makeNdx(DataNode node) throws IOException {
        if (this.isChoosable(node)) {
            if (!$assertionsDisabled && !node.hasDataObject(DataType.NDX)) {
                throw new AssertionError();
            }
            try {
                return (Ndx)node.getDataObject(DataType.NDX);
            }
            catch (DataObjectException e) {
                throw (IOException)new IOException(e.getMessage()).initCause(e);
            }
        }
        throw new IllegalArgumentException(node + " is not an NDX");
    }

    private static void customiseFactory(DataNodeFactory fact) {
        if (shunnedClassList == null) {
            String[] shunned = new String[]{(class$uk$ac$starlink$datanode$nodes$CompressedDataNode == null ? (class$uk$ac$starlink$datanode$nodes$CompressedDataNode = NdxNodeChooser.class$("uk.ac.starlink.datanode.nodes.CompressedDataNode")) : class$uk$ac$starlink$datanode$nodes$CompressedDataNode).getName(), (class$uk$ac$starlink$datanode$nodes$JDBCDataNode == null ? (class$uk$ac$starlink$datanode$nodes$JDBCDataNode = NdxNodeChooser.class$("uk.ac.starlink.datanode.nodes.JDBCDataNode")) : class$uk$ac$starlink$datanode$nodes$JDBCDataNode).getName(), (class$uk$ac$starlink$datanode$nodes$StarTableDataNode == null ? (class$uk$ac$starlink$datanode$nodes$StarTableDataNode = NdxNodeChooser.class$("uk.ac.starlink.datanode.nodes.StarTableDataNode")) : class$uk$ac$starlink$datanode$nodes$StarTableDataNode).getName(), (class$uk$ac$starlink$datanode$nodes$TableHDUDataNode == null ? (class$uk$ac$starlink$datanode$nodes$TableHDUDataNode = NdxNodeChooser.class$("uk.ac.starlink.datanode.nodes.TableHDUDataNode")) : class$uk$ac$starlink$datanode$nodes$TableHDUDataNode).getName(), (class$uk$ac$starlink$datanode$nodes$VOComponentDataNode == null ? (class$uk$ac$starlink$datanode$nodes$VOComponentDataNode = NdxNodeChooser.class$("uk.ac.starlink.datanode.nodes.VOComponentDataNode")) : class$uk$ac$starlink$datanode$nodes$VOComponentDataNode).getName(), (class$uk$ac$starlink$datanode$nodes$VOTableDataNode == null ? (class$uk$ac$starlink$datanode$nodes$VOTableDataNode = NdxNodeChooser.class$("uk.ac.starlink.datanode.nodes.VOTableDataNode")) : class$uk$ac$starlink$datanode$nodes$VOTableDataNode).getName(), (class$uk$ac$starlink$datanode$nodes$NDFDataNode == null ? (class$uk$ac$starlink$datanode$nodes$NDFDataNode = NdxNodeChooser.class$("uk.ac.starlink.datanode.nodes.NDFDataNode")) : class$uk$ac$starlink$datanode$nodes$NDFDataNode).getName(), (class$uk$ac$starlink$datanode$nodes$HistoryDataNode == null ? (class$uk$ac$starlink$datanode$nodes$HistoryDataNode = NdxNodeChooser.class$("uk.ac.starlink.datanode.nodes.HistoryDataNode")) : class$uk$ac$starlink$datanode$nodes$HistoryDataNode).getName()};
            ArrayList classes = new ArrayList();
            int i = 0;
            while (i < shunned.length) {
                try {
                    Class<?> clazz = Class.forName(shunned[i], true, Thread.currentThread().getContextClassLoader());
                    classes.add(clazz);
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
                ++i;
            }
            shunnedClassList = classes;
            deprecatedClassList = Arrays.asList(class$uk$ac$starlink$datanode$nodes$XMLDataNode == null ? (class$uk$ac$starlink$datanode$nodes$XMLDataNode = NdxNodeChooser.class$("uk.ac.starlink.datanode.nodes.XMLDataNode")) : class$uk$ac$starlink$datanode$nodes$XMLDataNode);
            preferredClassList = Arrays.asList(class$uk$ac$starlink$datanode$nodes$NdxDataNode == null ? (class$uk$ac$starlink$datanode$nodes$NdxDataNode = NdxNodeChooser.class$("uk.ac.starlink.datanode.nodes.NdxDataNode")) : class$uk$ac$starlink$datanode$nodes$NdxDataNode);
        }
        Iterator it = shunnedClassList.iterator();
        while (it.hasNext()) {
            fact.removeNodeClass((Class)it.next());
        }
        Iterator it2 = deprecatedClassList.iterator();
        while (it2.hasNext()) {
            fact.setDeprecatedClass((Class)it2.next());
        }
        Iterator it3 = preferredClassList.iterator();
        while (it3.hasNext()) {
            fact.setPreferredClass((Class)it3.next());
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        $assertionsDisabled = !(class$uk$ac$starlink$datanode$tree$NdxNodeChooser == null ? (class$uk$ac$starlink$datanode$tree$NdxNodeChooser = NdxNodeChooser.class$("uk.ac.starlink.datanode.tree.NdxNodeChooser")) : class$uk$ac$starlink$datanode$tree$NdxNodeChooser).desiredAssertionStatus();
    }
}

