/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.tree;

import java.util.Iterator;
import javax.swing.SwingUtilities;
import uk.ac.starlink.datanode.nodes.DataNode;
import uk.ac.starlink.datanode.tree.DataNodeTreeModel;
import uk.ac.starlink.datanode.tree.TreeModelNode;

public class NodeExpander {
    private boolean stopped;
    private boolean complete;
    private DataNodeTreeModel treeModel;
    private TreeModelNode modelNode;
    private DataNode dataNode;

    public NodeExpander(DataNodeTreeModel treeModel, TreeModelNode modelNode) {
        this.treeModel = treeModel;
        this.modelNode = modelNode;
        this.dataNode = modelNode.getDataNode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expandNode() {
        if (!this.dataNode.allowsChildren()) {
            this.stopped = true;
            this.complete = true;
        } else {
            this.repaintNode();
            Iterator it = this.dataNode.getChildIterator();
            while (!this.stopped && it.hasNext()) {
                DataNode childDataNode = (DataNode)it.next();
                TreeModelNode treeModelNode = this.modelNode;
                synchronized (treeModelNode) {
                    if (this.modelNode.getExpander() != this) {
                        this.stopped = true;
                    }
                    if (!this.stopped) {
                        this.treeModel.appendNode(childDataNode, this.dataNode);
                    }
                }
            }
            if (!this.stopped) {
                this.stopped = true;
                this.complete = true;
            }
            this.repaintNode();
        }
    }

    public void stop() {
        this.stopped = true;
    }

    public boolean isStopped() {
        return this.stopped;
    }

    public boolean isComplete() {
        return this.complete;
    }

    private void repaintNode() {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                if (NodeExpander.this.treeModel.containsNode(NodeExpander.this.dataNode)) {
                    NodeExpander.this.treeModel.repaintNode(NodeExpander.this.dataNode);
                }
            }
        });
    }
}

