/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.viewers;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import uk.ac.starlink.ast.AstObject;
import uk.ac.starlink.ast.Channel;
import uk.ac.starlink.datanode.viewers.TreeviewLAF;

public class AstTextShower
extends JPanel {
    public AstTextShower(AstObject astob) {
        this.setLayout(new BorderLayout());
        Box controlbox = new Box(1);
        Box commbox = new Box(0);
        Box fullbox = new Box(0);
        Box textbox = new Box(0);
        TreeviewLAF.configureControl(commbox);
        TreeviewLAF.configureControl(fullbox);
        TreeviewLAF.configureMainPanel(textbox);
        controlbox.add(commbox);
        controlbox.add(fullbox);
        this.add((Component)controlbox, "North");
        this.add((Component)textbox, "Center");
        final JTextArea ta = new JTextArea();
        final Document doc = ta.getDocument();
        ta.setEditable(false);
        textbox.add(ta);
        final Channel chan = new Channel(){

            public void sink(String line) {
                ta.append(line + "\n");
            }
        };
        final JCheckBox commbutt = new JCheckBox();
        commbutt.setSelected(chan.getComment());
        commbox.add(new JLabel("Display comments: "));
        commbox.add(commbutt);
        commbox.add(Box.createGlue());
        ButtonGroup bgrp = new ButtonGroup();
        JRadioButton bm = new JRadioButton("Minimum");
        JRadioButton b0 = new JRadioButton("Normal");
        JRadioButton bp = new JRadioButton("Maximum");
        bm.setActionCommand("-1");
        b0.setActionCommand("0");
        bp.setActionCommand("1");
        bgrp.add(bm);
        bgrp.add(b0);
        bgrp.add(bp);
        fullbox.add(new JLabel("Level of detail: "));
        fullbox.add(bm);
        fullbox.add(b0);
        fullbox.add(bp);
        fullbox.add(Box.createGlue());
        final AstObject astobject = astob;
        ActionListener listen = new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                if (evt.getSource() == commbutt) {
                    chan.setComment(commbutt.isSelected());
                } else {
                    chan.setFull(Integer.parseInt(evt.getActionCommand()));
                }
                Rectangle vis = AstTextShower.this.getVisibleRect();
                try {
                    doc.remove(0, doc.getLength());
                }
                catch (BadLocationException e) {
                    // empty catch block
                }
                try {
                    chan.write(astobject);
                }
                catch (IOException e) {
                    // empty catch block
                }
                ta.moveCaretPosition(0);
            }
        };
        commbutt.addActionListener(listen);
        bm.addActionListener(listen);
        b0.addActionListener(listen);
        bp.addActionListener(listen);
        b0.doClick();
    }
}

