/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.viewers;

import java.awt.Font;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Iterator;
import javax.swing.JTextArea;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import uk.ac.starlink.util.SourceReader;

public class TextViewer
extends JTextArea {
    private Writer appender = new Writer(){

        public void write(char[] cbuf, int off, int len) {
            TextViewer.this.append(new String(cbuf, off, len));
        }

        public void close() {
        }

        public void flush() {
        }
    };

    public TextViewer() {
        this.setEditable(false);
        Font font = new Font("Monospaced", this.getFont().getStyle(), this.getFont().getSize());
        this.setFont(font);
    }

    public TextViewer(final Source xsrc) {
        this();
        final SourceReader sr = new SourceReader();
        sr.setIndent(2);
        sr.setIncludeDeclaration(false);
        new Thread(){

            public void run() {
                try {
                    sr.writeSource(xsrc, TextViewer.this.appender);
                }
                catch (TransformerException e) {
                    e.printStackTrace(new PrintWriter(TextViewer.this.appender));
                }
            }
        }.start();
    }

    public TextViewer(Reader rdr) {
        this();
        final BufferedReader brdr = rdr instanceof BufferedReader ? (BufferedReader)rdr : new BufferedReader(rdr);
        new Thread(){

            /*
             * WARNING - void declaration
             */
            public void run() {
                try {
                    String line;
                    while ((line = brdr.readLine()) != null) {
                        void var1_1;
                        TextViewer.this.append((String)var1_1 + '\n');
                    }
                    brdr.close();
                }
                catch (IOException e) {
                    e.printStackTrace(new PrintWriter(TextViewer.this.appender));
                }
            }
        }.start();
    }

    public TextViewer(InputStream strm) {
        this(new InputStreamReader(strm));
    }

    public TextViewer(Iterator it) {
        this();
        while (it.hasNext()) {
            this.append(it.next().toString() + "\n");
        }
    }

    public TextViewer(Throwable th) {
        this();
        PrintWriter pw = new PrintWriter(this.appender);
        th.printStackTrace(pw);
        pw.close();
    }

    public Writer getAppender() {
        return this.appender;
    }
}

