/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.registry.client;

import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.astrogrid.config.Config;
import org.astrogrid.config.SimpleConfig;
import org.astrogrid.registry.client.admin.RegistryAdminService;
import org.astrogrid.registry.client.admin.UpdateRegistry;
import org.astrogrid.registry.client.harvest.RegistryHarvestService;
import org.astrogrid.registry.client.query.QueryRegistry;
import org.astrogrid.registry.client.query.RegistryService;

public class RegistryDelegateFactory {
    private static final Log logger = LogFactory.getLog((Class)RegistryDelegateFactory.class);
    public static Config conf = null;
    public static final String QUERY_URL_PROPERTY = "org.astrogrid.registry.query.endpoint";
    public static final String ADMIN_URL_PROPERTY = "org.astrogrid.registry.admin.endpoint";
    public static final String HARVEST_URL_PROPERTY = "org.astrogrid.registry.harvest.endpoint";

    public static synchronized RegistryService createQuery() {
        return RegistryDelegateFactory.createQuery(conf.getUrl(QUERY_URL_PROPERTY, null));
    }

    public static synchronized RegistryService createQuery(URL endPoint) {
        logger.info((Object)("createQuery(URL) - the ENDPOINT AT DELEGATE = '" + endPoint + "'"));
        return new QueryRegistry(endPoint);
    }

    public static synchronized RegistryAdminService createAdmin() {
        return RegistryDelegateFactory.createAdmin(conf.getUrl(ADMIN_URL_PROPERTY, null));
    }

    public static synchronized RegistryAdminService createAdmin(URL endPoint) {
        return new UpdateRegistry(endPoint);
    }

    public static synchronized RegistryHarvestService createHarvest() {
        return RegistryDelegateFactory.createHarvest(conf.getUrl(HARVEST_URL_PROPERTY, null));
    }

    public static synchronized RegistryHarvestService createHarvest(URL endPoint) {
        return new RegistryHarvestService(endPoint);
    }

    static {
        if (conf == null) {
            conf = SimpleConfig.getSingleton();
        }
    }
}

