/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.registry.client.admin;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.enum.Style;
import org.apache.axis.enum.Use;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.astrogrid.config.Config;
import org.astrogrid.config.SimpleConfig;
import org.astrogrid.registry.RegistryException;
import org.astrogrid.registry.client.admin.RegistryAdminService;
import org.astrogrid.util.DomHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class UpdateRegistry
implements RegistryAdminService {
    private static final Log logger = LogFactory.getLog((Class)UpdateRegistry.class);
    private static final String NAMESPACE_URI = "http://www.ivoa.net/schemas/services/UpdateRegistry/wsdl";
    public static final String ADMIN_URL_PROPERTY = "org.astrogrid.registry.admin.endpoint";
    private boolean validated = false;
    private URL endPoint = null;
    public static Config conf = null;

    public UpdateRegistry() {
        this(conf.getUrl(ADMIN_URL_PROPERTY, null));
    }

    public UpdateRegistry(URL endPoint) {
        this.endPoint = endPoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Call getCall() {
        Call _call = null;
        try {
            Service service = new Service();
            _call = (Call)service.createCall();
            _call.setTargetEndpointAddress(this.endPoint);
            _call.setSOAPActionURI("");
            _call.setOperationStyle(Style.MESSAGE);
            _call.setOperationUse(Use.LITERAL);
            _call.setEncodingStyle(null);
        }
        catch (ServiceException se) {
            logger.error((Object)"getCall()", (Throwable)se);
            _call = null;
            return _call;
        }
        finally {
            return _call;
        }
    }

    public void harvestResource(Document harvestDoc) throws RegistryException {
        throw new RegistryException("Not implemented yet");
    }

    public Document update(Document update) throws RegistryException {
        Object registryBuilder = null;
        Object doc = null;
        Document resultDoc = null;
        Element root = update.createElementNS(NAMESPACE_URI, "Update");
        root.appendChild(update.getDocumentElement());
        update.appendChild(root);
        Call call = this.getCall();
        logger.info((Object)("update(Document) - the endpoint = " + this.endPoint));
        logger.info((Object)("update(Document) - okay calling update service with doc = " + DomHelper.DocumentToString((Document)update)));
        SOAPBodyElement sbeRequest = new SOAPBodyElement(update.getDocumentElement());
        sbeRequest.setName("Update");
        sbeRequest.setNamespaceURI(NAMESPACE_URI);
        try {
            Vector result = (Vector)call.invoke(new Object[]{sbeRequest});
            if (result.size() > 0) {
                SOAPBodyElement sbe = (SOAPBodyElement)result.get(0);
                resultDoc = sbe.getAsDocument();
            }
        }
        catch (RemoteException re) {
            resultDoc = null;
            throw new RegistryException((Throwable)re);
        }
        catch (Exception e) {
            resultDoc = null;
            throw new RegistryException((Throwable)e);
        }
        return resultDoc;
    }

    public Document updateFromFile(File fi) throws RegistryException {
        try {
            return this.update(DomHelper.newDocument((File)fi));
        }
        catch (IOException ioe) {
            throw new RegistryException((Throwable)ioe);
        }
        catch (SAXException sax) {
            throw new RegistryException((Throwable)sax);
        }
        catch (ParserConfigurationException pce) {
            throw new RegistryException((Throwable)pce);
        }
    }

    public Document updateFromURL(URL location) throws RegistryException {
        try {
            return this.update(DomHelper.newDocument((URL)location));
        }
        catch (IOException ioe) {
            throw new RegistryException((Throwable)ioe);
        }
        catch (SAXException sax) {
            throw new RegistryException((Throwable)sax);
        }
        catch (ParserConfigurationException pce) {
            throw new RegistryException((Throwable)pce);
        }
    }

    public Document updateFromString(String voresources) throws RegistryException {
        try {
            return this.update(DomHelper.newDocument((String)voresources));
        }
        catch (IOException ioe) {
            throw new RegistryException((Throwable)ioe);
        }
        catch (SAXException sax) {
            throw new RegistryException((Throwable)sax);
        }
        catch (ParserConfigurationException pce) {
            throw new RegistryException((Throwable)pce);
        }
    }

    public String getCurrentStatus() {
        String status = "";
        try {
            Document doc = this.getStatus();
            NodeList nl = doc.getElementsByTagName("status");
            for (int i = 0; i < nl.getLength(); ++i) {
                Node nd = nl.item(i);
                if (!nd.hasChildNodes()) continue;
                status = status + nd.getFirstChild().getNodeValue();
            }
        }
        catch (Exception e) {
            logger.error((Object)"getCurrentStatus()", (Throwable)e);
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Document getStatus() {
        Document doc = null;
        Document resultDoc = null;
        try {
            DocumentBuilder registryBuilder = null;
            registryBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            doc = registryBuilder.newDocument();
            Element root = doc.createElementNS(NAMESPACE_URI, "getStatus");
            doc.appendChild(root);
        }
        catch (ParserConfigurationException pce) {
            doc = null;
            logger.error((Object)"getStatus()", (Throwable)pce);
        }
        if (doc == null) {
            return null;
        }
        Call call = this.getCall();
        SOAPBodyElement sbeRequest = new SOAPBodyElement(doc.getDocumentElement());
        sbeRequest.setName("getStatus");
        sbeRequest.setNamespaceURI(NAMESPACE_URI);
        try {
            Vector result = (Vector)call.invoke(new Object[]{sbeRequest});
            SOAPBodyElement sbe = null;
            if (result.size() > 0) {
                sbe = (SOAPBodyElement)result.get(0);
                resultDoc = sbe.getAsDocument();
                return resultDoc;
            }
        }
        catch (RemoteException re) {
            resultDoc = null;
            logger.error((Object)"getStatus()", (Throwable)re);
        }
        catch (Exception e) {
            resultDoc = null;
            logger.error((Object)"getStatus()", (Throwable)e);
        }
        finally {
            return resultDoc;
        }
    }

    static {
        if (conf == null) {
            conf = SimpleConfig.getSingleton();
        }
    }
}

