/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.registry.client.harvest;

import java.net.URL;
import java.rmi.RemoteException;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.enum.Style;
import org.apache.axis.enum.Use;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.axis.utils.XMLUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class RegistryHarvestService {
    private static final Log logger = LogFactory.getLog((Class)RegistryHarvestService.class);
    private URL endPoint = null;
    private static final String NAMESPACE_URI = "http://harvest.server.registry.astrogrid.org";

    public RegistryHarvestService() {
        this(null);
    }

    public RegistryHarvestService(URL endPoint) {
        this.endPoint = endPoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Call getCall() {
        Call _call = null;
        try {
            Service service = new Service();
            _call = (Call)service.createCall();
            _call.setTargetEndpointAddress(this.endPoint);
            _call.setSOAPActionURI("");
            _call.setOperationStyle(Style.MESSAGE);
            _call.setOperationUse(Use.LITERAL);
            _call.setEncodingStyle(null);
        }
        catch (ServiceException se) {
            logger.error((Object)"getCall()", (Throwable)se);
            _call = null;
            return _call;
        }
        finally {
            return _call;
        }
    }

    public Document harvest(Document query) {
        try {
            Call call = this.getCall();
            DocumentBuilder registryBuilder = null;
            registryBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = registryBuilder.newDocument();
            Element root = doc.createElementNS(NAMESPACE_URI, "harvest");
            doc.appendChild(root);
            SOAPBodyElement sbeRequest = new SOAPBodyElement(doc.getDocumentElement());
            sbeRequest.setName("harvest");
            sbeRequest.setNamespaceURI(NAMESPACE_URI);
            Vector result = (Vector)call.invoke(new Object[]{sbeRequest});
            SOAPBodyElement sbe = (SOAPBodyElement)result.get(0);
            return sbe.getAsDocument();
        }
        catch (ParserConfigurationException pce) {
            logger.error((Object)"harvest(Document)", (Throwable)pce);
        }
        catch (RemoteException re) {
            logger.error((Object)"harvest(Document)", (Throwable)re);
        }
        catch (Exception e) {
            logger.error((Object)"harvest(Document)", (Throwable)e);
        }
        return null;
    }

    public Document harvestFrom(Document query) {
        try {
            Call call = this.getCall();
            DocumentBuilder registryBuilder = null;
            registryBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = registryBuilder.newDocument();
            Element root = doc.createElementNS(NAMESPACE_URI, "harvestFrom");
            doc.appendChild(root);
            Node nd = doc.importNode(query.getDocumentElement(), true);
            root.appendChild(nd);
            SOAPBodyElement sbeRequest = new SOAPBodyElement(doc.getDocumentElement());
            sbeRequest.setName("harvestFrom");
            sbeRequest.setNamespaceURI(NAMESPACE_URI);
            Vector result = (Vector)call.invoke(new Object[]{sbeRequest});
            SOAPBodyElement sbe = (SOAPBodyElement)result.get(0);
            logger.info((Object)("harvestFrom(Document) - received " + XMLUtils.DocumentToString((Document)sbe.getAsDocument())));
            return sbe.getAsDocument();
        }
        catch (ParserConfigurationException pce) {
            logger.error((Object)"harvestFrom(Document)", (Throwable)pce);
        }
        catch (RemoteException re) {
            logger.error((Object)"harvestFrom(Document)", (Throwable)re);
        }
        catch (Exception e) {
            logger.error((Object)"harvestFrom(Document)", (Throwable)e);
        }
        return null;
    }

    public void harvestAll(Document query) {
        try {
            Call call = this.getCall();
            DocumentBuilder registryBuilder = null;
            registryBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = registryBuilder.newDocument();
            Element root = doc.createElementNS(NAMESPACE_URI, "harvestAll");
            doc.appendChild(root);
            if (query != null) {
                Node nd = doc.importNode(query.getDocumentElement(), true);
                root.appendChild(nd);
            }
            SOAPBodyElement sbeRequest = new SOAPBodyElement(doc.getDocumentElement());
            sbeRequest.setName("harvestAll");
            sbeRequest.setNamespaceURI(NAMESPACE_URI);
            call.invokeOneWay(new Object[]{sbeRequest});
        }
        catch (ParserConfigurationException pce) {
            logger.error((Object)"harvestAll(Document)", (Throwable)pce);
        }
        catch (Exception e) {
            logger.error((Object)"harvestAll(Document)", (Throwable)e);
        }
    }

    public void harvestResource(Document query) {
        try {
            logger.info((Object)("harvestResource(Document) - okay doing Call and endpoint = " + this.endPoint.toString()));
            Call call = this.getCall();
            DocumentBuilder registryBuilder = null;
            registryBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = registryBuilder.newDocument();
            Element root = doc.createElementNS(NAMESPACE_URI, "harvestResource");
            doc.appendChild(root);
            Node nd = doc.importNode(query.getDocumentElement(), true);
            root.appendChild(nd);
            SOAPBodyElement sbeRequest = new SOAPBodyElement(doc.getDocumentElement());
            sbeRequest.setName("harvestResource");
            sbeRequest.setNamespaceURI(NAMESPACE_URI);
            logger.info((Object)("harvestResource(Document) - Invoking this doc = " + XMLUtils.DocumentToString((Document)query)));
            call.invokeOneWay(new Object[]{sbeRequest});
        }
        catch (ParserConfigurationException pce) {
            logger.error((Object)"harvestResource(Document)", (Throwable)pce);
        }
        catch (Exception e) {
            logger.error((Object)"harvestResource(Document)", (Throwable)e);
        }
    }

    public void harvestFromResource(Document query) {
        try {
            Call call = this.getCall();
            DocumentBuilder registryBuilder = null;
            registryBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = registryBuilder.newDocument();
            Element root = doc.createElementNS(NAMESPACE_URI, "harvestFromResource");
            doc.appendChild(root);
            Node nd = doc.importNode(query.getDocumentElement(), true);
            root.appendChild(nd);
            SOAPBodyElement sbeRequest = new SOAPBodyElement(doc.getDocumentElement());
            sbeRequest.setName("harvestFromResource");
            sbeRequest.setNamespaceURI(NAMESPACE_URI);
            call.invokeOneWay(new Object[]{sbeRequest});
        }
        catch (ParserConfigurationException pce) {
            logger.error((Object)"harvestFromResource(Document)", (Throwable)pce);
        }
        catch (Exception e) {
            logger.error((Object)"harvestFromResource(Document)", (Throwable)e);
        }
    }
}

