/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.registry.client.query;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.wsdl.Definition;
import javax.wsdl.Port;
import javax.wsdl.Service;
import javax.wsdl.WSDLException;
import javax.wsdl.extensions.ExtensibilityElement;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.wsdl.factory.WSDLFactory;
import javax.wsdl.xml.WSDLReader;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.rpc.ServiceException;
import org.apache.axis.client.Call;
import org.apache.axis.enum.Style;
import org.apache.axis.enum.Use;
import org.apache.axis.message.SOAPBodyElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.astrogrid.config.Config;
import org.astrogrid.config.SimpleConfig;
import org.astrogrid.registry.RegistryException;
import org.astrogrid.registry.client.query.RegistryService;
import org.astrogrid.registry.client.query.ServiceData;
import org.astrogrid.registry.common.InterfaceType;
import org.astrogrid.registry.common.WSDLBasicInformation;
import org.astrogrid.store.Ivorn;
import org.astrogrid.util.DomHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class QueryRegistry
implements RegistryService {
    private static final Log logger = LogFactory.getLog((Class)QueryRegistry.class);
    private URL endPoint = null;
    private boolean useCache = false;
    private static final String NAMESPACE_URI = "http://www.ivoa.net/schemas/services/QueryRegistry/wsdl";
    private static final String QUERY_URL_PROPERTY = "org.astrogrid.registry.query.endpoint";
    public static Config conf = null;

    public QueryRegistry() {
        this(conf.getUrl(QUERY_URL_PROPERTY, null));
    }

    public QueryRegistry(URL endPoint) {
        logger.info((Object)"QueryRegistry(URL) - entered const(url) of RegistryService");
        this.endPoint = endPoint;
        if (this.endPoint == null) {
            logger.warn((Object)"endpoint is null, using cache");
            this.useCache = true;
        }
        logger.info((Object)"QueryRegistry(URL) - exiting const(url) of RegistryService");
    }

    private Call getCall() throws ServiceException {
        logger.info((Object)"getCall() - entered getCall()");
        Call _call = null;
        org.apache.axis.client.Service service = new org.apache.axis.client.Service();
        _call = (Call)service.createCall();
        _call.setTargetEndpointAddress(this.endPoint);
        _call.setSOAPActionURI("");
        _call.setOperationStyle(Style.MESSAGE);
        _call.setOperationUse(Use.LITERAL);
        _call.setEncodingStyle(null);
        return _call;
    }

    public Document searchFromSADQL(String adql) throws RegistryException {
        throw new RegistryException("No implementation for adqls.");
    }

    public Document search(String xadql) throws RegistryException {
        try {
            return this.search(DomHelper.newDocument((String)xadql));
        }
        catch (ParserConfigurationException pce) {
            throw new RegistryException((Throwable)pce);
        }
        catch (IOException ioe) {
            throw new RegistryException((Throwable)ioe);
        }
        catch (SAXException sax) {
            throw new RegistryException((Throwable)sax);
        }
    }

    public Document search(Document adql) throws RegistryException {
        Element currentRoot = adql.getDocumentElement();
        Element newRoot = adql.createElementNS(NAMESPACE_URI, "Search");
        newRoot.appendChild(currentRoot);
        adql.appendChild(newRoot);
        try {
            Call call = this.getCall();
            SOAPBodyElement sbeRequest = new SOAPBodyElement(adql.getDocumentElement());
            sbeRequest.setName("Search");
            sbeRequest.setNamespaceURI(NAMESPACE_URI);
            Vector result = (Vector)call.invoke(new Object[]{sbeRequest});
            SOAPBodyElement sbe = null;
            if (result.size() > 0) {
                sbe = (SOAPBodyElement)result.get(0);
                return sbe.getAsDocument();
            }
        }
        catch (RemoteException re) {
            throw new RegistryException((Throwable)re);
        }
        catch (ServiceException se) {
            throw new RegistryException((Throwable)se);
        }
        catch (Exception e) {
            throw new RegistryException((Throwable)e);
        }
        throw new RegistryException("Server error must have occurred.");
    }

    public Document getRegistries() throws RegistryException {
        Document doc = null;
        Object resultDoc = null;
        try {
            logger.info((Object)"getRegistries() - creating full soap element.");
            doc = DomHelper.newDocument();
            Element root = doc.createElementNS(NAMESPACE_URI, "GetRegistries");
            doc.appendChild(root);
        }
        catch (ParserConfigurationException pce) {
            throw new RegistryException((Throwable)pce);
        }
        try {
            Call call = this.getCall();
            SOAPBodyElement sbeRequest = new SOAPBodyElement(doc.getDocumentElement());
            sbeRequest.setName("GetRegistries");
            sbeRequest.setNamespaceURI(NAMESPACE_URI);
            Vector result = (Vector)call.invoke(new Object[]{sbeRequest});
            SOAPBodyElement sbe = null;
            if (result.size() > 0) {
                sbe = (SOAPBodyElement)result.get(0);
                return sbe.getAsDocument();
            }
        }
        catch (RemoteException re) {
            throw new RegistryException((Throwable)re);
        }
        catch (ServiceException se) {
            throw new RegistryException((Throwable)se);
        }
        catch (Exception e) {
            throw new RegistryException((Throwable)e);
        }
        throw new RegistryException("Error from server it returned nothing");
    }

    public Document identify() throws RegistryException {
        Document doc = null;
        Object resultDoc = null;
        try {
            logger.info((Object)"identify() - creating full soap element.");
            doc = DomHelper.newDocument();
            Element root = doc.createElementNS(NAMESPACE_URI, "Identify");
            doc.appendChild(root);
        }
        catch (ParserConfigurationException pce) {
            throw new RegistryException((Throwable)pce);
        }
        try {
            Call call = this.getCall();
            SOAPBodyElement sbeRequest = new SOAPBodyElement(doc.getDocumentElement());
            sbeRequest.setName("Identify");
            sbeRequest.setNamespaceURI(NAMESPACE_URI);
            Vector result = (Vector)call.invoke(new Object[]{sbeRequest});
            SOAPBodyElement sbe = null;
            if (result.size() > 0) {
                sbe = (SOAPBodyElement)result.get(0);
                return sbe.getAsDocument();
            }
        }
        catch (RemoteException re) {
            throw new RegistryException((Throwable)re);
        }
        catch (ServiceException se) {
            throw new RegistryException((Throwable)se);
        }
        catch (Exception e) {
            throw new RegistryException((Throwable)e);
        }
        throw new RegistryException("Error from server it returned nothing");
    }

    public Document listRecords() throws RegistryException {
        return this.listRecords(null, null, null);
    }

    public Document listRecords(Date fromDate) throws RegistryException {
        return this.listRecords(null, fromDate, null);
    }

    public Document listRecords(String metadataPrefix, Date fromDate, Date untilDate) throws RegistryException {
        Document doc = null;
        Object resultDoc = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            logger.info((Object)"listRecords(String, Date, Date) - creating full soap element.");
            doc = DomHelper.newDocument();
            Element root = doc.createElementNS(NAMESPACE_URI, "ListRecords");
            doc.appendChild(root);
            Element temp = null;
            if (metadataPrefix != null && metadataPrefix.trim().length() > 0) {
                temp = doc.createElement("metadataPrefix");
                temp.appendChild(doc.createTextNode(metadataPrefix));
                root.appendChild(temp);
            }
            if (fromDate != null) {
                temp = doc.createElement("from");
                temp.appendChild(doc.createTextNode(sdf.format(fromDate)));
                root.appendChild(temp);
            }
            if (untilDate != null) {
                temp = doc.createElement("until");
                temp.appendChild(doc.createTextNode(sdf.format(untilDate)));
                root.appendChild(temp);
            }
        }
        catch (ParserConfigurationException pce) {
            throw new RegistryException((Throwable)pce);
        }
        try {
            Call call = this.getCall();
            SOAPBodyElement sbeRequest = new SOAPBodyElement(doc.getDocumentElement());
            sbeRequest.setName("ListRecords");
            sbeRequest.setNamespaceURI(NAMESPACE_URI);
            logger.info((Object)("listRecords(String, Date, Date) - List Records Client-side = " + DomHelper.DocumentToString((Document)doc)));
            Vector result = (Vector)call.invoke(new Object[]{sbeRequest});
            SOAPBodyElement sbe = null;
            if (result.size() > 0) {
                sbe = (SOAPBodyElement)result.get(0);
                return sbe.getAsDocument();
            }
        }
        catch (RemoteException re) {
            throw new RegistryException((Throwable)re);
        }
        catch (ServiceException se) {
            throw new RegistryException((Throwable)se);
        }
        catch (Exception e) {
            throw new RegistryException((Throwable)e);
        }
        throw new RegistryException("Error from server it returned nothing");
    }

    public Document listMetadataFormats(String identifier) throws RegistryException {
        Document doc = null;
        Object resultDoc = null;
        try {
            logger.info((Object)"listMetadataFormats(String) - creating full soap element.");
            doc = DomHelper.newDocument();
            Element root = doc.createElementNS(NAMESPACE_URI, "ListMetadataFormats");
            doc.appendChild(root);
            if (identifier != null || identifier.trim().length() > 0) {
                Element temp = doc.createElement("identifier");
                temp.appendChild(doc.createTextNode(identifier));
                root.appendChild(temp);
            }
        }
        catch (ParserConfigurationException pce) {
            throw new RegistryException((Throwable)pce);
        }
        try {
            Call call = this.getCall();
            SOAPBodyElement sbeRequest = new SOAPBodyElement(doc.getDocumentElement());
            sbeRequest.setName("ListMetadataFormats");
            sbeRequest.setNamespaceURI(NAMESPACE_URI);
            Vector result = (Vector)call.invoke(new Object[]{sbeRequest});
            SOAPBodyElement sbe = null;
            if (result.size() > 0) {
                sbe = (SOAPBodyElement)result.get(0);
                return sbe.getAsDocument();
            }
        }
        catch (RemoteException re) {
            throw new RegistryException((Throwable)re);
        }
        catch (ServiceException se) {
            throw new RegistryException((Throwable)se);
        }
        catch (Exception e) {
            throw new RegistryException((Throwable)e);
        }
        throw new RegistryException("Error from server it returned nothing");
    }

    public Document getRecord(String identifier) throws RegistryException {
        return this.getRecord(identifier, null);
    }

    public Document getRecord(String identifier, String metadataPrefix) throws RegistryException {
        Document doc = null;
        Object resultDoc = null;
        try {
            logger.info((Object)"getRecord(String, String) - creating full soap element.");
            doc = DomHelper.newDocument();
            Element root = doc.createElementNS(NAMESPACE_URI, "GetRecord");
            doc.appendChild(root);
            Element temp = null;
            if (identifier == null || identifier.trim().length() <= 0) {
                throw new RegistryException("Error From Client: No identifier found for calling GetRecord");
            }
            temp = doc.createElement("identifier");
            temp.appendChild(doc.createTextNode(identifier));
            root.appendChild(temp);
            if (metadataPrefix != null && metadataPrefix.trim().length() > 0) {
                temp = doc.createElement("metadataPrefix");
                temp.appendChild(doc.createTextNode(metadataPrefix));
                root.appendChild(temp);
            }
        }
        catch (ParserConfigurationException pce) {
            throw new RegistryException((Throwable)pce);
        }
        try {
            Call call = this.getCall();
            SOAPBodyElement sbeRequest = new SOAPBodyElement(doc.getDocumentElement());
            sbeRequest.setName("GetRecord");
            sbeRequest.setNamespaceURI(NAMESPACE_URI);
            Vector result = (Vector)call.invoke(new Object[]{sbeRequest});
            SOAPBodyElement sbe = null;
            if (result.size() > 0) {
                sbe = (SOAPBodyElement)result.get(0);
                return sbe.getAsDocument();
            }
        }
        catch (RemoteException re) {
            throw new RegistryException((Throwable)re);
        }
        catch (ServiceException se) {
            throw new RegistryException((Throwable)se);
        }
        catch (Exception e) {
            throw new RegistryException((Throwable)e);
        }
        throw new RegistryException("Error from server it returned nothing");
    }

    public Document listIdentifiers() throws RegistryException {
        return this.listIdentifiers(null, null, null);
    }

    public Document listIdentifiers(String metadataPrefix, Date fromDate, Date untilDate) throws RegistryException {
        Document doc = null;
        Object resultDoc = null;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            logger.info((Object)"listIdentifiers(String, Date, Date) - creating full soap element.");
            doc = DomHelper.newDocument();
            Element root = doc.createElementNS(NAMESPACE_URI, "ListIdentifiers");
            doc.appendChild(root);
            Element temp = null;
            if (metadataPrefix != null && metadataPrefix.trim().length() > 0) {
                temp = doc.createElement("metadataPrefix");
                temp.appendChild(doc.createTextNode(metadataPrefix));
                root.appendChild(temp);
            }
            if (fromDate != null) {
                temp = doc.createElement("from");
                temp.appendChild(doc.createTextNode(sdf.format(fromDate)));
                root.appendChild(temp);
            }
            if (untilDate != null) {
                temp = doc.createElement("until");
                temp.appendChild(doc.createTextNode(sdf.format(untilDate)));
                root.appendChild(temp);
            }
        }
        catch (ParserConfigurationException pce) {
            throw new RegistryException((Throwable)pce);
        }
        try {
            Call call = this.getCall();
            SOAPBodyElement sbeRequest = new SOAPBodyElement(doc.getDocumentElement());
            sbeRequest.setName("ListIdentifiers");
            sbeRequest.setNamespaceURI(NAMESPACE_URI);
            Vector result = (Vector)call.invoke(new Object[]{sbeRequest});
            SOAPBodyElement sbe = null;
            if (result.size() > 0) {
                sbe = (SOAPBodyElement)result.get(0);
                return sbe.getAsDocument();
            }
        }
        catch (RemoteException re) {
            throw new RegistryException((Throwable)re);
        }
        catch (ServiceException se) {
            throw new RegistryException((Throwable)se);
        }
        catch (Exception e) {
            throw new RegistryException((Throwable)e);
        }
        throw new RegistryException("Error from server it returned nothing");
    }

    public Document submitQuery(String query) throws RegistryException {
        logger.info((Object)"submitQuery(String) - entered submitQueryStringDOM()");
        try {
            return this.submitQuery(DomHelper.newDocument((String)query));
        }
        catch (ParserConfigurationException pce) {
            throw new RegistryException((Throwable)pce);
        }
        catch (IOException ioe) {
            throw new RegistryException((Throwable)ioe);
        }
        catch (SAXException sax) {
            throw new RegistryException((Throwable)sax);
        }
    }

    public Document submitQuery(Document query) throws RegistryException {
        logger.info((Object)"submitQuery(Document) - entered submitQueryDOM()");
        Document doc = null;
        Object resultDoc = null;
        try {
            logger.info((Object)"submitQuery(Document) - creating full soap element.");
            doc = DomHelper.newDocument();
            Element root = doc.createElementNS(NAMESPACE_URI, "submitQuery");
            doc.appendChild(root);
            Node nd = doc.importNode(query.getDocumentElement(), true);
            root.appendChild(nd);
        }
        catch (ParserConfigurationException pce) {
            throw new RegistryException((Throwable)pce);
        }
        try {
            Call call = this.getCall();
            SOAPBodyElement sbeRequest = new SOAPBodyElement(doc.getDocumentElement());
            sbeRequest.setName("submitQuery");
            sbeRequest.setNamespaceURI(NAMESPACE_URI);
            Vector result = (Vector)call.invoke(new Object[]{sbeRequest});
            SOAPBodyElement sbe = null;
            if (result.size() > 0) {
                sbe = (SOAPBodyElement)result.get(0);
                return sbe.getAsDocument();
            }
            return DomHelper.newDocument();
        }
        catch (RemoteException re) {
            throw new RegistryException((Throwable)re);
        }
        catch (ServiceException se) {
            throw new RegistryException((Throwable)se);
        }
        catch (Exception e) {
            throw new RegistryException((Throwable)e);
        }
    }

    public Document loadRegistry() throws RegistryException {
        logger.info((Object)"loadRegistry() - loadRegistry");
        Document doc = null;
        Object resultDoc = null;
        try {
            DocumentBuilder registryBuilder = null;
            registryBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            doc = registryBuilder.newDocument();
            Element root = doc.createElementNS(NAMESPACE_URI, "loadRegistry");
            doc.appendChild(root);
        }
        catch (ParserConfigurationException pce) {
            throw new RegistryException((Throwable)pce);
        }
        try {
            Call call = this.getCall();
            SOAPBodyElement sbeRequest = new SOAPBodyElement(doc.getDocumentElement());
            sbeRequest.setName("loadRegistry");
            sbeRequest.setNamespaceURI(NAMESPACE_URI);
            Vector result = (Vector)call.invoke(new Object[]{sbeRequest});
            SOAPBodyElement sbe = null;
            if (result.size() > 0) {
                sbe = (SOAPBodyElement)result.get(0);
                return sbe.getAsDocument();
            }
        }
        catch (RemoteException re) {
            throw new RegistryException((Throwable)re);
        }
        catch (ServiceException se) {
            throw new RegistryException((Throwable)se);
        }
        catch (Exception e) {
            throw new RegistryException((Throwable)e);
        }
        throw new RegistryException("Error server returned nothing");
    }

    public HashMap managedAuthorities() throws RegistryException {
        logger.info((Object)"managedAuthorities() - entered managedAuthorities");
        HashMap<String, Object> hm = null;
        Document doc = this.loadRegistry();
        if (doc != null) {
            NodeList nl = doc.getElementsByTagNameNS("*", "ManagedAuthority");
            hm = new HashMap<String, Object>();
            for (int i = 0; i < nl.getLength(); ++i) {
                hm.put(nl.item(i).getFirstChild().getNodeValue(), null);
            }
        }
        logger.info((Object)"managedAuthorities() - exiting managedAuthorities");
        return hm;
    }

    public Document getResourceByIdentifier(Ivorn ident) throws RegistryException {
        if (ident == null) {
            throw new RegistryException("Cannot call this method with a null ivorn identifier");
        }
        return this.getResourceByIdentifier(ident.getPath());
    }

    public Document getResourceByIdentifier(String ident) throws RegistryException {
        Document doc = null;
        logger.info((Object)"getResourceByIdentifier(String) - entered getResourceByIdentifierDOM");
        if (ident == null) {
            throw new RegistryException("Cannot call this method with a null identifier");
        }
        logger.info((Object)("getResourceByIdentifier(String) - using ident = " + ident));
        if (!this.useCache) {
            NodeList resultList;
            int iTemp = 0;
            iTemp = ident.indexOf("/");
            if (iTemp == -1) {
                iTemp = ident.length();
            }
            String selectQuery = "<query><selectionSequence><selection item='searchElements' itemOp='EQ' value='all'/><selectionOp op='$and$'/><selection item='vr:Identifier/vr:AuthorityID' itemOp='EQ' value='" + ident.substring(0, iTemp) + "'/>";
            if (iTemp < ident.length()) {
                selectQuery = selectQuery + "<selectionOp op='AND'/><selection item='vr:Identifier/vr:ResourceKey' itemOp='EQ' value='" + ident.substring(iTemp + 1) + "'/>";
            }
            if ((resultList = (doc = this.submitQuery(selectQuery = selectQuery + "</selectionSequence></query>")).getElementsByTagNameNS("*", "Resource")).getLength() == 0) {
                throw new RegistryException("No Resource Found for ident = " + ident);
            }
            if (resultList.getLength() > 1) {
                throw new RegistryException("Found more than one Resource for Ident = " + ident);
            }
            logger.info((Object)"getResourceByIdentifier(String) - exiting getResourceByIdentifierDOM (did not use config cache)");
            return doc;
        }
        logger.info((Object)"getResourceByIdentifier(String) - exiting getResourceByIdentifierDOM (used config cache)");
        return conf.getDom(ident);
    }

    public URL[] getEndPointByInterfaceType(InterfaceType interfaceType) throws RegistryException {
        ServiceData[] sd = this.getResourcesByInterfaceType(interfaceType);
        URL[] serviceURL = new URL[sd.length];
        for (int i = 0; i < sd.length; ++i) {
            serviceURL[i] = sd[i].getAccessURL();
        }
        return serviceURL;
    }

    public ServiceData[] getResourcesByInterfaceType(InterfaceType interfaceType) throws RegistryException {
        Document doc = null;
        if (interfaceType == null) {
            throw new RegistryException("No interfaceType defined");
        }
        String type = interfaceType.getInterfaceType();
        logger.info((Object)("getResourcesByInterfaceType(InterfaceType) type - " + type));
        String selectQuery = "<query><selectionSequence><selection item='searchElements' itemOp='EQ' value='all'/><selectionOp op='$and$'/><selection item='vr:RelatedResource/vr:Relationship' itemOp='EQ' value='derived-from'/><selectionOp op='AND'/><selection item='vr:RelatedResource/vr:RelatedTo/vr:Identifier/vr:ResourceKey' itemOp='EQ' value='" + type + "'/>";
        selectQuery = selectQuery + "</selectionSequence></query>";
        doc = this.submitQuery(selectQuery);
        logger.info((Object)"getResourcesByInterfaceType(InterfaceType) - exiting getResourcesByInterfaceType");
        return this.createServiceData(doc);
    }

    private ServiceData[] createServiceData(Document doc) {
        NodeList nl = doc.getElementsByTagNameNS("*", "Resource");
        ServiceData[] sd = new ServiceData[nl.getLength()];
        NodeList serviceNodes = null;
        String authority = null;
        String resKey = null;
        for (int i = 0; i < nl.getLength(); ++i) {
            sd[i] = new ServiceData();
            serviceNodes = ((Element)nl.item(i)).getElementsByTagNameNS("*", "Title");
            if (serviceNodes.getLength() > 0) {
                sd[i].setTitle(DomHelper.getValue((Element)((Element)serviceNodes.item(0))));
            }
            if ((serviceNodes = ((Element)nl.item(i)).getElementsByTagNameNS("*", "Description")).getLength() > 0) {
                sd[i].setDescription(DomHelper.getValue((Element)((Element)serviceNodes.item(0))));
            }
            if ((serviceNodes = ((Element)nl.item(i)).getElementsByTagNameNS("*", "AccessURL")).getLength() > 0) {
                try {
                    sd[i].setAccessURL(new URL(DomHelper.getValue((Element)((Element)serviceNodes.item(0)))));
                }
                catch (MalformedURLException mfe) {
                    logger.error((Object)mfe);
                }
            }
            if ((serviceNodes = ((Element)nl.item(i)).getElementsByTagNameNS("*", "AuthorityID")).getLength() <= 0) continue;
            authority = DomHelper.getValue((Element)((Element)serviceNodes.item(0)));
            serviceNodes = ((Element)nl.item(i)).getElementsByTagNameNS("*", "ResourceKey");
            resKey = DomHelper.getValue((Element)((Element)serviceNodes.item(0)));
            if (resKey != null) {
                sd[i].setIvorn(new Ivorn(authority, resKey, null));
                continue;
            }
            sd[i].setIvorn(new Ivorn(authority, null, null));
        }
        return sd;
    }

    public String getEndPointByIdentifier(Ivorn ident) throws RegistryException {
        return this.getEndPointByIdentifier(ident.getPath());
    }

    public String getEndPointByIdentifier(String ident) throws RegistryException {
        String returnVal;
        logger.info((Object)("getEndPointByIdentifier(String) - entered getEndPointByIdentifier with ident = " + ident));
        String invocation = null;
        Document doc = this.getResourceByIdentifier(ident);
        try {
            returnVal = DomHelper.getNodeTextValue((Node)doc, (String)"AccessURL", (String)"vr");
            invocation = DomHelper.getNodeTextValue((Node)doc, (String)"Invocation", (String)"vr");
        }
        catch (IOException ioe) {
            throw new RegistryException("Could not parse xml to get AcessURL or Invocation");
        }
        if (returnVal == null) {
            throw new RegistryException("Found Resource Document, but had no AccessURL");
        }
        logger.info((Object)("getEndPointByIdentifier(String) - The AccessURL = " + returnVal));
        logger.info((Object)("getEndPointByIdentifier(String) - The Invocation = " + invocation));
        if (returnVal != null && returnVal.indexOf("wsdl") > 0 && "WebService".equals(invocation)) {
            logger.info((Object)"getEndPointByIdentifier(String) - has ?wsdl stripping off");
            returnVal = returnVal.substring(0, returnVal.indexOf("?wsdl"));
        }
        return returnVal;
    }

    public WSDLBasicInformation getBasicWSDLInformation(Ivorn ident) throws RegistryException {
        return this.getBasicWSDLInformation(this.getResourceByIdentifier(ident));
    }

    public WSDLBasicInformation getBasicWSDLInformation(Document voDoc) throws RegistryException {
        WSDLBasicInformation wsdlBasic = null;
        String invocType = null;
        String accessURL = null;
        try {
            invocType = DomHelper.getNodeTextValue((Node)voDoc, (String)"Invocation", (String)"vr");
            accessURL = DomHelper.getNodeTextValue((Node)voDoc, (String)"AccessURL", (String)"vr");
        }
        catch (IOException ioe) {
            throw new RegistryException("Could not parse xml to get AcessURL or Invocation");
        }
        if ("WebService".equals(invocType)) {
            if (accessURL == null) {
                throw new RegistryException("Cound not find an AccessURL with a web service invocation type");
            }
            try {
                logger.info((Object)"getBasicWSDLInformation(Document) - status msg for getBasicWSDLInformation, the invocation is a Web service being processing wsdl");
                WSDLFactory wf = WSDLFactory.newInstance();
                WSDLReader wr = wf.newWSDLReader();
                Definition def = wr.readWSDL(accessURL);
                wsdlBasic = new WSDLBasicInformation();
                wsdlBasic.setTargetNameSpace(def.getTargetNamespace());
                Map mp = def.getServices();
                Set serviceSet = mp.keySet();
                Iterator iter = serviceSet.iterator();
                while (iter.hasNext()) {
                    QName serviceQName = (QName)iter.next();
                    Service service = (Service)mp.get(serviceQName);
                    Set portSet = service.getPorts().keySet();
                    Iterator portIter = portSet.iterator();
                    while (portIter.hasNext()) {
                        String portName = (String)portIter.next();
                        Port port = (Port)service.getPorts().get(portName);
                        List lst = port.getExtensibilityElements();
                        for (int i = 0; i < lst.size(); ++i) {
                            ExtensibilityElement extElement = (ExtensibilityElement)lst.get(i);
                            if (!(extElement instanceof SOAPAddress)) continue;
                            SOAPAddress soapAddress = (SOAPAddress)extElement;
                            logger.info((Object)("getBasicWSDLInformation(Document) - status msg for getBasicWSDLInformation, found a LocationURI in the wsdl = " + soapAddress.getLocationURI()));
                            wsdlBasic.addEndPoint(port.getName(), soapAddress.getLocationURI());
                        }
                    }
                }
            }
            catch (WSDLException wsdle) {
                logger.error((Object)"getBasicWSDLInformation(Document)", (Throwable)wsdle);
                throw new RegistryException((Throwable)wsdle);
            }
        } else {
            throw new RegistryException("Invalid Entry in Method: This method only accepts WebService InvocationTypes");
        }
        logger.info((Object)"getBasicWSDLInformation(Document) - exiting getBasicWSDLInformation with ident");
        return wsdlBasic;
    }

    static {
        if (conf == null) {
            conf = SimpleConfig.getSingleton();
        }
    }
}

