/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io;

import edu.sdsc.grid.io.Host;

public final class BinaryDataFormat {
    private byte shortSize = 0;
    private byte intSize = 0;
    private byte longSize = 0;
    private byte longLongSize = 0;
    private byte floatSize = 0;
    private byte doubleSize = 0;
    private byte longDoubleSize = 0;
    private boolean isMBF = true;
    private boolean sameByteOrder = true;
    private boolean sameShortSize = true;
    private boolean sameIntSize = true;
    private boolean sameLongSize = true;
    private boolean sameLongLongSize = true;
    private boolean sameFloatSize = true;
    private boolean sameDoubleSize = true;
    private boolean sameLongDoubleSize = true;

    public BinaryDataFormat() {
        this.isMBF = Host.isMBFByteOrder();
        this.sameByteOrder = true;
        this.shortSize = Host.getStorageSize(1);
        this.intSize = Host.getStorageSize(2);
        this.longSize = Host.getStorageSize(3);
        this.longLongSize = Host.getStorageSize(4);
        this.floatSize = Host.getStorageSize(5);
        this.doubleSize = Host.getStorageSize(6);
        this.longDoubleSize = Host.getStorageSize(7);
        this.sameShortSize = true;
        this.sameIntSize = true;
        this.sameLongSize = true;
        this.sameLongLongSize = true;
        this.sameFloatSize = true;
        this.sameDoubleSize = true;
        this.sameLongDoubleSize = true;
    }

    public BinaryDataFormat(BinaryDataFormat binaryDataFormat) throws NullPointerException {
        if (binaryDataFormat == null) {
            throw new NullPointerException();
        }
        this.isMBF = binaryDataFormat.isMBF;
        this.shortSize = binaryDataFormat.shortSize;
        this.intSize = binaryDataFormat.intSize;
        this.longSize = binaryDataFormat.longSize;
        this.longLongSize = binaryDataFormat.longLongSize;
        this.floatSize = binaryDataFormat.floatSize;
        this.doubleSize = binaryDataFormat.doubleSize;
        this.longDoubleSize = binaryDataFormat.longDoubleSize;
        this.sameByteOrder = Host.isMBFByteOrder() == this.isMBF;
        this.sameShortSize = Host.getStorageSize(1) == this.shortSize;
        this.sameIntSize = Host.getStorageSize(2) == this.intSize;
        this.sameLongSize = Host.getStorageSize(3) == this.longSize;
        this.sameLongLongSize = Host.getStorageSize(4) == this.longLongSize;
        this.sameFloatSize = Host.getStorageSize(5) == this.floatSize;
        this.sameDoubleSize = Host.getStorageSize(6) == this.doubleSize;
        this.sameLongDoubleSize = Host.getStorageSize(7) == this.longDoubleSize;
    }

    public final void finalize() {
    }

    public final boolean equals(BinaryDataFormat binaryDataFormat) {
        if (this.isMBF != binaryDataFormat.isMBF) {
            return false;
        }
        if (this.shortSize != binaryDataFormat.shortSize) {
            return false;
        }
        if (this.intSize != binaryDataFormat.intSize) {
            return false;
        }
        if (this.longSize != binaryDataFormat.longSize) {
            return false;
        }
        if (this.longLongSize != binaryDataFormat.longLongSize) {
            return false;
        }
        if (this.floatSize != binaryDataFormat.floatSize) {
            return false;
        }
        if (this.doubleSize != binaryDataFormat.doubleSize) {
            return false;
        }
        return this.longDoubleSize == binaryDataFormat.longDoubleSize;
    }

    public final boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        BinaryDataFormat binaryDataFormat = (BinaryDataFormat)object;
        return this.equals(binaryDataFormat);
    }

    public final void setMBFByteOrder() {
        this.isMBF = true;
        this.sameByteOrder = this.isMBF == Host.isMBFByteOrder();
    }

    public final void setLBFByteOrder() {
        this.isMBF = false;
        this.sameByteOrder = this.isMBF == Host.isMBFByteOrder();
    }

    public final boolean isMBFByteOrder() {
        return this.isMBF;
    }

    public final boolean isLBFByteOrder() {
        return !this.isMBF;
    }

    public final void setShortSize(int n) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.shortSize = (byte)n;
        this.sameShortSize = n == Host.getStorageSize(1);
    }

    public final void setIntSize(int n) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.intSize = (byte)n;
        this.sameIntSize = n == Host.getStorageSize(2);
    }

    public final void setLongSize(int n) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.longSize = (byte)n;
        this.sameLongSize = n == Host.getStorageSize(3);
    }

    public final void setLongLongSize(int n) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        this.longLongSize = (byte)n;
        this.sameLongLongSize = n == Host.getStorageSize(4);
    }

    public final void setFloatSize(int n) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        if (n != 4 && n != 8 && n != 16) {
            throw new IllegalArgumentException();
        }
        this.floatSize = (byte)n;
        this.sameFloatSize = n == Host.getStorageSize(5);
    }

    public final void setDoubleSize(int n) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        if (n != 4 && n != 8 && n != 16) {
            throw new IllegalArgumentException();
        }
        this.doubleSize = (byte)n;
        this.sameDoubleSize = n == Host.getStorageSize(6);
    }

    public final void setLongDoubleSize(int n) throws IllegalArgumentException {
        if (n <= 0) {
            throw new IllegalArgumentException();
        }
        if (n != 4 && n != 8 && n != 16) {
            throw new IllegalArgumentException();
        }
        this.longDoubleSize = (byte)n;
        this.sameLongDoubleSize = n == Host.getStorageSize(7);
    }

    public final int getShortSize() {
        return this.shortSize;
    }

    public final int getIntSize() {
        return this.intSize;
    }

    public final int getLongSize() {
        return this.longSize;
    }

    public final int getLongLongSize() {
        return this.longLongSize;
    }

    public final int getFloatSize() {
        return this.floatSize;
    }

    public final int getDoubleSize() {
        return this.doubleSize;
    }

    public final int getLongDoubleSize() {
        return this.longDoubleSize;
    }

    public final short shortValue(byte[] byArray) {
        if (this.sameShortSize) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, this.shortSize);
            }
            return Host.castToShort(byArray);
        }
        int n = this.shortSize;
        short s = 0;
        if (this.isMBF) {
            if ((byArray[0] & 0xFFFFFF80) > 0) {
                s = -1;
            }
            int n2 = 0;
            while (n2 < n) {
                s = (short)(s << 8 | byArray[n2] & 0xFF);
                ++n2;
            }
            return s;
        }
        if ((byArray[n - 1] & 0xFFFFFF80) > 0) {
            s = -1;
        }
        int n3 = n - 1;
        while (n3 >= 0) {
            s = (short)(s << 8 | byArray[n3] & 0xFF);
            --n3;
        }
        return s;
    }

    public final int unsignedShortValue(byte[] byArray) {
        if (this.sameShortSize) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, this.shortSize);
            }
            return Host.castToShort(byArray);
        }
        int n = this.shortSize;
        int n2 = 0;
        if (this.isMBF) {
            int n3 = 0;
            while (n3 < n) {
                n2 = n2 << 8 | byArray[n3] & 0xFF;
                ++n3;
            }
            return n2 &= ~(-1 << Host.getSignificantBits(1));
        }
        int n4 = n - 1;
        while (n4 >= 0) {
            n2 = n2 << 8 | byArray[n4] & 0xFF;
            --n4;
        }
        return n2 &= ~(-1 << Host.getSignificantBits(1));
    }

    public final int intValue(byte[] byArray) {
        if (this.sameIntSize) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, this.intSize);
            }
            return Host.castToInt(byArray);
        }
        int n = this.intSize;
        int n2 = 0;
        if (this.isMBF) {
            if ((byArray[0] & 0xFFFFFF80) > 0) {
                n2 = -1;
            }
            int n3 = 0;
            while (n3 < n) {
                n2 = n2 << 8 | byArray[n3] & 0xFF;
                ++n3;
            }
            return n2;
        }
        if ((byArray[n - 1] & 0xFFFFFF80) > 0) {
            n2 = -1;
        }
        int n4 = n - 1;
        while (n4 >= 0) {
            n2 = n2 << 8 | byArray[n4] & 0xFF;
            --n4;
        }
        return n2;
    }

    public final long unsignedIntValue(byte[] byArray) {
        if (this.sameIntSize) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, this.intSize);
            }
            return Host.castToInt(byArray);
        }
        int n = this.intSize;
        long l = 0L;
        if (this.isMBF) {
            int n2 = 0;
            while (n2 < n) {
                l = l << 8 | (long)byArray[n2] & 0xFFL;
                ++n2;
            }
            return l &= -1L << Host.getSignificantBits(2) ^ 0xFFFFFFFFFFFFFFFFL;
        }
        int n3 = n - 1;
        while (n3 >= 0) {
            l = l << 8 | (long)byArray[n3] & 0xFFL;
            --n3;
        }
        return l &= -1L << Host.getSignificantBits(2) ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public final long longValue(byte[] byArray) {
        if (this.sameLongSize) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, this.longSize);
            }
            return Host.castToLong(byArray);
        }
        int n = this.longSize;
        long l = 0L;
        if (this.isMBF) {
            if ((byArray[0] & 0xFFFFFF80) > 0) {
                l = -1L;
            }
            int n2 = 0;
            while (n2 < n) {
                l = l << 8 | (long)byArray[n2] & 0xFFL;
                ++n2;
            }
            return l;
        }
        if ((byArray[n - 1] & 0xFFFFFF80) > 0) {
            l = -1L;
        }
        int n3 = n - 1;
        while (n3 >= 0) {
            l = l << 8 | (long)byArray[n3] & 0xFFL;
            --n3;
        }
        return l;
    }

    public final long unsignedLongValue(byte[] byArray) {
        if (this.sameLongSize) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, this.longSize);
            }
            return Host.castToLong(byArray);
        }
        int n = this.longSize;
        long l = 0L;
        if (this.isMBF) {
            int n2 = 0;
            while (n2 < n) {
                l = l << 8 | (long)byArray[n2] & 0xFFL;
                ++n2;
            }
            return l;
        }
        int n3 = n - 1;
        while (n3 >= 0) {
            l = l << 8 | (long)byArray[n3] & 0xFFL;
            --n3;
        }
        return l;
    }

    public final long longLongValue(byte[] byArray) {
        if (this.sameLongLongSize) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, this.longLongSize);
            }
            return Host.castToLongLong(byArray);
        }
        int n = this.longLongSize;
        long l = 0L;
        if (this.isMBF) {
            if ((byArray[0] & 0xFFFFFF80) > 0) {
                l = -1L;
            }
            int n2 = 0;
            while (n2 < n) {
                l = l << 8 | (long)byArray[n2] & 0xFFL;
                ++n2;
            }
            return l;
        }
        if ((byArray[n - 1] & 0xFFFFFF80) > 0) {
            l = -1L;
        }
        int n3 = n - 1;
        while (n3 >= 0) {
            l = l << 8 | (long)byArray[n3] & 0xFFL;
            --n3;
        }
        return l;
    }

    public final long unsignedLongLongValue(byte[] byArray) {
        if (this.sameLongLongSize) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, this.longLongSize);
            }
            return Host.castToLongLong(byArray);
        }
        int n = this.longLongSize;
        long l = 0L;
        if (this.isMBF) {
            int n2 = 0;
            while (n2 < n) {
                l = l << 8 | (long)byArray[n2] & 0xFFL;
                ++n2;
            }
            return l;
        }
        int n3 = n - 1;
        while (n3 >= 0) {
            l = l << 8 | (long)byArray[n3] & 0xFFL;
            --n3;
        }
        return l;
    }

    public final float floatValue(byte[] byArray) {
        if (this.sameFloatSize) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, this.floatSize);
            }
            return Host.castToFloat(byArray);
        }
        byte by = this.floatSize;
        if (Host.getStorageSize(6) == by) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, by);
            }
            return (float)Host.castToDouble(byArray);
        }
        if (Host.getStorageSize(7) == by) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, by);
            }
            return (float)Host.castToLongDouble(byArray);
        }
        return 0.0f;
    }

    public final double doubleValue(byte[] byArray) {
        if (this.sameDoubleSize) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, this.doubleSize);
            }
            return Host.castToDouble(byArray);
        }
        byte by = this.doubleSize;
        if (Host.getStorageSize(5) == by) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, by);
            }
            return Host.castToFloat(byArray);
        }
        if (Host.getStorageSize(7) == by) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, by);
            }
            return Host.castToLongDouble(byArray);
        }
        return 0.0;
    }

    public final double longDoubleValue(byte[] byArray) {
        if (this.sameLongDoubleSize) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, this.longDoubleSize);
            }
            return Host.castToLongDouble(byArray);
        }
        byte by = this.longDoubleSize;
        if (Host.getStorageSize(5) == by) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, by);
            }
            return Host.castToFloat(byArray);
        }
        if (Host.getStorageSize(6) == by) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, by);
            }
            return Host.castToDouble(byArray);
        }
        return 0.0;
    }

    public final short shortValue(byte[] byArray, int n) {
        if (this.sameShortSize) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, this.shortSize);
            }
            return Host.castToShort(byArray, n);
        }
        int n2 = this.shortSize;
        short s = 0;
        if (this.isMBF) {
            if ((byArray[n] & 0xFFFFFF80) > 0) {
                s = -1;
            }
            int n3 = 0;
            while (n3 < n2) {
                s = (short)(s << 8 | byArray[n + n3] & 0xFF);
                ++n3;
            }
            return s;
        }
        if ((byArray[n + n2 - 1] & 0xFFFFFF80) > 0) {
            s = -1;
        }
        int n4 = n2 - 1;
        while (n4 >= 0) {
            s = (short)(s << 8 | byArray[n + n4] & 0xFF);
            --n4;
        }
        return s;
    }

    public final int unsignedShortValue(byte[] byArray, int n) {
        if (this.sameShortSize) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, this.shortSize);
            }
            return Host.castToShort(byArray, n);
        }
        int n2 = this.shortSize;
        int n3 = 0;
        if (this.isMBF) {
            int n4 = 0;
            while (n4 < n2) {
                n3 = n3 << 8 | byArray[n + n4] & 0xFF;
                ++n4;
            }
            return n3 &= ~(-1 << Host.getSignificantBits(1));
        }
        int n5 = n2 - 1;
        while (n5 >= 0) {
            n3 = n3 << 8 | byArray[n + n5] & 0xFF;
            --n5;
        }
        return n3 &= ~(-1 << Host.getSignificantBits(1));
    }

    public final int intValue(byte[] byArray, int n) {
        if (this.sameIntSize) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, this.intSize);
            }
            return Host.castToInt(byArray, n);
        }
        int n2 = this.intSize;
        int n3 = 0;
        if (this.isMBF) {
            if ((byArray[n] & 0xFFFFFF80) > 0) {
                n3 = -1;
            }
            int n4 = 0;
            while (n4 < n2) {
                n3 = n3 << 8 | byArray[n + n4] & 0xFF;
                ++n4;
            }
            return n3;
        }
        if ((byArray[n + n2 - 1] & 0xFFFFFF80) > 0) {
            n3 = -1;
        }
        int n5 = n2 - 1;
        while (n5 >= 0) {
            n3 = n3 << 8 | byArray[n + n5] & 0xFF;
            --n5;
        }
        return n3;
    }

    public final long unsignedIntValue(byte[] byArray, int n) {
        if (this.sameIntSize) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, this.intSize);
            }
            return Host.castToInt(byArray, n);
        }
        int n2 = this.intSize;
        long l = 0L;
        if (this.isMBF) {
            int n3 = 0;
            while (n3 < n2) {
                l = l << 8 | (long)byArray[n + n3] & 0xFFL;
                ++n3;
            }
            return l &= -1L << Host.getSignificantBits(2) ^ 0xFFFFFFFFFFFFFFFFL;
        }
        int n4 = n2 - 1;
        while (n4 >= 0) {
            l = l << 8 | (long)byArray[n + n4] & 0xFFL;
            --n4;
        }
        return l &= -1L << Host.getSignificantBits(2) ^ 0xFFFFFFFFFFFFFFFFL;
    }

    public final long longValue(byte[] byArray, int n) {
        if (this.sameLongSize) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, this.longSize);
            }
            return Host.castToLong(byArray, n);
        }
        int n2 = this.longSize;
        long l = 0L;
        if (this.isMBF) {
            if ((byArray[n] & 0xFFFFFF80) > 0) {
                l = -1L;
            }
            int n3 = 0;
            while (n3 < n2) {
                l = l << 8 | (long)byArray[n + n3] & 0xFFL;
                ++n3;
            }
            return l;
        }
        if ((byArray[n + n2 - 1] & 0xFFFFFF80) > 0) {
            l = -1L;
        }
        int n4 = n2 - 1;
        while (n4 >= 0) {
            l = l << 8 | (long)byArray[n + n4] & 0xFFL;
            --n4;
        }
        return l;
    }

    public final long unsignedLongValue(byte[] byArray, int n) {
        if (this.sameLongSize) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, this.longSize);
            }
            return Host.castToLong(byArray, n);
        }
        int n2 = this.longSize;
        long l = 0L;
        if (this.isMBF) {
            int n3 = 0;
            while (n3 < n2) {
                l = l << 8 | (long)byArray[n + n3] & 0xFFL;
                ++n3;
            }
            return l;
        }
        int n4 = n2 - 1;
        while (n4 >= 0) {
            l = l << 8 | (long)byArray[n + n4] & 0xFFL;
            --n4;
        }
        return l;
    }

    public final long longLongValue(byte[] byArray, int n) {
        if (this.sameLongLongSize) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, this.longLongSize);
            }
            return Host.castToLongLong(byArray, n);
        }
        int n2 = this.longLongSize;
        long l = 0L;
        if (this.isMBF) {
            if ((byArray[n] & 0xFFFFFF80) > 0) {
                l = -1L;
            }
            int n3 = 0;
            while (n3 < n2) {
                l = l << 8 | (long)byArray[n + n3] & 0xFFL;
                ++n3;
            }
            return l;
        }
        if ((byArray[n + n2 - 1] & 0xFFFFFF80) > 0) {
            l = -1L;
        }
        int n4 = n2 - 1;
        while (n4 >= 0) {
            l = l << 8 | (long)byArray[n + n4] & 0xFFL;
            --n4;
        }
        return l;
    }

    public final long unsignedLongLongValue(byte[] byArray, int n) {
        if (this.sameLongLongSize) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, this.longLongSize);
            }
            return Host.castToLongLong(byArray, n);
        }
        int n2 = this.longLongSize;
        long l = 0L;
        if (this.isMBF) {
            int n3 = 0;
            while (n3 < n2) {
                l = l << 8 | (long)byArray[n + n3] & 0xFFL;
                ++n3;
            }
            return l;
        }
        int n4 = n2 - 1;
        while (n4 >= 0) {
            l = l << 8 | (long)byArray[n + n4] & 0xFFL;
            --n4;
        }
        return l;
    }

    public final float floatValue(byte[] byArray, int n) {
        if (this.sameFloatSize) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, this.floatSize);
            }
            return Host.castToFloat(byArray, n);
        }
        byte by = this.floatSize;
        if (Host.getStorageSize(6) == by) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, by);
            }
            return (float)Host.castToDouble(byArray, n);
        }
        if (Host.getStorageSize(7) == by) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, by);
            }
            return (float)Host.castToLongDouble(byArray, n);
        }
        return 0.0f;
    }

    public final double doubleValue(byte[] byArray, int n) {
        if (this.sameDoubleSize) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, this.doubleSize);
            }
            return Host.castToDouble(byArray, n);
        }
        byte by = this.doubleSize;
        if (Host.getStorageSize(5) == by) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, by);
            }
            return Host.castToFloat(byArray, n);
        }
        if (Host.getStorageSize(7) == by) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, by);
            }
            return Host.castToLongDouble(byArray, n);
        }
        return 0.0;
    }

    public final double longDoubleValue(byte[] byArray, int n) {
        if (this.sameLongDoubleSize) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, this.longDoubleSize);
            }
            return Host.castToLongDouble(byArray, n);
        }
        byte by = this.longDoubleSize;
        if (Host.getStorageSize(5) == by) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, by);
            }
            return Host.castToFloat(byArray, n);
        }
        if (Host.getStorageSize(6) == by) {
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, by);
            }
            return Host.castToDouble(byArray, n);
        }
        return 0.0;
    }

    public final void shortValues(byte[] byArray, short[] sArray, int n) {
        byte by = this.shortSize;
        int n2 = 0;
        int n3 = n - 1;
        while (n3 >= 0) {
            sArray[n3] = this.shortValue(byArray, n2);
            n2 += by;
            --n3;
        }
    }

    public final void unsignedShortValues(byte[] byArray, short[] sArray, int n) {
        byte by = this.shortSize;
        int n2 = 0;
        int n3 = n - 1;
        while (n3 >= 0) {
            sArray[n3] = (short)this.unsignedShortValue(byArray, n2);
            n2 += by;
            --n3;
        }
    }

    public final void intValues(byte[] byArray, int[] nArray, int n) {
        byte by = this.intSize;
        int n2 = 0;
        int n3 = n - 1;
        while (n3 >= 0) {
            nArray[n3] = this.intValue(byArray, n2);
            n2 += by;
            --n3;
        }
    }

    public final void unsignedIntValues(byte[] byArray, int[] nArray, int n) {
        byte by = this.intSize;
        int n2 = 0;
        int n3 = n - 1;
        while (n3 >= 0) {
            nArray[n3] = (int)this.unsignedIntValue(byArray, n2);
            n2 += by;
            --n3;
        }
    }

    public final void longValues(byte[] byArray, long[] lArray, int n) {
        byte by = this.longSize;
        int n2 = 0;
        int n3 = n - 1;
        while (n3 >= 0) {
            lArray[n3] = this.longValue(byArray, n2);
            n2 += by;
            --n3;
        }
    }

    public final void unsignedLongValues(byte[] byArray, long[] lArray, int n) {
        byte by = this.longSize;
        int n2 = 0;
        int n3 = n - 1;
        while (n3 >= 0) {
            lArray[n3] = this.unsignedLongValue(byArray, n2);
            n2 += by;
            --n3;
        }
    }

    public final void longLongValues(byte[] byArray, long[] lArray, int n) {
        byte by = this.longLongSize;
        int n2 = 0;
        int n3 = n - 1;
        while (n3 >= 0) {
            lArray[n3] = this.longLongValue(byArray, n2);
            n2 += by;
            --n3;
        }
    }

    public final void unsignedLongLongValues(byte[] byArray, long[] lArray, int n) {
        byte by = this.longLongSize;
        int n2 = 0;
        int n3 = n - 1;
        while (n3 >= 0) {
            lArray[n3] = this.unsignedLongLongValue(byArray, n2);
            n2 += by;
            --n3;
        }
    }

    public final void floatValues(byte[] byArray, float[] fArray, int n) {
        byte by = this.floatSize;
        int n2 = 0;
        int n3 = n - 1;
        while (n3 >= 0) {
            fArray[n3] = this.floatValue(byArray, n2);
            n2 += by;
            --n3;
        }
    }

    public final void doubleValues(byte[] byArray, double[] dArray, int n) {
        byte by = this.doubleSize;
        int n2 = 0;
        int n3 = n - 1;
        while (n3 >= 0) {
            dArray[n3] = this.doubleValue(byArray, n2);
            n2 += by;
            --n3;
        }
    }

    public final void longDoubleValues(byte[] byArray, double[] dArray, int n) {
        byte by = this.longDoubleSize;
        int n2 = 0;
        int n3 = n - 1;
        while (n3 >= 0) {
            dArray[n3] = this.longDoubleValue(byArray, n2);
            n2 += by;
            --n3;
        }
    }

    public final int encodeShort(short s, byte[] byArray) {
        if (this.sameShortSize) {
            Host.copyShort(s, byArray);
            if (!this.sameByteOrder) {
                Host.swap(byArray, this.shortSize);
            }
            return this.shortSize;
        }
        int n = this.shortSize;
        if (this.isMBF) {
            int n2 = n - 1;
            while (n2 >= 0) {
                byArray[n2] = (byte)s;
                s = (short)(s >> 8);
                --n2;
            }
            return n;
        }
        int n3 = 0;
        while (n3 < n) {
            byArray[n3] = (byte)s;
            s = (short)(s >> 8);
            ++n3;
        }
        return n;
    }

    public final int encodeShort(int n, byte[] byArray) {
        if (this.sameShortSize) {
            Host.copyShort(n, byArray);
            if (!this.sameByteOrder) {
                Host.swap(byArray, this.shortSize);
            }
            return this.shortSize;
        }
        int n2 = this.shortSize;
        short s = (short)n;
        if (this.isMBF) {
            int n3 = n2 - 1;
            while (n3 >= 0) {
                byArray[n3] = (byte)s;
                s = (short)(s >> 8);
                --n3;
            }
            return n2;
        }
        int n4 = 0;
        while (n4 < n2) {
            byArray[n4] = (byte)s;
            s = (short)(s >> 8);
            ++n4;
        }
        return n2;
    }

    public final int encodeUnsignedShort(short s, byte[] byArray) {
        if (this.sameShortSize) {
            Host.copyUnsignedShort(s, byArray);
            if (!this.sameByteOrder) {
                Host.swap(byArray, this.shortSize);
            }
            return this.shortSize;
        }
        int n = this.shortSize;
        if (this.isMBF) {
            int n2 = n - 1;
            while (n2 >= 0) {
                byArray[n2] = (byte)s;
                s = (short)(s >>> 8);
                --n2;
            }
            return n;
        }
        int n3 = 0;
        while (n3 < n) {
            byArray[n3] = (byte)s;
            s = (short)(s >>> 8);
            ++n3;
        }
        return n;
    }

    public final int encodeUnsignedShort(int n, byte[] byArray) {
        if (this.sameShortSize) {
            Host.copyUnsignedShort(n, byArray);
            if (!this.sameByteOrder) {
                Host.swap(byArray, this.shortSize);
            }
            return this.shortSize;
        }
        int n2 = this.shortSize;
        short s = (short)n;
        if (this.isMBF) {
            int n3 = n2 - 1;
            while (n3 >= 0) {
                byArray[n3] = (byte)s;
                s = (short)(s >>> 8);
                --n3;
            }
            return n2;
        }
        int n4 = 0;
        while (n4 < n2) {
            byArray[n4] = (byte)s;
            s = (short)(s >>> 8);
            ++n4;
        }
        return n2;
    }

    public final int encodeInt(int n, byte[] byArray) {
        if (this.sameIntSize) {
            Host.copyInt(n, byArray);
            if (!this.sameByteOrder) {
                Host.swap(byArray, this.intSize);
            }
            return this.intSize;
        }
        int n2 = this.intSize;
        if (this.isMBF) {
            int n3 = n2 - 1;
            while (n3 >= 0) {
                byArray[n3] = (byte)n;
                n >>= 8;
                --n3;
            }
            return n2;
        }
        int n4 = 0;
        while (n4 < n2) {
            byArray[n4] = (byte)n;
            n >>= 8;
            ++n4;
        }
        return n2;
    }

    public final int encodeUnsignedInt(int n, byte[] byArray) {
        if (this.sameIntSize) {
            Host.copyUnsignedInt(n, byArray);
            if (!this.sameByteOrder) {
                Host.swap(byArray, this.intSize);
            }
            return this.intSize;
        }
        int n2 = this.intSize;
        if (this.isMBF) {
            int n3 = n2 - 1;
            while (n3 >= 0) {
                byArray[n3] = (byte)n;
                n >>>= 8;
                --n3;
            }
            return n2;
        }
        int n4 = 0;
        while (n4 < n2) {
            byArray[n4] = (byte)n;
            n >>>= 8;
            ++n4;
        }
        return n2;
    }

    public final int encodeUnsignedInt(long l, byte[] byArray) {
        if (this.sameIntSize) {
            Host.copyUnsignedInt((int)l, byArray);
            if (!this.sameByteOrder) {
                Host.swap(byArray, this.intSize);
            }
            return this.intSize;
        }
        int n = this.intSize;
        if (this.isMBF) {
            int n2 = n - 1;
            while (n2 >= 0) {
                byArray[n2] = (byte)l;
                l >>>= 8;
                --n2;
            }
            return n;
        }
        int n3 = 0;
        while (n3 < n) {
            byArray[n3] = (byte)l;
            l >>>= 8;
            ++n3;
        }
        return n;
    }

    public final int encodeLong(long l, byte[] byArray) {
        if (this.sameLongSize) {
            Host.copyLong(l, byArray);
            if (!this.sameByteOrder) {
                Host.swap(byArray, this.longSize);
            }
            return this.longSize;
        }
        int n = this.longSize;
        if (this.isMBF) {
            int n2 = n - 1;
            while (n2 >= 0) {
                byArray[n2] = (byte)l;
                l >>= 8;
                --n2;
            }
            return n;
        }
        int n3 = 0;
        while (n3 < n) {
            byArray[n3] = (byte)l;
            l >>= 8;
            ++n3;
        }
        return n;
    }

    public final int encodeUnsignedLong(long l, byte[] byArray) {
        if (this.sameLongSize) {
            Host.copyUnsignedLong(l, byArray);
            if (!this.sameByteOrder) {
                Host.swap(byArray, this.longSize);
            }
            return this.longSize;
        }
        int n = this.longSize;
        if (this.isMBF) {
            int n2 = n - 1;
            while (n2 >= 0) {
                byArray[n2] = (byte)l;
                l >>>= 8;
                --n2;
            }
            return n;
        }
        int n3 = 0;
        while (n3 < n) {
            byArray[n3] = (byte)l;
            l >>>= 8;
            ++n3;
        }
        return n;
    }

    public final int encodeLongLong(long l, byte[] byArray) {
        if (this.sameLongLongSize) {
            Host.copyLongLong(l, byArray);
            if (!this.sameByteOrder) {
                Host.swap(byArray, this.longLongSize);
            }
            return this.longLongSize;
        }
        int n = this.longLongSize;
        if (this.isMBF) {
            int n2 = n - 1;
            while (n2 >= 0) {
                byArray[n2] = (byte)l;
                l >>= 8;
                --n2;
            }
            return n;
        }
        int n3 = 0;
        while (n3 < n) {
            byArray[n3] = (byte)l;
            l >>= 8;
            ++n3;
        }
        return n;
    }

    public final int encodeUnsignedLongLong(long l, byte[] byArray) {
        if (this.sameLongLongSize) {
            Host.copyUnsignedLongLong(l, byArray);
            if (!this.sameByteOrder) {
                Host.swap(byArray, this.longLongSize);
            }
            return this.longLongSize;
        }
        int n = this.longLongSize;
        if (this.isMBF) {
            int n2 = n - 1;
            while (n2 >= 0) {
                byArray[n2] = (byte)l;
                l >>>= 8;
                --n2;
            }
            return n;
        }
        int n3 = 0;
        while (n3 < n) {
            byArray[n3] = (byte)l;
            l >>>= 8;
            ++n3;
        }
        return n;
    }

    public final int encodeFloat(float f, byte[] byArray) {
        if (this.sameFloatSize) {
            Host.copyFloat(f, byArray);
            if (!this.sameByteOrder) {
                Host.swap(byArray, this.floatSize);
            }
            return this.floatSize;
        }
        byte by = this.floatSize;
        if (Host.getStorageSize(6) == by) {
            Host.copyDouble(f, byArray);
            if (!this.sameByteOrder) {
                Host.swap(byArray, by);
            }
            return by;
        }
        if (Host.getStorageSize(7) == by) {
            Host.copyLongDouble(f, byArray);
            if (!this.sameByteOrder) {
                Host.swap(byArray, by);
            }
            return by;
        }
        return by;
    }

    public final int encodeFloat(double d, byte[] byArray) {
        if (this.sameFloatSize) {
            Host.copyFloat((float)d, byArray);
            if (!this.sameByteOrder) {
                Host.swap(byArray, this.floatSize);
            }
            return this.floatSize;
        }
        byte by = this.floatSize;
        if (Host.getStorageSize(6) == by) {
            Host.copyDouble(d, byArray);
            if (!this.sameByteOrder) {
                Host.swap(byArray, by);
            }
            return by;
        }
        if (Host.getStorageSize(7) == by) {
            Host.copyLongDouble(d, byArray);
            if (!this.sameByteOrder) {
                Host.swap(byArray, by);
            }
            return by;
        }
        return by;
    }

    public final int encodeDouble(double d, byte[] byArray) {
        if (this.sameDoubleSize) {
            Host.copyDouble(d, byArray);
            if (!this.sameByteOrder) {
                Host.swap(byArray, this.doubleSize);
            }
            return this.doubleSize;
        }
        byte by = this.doubleSize;
        if (Host.getStorageSize(5) == by) {
            Host.copyFloat((float)d, byArray);
            if (!this.sameByteOrder) {
                Host.swap(byArray, by);
            }
            return by;
        }
        if (Host.getStorageSize(7) == by) {
            Host.copyLongDouble(d, byArray);
            if (!this.sameByteOrder) {
                Host.swap(byArray, by);
            }
            return by;
        }
        return by;
    }

    public final int encodeLongDouble(double d, byte[] byArray) {
        if (this.sameLongDoubleSize) {
            Host.copyLongDouble(d, byArray);
            if (!this.sameByteOrder) {
                Host.swap(byArray, this.longDoubleSize);
            }
            return this.longDoubleSize;
        }
        byte by = this.longDoubleSize;
        if (Host.getStorageSize(5) == by) {
            Host.copyFloat((float)d, byArray);
            if (!this.sameByteOrder) {
                Host.swap(byArray, by);
            }
            return by;
        }
        if (Host.getStorageSize(6) == by) {
            Host.copyDouble(d, byArray);
            if (!this.sameByteOrder) {
                Host.swap(byArray, by);
            }
            return by;
        }
        return by;
    }

    public final int encodeShort(short s, byte[] byArray, int n) {
        if (this.sameShortSize) {
            Host.copyShort(s, byArray, n);
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, this.shortSize);
            }
            return this.shortSize;
        }
        int n2 = this.shortSize;
        if (this.isMBF) {
            int n3 = n2 - 1;
            while (n3 >= 0) {
                byArray[n + n3] = (byte)s;
                s = (short)(s >> 8);
                --n3;
            }
            return n2;
        }
        int n4 = 0;
        while (n4 < n2) {
            byArray[n + n4] = (byte)s;
            s = (short)(s >> 8);
            ++n4;
        }
        return n2;
    }

    public final int encodeShort(int n, byte[] byArray, int n2) {
        if (this.sameShortSize) {
            Host.copyShort((short)n, byArray, n2);
            if (!this.sameByteOrder) {
                Host.swap(byArray, n2, this.shortSize);
            }
            return this.shortSize;
        }
        int n3 = this.shortSize;
        short s = (short)n;
        if (this.isMBF) {
            int n4 = n3 - 1;
            while (n4 >= 0) {
                byArray[n2 + n4] = (byte)s;
                s = (short)(s >> 8);
                --n4;
            }
            return n3;
        }
        int n5 = 0;
        while (n5 < n3) {
            byArray[n2 + n5] = (byte)s;
            s = (short)(s >> 8);
            ++n5;
        }
        return n3;
    }

    public final int encodeUnsignedShort(short s, byte[] byArray, int n) {
        if (this.sameShortSize) {
            Host.copyUnsignedShort(s, byArray, n);
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, this.shortSize);
            }
            return this.shortSize;
        }
        int n2 = this.shortSize;
        if (this.isMBF) {
            int n3 = n2 - 1;
            while (n3 >= 0) {
                byArray[n + n3] = (byte)s;
                s = (short)(s >>> 8);
                --n3;
            }
            return n2;
        }
        int n4 = 0;
        while (n4 < n2) {
            byArray[n + n4] = (byte)s;
            s = (short)(s >>> 8);
            ++n4;
        }
        return n2;
    }

    public final int encodeUnsignedShort(int n, byte[] byArray, int n2) {
        if (this.sameShortSize) {
            Host.copyUnsignedShort((short)n, byArray, n2);
            if (!this.sameByteOrder) {
                Host.swap(byArray, n2, this.shortSize);
            }
            return this.shortSize;
        }
        int n3 = this.shortSize;
        short s = (short)n;
        if (this.isMBF) {
            int n4 = n3 - 1;
            while (n4 >= 0) {
                byArray[n2 + n4] = (byte)s;
                s = (short)(s >>> 8);
                --n4;
            }
            return n3;
        }
        int n5 = 0;
        while (n5 < n3) {
            byArray[n2 + n5] = (byte)s;
            s = (short)(s >>> 8);
            ++n5;
        }
        return n3;
    }

    public final int encodeInt(int n, byte[] byArray, int n2) {
        if (this.sameIntSize) {
            Host.copyInt(n, byArray, n2);
            if (!this.sameByteOrder) {
                Host.swap(byArray, n2, this.intSize);
            }
            return this.intSize;
        }
        int n3 = this.intSize;
        if (this.isMBF) {
            int n4 = n3 - 1;
            while (n4 >= 0) {
                byArray[n2 + n4] = (byte)n;
                n >>= 8;
                --n4;
            }
            return n3;
        }
        int n5 = 0;
        while (n5 < n3) {
            byArray[n2 + n5] = (byte)n;
            n >>= 8;
            ++n5;
        }
        return n3;
    }

    public final int encodeUnsignedInt(int n, byte[] byArray, int n2) {
        if (this.sameIntSize) {
            Host.copyUnsignedInt(n, byArray, n2);
            if (!this.sameByteOrder) {
                Host.swap(byArray, n2, this.intSize);
            }
            return this.intSize;
        }
        int n3 = this.intSize;
        if (this.isMBF) {
            int n4 = n3 - 1;
            while (n4 >= 0) {
                byArray[n2 + n4] = (byte)n;
                n >>>= 8;
                --n4;
            }
            return n3;
        }
        int n5 = 0;
        while (n5 < n3) {
            byArray[n2 + n5] = (byte)n;
            n >>>= 8;
            ++n5;
        }
        return n3;
    }

    public final int encodeUnsignedInt(long l, byte[] byArray, int n) {
        if (this.sameIntSize) {
            Host.copyUnsignedInt(l, byArray, n);
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, this.intSize);
            }
            return this.intSize;
        }
        int n2 = this.intSize;
        int n3 = (int)l;
        if (this.isMBF) {
            int n4 = n2 - 1;
            while (n4 >= 0) {
                byArray[n + n4] = (byte)n3;
                n3 >>>= 8;
                --n4;
            }
            return n2;
        }
        int n5 = 0;
        while (n5 < n2) {
            byArray[n + n5] = (byte)n3;
            n3 >>>= 8;
            ++n5;
        }
        return n2;
    }

    public final int encodeLong(long l, byte[] byArray, int n) {
        if (this.sameLongSize) {
            Host.copyLong(l, byArray, n);
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, this.longSize);
            }
            return this.longSize;
        }
        int n2 = this.longSize;
        if (this.isMBF) {
            int n3 = n2 - 1;
            while (n3 >= 0) {
                byArray[n + n3] = (byte)l;
                l >>= 8;
                --n3;
            }
            return n2;
        }
        int n4 = 0;
        while (n4 < n2) {
            byArray[n + n4] = (byte)l;
            l >>= 8;
            ++n4;
        }
        return n2;
    }

    public final int encodeUnsignedLong(long l, byte[] byArray, int n) {
        if (this.sameLongSize) {
            Host.copyUnsignedLong(l, byArray, n);
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, this.longSize);
            }
            return this.longSize;
        }
        int n2 = this.longSize;
        if (this.isMBF) {
            int n3 = n2 - 1;
            while (n3 >= 0) {
                byArray[n + n3] = (byte)l;
                l >>>= 8;
                --n3;
            }
            return n2;
        }
        int n4 = 0;
        while (n4 < n2) {
            byArray[n + n4] = (byte)l;
            l >>>= 8;
            ++n4;
        }
        return n2;
    }

    public final int encodeLongLong(long l, byte[] byArray, int n) {
        if (this.sameLongLongSize) {
            Host.copyLongLong(l, byArray, n);
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, this.longLongSize);
            }
            return this.longLongSize;
        }
        int n2 = this.longLongSize;
        if (this.isMBF) {
            int n3 = n2 - 1;
            while (n3 >= 0) {
                byArray[n + n3] = (byte)l;
                l >>= 8;
                --n3;
            }
            return n2;
        }
        int n4 = 0;
        while (n4 < n2) {
            byArray[n + n4] = (byte)l;
            l >>= 8;
            ++n4;
        }
        return n2;
    }

    public final int encodeUnsignedLongLong(long l, byte[] byArray, int n) {
        if (this.sameLongLongSize) {
            Host.copyUnsignedLongLong(l, byArray, n);
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, this.longLongSize);
            }
            return this.longLongSize;
        }
        int n2 = this.longLongSize;
        if (this.isMBF) {
            int n3 = n2 - 1;
            while (n3 >= 0) {
                byArray[n + n3] = (byte)l;
                l >>>= 8;
                --n3;
            }
            return n2;
        }
        int n4 = 0;
        while (n4 < n2) {
            byArray[n + n4] = (byte)l;
            l >>>= 8;
            ++n4;
        }
        return n2;
    }

    public final int encodeFloat(float f, byte[] byArray, int n) {
        if (this.sameFloatSize) {
            Host.copyFloat(f, byArray, n);
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, this.floatSize);
            }
            return this.floatSize;
        }
        byte by = this.floatSize;
        if (Host.getStorageSize(6) == by) {
            Host.copyDouble(f, byArray);
            if (!this.sameByteOrder) {
                Host.swap(byArray, by);
            }
            return by;
        }
        if (Host.getStorageSize(7) == by) {
            Host.copyLongDouble(f, byArray);
            if (!this.sameByteOrder) {
                Host.swap(byArray, by);
            }
            return by;
        }
        return by;
    }

    public final int encodeFloat(double d, byte[] byArray, int n) {
        if (this.sameFloatSize) {
            Host.copyFloat((float)d, byArray, n);
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, this.floatSize);
            }
            return this.floatSize;
        }
        byte by = this.floatSize;
        if (Host.getStorageSize(6) == by) {
            Host.copyDouble(d, byArray, n);
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, by);
            }
            return by;
        }
        if (Host.getStorageSize(7) == by) {
            Host.copyLongDouble(d, byArray, n);
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, by);
            }
            return by;
        }
        return by;
    }

    public final int encodeDouble(double d, byte[] byArray, int n) {
        if (this.sameDoubleSize) {
            Host.copyDouble(d, byArray, n);
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, this.doubleSize);
            }
            return this.doubleSize;
        }
        byte by = this.doubleSize;
        if (Host.getStorageSize(5) == by) {
            Host.copyFloat((float)d, byArray, n);
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, by);
            }
            return by;
        }
        if (Host.getStorageSize(7) == by) {
            Host.copyLongDouble(d, byArray, n);
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, by);
            }
            return by;
        }
        return by;
    }

    public final int encodeLongDouble(double d, byte[] byArray, int n) {
        if (this.sameLongDoubleSize) {
            Host.copyLongDouble(d, byArray, n);
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, this.longDoubleSize);
            }
            return this.longDoubleSize;
        }
        byte by = this.longDoubleSize;
        if (Host.getStorageSize(5) == by) {
            Host.copyFloat((float)d, byArray, n);
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, by);
            }
            return by;
        }
        if (Host.getStorageSize(6) == by) {
            Host.copyDouble(d, byArray, n);
            if (!this.sameByteOrder) {
                Host.swap(byArray, n, by);
            }
            return by;
        }
        return by;
    }

    public final int encodeShorts(short[] sArray, int n, byte[] byArray) {
        byte by = this.shortSize;
        int n2 = 0;
        int n3 = n - 1;
        while (n3 >= 0) {
            this.encodeShort(sArray[n3], byArray, n2);
            n2 += by;
            --n3;
        }
        return n2;
    }

    public final int encodeUnsignedShorts(short[] sArray, int n, byte[] byArray) {
        byte by = this.shortSize;
        int n2 = 0;
        int n3 = n - 1;
        while (n3 >= 0) {
            this.encodeUnsignedShort(sArray[n3], byArray, n2);
            n2 += by;
            --n3;
        }
        return n2;
    }

    public final int encodeInts(int[] nArray, int n, byte[] byArray) {
        byte by = this.intSize;
        int n2 = 0;
        int n3 = n - 1;
        while (n3 >= 0) {
            this.encodeInt(nArray[n3], byArray, n2);
            n2 += by;
            --n3;
        }
        return n2;
    }

    public final int encodeUnsignedInts(int[] nArray, int n, byte[] byArray) {
        byte by = this.intSize;
        int n2 = 0;
        int n3 = n - 1;
        while (n3 >= 0) {
            this.encodeUnsignedInt(nArray[n3], byArray, n2);
            n2 += by;
            --n3;
        }
        return n2;
    }

    public final int encodeLongs(long[] lArray, int n, byte[] byArray) {
        byte by = this.longSize;
        int n2 = 0;
        int n3 = n - 1;
        while (n3 >= 0) {
            this.encodeLong(lArray[n3], byArray, n2);
            n2 += by;
            --n3;
        }
        return n2;
    }

    public final int encodeUnsignedLongs(long[] lArray, int n, byte[] byArray) {
        byte by = this.longSize;
        int n2 = 0;
        int n3 = n - 1;
        while (n3 >= 0) {
            this.encodeUnsignedLong(lArray[n3], byArray, n2);
            n2 += by;
            --n3;
        }
        return n2;
    }

    public final int encodeLongLongs(long[] lArray, int n, byte[] byArray) {
        byte by = this.longLongSize;
        int n2 = 0;
        int n3 = n - 1;
        while (n3 >= 0) {
            this.encodeLongLong(lArray[n3], byArray, n2);
            n2 += by;
            --n3;
        }
        return n2;
    }

    public final int encodeUnsignedLongLongs(long[] lArray, int n, byte[] byArray) {
        byte by = this.longLongSize;
        int n2 = 0;
        int n3 = n - 1;
        while (n3 >= 0) {
            this.encodeUnsignedLongLong(lArray[n3], byArray, n2);
            n2 += by;
            --n3;
        }
        return n2;
    }

    public final int encodeFloats(float[] fArray, int n, byte[] byArray) {
        byte by = this.floatSize;
        int n2 = 0;
        int n3 = n - 1;
        while (n3 >= 0) {
            this.encodeFloat(fArray[n3], byArray, n2);
            n2 += by;
            --n3;
        }
        return n2;
    }

    public final int encodeDoubles(double[] dArray, int n, byte[] byArray) {
        byte by = this.doubleSize;
        int n2 = 0;
        int n3 = n - 1;
        while (n3 >= 0) {
            this.encodeDouble(dArray[n3], byArray, n2);
            n2 += by;
            --n3;
        }
        return n2;
    }

    public final int encodeLongDoubles(double[] dArray, int n, byte[] byArray) {
        byte by = this.longDoubleSize;
        int n2 = 0;
        int n3 = n - 1;
        while (n3 >= 0) {
            this.encodeDouble(dArray[n3], byArray, n2);
            n2 += by;
            --n3;
        }
        return n2;
    }
}

