/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io.local;

import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.local.LocalFileSystem;
import edu.sdsc.grid.io.srb.SRBFile;
import java.io.File;
import java.io.FileFilter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Iterator;
import java.util.Properties;

public class LocalFile
extends GeneralFile {
    private static final String PATH_SEPARATOR = System.getProperty("file.separator");
    private static final char PATH_SEPARATOR_CHAR = PATH_SEPARATOR.charAt(0);
    private File wrapper;

    public LocalFile(String string) {
        this(string, "");
    }

    public LocalFile(String string, String string2) {
        super(new LocalFileSystem(), string, string2);
        this.wrapper = new File(string, string2);
    }

    public LocalFile(LocalFile localFile, String string) {
        this(localFile.getAbsolutePath(), string);
        this.wrapper = new File(localFile.getAbsolutePath(), string);
    }

    public LocalFile(File file) {
        this(file.getAbsolutePath(), "");
        this.wrapper = file;
    }

    public LocalFile(File file, String string) {
        this(file.getAbsolutePath(), string);
        this.wrapper = new File(file, string);
    }

    public LocalFile(URI uRI) {
        this(uRI.getPath(), "");
        this.wrapper = new File(uRI);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.wrapper = null;
    }

    public Iterator listIterator() throws IOException {
        return null;
    }

    protected void setDirectory(String string) {
    }

    protected void setFileName(String string) {
    }

    public File getFile() {
        return this.wrapper;
    }

    public Properties getMetaData() {
        return null;
    }

    public String getPathSeparator() {
        return PATH_SEPARATOR;
    }

    public char getPathSeparatorChar() {
        return PATH_SEPARATOR_CHAR;
    }

    protected String getHomeDirectory() {
        return System.getProperty("user.home");
    }

    public void copyTo(GeneralFile generalFile) throws IOException {
        if (generalFile instanceof SRBFile) {
            generalFile.copyFrom(this, false);
        } else {
            super.copyTo(generalFile, false);
        }
    }

    public void copyTo(GeneralFile generalFile, boolean bl) throws IOException {
        if (generalFile instanceof SRBFile) {
            generalFile.copyFrom(this, bl);
        } else {
            super.copyTo(generalFile, bl);
        }
    }

    public void copyFrom(GeneralFile generalFile) throws IOException {
        if (generalFile instanceof SRBFile) {
            generalFile.copyTo(this, false);
        } else {
            super.copyFrom(generalFile, false);
        }
    }

    public void copyFrom(GeneralFile generalFile, boolean bl) throws IOException {
        if (generalFile instanceof SRBFile) {
            generalFile.copyTo(this, bl);
        } else {
            super.copyFrom(generalFile, bl);
        }
    }

    public boolean canRead() {
        return this.wrapper.canRead();
    }

    public boolean canWrite() {
        return this.wrapper.canWrite();
    }

    public int compareTo(GeneralFile generalFile) {
        return this.wrapper.compareTo(((LocalFile)generalFile).getFile());
    }

    public int compareTo(Object object) {
        return this.wrapper.compareTo(object);
    }

    public boolean createNewFile() throws IOException {
        return this.wrapper.createNewFile();
    }

    public static GeneralFile createTempFile(String string, String string2) throws IOException {
        return new LocalFile(File.createTempFile(string, string2));
    }

    public static GeneralFile createTempFile(String string, String string2, GeneralFile generalFile) throws IOException {
        return new LocalFile(File.createTempFile(string, string2, new File(generalFile.getAbsolutePath())));
    }

    public boolean delete() {
        return this.wrapper.delete();
    }

    public void deleteOnExit() {
        this.wrapper.deleteOnExit();
    }

    public boolean equals(Object object) {
        return this.wrapper.equals(object);
    }

    public boolean exists() {
        return this.wrapper.exists();
    }

    public GeneralFile getAbsoluteFile() {
        return new LocalFile(this.wrapper.getAbsoluteFile());
    }

    public String getAbsolutePath() {
        return this.wrapper.getAbsolutePath();
    }

    public GeneralFile getCanonicalFile() throws IOException {
        return new LocalFile(this.wrapper.getCanonicalFile());
    }

    public String getCanonicalPath() throws IOException {
        return this.wrapper.getCanonicalPath();
    }

    public String getName() {
        return this.wrapper.getName();
    }

    public String getParent() {
        String string = null;
        int n = -1;
        try {
            string = this.wrapper.getCanonicalPath();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (string == null) {
            string = this.wrapper.getPath();
        }
        if ((n = string.lastIndexOf(PATH_SEPARATOR)) == string.length() - 1) {
            n = string.lastIndexOf(PATH_SEPARATOR, n);
        }
        string = string.substring(0, n);
        return string;
    }

    public GeneralFile getParentFile() {
        return new LocalFile(this.getParent());
    }

    public String getPath() {
        return this.wrapper.getPath();
    }

    public int hashCode() {
        return this.wrapper.hashCode();
    }

    public boolean isAbsolute() {
        return this.wrapper.isAbsolute();
    }

    public boolean isDirectory() {
        return this.wrapper.isDirectory();
    }

    public boolean isFile() {
        return this.wrapper.isFile();
    }

    public boolean isHidden() {
        return this.wrapper.isHidden();
    }

    public long lastModified() {
        return this.wrapper.lastModified();
    }

    public long length() {
        return this.wrapper.length();
    }

    public String[] list() {
        return this.wrapper.list();
    }

    public String[] list(FilenameFilter filenameFilter) {
        return this.wrapper.list(filenameFilter);
    }

    public GeneralFile[] listFiles() {
        File[] fileArray = this.wrapper.listFiles();
        if (fileArray == null) {
            return null;
        }
        GeneralFile[] generalFileArray = new LocalFile[fileArray.length];
        int n = 0;
        while (n < fileArray.length) {
            generalFileArray[n] = new LocalFile(fileArray[n]);
            ++n;
        }
        return generalFileArray;
    }

    public GeneralFile[] listFiles(FileFilter fileFilter) {
        File[] fileArray = this.wrapper.listFiles(fileFilter);
        GeneralFile[] generalFileArray = new LocalFile[fileArray.length];
        int n = 0;
        while (n < fileArray.length) {
            generalFileArray[n] = new LocalFile(fileArray[n]);
            ++n;
        }
        return generalFileArray;
    }

    public GeneralFile[] listFiles(FilenameFilter filenameFilter) {
        File[] fileArray = this.wrapper.listFiles(filenameFilter);
        GeneralFile[] generalFileArray = new LocalFile[fileArray.length];
        int n = 0;
        while (n < fileArray.length) {
            generalFileArray[n] = new LocalFile(fileArray[n]);
            ++n;
        }
        return generalFileArray;
    }

    public static GeneralFile[] listRoots() {
        File[] fileArray = File.listRoots();
        GeneralFile[] generalFileArray = new LocalFile[fileArray.length];
        int n = 0;
        while (n < fileArray.length) {
            generalFileArray[n] = new LocalFile(fileArray[n]);
            ++n;
        }
        return generalFileArray;
    }

    public boolean mkdir() {
        return this.wrapper.mkdir();
    }

    public boolean mkdirs() {
        return this.wrapper.mkdirs();
    }

    public boolean renameTo(GeneralFile generalFile) {
        return this.wrapper.renameTo(new File(generalFile.getAbsolutePath()));
    }

    public boolean setLastModified(long l) {
        return this.wrapper.setLastModified(l);
    }

    public boolean setReadOnly() {
        return this.wrapper.setReadOnly();
    }

    public String toString() {
        return this.wrapper.toURI().toString();
    }

    public URI toURI() {
        return this.wrapper.toURI();
    }

    public URL toURL() throws MalformedURLException {
        return this.wrapper.toURL();
    }
}

