/*
 * Decompiled with CFR 0.152.
 */
package edu.sdsc.grid.io.srb;

import edu.sdsc.grid.io.FileFactory;
import edu.sdsc.grid.io.GeneralFile;
import edu.sdsc.grid.io.GeneralRandomAccessFile;
import edu.sdsc.grid.io.Host;
import edu.sdsc.grid.io.MetaDataCondition;
import edu.sdsc.grid.io.MetaDataField;
import edu.sdsc.grid.io.MetaDataRecordList;
import edu.sdsc.grid.io.MetaDataSelect;
import edu.sdsc.grid.io.MetaDataSet;
import edu.sdsc.grid.io.MetaDataTable;
import edu.sdsc.grid.io.local.LocalFile;
import edu.sdsc.grid.io.local.LocalRandomAccessFile;
import edu.sdsc.grid.io.srb.GSIAuth;
import edu.sdsc.grid.io.srb.SRBAccount;
import edu.sdsc.grid.io.srb.SRBException;
import edu.sdsc.grid.io.srb.SRBFileSystem;
import edu.sdsc.grid.io.srb.SRBMetaDataCommands;
import edu.sdsc.grid.io.srb.SRBMetaDataRecordList;
import edu.sdsc.grid.io.srb.SRBMetaDataSet;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.ProtocolException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.nio.channels.ClosedChannelException;

class SRBCommands {
    static int DEBUG = 0;
    static final char STATUS_OK = '\u0000';
    public static final int CHAR_LENGTH = 2;
    public static final int SHORT_LENGTH = 2;
    public static final int INT_LENGTH = 4;
    public static final int LONG_LENGTH = 8;
    private static final int ERROR_MSG_LENGTH = 4096;
    private static final String STARTUP_HEADER = "START SRB\u0000";
    private static final int OUTPUT_BUFFER_LENGTH = 16384;
    private static final int ENCRYPT1_MESSAGE_SIZE = 64;
    private static final int OPR_COMMAND = 1;
    private static final int F_E_CREATE = 1000;
    private static final int F_E_OPEN = 1001;
    private static final int F_E_CLOSE = 1002;
    private static final int F_E_UNLINK = 1003;
    private static final int F_E_READ = 1004;
    private static final int F_E_WRITE = 1005;
    private static final int F_E_SEEK = 1006;
    private static final int F_E_SYNC = 1007;
    private static final int F_E_STAT = 1008;
    private static final int F_E_MKDIR = 1009;
    private static final int F_E_CHMOD = 1010;
    private static final int F_E_RMDIR = 1011;
    private static final int F_E_OPENDIR = 1012;
    private static final int F_E_READDIR = 1013;
    private static final int F_E_CLOSEDIR = 1014;
    private static final int F_E_SETSTORATTRI = 1015;
    private static final int F_E_MIGRATE = 1016;
    private static final int F_E_STAGE = 1017;
    private static final int F_E_PURGE = 1018;
    private static final int F_E_FSTAT = 1019;
    private static final int F_E_VAULT_INFO = 1050;
    private static final int F_GET_SVR_VER = 1051;
    private static final int F_SRBO_CREATE = 2000;
    private static final int F_SRBO_OPEN = 2001;
    private static final int F_SRBO_CLOSE = 2002;
    private static final int F_SRBO_UNLINK = 2003;
    private static final int F_SRBO_READ = 2004;
    private static final int F_SRBO_WRITE = 2005;
    private static final int F_SRBO_SEEK = 2006;
    private static final int F_SRBO_SYNC = 2007;
    private static final int F_SRBO_STAT = 2008;
    private static final int F_SRBO_REPLICATE = 2009;
    private static final int F_SRBO_MOVE = 2010;
    private static final int F_SRBO_PROXY_OPR = 2011;
    private static final int F_SRBO_GET_DENTS = 2012;
    private static final int F_SRBO_GET_DENTS64 = 2013;
    private static final int F_SRBC_SEEK = 2014;
    private static final int F_SRBO_CHKSUM = 2015;
    private static final int F_SRBO_GET_LOID_INFO = 2100;
    static final int F_SRBO_GET_DATADIR_INFO = 2101;
    private static final int F_SRBO_REGISTER_FILE = 2102;
    private static final int F_SRBO_MODIFY_FILE = 2103;
    private static final int F_CHK_MDAS_AUTH = 2104;
    private static final int F_CREATE_DIRECTORY = 2105;
    private static final int F_LIST_DIRECTORY = 2106;
    private static final int F_MODIFY_DIRECTORY = 2107;
    private static final int F_CHK_MDAS_SYS_AUTH = 2108;
    private static final int F_REGISTER_USER_GROUP = 2109;
    private static final int F_REGISTER_USER = 2110;
    private static final int F_MODIFY_USER = 2111;
    private static final int F_SET_AUDIT_TRAIL = 2112;
    private static final int F_SRBO_AUDIT = 2113;
    private static final int F_REGISTER_REPLICA = 2114;
    private static final int F_GET_PRIV_USERS = 2115;
    private static final int F_GET_MORE_ROWS = 2116;
    private static final int F_ISSUE_TICKET = 2117;
    private static final int F_REMOVE_TICKET = 2118;
    private static final int F_UNREGISTER_FILE = 2119;
    private static final int F_CONTAINER_CREATE = 2120;
    private static final int F_REGISTER_CONTAINER = 2121;
    private static final int F_REGISTER_IN_CONTAINER = 2122;
    private static final int F_GET_CONTAINER_INFO = 2123;
    private static final int F_GET_RESC_ON_CHOICE = 2124;
    private static final int F_REMOVE_CONTAINER = 2125;
    private static final int F_SYNC_CONTAINER = 2126;
    private static final int F_REPLICATION_CONTAINER = 2127;
    private static final int F_CHK_ENCRYPT1_AUTH = 2128;
    private static final int F_SRBO_LOCK = 2129;
    private static final int F_CONTAINER_OPEN = 2130;
    private static final int F_CONTAINER_CLOSE = 2131;
    private static final int F_FILE_COPY = 2132;
    private static final int F_SRBO_COPY = 2133;
    private static final int F_FILE_PUT = 2134;
    private static final int F_SRBO_PUT = 2135;
    private static final int F_FILE_GET = 2136;
    private static final int F_SRBO_GET = 2137;
    private static final int F_BULK_REGISTER = 2138;
    private static final int F_SRBO_SYNC_DATA = 2139;
    private static final int F_MOD_RESC_INFO = 2140;
    private static final int F_SRBO_REG_FILE_INT = 2141;
    private static final int F_REGISTER_LOCATION = 2142;
    private static final int F_INGEST_TOKEN = 2143;
    private static final int F_REGISTER_RESOURCE = 2144;
    private static final int F_REGISTER_LOGICAL_RESOURCE = 2145;
    private static final int F_REGISTER_REPLICATE_RESOURCE_INFO = 2146;
    private static final int F_DELETE_VALUE = 2147;
    private static final int F_SETUP_SESSION = 2148;
    private static final int F_SETUP_SESSION_PUBLIC_KEY = 2149;
    private static final int F_BULK_LOAD = 2150;
    private static final int F_GET_MCAT_NAME = 2151;
    private static final int F_MODIFY_ZONE = 2152;
    private static final int F_BULK_QUERY_ANSWER = 2153;
    private static final int F_BULK_MCAT_INGEST = 2154;
    static final int F_GEN_QUERY = 2155;
    private static final int F_BULK_UNLOAD = 2156;
    private static final int F_GEN_GET_MORE_ROWS = 2157;
    private static final int F_BULK_UNLOAD_C = 2158;
    private static final int F_BACKUP_DATA = 2159;
    private static final int F_REMOVE_TICKET_WITH_ZONE = 2160;
    private static final int F_MODIFY_USER_NP = 2161;
    private static final int F_MODIFY_RESOURCE = 2162;
    private static final int F_GET_HOST_CONFIG = 2200;
    private static final int F_DB_LOBJ_CREATE = 3000;
    private static final int F_DB_LOBJ_OPEN = 3001;
    private static final int F_DB_LOBJ_CLOSE = 3002;
    private static final int F_DB_LOBJ_READ = 3004;
    private static final int F_DB_LOBJ_WRITE = 3005;
    private static final int F_DB_LOBJ_SEEK = 3006;
    private static final int F_DB_LOBJ_UNLINK = 3007;
    private static final int F_DB_TABLE_CREATE = 4000;
    private static final int F_DB_TABLE_OPEN = 4001;
    private static final int F_DB_TABLE_CLOSE = 4002;
    private static final int F_DB_TABLE_READ = 4004;
    private static final int F_DB_TABLE_WRITE = 4005;
    private static final int F_DB_TABLE_SEEK = 4006;
    private static final int F_DB_TABLE_UNLINK = 4007;
    private static final int F_TAPELIB_MNT_CART = 5000;
    private static final int F_TAPELIB_DISMNT_CART = 5001;
    private static final int F_TAPELIB_GET_CART_PRI = 5002;
    private static final int F_CMP_DUMP_FILE_LIST = 5100;
    private static final int F_CMP_STAGE_COMP_OBJ = 5101;
    private static final int F_CMP_REG_INT_COMP_OBJ = 5102;
    private static final int F_CMP_RM_INT_COMP_OBJ = 5103;
    private static final int F_CMP_RM_COMP_OBJ = 5104;
    private static final int F_CMP_MOD_INT_COMP_OBJ = 5105;
    private static final int F_DUMMY = 999999;
    static final int MSG_USE_SINGLE_PORT = -99999999;
    static boolean singleServerPort;
    private Socket srbConnection;
    private InputStream in = null;
    private OutputStream out = null;
    private byte[] outputBuffer = new byte[16384];
    private int outputOffset = 0;
    private String password;
    private int passwordOption;
    String certAuth;
    private String zone;
    int srbGetDataDirInfoCount = 0;
    long totalBytesMoved = 0L;
    long bytesMoved = 0L;
    long srcLength;
    static final int MAX_THREADS = 4;
    boolean singlePortBulkUnload = false;

    SRBCommands() throws IOException {
    }

    protected void finalize() throws IOException {
        if (this.outputBuffer != null) {
            this.outputBuffer = null;
        }
        this.close();
        if (this.out != null) {
            this.out = null;
        }
        if (this.in != null) {
            this.in = null;
        }
        if (this.srbConnection != null) {
            this.srbConnection = null;
        }
    }

    int connect(SRBAccount sRBAccount, byte[] byArray) throws IOException {
        int n = -1;
        String string = sRBAccount.getHost();
        int n2 = sRBAccount.getPort();
        float f = sRBAccount.getVersionNumber();
        this.zone = sRBAccount.getMcatZone();
        if (DEBUG > 1) {
            System.out.println("Connecting to master server, " + string + ":" + n2);
        }
        this.openSocket(string, n2);
        this.send(STARTUP_HEADER.getBytes());
        this.flush();
        if ((double)f >= 3.3) {
            byte[] byArray2 = this.read(4);
            n2 = Host.castToInt(byArray2);
            if (n2 != 0) {
                byArray2 = this.read(4);
                n2 = Host.castToInt(byArray2);
            }
        } else {
            byte[] byArray3 = this.read(4);
            n2 = Host.castToInt(byArray3);
        }
        if (n2 < 0) {
            this.close();
            throw new ProtocolException("connect() -- couldn't read port number: " + n2);
        }
        if (n2 > 0) {
            this.close();
            if (DEBUG > 1) {
                System.out.println("Connecting to srbServer:" + n2);
            }
            this.openSocket(string, n2);
        } else if (DEBUG > 1) {
            System.out.println("Connecting to srbServer through srbMaster server.");
        }
        return this.sendUserInfo(sRBAccount, byArray, n2);
    }

    int sendUserInfo(SRBAccount sRBAccount, byte[] byArray, int n) throws IOException {
        int n2 = -1;
        this.send(byArray);
        this.flush();
        byte[] byArray2 = this.read(4);
        n2 = Host.castToInt(byArray2);
        if (n2 < 0) {
            this.close();
            return n2;
        }
        this.outputBuffer = new byte[16384];
        if (DEBUG > 1) {
            System.out.println("Sending password...");
        }
        this.password = sRBAccount.getPassword();
        this.passwordOption = sRBAccount.getOptions();
        switch (this.passwordOption) {
            case 48: {
                this.send(this.password);
                break;
            }
            case 51: {
                this.certAuth = sRBAccount.getCertificateAuthority();
                new GSIAuth(this.password, this.certAuth, this.srbConnection, this.out, this.in);
                break;
            }
            case 54: {
                this.certAuth = sRBAccount.getCertificateAuthority();
                new GSIAuth(this.password, this.certAuth, this.srbConnection, this.out, this.in);
                break;
            }
            case 53: {
                this.sendEncrypt1Auth(this.password);
                break;
            }
            default: {
                this.send(this.password);
            }
        }
        this.flush();
        byArray2 = this.read(4);
        n2 = Host.castToInt(byArray2);
        if (n2 == -1004 || n2 == -1005 || n2 == -1006 || n2 == -1017) {
            SRBException sRBException = new SRBException("connect() -- couldn't connect to SRB. ", n2);
            throw new SecurityException(sRBException.getMessage() + sRBException.getStandardMessage());
        }
        if (n2 < 0) {
            this.close();
            throw new SRBException("connect() -- couldn't connect to SRB. ", n2);
        }
        if (DEBUG > 1) {
            System.out.println("Successful connection.");
        }
        return n;
    }

    synchronized void close() throws IOException {
        if (this.isConnected()) {
            this.out.write(new String("X").getBytes());
            this.out.close();
            this.in.close();
            this.srbConnection.close();
        }
    }

    void sendEncrypt1Auth(String string) throws IOException {
        int n = -1;
        int n2 = -1;
        int n3 = -1;
        long l = 0L;
        long l2 = 0L;
        long l3 = 64L;
        double d = 2.6035084875658576;
        long[] lArray = new long[2];
        long[] lArray2 = new long[2];
        byte[] byArray = new byte[64];
        int[] nArray = new int[63];
        int n4 = 0;
        while (n4 < nArray.length) {
            nArray[n4] = this.in.read();
            ++n4;
        }
        this.read(1);
        if (string != null) {
            int[] nArray2 = new int[string.length()];
            byte[] byArray2 = string.getBytes();
            int n5 = 0;
            while (n5 < nArray2.length) {
                nArray2[n5] = byArray2[n5];
                ++n5;
            }
            SRBCommands.vHashString(lArray, nArray2);
            SRBCommands.vHashString(lArray2, nArray);
            l3 = 0x3FFFFFFFL;
            d = l3;
            l = (lArray[0] ^ lArray2[0]) % l3;
            l2 = (lArray[1] ^ lArray2[1]) % l3;
            int n6 = 0;
            while (n6 < nArray.length) {
                l = (l * 3L + l2) % l3;
                l2 = (l + l2 + 33L) % l3;
                byArray[n6] = (byte)(Math.floor((double)l / d * 31.0) + 64.0);
                ++n6;
            }
        }
        this.send(byArray, 0, byArray.length);
        if (n3 != 64) {
            // empty if block
        }
    }

    static void vHashString(long[] lArray, int[] nArray) {
        long l = 1345345333L;
        long l2 = 7L;
        long l3 = 305419889L;
        int n = 0;
        while (n < nArray.length) {
            int n2 = nArray[n];
            long l4 = l << 8;
            long l5 = 0x100000000L;
            if (l4 > l5) {
                l4 = (int)l4;
            }
            if (l4 < -l5) {
                l4 = l5 + l4;
            }
            if ((l ^= ((l & 0x3FL) + l2) * (long)n2 + l4) < 0L) {
                l = l5 + l;
            }
            if ((l4 = l3 << 8) > l5) {
                l4 = (int)l4;
            }
            if (l4 < 0L) {
                l4 = l5 + l4;
            }
            if ((l3 += l4 ^ l) > l5) {
                l3 = (int)l3;
            }
            if (l3 < 0L) {
                l3 = l5 + l3;
            }
            l2 += (long)n2;
            ++n;
        }
        lArray[0] = l & Integer.MAX_VALUE;
        lArray[1] = l3 & Integer.MAX_VALUE;
    }

    String getZone() {
        return this.zone;
    }

    private void openSocket(String string, int n) throws IOException {
        try {
            this.srbConnection = new Socket(string, n);
            this.in = this.srbConnection.getInputStream();
            this.out = this.srbConnection.getOutputStream();
        }
        catch (ConnectException connectException) {
            ConnectException connectException2 = new ConnectException("Connection cannot be made to: " + string + " at port: " + n);
            connectException2.initCause(connectException);
            throw connectException2;
        }
        catch (SocketException socketException) {
            SocketException socketException2 = new SocketException("A socket error occured when connecting to: " + string + " at port: " + n);
            socketException2.initCause(socketException);
            throw socketException2;
        }
    }

    boolean isConnected() {
        return this.srbConnection.isConnected() && !this.srbConnection.isClosed();
    }

    private void send(byte[] byArray) throws IOException {
        if (byArray.length + this.outputOffset >= 16384) {
            if (this.srbConnection.isClosed()) {
                throw new ClosedChannelException();
            }
            this.out.write(this.outputBuffer, 0, this.outputOffset);
            this.out.write(byArray);
            this.out.flush();
            this.outputOffset = 0;
        } else {
            System.arraycopy(byArray, 0, this.outputBuffer, this.outputOffset, byArray.length);
            this.outputOffset += byArray.length;
            if (DEBUG > 5) {
                System.out.print("Send: " + new String(byArray));
            }
        }
    }

    private void send(byte[] byArray, int n, int n2) throws IOException {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.send(byArray2);
    }

    private void send(String string) throws IOException {
        this.send(string.getBytes());
    }

    private void send(int n) throws IOException {
        byte[] byArray = new byte[4];
        Host.copyInt(n, byArray);
        Host.swap(byArray, 4);
        this.send(byArray);
    }

    private void send(long l) throws IOException {
        byte[] byArray = new byte[8];
        Host.copyLong(l, byArray);
        Host.swap(byArray, 8);
        this.send(byArray);
    }

    void flush() throws IOException {
        if (this.srbConnection.isClosed()) {
            throw new ClosedChannelException();
        }
        this.out.write(this.outputBuffer, 0, this.outputOffset);
        this.out.flush();
        this.outputOffset = 0;
    }

    private byte read() throws IOException {
        return (byte)this.in.read();
    }

    /*
     * Unable to fully structure code
     */
    byte[] read(int var1_1) throws ClosedChannelException, InterruptedIOException, IOException {
        block7: {
            if (var1_1 <= 0) {
                return null;
            }
            var2_2 = new byte[var1_1];
            try {
                var3_3 = 1448;
                var4_5 = 0;
                if (var1_1 <= var3_3) ** GOTO lbl16
                while (var1_1 > var4_5 + var3_3 - 1) {
                    var4_5 += this.in.read(var2_2, var4_5, var3_3);
                }
                while (var1_1 - var4_5 - 1 > 0) {
                    var4_5 += this.in.read(var2_2, var4_5, var1_1 - var4_5);
                }
                break block7;
lbl-1000:
                // 1 sources

                {
                    var4_5 += this.in.read(var2_2, var4_5, var1_1 - var4_5);
lbl16:
                    // 2 sources

                    ** while (var1_1 - var4_5 > 0)
                }
lbl17:
                // 1 sources

            }
            catch (IOException var3_4) {
                var4_6 = new IOException("read() -- couldn't read complete packet");
                var4_6.initCause(var3_4);
                throw var4_6;
            }
        }
        if (SRBCommands.DEBUG > 5) {
            System.out.print("Read: " + new String(var2_2));
        }
        return var2_2;
    }

    private char readChar() throws IOException {
        byte[] byArray = this.read(2);
        Host.swap(byArray, 2);
        char c = (char)Host.castToShort(byArray);
        return c;
    }

    private short readShort() throws IOException {
        byte[] byArray = this.read(2);
        Host.swap(byArray, 2);
        short s = Host.castToShort(byArray);
        return s;
    }

    private int readInt() throws IOException {
        byte[] byArray = this.read(4);
        Host.swap(byArray, 4);
        int n = Host.castToInt(byArray);
        return n;
    }

    long readUnsignedInt() throws IOException {
        long l = Host.castToUnsignedInt(this.read(4));
        return l;
    }

    private long readLong() throws IOException {
        byte[] byArray = this.read(8);
        Host.swap(byArray, 8);
        long l = Host.castToLong(byArray);
        return l;
    }

    private String readString() throws IOException {
        String string = "";
        byte by = this.read();
        while (by != 0) {
            string = string + (char)by;
            by = this.read();
        }
        return string;
    }

    private String readString(int n) throws IOException {
        String string = new String(this.read(n));
        return string;
    }

    private void status() throws IOException {
        byte[] byArray = this.read(1);
        if (byArray[0] < 0) {
            throw new SRBException("Unknown error received from server.");
        }
    }

    void startSRBCommand(int n, int n2) throws IOException {
        String string = "F \u0000";
        this.send(string.getBytes());
        this.send(n);
        this.send(n2);
    }

    void sendArg(int n) throws IOException {
        this.send(4);
        this.send(n);
    }

    void sendArg(long l) throws IOException {
        this.send(8);
        this.send(l);
    }

    void sendArg(String string) throws IOException {
        if (string == null) {
            this.send(new String("\u0000\u0000\u0000\u0000").getBytes());
        } else {
            this.send(string.length());
            this.send(string.getBytes());
        }
    }

    void sendArg(byte[] byArray) throws IOException {
        if (byArray == null) {
            this.send(new String("\u0000\u0000\u0000\u0000").getBytes());
        } else {
            this.send(byArray.length);
            this.send(byArray);
        }
    }

    void sendArg(byte[] byArray, int n) throws IOException {
        if (byArray == null) {
            this.send(new String("\u0000\u0000\u0000\u0000").getBytes());
        } else {
            this.send(n);
            this.send(byArray, 0, n);
        }
    }

    void sendArg(byte[] byArray, int n, int n2) throws IOException {
        if (byArray == null) {
            this.send(new String("\u0000\u0000\u0000\u0000").getBytes());
        } else {
            this.send(n2);
            this.send(byArray, n, n2);
        }
    }

    void sendArg(int[] nArray) throws IOException {
        this.send(nArray.length * 4);
        int n = 0;
        while (n < nArray.length) {
            this.send(nArray[n]);
            ++n;
        }
    }

    void sendArg(char[][] cArray) throws IOException {
        int n = cArray.length * cArray[0].length;
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = 0;
        while (n3 < cArray.length) {
            int n4 = 0;
            while (n4 < cArray[n3].length) {
                byArray[n2] = (byte)cArray[n3][n4];
                ++n2;
                ++n4;
            }
            ++n3;
        }
        this.send(n);
        this.send(byArray);
    }

    void sendArg(SRBMetaDataRecordList[] sRBMetaDataRecordListArray) throws IOException {
        byte[] byArray = new byte[]{0};
        String string = new String(byArray);
        boolean bl = false;
        int n = sRBMetaDataRecordListArray[0].getFieldCount();
        byte[] byArray2 = new byte[4];
        Host.copyInt(n, byArray2);
        int n2 = sRBMetaDataRecordListArray.length;
        byte[] byArray3 = new byte[4];
        Host.copyInt(n2, byArray3);
        String string2 = "";
        int n3 = 0;
        int n4 = 0;
        while (n4 < sRBMetaDataRecordListArray[0].getFieldCount()) {
            string2 = string2 + SRBMetaDataSet.getSRBTableName(sRBMetaDataRecordListArray[0].getFieldName(n4)) + string + SRBMetaDataSet.getSRBAttributeName(sRBMetaDataRecordListArray[0].getFieldName(n4)) + string;
            int n5 = 0;
            while (n5 < sRBMetaDataRecordListArray.length) {
                string2 = string2 + sRBMetaDataRecordListArray[n5].getStringValue(n4) + string;
                ++n5;
            }
            ++n4;
        }
        byte[] byArray4 = new byte[(100 - sRBMetaDataRecordListArray[0].getFieldCount()) * 2 * 3];
        byArray4[0] = 1;
        int n6 = 1;
        while (n6 < byArray4.length - 1) {
            byArray4[n6] = 0;
            byArray4[n6 + 1] = 1;
            n6 += 2;
        }
        this.send(12 + string2.length() + byArray4.length + 4);
        this.send(0);
        this.send(byArray2);
        this.send(byArray3);
        this.send(string2);
        this.send(byArray4);
        this.send(n3);
        if (DEBUG > 2) {
            System.out.print("sendArg(rl): " + new String(byArray2));
            System.out.println(new String(byArray3));
            System.out.println(string2);
            System.out.println(new String(byArray4));
            System.out.println(n3);
        }
    }

    void commandStatus() throws IOException {
        byte[] byArray = this.read(1);
        String string = "\nThe SRB server returned an error: ";
        if ((char)byArray[0] == 'A') {
            byte[] byArray2 = new byte[]{(byte)this.passwordOption, 0, 0, 0};
            this.out.write(byArray2);
            switch (this.passwordOption) {
                case 48: {
                    this.send(this.password);
                    break;
                }
                case 51: {
                    new GSIAuth(this.password, this.certAuth, this.srbConnection, this.out, this.in);
                    break;
                }
                case 54: {
                    new GSIAuth(this.password, this.certAuth, this.srbConnection, this.out, this.in);
                    break;
                }
                case 53: {
                    this.sendEncrypt1Auth(this.password);
                    break;
                }
                default: {
                    this.send(this.password);
                }
            }
            this.commandStatus();
            return;
        }
        if ((char)byArray[0] != 'V') {
            int n = -1;
            int n2 = 0;
            int n3 = 10;
            byArray = new byte[4096 * n3];
            boolean bl = true;
            block12: while (bl) {
                n2 = this.in.read(byArray, 0, 4096 * n3);
                int n4 = 0;
                while (n4 < n2) {
                    if ((char)byArray[n4] == 'V') {
                        byte[] byArray3;
                        if (byArray[n4 + 1] == 71) {
                            if (byArray[n4 + 2] == 8) {
                                byArray3 = new byte[]{byArray[n4 + 6], byArray[n4 + 7], byArray[n4 + 8], byArray[n4 + 9]};
                                Host.swap(byArray3, 4);
                                n = Host.castToInt(byArray3);
                                bl = false;
                                n4 = n2;
                            } else {
                                byArray3 = new byte[]{byArray[n4 + 6], byArray[n4 + 7], byArray[n4 + 8], byArray[n4 + 9]};
                                n = (int)Host.castToUnsignedInt(byArray3);
                                if (n > 0) {
                                    Host.swap(byArray3, 4);
                                    n = Host.castToInt(byArray3);
                                }
                                bl = false;
                                n4 = n2;
                            }
                        } else {
                            if (byArray[n4 - 1] == 0) {
                                byArray3 = new byte[]{byArray[n4 + 6], byArray[n4 + 7], byArray[n4 + 8], byArray[n4 + 9]};
                                n = (int)Host.castToUnsignedInt(byArray3);
                                if (n > 0) {
                                    Host.swap(byArray3, 4);
                                    n = Host.castToInt(byArray3);
                                }
                                bl = false;
                                continue block12;
                            }
                            string = string + (char)byArray[n4];
                        }
                    } else {
                        string = string + (char)byArray[n4];
                    }
                    ++n4;
                }
            }
            if (byArray[n2 - 1] != 48) {
                this.status();
            }
            throw new SRBException(string, n);
        }
        byArray = this.read(1);
        switch ((char)byArray[0]) {
            case 'G': {
                return;
            }
            case 'E': {
                throw new SRBException("SRB Server: returned an unknown error");
            }
            case 'N': {
                byArray = new byte[4096];
                this.in.read(byArray);
                if (byArray.length == 1) {
                    throw new SRBException("Return detected, but error message cannot be read");
                }
                string = new String(byArray);
                throw new SRBException(string);
            }
            case '0': {
                return;
            }
        }
        string = "FATAL: SRB protocol error: ";
        string = string + new String(byArray);
        throw new SRBException(string);
    }

    private int returnInt() throws IOException {
        byte[] byArray = this.read(1);
        int n = -1;
        if (byArray[0] > 4) {
            byArray = this.read(byArray[0] + 1);
            String string = "The SRB server returned an error: ";
            string = string + new String(byArray);
            throw new SRBException(string);
        }
        byArray = this.read(3);
        n = this.readInt();
        this.status();
        return n;
    }

    private long returnLong() throws IOException {
        byte[] byArray = this.read(1);
        long l = -1L;
        if (byArray[0] > 8) {
            byArray = this.read(byArray[0] + 1);
            String string = "The SRB server returned an error: ";
            string = string + new String(byArray);
            throw new SRBException(string);
        }
        byArray = this.read(3);
        l = this.readLong();
        this.status();
        return l;
    }

    private byte[] returnBytes() throws IOException {
        byte[] byArray = this.read(4);
        int n = 0;
        int n2 = byArray.length - 1;
        while (n2 >= 0) {
            n = byArray[n2] < 0 ? (n << 8) + 256 + byArray[n2] : (n << 8) + byArray[n2];
            --n2;
        }
        if (n >= 4) {
            this.read(4);
            byArray = this.read(n -= 4);
            this.read(1);
            return byArray;
        }
        String string = "\nThe SRB server returned an error: ";
        string = string + (int)Host.castToUnsignedInt(this.read(4));
        this.read(1);
        throw new SRBException(string);
    }

    SRBMetaDataRecordList[] returnSRBMetaDataRecordList(boolean bl) throws IOException {
        return this.returnSRBMetaDataRecordList(bl, false);
    }

    SRBMetaDataRecordList[] returnSRBMetaDataRecordList(boolean bl, boolean bl2) throws IOException {
        if (DEBUG > 2) {
            System.out.println("returnSRBMetaDataRecordList new");
        }
        if (!bl) {
            return this.returnSRBMetaDataRecordList();
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        boolean bl3 = false;
        if (this.singlePortBulkUnload) {
            this.read(4);
        }
        int n4 = bl2 ? Host.castToInt(this.read(4)) : this.readInt();
        int n5 = (int)this.readUnsignedInt();
        if (bl2) {
            this.read(4);
        }
        if (n5 < 0) {
            if (DEBUG > 3) {
                System.out.println(n5);
            }
            if (n5 == -3005) {
                this.read(1);
                return null;
            }
            String string = "\nSRB server status: " + n5;
            this.read(1);
            throw new SRBException(string);
        }
        int n6 = (int)this.readUnsignedInt();
        int n7 = (int)this.readUnsignedInt();
        byte[] byArray = this.read(n4 - 16);
        if (bl2) {
            this.read(3);
        }
        byte[] byArray2 = this.read(4);
        short s = (short)Host.castToInt(byArray2);
        if (DEBUG > 2) {
            System.out.println("bufferLength " + n4);
            System.out.println("status " + n5);
            System.out.println("fieldCount " + n6);
            System.out.println("recordCount " + n7);
            System.out.println("continuationIndex " + s);
            System.out.println("resultBuffer " + byArray.length);
            if (DEBUG > 4) {
                n = 0;
                while (n < byArray.length) {
                    if (byArray[n] > 32) {
                        System.out.print((char)byArray[n]);
                    } else if (byArray[n] > 1) {
                        System.out.print(byArray[n]);
                    } else if (n > 1 && byArray[n - 1] != 1 && byArray[n - 2] != 0 && byArray[n] != 1) {
                        System.out.print(byArray[n]);
                    }
                    ++n;
                }
                System.out.print("\n");
                n = 0;
                while (n < byArray.length) {
                    System.out.print(" " + byArray[n]);
                    ++n;
                }
            }
        }
        String[] stringArray = new String[n6];
        String[] stringArray2 = new String[n6];
        String[][] stringArray3 = new String[n6][n7];
        n = 0;
        while (n < n6) {
            stringArray[n] = "";
            while (byArray[n2] != 0 && n2 < byArray.length - 1) {
                int n8 = n;
                stringArray[n8] = stringArray[n8] + (char)byArray[n2];
                ++n2;
            }
            if (byArray[n2] == 0 && n2 < byArray.length - 1) {
                ++n2;
            }
            stringArray2[n] = "";
            while (byArray[n2] != 0 && n2 < byArray.length - 1) {
                int n9 = n;
                stringArray2[n9] = stringArray2[n9] + (char)byArray[n2];
                ++n2;
            }
            if (byArray[n2] == 0 && n2 < byArray.length - 1) {
                ++n2;
            }
            n3 = 0;
            while (n3 < n7) {
                stringArray3[n][n3] = "";
                while (byArray[n2] != 0 && n2 < byArray.length - 1) {
                    String[] stringArray4 = stringArray3[n];
                    int n10 = n3;
                    stringArray4[n10] = stringArray4[n10] + (char)byArray[n2];
                    ++n2;
                }
                if (byArray[n2] == 0 && n2 < byArray.length - 1) {
                    ++n2;
                }
                ++n3;
            }
            if (byArray[n2] == 0) {
                ++n2;
            }
            ++n;
        }
        return this.parseSRBMetaDataRecordList(n6, n7, s, stringArray, stringArray2, stringArray3);
    }

    SRBMetaDataRecordList[] returnSRBMetaDataRecordList() throws IOException {
        if (DEBUG > 2) {
            System.out.println("returnSRBMetaDataRecordList old");
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = this.readInt();
        int n6 = (int)this.readUnsignedInt();
        if (n6 < 0) {
            if (DEBUG > 3) {
                System.out.println(n6);
            }
            if (n6 == -3005) {
                this.read(1);
                return null;
            }
            String string = "\nSRB server status: " + n6;
            this.read(1);
            throw new SRBException(string);
        }
        int n7 = (int)this.readUnsignedInt();
        int n8 = (int)this.readUnsignedInt();
        int n9 = (int)this.readUnsignedInt();
        byte[] byArray = this.read(n5 - 19);
        this.read(3);
        this.status();
        if (DEBUG > 2) {
            System.out.println("bufferLength " + n5);
            System.out.println("status " + n6);
            System.out.println("fieldCount " + n7);
            System.out.println("recordCount " + n8);
            System.out.println("continuationIndex " + n9);
            System.out.println("resultBuffer " + byArray.length);
            if (DEBUG > 4) {
                n = 0;
                while (n < byArray.length) {
                    if (byArray[n] != 0) {
                        System.out.print((char)byArray[n]);
                    }
                    ++n;
                }
                n = 0;
                while (n < byArray.length) {
                    System.out.print(" " + byArray[n]);
                    ++n;
                }
            }
        }
        String[] stringArray = new String[n7];
        String[] stringArray2 = new String[n7];
        String[][] stringArray3 = new String[n7][n8];
        n = 0;
        while (n < n7) {
            stringArray[n] = "";
            n4 = n2;
            while (byArray[n2] != 0 && n2 < byArray.length - 1) {
                int n10 = n;
                stringArray[n10] = stringArray[n10] + (char)byArray[n2];
                ++n2;
            }
            while (byArray[n2] == 0 && n2 < byArray.length - 1) {
                ++n2;
            }
            stringArray2[n] = "";
            n4 = n2;
            while (byArray[n2] != 0 && n2 < byArray.length - 1) {
                int n11 = n;
                stringArray2[n11] = stringArray2[n11] + (char)byArray[n2];
                ++n2;
            }
            if (byArray[n2] == 0 && n2 < byArray.length - 1) {
                ++n2;
            }
            n3 = 0;
            while (n3 < n8) {
                n4 = n2;
                stringArray3[n][n3] = "";
                while (byArray[n2] != 0 && n2 < byArray.length - 1) {
                    String[] stringArray4 = stringArray3[n];
                    int n12 = n3;
                    stringArray4[n12] = stringArray4[n12] + (char)byArray[n2];
                    ++n2;
                }
                if (n2 < n4 + SRBFileSystem.MAX_FILE_SIZE) {
                    n2 = n4 + SRBFileSystem.MAX_FILE_SIZE;
                }
                ++n3;
            }
            ++n;
        }
        return this.parseSRBMetaDataRecordList(n7, n8, n9, stringArray, stringArray2, stringArray3);
    }

    SRBMetaDataRecordList[] parseSRBMetaDataRecordList(int n, int n2, int n3, String[] stringArray, String[] stringArray2, String[][] stringArray3) throws IOException {
        Object object;
        MetaDataField[] metaDataFieldArray = null;
        Object[] objectArray = null;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        int n7 = 0;
        boolean bl = false;
        MetaDataField[] metaDataFieldArray2 = new MetaDataField[n];
        n4 = 0;
        while (n4 < n) {
            metaDataFieldArray2[n4] = SRBMetaDataSet.getGeneralMetaData(stringArray[n4], stringArray2[n4]);
            ++n4;
        }
        if (DEBUG > 3) {
            n4 = 0;
            while (n4 < n) {
                System.out.println("fields " + metaDataFieldArray2[n4]);
                ++n4;
            }
        }
        SRBMetaDataRecordList[] sRBMetaDataRecordListArray = new SRBMetaDataRecordList[n2];
        Object[] objectArray2 = new Object[n];
        int n8 = 0;
        int n9 = 0;
        String string = null;
        n4 = 0;
        while (n4 < n2) {
            n5 = 0;
            while (n5 < n) {
                int[] nArray;
                String[][] stringArray4;
                int n10;
                String string2;
                String string3;
                string = metaDataFieldArray2[n5].getName();
                if (string == "definable metadata file0") {
                    object = null;
                    if (n5 + 1 < n) {
                        object = metaDataFieldArray2[n5 + 1].getName();
                    }
                    if (object == "definable metadata file1") {
                        string3 = null;
                        string2 = null;
                        n10 = -1;
                        int n11 = -1;
                        n6 = 0;
                        n7 = 0;
                        while (n6 < n) {
                            if (metaDataFieldArray2[n6].getName() == "file name") {
                                string3 = stringArray3[n6][n4];
                                n10 = n6;
                            }
                            if (metaDataFieldArray2[n6].getName() == "directory name") {
                                string2 = stringArray3[n6][n4];
                                n11 = n6;
                            }
                            ++n6;
                            ++n7;
                        }
                        if (n10 >= 0 && n11 >= 0) {
                            n7 = 0;
                            while (n7 < n2) {
                                if (stringArray3[n10][n7].equals(string3) && stringArray3[n11][n7].equals(string2)) {
                                    ++n8;
                                }
                                ++n7;
                            }
                            stringArray4 = new String[n8][10];
                            nArray = new int[n8];
                            n6 = 0;
                            while (n6 < n8) {
                                n7 = 0;
                                while (n7 < stringArray4[0].length) {
                                    stringArray4[n6][n7] = stringArray3[n5 + n7][n6 + n4];
                                    ++n7;
                                }
                                nArray[n6] = 0;
                                ++n6;
                            }
                            objectArray2[n5] = new MetaDataTable(nArray, stringArray4);
                            n9 += n8 - 1;
                            if (metaDataFieldArray == null) {
                                metaDataFieldArray = new MetaDataField[n - 9];
                            }
                            n4 += n8 - 1;
                            n5 += 9;
                            n8 = 0;
                        }
                    } else {
                        objectArray2[n5] = stringArray3[n5][n4];
                    }
                } else if (string == "definable metadata directory0") {
                    object = null;
                    if (n5 + 1 < n) {
                        object = metaDataFieldArray2[n5 + 1].getName();
                    }
                    if (object == "definable metadata directory1") {
                        string3 = null;
                        string2 = null;
                        n10 = -1;
                        n6 = 0;
                        n7 = 0;
                        while (n6 < n) {
                            if (metaDataFieldArray2[n6].getName() == "directory name") {
                                string2 = stringArray3[n6][n4];
                                n10 = n6;
                            }
                            ++n6;
                            ++n7;
                        }
                        if (n10 >= 0) {
                            n7 = 0;
                            while (n7 < n2) {
                                if (stringArray3[n10][n7].equals(string2)) {
                                    ++n8;
                                }
                                ++n7;
                            }
                            String[][] stringArray5 = new String[n8][10];
                            stringArray4 = (String[][])new int[n8];
                            n6 = 0;
                            while (n6 < n8) {
                                n7 = 0;
                                while (n7 < stringArray5[0].length) {
                                    stringArray5[n6][n7] = stringArray3[n5 + n7][n6 + n4];
                                    ++n7;
                                }
                                stringArray4[n6] = (String[])false;
                                ++n6;
                            }
                            objectArray2[n5] = new MetaDataTable((int[])stringArray4, stringArray5);
                            n9 += n8 - 1;
                            if (metaDataFieldArray == null) {
                                metaDataFieldArray = new MetaDataField[n - 9];
                            }
                            n4 += n8 - 1;
                            n5 += 9;
                            n8 = 0;
                        }
                    } else {
                        objectArray2[n5] = stringArray3[n5][n4];
                    }
                } else if (string == "definable metadata user0") {
                    object = null;
                    if (n5 + 1 < n) {
                        object = metaDataFieldArray2[n5 + 1].getName();
                    }
                    if (object == "definable metadata user1") {
                        string3 = null;
                        string2 = null;
                        n10 = -1;
                        int n12 = -1;
                        n6 = 0;
                        n7 = 0;
                        while (n6 < n) {
                            if (metaDataFieldArray2[n6].getName() == "user name") {
                                string3 = stringArray3[n6][n4];
                                n10 = n6;
                            }
                            if (metaDataFieldArray2[n6].getName() == "user domain") {
                                string2 = stringArray3[n6][n4];
                                n12 = n6;
                            }
                            ++n6;
                            ++n7;
                        }
                        if (n10 >= 0 && n12 >= 0) {
                            n7 = 0;
                            while (n7 < n2) {
                                if (stringArray3[n10][n7].equals(string3) && stringArray3[n12][n7].equals(string2)) {
                                    ++n8;
                                }
                                ++n7;
                            }
                            stringArray4 = new String[n8][10];
                            nArray = new int[n8];
                            n6 = 0;
                            while (n6 < n8) {
                                n7 = 0;
                                while (n7 < stringArray4[0].length) {
                                    stringArray4[n6][n7] = stringArray3[n5 + n7][n6 + n4];
                                    ++n7;
                                }
                                nArray[n6] = 0;
                                ++n6;
                            }
                            objectArray2[n5] = new MetaDataTable(nArray, stringArray4);
                            n9 += n8 - 1;
                            if (metaDataFieldArray == null) {
                                metaDataFieldArray = new MetaDataField[n - 9];
                            }
                            n4 += n8 - 1;
                            n5 += 9;
                            n8 = 0;
                        }
                    } else {
                        objectArray2[n5] = stringArray3[n5][n4];
                    }
                } else if (string == "definable metadata resource0") {
                    object = null;
                    if (n5 + 1 < n) {
                        object = metaDataFieldArray2[n5 + 1].getName();
                    }
                    if (object == "definable metadata resource1") {
                        string3 = null;
                        string2 = null;
                        n10 = -1;
                        n6 = 0;
                        n7 = 0;
                        while (n6 < n) {
                            if (metaDataFieldArray2[n6].getName() == "resource name") {
                                string2 = stringArray3[n6][n4];
                                n10 = n6;
                            }
                            ++n6;
                            ++n7;
                        }
                        if (n10 >= 0) {
                            n7 = 0;
                            while (n7 < n2) {
                                if (stringArray3[n10][n7].equals(string2)) {
                                    ++n8;
                                }
                                ++n7;
                            }
                            String[][] stringArray6 = new String[n8][10];
                            stringArray4 = (String[][])new int[n8];
                            n6 = 0;
                            while (n6 < n8) {
                                n7 = 0;
                                while (n7 < stringArray6[0].length) {
                                    stringArray6[n6][n7] = stringArray3[n5 + n7][n6 + n4];
                                    ++n7;
                                }
                                stringArray4[n6] = (String[])false;
                                ++n6;
                            }
                            objectArray2[n5] = new MetaDataTable((int[])stringArray4, stringArray6);
                            n9 += n8 - 1;
                            if (metaDataFieldArray == null) {
                                metaDataFieldArray = new MetaDataField[n - 9];
                            }
                            n4 += n8 - 1;
                            n5 += 9;
                            n8 = 0;
                        }
                    } else {
                        objectArray2[n5] = stringArray3[n5][n4];
                    }
                } else {
                    objectArray2[n5] = stringArray3[n5][n4];
                }
                ++n5;
            }
            if (metaDataFieldArray != null) {
                objectArray = new Object[n - 9];
                n6 = 0;
                n7 = 0;
                while (n6 < objectArray2.length) {
                    if (objectArray2[n6] != null) {
                        objectArray[n7] = objectArray2[n6];
                        metaDataFieldArray[n7] = metaDataFieldArray2[n6].getName() == "definable metadata file0" ? MetaDataSet.getField("definable metadata for files") : (metaDataFieldArray2[n6].getName() == "definable metadata directory0" ? MetaDataSet.getField("definable metadata for directories") : (metaDataFieldArray2[n6].getName() == "definable metadata user0" ? MetaDataSet.getField("definable metadata for users") : (metaDataFieldArray2[n6].getName() == "definable metadata resource0" ? MetaDataSet.getField("definable metadata for resources") : metaDataFieldArray2[n6])));
                        ++n7;
                    }
                    ++n6;
                }
                sRBMetaDataRecordListArray[n4] = new SRBMetaDataRecordList(metaDataFieldArray, objectArray, n3, this);
                metaDataFieldArray = null;
            } else {
                sRBMetaDataRecordListArray[n4] = new SRBMetaDataRecordList(metaDataFieldArray2, objectArray2, n3, this);
            }
            ++n4;
        }
        if (DEBUG > 3) {
            n4 = 0;
            while (n4 < n2) {
                n5 = 0;
                while (n5 < n) {
                    System.out.println("rl[" + n4 + "]." + n5 + " " + sRBMetaDataRecordListArray[n4].getValue(n5));
                    ++n5;
                }
                ++n4;
            }
        }
        this.status();
        object = new SRBMetaDataRecordList[n2 - n9];
        n4 = 0;
        n5 = 0;
        while (n4 < sRBMetaDataRecordListArray.length) {
            if (sRBMetaDataRecordListArray[n4] != null) {
                object[n5] = sRBMetaDataRecordListArray[n4];
                ++n5;
            }
            ++n4;
        }
        return object;
    }

    synchronized int srbObjCreate(int n, String string, String string2, String string3, String string4, String string5, long l) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbObjCreate " + string + " " + string4 + " " + string3);
        }
        this.startSRBCommand(2000, 7);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.sendArg(string4);
        this.sendArg(string5);
        this.sendArg(l);
        this.flush();
        this.commandStatus();
        int n2 = this.returnInt();
        if (n2 < 0) {
            throw new SRBException(n2);
        }
        return n2;
    }

    synchronized int srbObjOpen(String string, int n, String string2) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbObjOpen");
        }
        this.startSRBCommand(2001, 3);
        this.sendArg(string);
        this.sendArg(n);
        this.sendArg(string2);
        this.flush();
        this.commandStatus();
        int n2 = this.returnInt();
        if (n2 < 0) {
            throw new SRBException(n2);
        }
        return n2;
    }

    synchronized void srbObjClose(int n) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbObjClose");
        }
        this.startSRBCommand(2002, 1);
        this.sendArg(n);
        this.flush();
        this.commandStatus();
        int n2 = this.returnInt();
        if (n2 < 0) {
            throw new SRBException(n2);
        }
    }

    synchronized void srbObjUnlink(String string, String string2) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbObjUnlink");
        }
        this.startSRBCommand(2003, 2);
        this.sendArg(string);
        this.sendArg(string2);
        this.flush();
        this.commandStatus();
        int n = this.returnInt();
        if (n < 0) {
            throw new SRBException(n);
        }
    }

    synchronized byte[] srbObjRead(int n, int n2) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbObjRead");
        }
        this.startSRBCommand(2004, 2);
        this.sendArg(n);
        this.sendArg(n2);
        this.flush();
        this.commandStatus();
        return this.returnBytes();
    }

    synchronized int srbObjWrite(int n, byte[] byArray, int n2) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbObjWrite");
        }
        this.startSRBCommand(2005, 2);
        this.sendArg(n);
        this.sendArg(byArray, n2);
        this.flush();
        this.commandStatus();
        int n3 = this.returnInt();
        if (n3 < 0) {
            throw new SRBException("Write failed", n3);
        }
        return n3;
    }

    synchronized void srbObjSeek(int n, long l, int n2) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbObjSeek");
        }
        this.startSRBCommand(2006, 3);
        this.sendArg(n);
        this.sendArg(l);
        this.sendArg(n2);
        this.flush();
        this.commandStatus();
        int n3 = (int)this.returnLong();
        if (n3 < 0) {
            throw new SRBException(n3);
        }
    }

    synchronized void srbObjSync(int n) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbObjSync");
        }
        this.startSRBCommand(2007, 1);
        this.sendArg(n);
        this.flush();
        this.commandStatus();
        int n2 = this.returnInt();
        if (n2 < 0) {
            throw new SRBException(n2);
        }
    }

    synchronized long[] srbObjStat(int n, String string, int n2) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbObjStat");
        }
        long[] lArray = new long[30];
        long l = 0L;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        boolean bl = false;
        this.startSRBCommand(2008, 3);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(n2);
        this.flush();
        this.commandStatus();
        byte[] byArray = this.returnBytes();
        if (byArray != null) {
            n4 = 0;
            while (n4 < 8) {
                l = byArray[n4] < 0 ? (l << 8) + 256L + (long)byArray[n4] : (l << 8) + (long)byArray[n4];
                ++n4;
            }
            lArray[0] = l;
            ++n3;
            while (n3 < lArray.length - 7) {
                l = 0L;
                n5 = n4 + 4;
                while (n4 < n5) {
                    l = byArray[n4] < 0 ? (l << 8) + 256L + (long)byArray[n4] : (l << 8) + (long)byArray[n4];
                    ++n4;
                }
                lArray[n3] = l;
                ++n3;
            }
            while (n3 < lArray.length - 5) {
                l = 0L;
                n5 = n4 + 2;
                while (n4 < n5) {
                    l = byArray[n4] < 0 ? (l << 8) + 256L + (long)byArray[n4] : (l << 8) + (long)byArray[n4];
                    ++n4;
                }
                lArray[n3] = l;
                ++n3;
            }
            while (n3 < lArray.length) {
                l = 0L;
                n5 = n4 + 4;
                while (n4 < n5) {
                    l = byArray[n4] < 0 ? (l << 8) + 256L + (long)byArray[n4] : (l << 8) + (long)byArray[n4];
                    ++n4;
                }
                lArray[n3] = l;
                ++n3;
            }
        }
        return lArray;
    }

    long[] srbObjStat64(int n, String string) throws IOException {
        return this.srbObjStat(n, string, 0);
    }

    synchronized void srbObjReplicate(int n, String string, String string2, String string3, String string4) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbObjReplicate");
        }
        this.startSRBCommand(2009, 5);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.sendArg(string4);
        this.flush();
        this.commandStatus();
        int n2 = this.returnInt();
        if (n2 < 0) {
            throw new SRBException(n2);
        }
    }

    synchronized void srbObjMove(int n, String string, String string2, String string3, String string4) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbObjMove");
        }
        this.startSRBCommand(2010, 5);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.sendArg(string4);
        this.flush();
        this.commandStatus();
        int n2 = this.returnInt();
        if (n2 < 0) {
            throw new SRBException(n2);
        }
    }

    synchronized byte[] srbObjProxyOpr(int n, int n2, int n3, int n4, int n5, String string, String string2, String string3, String string4, byte[] byArray, byte[] byArray2, byte[] byArray3) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbObjProxyOpr");
        }
        this.startSRBCommand(2011, 12);
        this.sendArg(n);
        this.sendArg(n2);
        this.sendArg(n3);
        this.sendArg(n4);
        this.sendArg(n5);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string2);
        this.sendArg(string4);
        this.sendArg(byArray);
        this.sendArg(byArray2);
        this.sendArg(byArray3);
        this.flush();
        this.commandStatus();
        byte[] byArray4 = this.read(4);
        int n6 = 0;
        int n7 = byArray4.length - 1;
        while (n7 >= 0) {
            n6 = byArray4[n7] < 0 ? (n6 << 8) + 256 + byArray4[n7] : (n6 << 8) + byArray4[n7];
            --n7;
        }
        if (n6 > 4) {
            this.read(4);
            byArray4 = this.read(n6 -= 4);
            this.read(1);
            return byArray4;
        }
        byArray4 = this.read(4);
        this.status();
        return byArray4;
    }

    synchronized byte[] srbObjGetdents(int n, int n2, long l) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbObjGetdents");
        }
        this.startSRBCommand(2012, 3);
        this.sendArg(n);
        this.sendArg(n2);
        this.sendArg(l);
        this.flush();
        this.commandStatus();
        return this.returnBytes();
    }

    synchronized byte[] srbObjGetdents64(int n, int n2, long l) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbObjGetdents64");
        }
        this.startSRBCommand(2013, 3);
        this.sendArg(n);
        this.sendArg(n2);
        this.sendArg(l);
        this.flush();
        this.commandStatus();
        return this.returnBytes();
    }

    synchronized void srbCollSeek(int n, int n2, int n3, int n4) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbCollSeek");
        }
        this.startSRBCommand(2014, 4);
        this.sendArg(n);
        this.sendArg(n2);
        this.sendArg(n3);
        this.sendArg(n4);
        this.flush();
        this.commandStatus();
        int n5 = this.returnInt();
        if (n5 < 0) {
            throw new SRBException(n5);
        }
    }

    synchronized SRBMetaDataRecordList[] srbGetDatasetInfo(int n, String string, String string2, int n2) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbGetDatasetInfo");
        }
        this.startSRBCommand(2100, 4);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(n2);
        this.flush();
        this.commandStatus();
        return this.returnSRBMetaDataRecordList();
    }

    synchronized SRBMetaDataRecordList[] srbGetDataDirInfo(int n, MetaDataCondition[] metaDataConditionArray, MetaDataSelect[] metaDataSelectArray, int n2, boolean bl, boolean bl2) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbGetDataDirInfo " + this.srbGetDataDirInfoCount);
        }
        ++this.srbGetDataDirInfoCount;
        SRBMetaDataCommands sRBMetaDataCommands = new SRBMetaDataCommands(this);
        return sRBMetaDataCommands.srbGetDataDirInfo(n, metaDataConditionArray, metaDataSelectArray, n2, bl, bl2);
    }

    SRBMetaDataRecordList[] srbGenQuery(int n, String string, MetaDataCondition[] metaDataConditionArray, MetaDataSelect[] metaDataSelectArray, int n2, boolean bl, boolean bl2) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbGenQuery");
        }
        SRBMetaDataCommands sRBMetaDataCommands = new SRBMetaDataCommands(this);
        return sRBMetaDataCommands.srbGenQuery(n, string, metaDataConditionArray, metaDataSelectArray, n2, bl, bl2);
    }

    synchronized void srbRegisterDataset(int n, String string, String string2, String string3, String string4, String string5, long l) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbRegisterDataset");
        }
        this.startSRBCommand(2102, 7);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.sendArg(string4);
        this.sendArg(string5);
        this.sendArg(l);
        this.flush();
        this.commandStatus();
        int n2 = this.returnInt();
        if (n2 < 0) {
            throw new SRBException(n2);
        }
    }

    synchronized int srbModifyDataset(int n, String string, String string2, String string3, String string4, String string5, String string6, int n2) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbModifyDataset " + n + " " + string + " " + string2 + " " + string3 + " " + string4 + " " + string5 + " " + string6 + " " + n2);
        }
        this.startSRBCommand(2103, 8);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.sendArg(string4);
        this.sendArg(string5);
        this.sendArg(string6);
        this.sendArg(n2);
        this.flush();
        this.commandStatus();
        int n3 = this.returnInt();
        if (n3 < 0) {
            throw new SRBException(n3);
        }
        return n3;
    }

    synchronized void srbChkMdasAuth(String string, String string2, String string3) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbChkMdasAuth");
        }
        this.startSRBCommand(2104, 3);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.flush();
        this.commandStatus();
        int n = this.returnInt();
        if (n < 0) {
            throw new SRBException(n);
        }
    }

    synchronized void srbCreateCollect(int n, String string, String string2) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbCreateCollect");
        }
        this.startSRBCommand(2105, 3);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(string2);
        this.flush();
        this.commandStatus();
        int n2 = this.returnInt();
        if (n2 < 0) {
            throw new SRBException(n2);
        }
    }

    synchronized SRBMetaDataRecordList[] srbListCollect(int n, String string, String string2, int n2) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbListCollect");
        }
        this.startSRBCommand(2106, 4);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(n2);
        this.flush();
        this.commandStatus();
        return this.returnSRBMetaDataRecordList();
    }

    synchronized void srbModifyCollect(int n, String string, String string2, String string3, String string4, int n2) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbModifyCollect " + n + " " + string + " " + string2 + " " + string3 + " " + string4 + " " + n2);
        }
        this.startSRBCommand(2107, 6);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.sendArg(string4);
        this.sendArg(n2);
        this.flush();
        this.commandStatus();
        int n3 = this.returnInt();
        if (n3 < 0) {
            throw new SRBException(n3);
        }
    }

    synchronized void srbChkMdasSysAuth(String string, String string2, String string3) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbChkMdasSysAuth");
        }
        this.startSRBCommand(2108, 3);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.flush();
        this.commandStatus();
        int n = this.returnInt();
        if (n < 0) {
            throw new SRBException(n);
        }
    }

    synchronized void srbRegisterUserGrp(int n, String string, String string2, String string3, String string4, String string5, String string6) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbRegisterUserGrp");
        }
        this.startSRBCommand(2109, 7);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.sendArg(string4);
        this.sendArg(string5);
        this.sendArg(string6);
        this.flush();
        this.commandStatus();
        int n2 = this.returnInt();
        if (n2 < 0) {
            throw new SRBException(n2);
        }
    }

    synchronized void srbRegisterUser(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbRegisterUser");
        }
        this.startSRBCommand(2110, 8);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.sendArg(string4);
        this.sendArg(string5);
        this.sendArg(string6);
        this.sendArg(string7);
        this.flush();
        this.commandStatus();
        int n2 = this.returnInt();
        if (n2 < 0) {
            throw new SRBException(n2);
        }
    }

    synchronized void srbModifyUser(int n, String string, String string2, int n2) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbModifyUser");
        }
        this.startSRBCommand(2111, 4);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(n2);
        this.flush();
        this.commandStatus();
        int n3 = this.returnInt();
        if (n3 < 0) {
            throw new SRBException(n3);
        }
    }

    synchronized int srbSetAuditTrail(int n) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbSetAuditTrail");
        }
        this.startSRBCommand(2112, 1);
        this.sendArg(n);
        this.flush();
        this.commandStatus();
        return this.returnInt();
    }

    synchronized void srbObjAudit(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, int n2, String string8) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbObjAudit");
        }
        this.startSRBCommand(2113, 10);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.sendArg(string4);
        this.sendArg(string5);
        this.sendArg(string6);
        this.sendArg(string7);
        this.sendArg(n2);
        this.sendArg(string8);
        this.flush();
        this.commandStatus();
        int n3 = this.returnInt();
        if (n3 < 0) {
            throw new SRBException(n3);
        }
    }

    synchronized void srbRegisterReplica(int n, String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbRegisterReplica");
        }
        this.startSRBCommand(2114, 9);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.sendArg(string4);
        this.sendArg(string5);
        this.sendArg(string6);
        this.sendArg(string7);
        this.sendArg(string8);
        this.flush();
        this.commandStatus();
        int n2 = this.returnInt();
        if (n2 < 0) {
            throw new SRBException(n2);
        }
    }

    synchronized SRBMetaDataRecordList[] srbGetPrivUsers(int n, int n2) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbGetPrivUsers");
        }
        this.startSRBCommand(2115, 2);
        this.sendArg(n);
        this.sendArg(n2);
        this.flush();
        this.commandStatus();
        return this.returnSRBMetaDataRecordList();
    }

    synchronized SRBMetaDataRecordList[] srbGetMoreRows(int n, int n2, int n3) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbGetMoreRows " + n + " " + n2 + " " + n3);
        }
        float f = SRBAccount.getVersionNumber();
        if (n2 < 0) {
            return null;
        }
        if (f >= 3.0f) {
            return this.srbGenGetMoreRows(n, n2, n3);
        }
        try {
            this.startSRBCommand(2116, 3);
            this.sendArg(n);
            this.sendArg(n2);
            this.sendArg(n3);
            this.flush();
            this.commandStatus();
            return this.returnSRBMetaDataRecordList();
        }
        catch (SRBException sRBException) {
            if (sRBException.getType() == -3005) {
                return null;
            }
            throw sRBException;
        }
    }

    SRBMetaDataRecordList[] srbGenGetMoreRows(int n, int n2, int n3) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbGenGetMoreRows " + n + " " + n2 + " " + n3);
        }
        if (n2 < 0) {
            return null;
        }
        try {
            this.startSRBCommand(2157, 3);
            this.sendArg(n);
            this.sendArg(n2);
            this.sendArg(n3);
            this.flush();
            this.commandStatus();
            return this.returnSRBMetaDataRecordList(true);
        }
        catch (SRBException sRBException) {
            if (sRBException.getType() == -3005) {
                return null;
            }
            throw sRBException;
        }
    }

    synchronized void srbIssueTicket(String string, String string2, String string3, String string4, String string5, int n, String string6) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbIssueTicket");
        }
        this.startSRBCommand(2117, 7);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.sendArg(string4);
        this.sendArg(string5);
        this.sendArg(n);
        this.sendArg(string6);
        this.flush();
        this.commandStatus();
        int n2 = this.returnInt();
        if (n2 < 0) {
            throw new SRBException(n2);
        }
    }

    synchronized void srbRemoveTicket(String string) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbRemoveTicket");
        }
        this.startSRBCommand(2118, 1);
        this.sendArg(string);
        this.flush();
        this.commandStatus();
        int n = this.returnInt();
        if (n < 0) {
            throw new SRBException(n);
        }
    }

    synchronized void srbUnregisterDataset(String string, String string2) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbUnregisterDataset");
        }
        this.startSRBCommand(2119, 2);
        this.sendArg(string);
        this.sendArg(string2);
        this.flush();
        this.commandStatus();
        int n = this.returnInt();
        if (n < 0) {
            throw new SRBException(n);
        }
    }

    synchronized void srbContainerCreate(int n, String string, String string2, String string3, long l) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbContainerCreate");
        }
        this.startSRBCommand(2120, 5);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.sendArg(l);
        this.flush();
        this.commandStatus();
        int n2 = this.returnInt();
        if (n2 < 0) {
            throw new SRBException(n2);
        }
    }

    synchronized void srbRegisterContainer(int n, String string, String string2, long l) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbRegisterContainer");
        }
        this.startSRBCommand(2000, 4);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(l);
        this.flush();
        this.commandStatus();
        int n2 = this.returnInt();
        if (n2 < 0) {
            throw new SRBException(n2);
        }
    }

    synchronized void srbRegisterInContDataset(int n, String string, String string2, String string3, String string4, long l, long l2) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbRegisterInContDataset");
        }
        this.startSRBCommand(2122, 7);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.sendArg(string4);
        this.sendArg(l);
        this.sendArg(l2);
        this.flush();
        this.commandStatus();
        int n2 = this.returnInt();
        if (n2 < 0) {
            throw new SRBException(n2);
        }
    }

    synchronized SRBMetaDataRecordList[] srbGetContainerInfo(int n, String string, int n2) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbGetContainerInfo");
        }
        this.startSRBCommand(2123, 3);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(n2);
        this.flush();
        this.commandStatus();
        return this.returnSRBMetaDataRecordList();
    }

    synchronized String srbGetResOnChoice(int n, String string, String string2, String string3) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbObjProxyOpr");
        }
        this.startSRBCommand(2124, 3);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(string3);
        this.flush();
        this.commandStatus();
        return new String(this.returnBytes());
    }

    synchronized void srbRmContainer(int n, String string, boolean bl) throws IOException {
        float f;
        if (DEBUG > 0) {
            System.out.println("\n srbRmContainer");
        }
        if ((f = SRBAccount.getVersionNumber()) <= 3.0f) {
            this.startSRBCommand(2125, 2);
            this.sendArg(n);
            this.sendArg(string);
        } else if (bl) {
            this.startSRBCommand(2125, 3);
            this.sendArg(n);
            this.sendArg(string);
            this.sendArg(1);
        } else {
            this.startSRBCommand(2125, 3);
            this.sendArg(n);
            this.sendArg(string);
            this.sendArg(1006);
        }
        this.flush();
        this.commandStatus();
        int n2 = this.returnInt();
        if (n2 < 0) {
            throw new SRBException(n2);
        }
    }

    synchronized void srbSyncContainer(int n, String string, int n2) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbSyncContainer");
        }
        this.startSRBCommand(2126, 3);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(n2);
        this.flush();
        this.commandStatus();
        int n3 = this.returnInt();
        if (n3 < 0) {
            throw new SRBException(n3);
        }
    }

    synchronized void srbReplContainer(int n, String string, String string2) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbReplContainer");
        }
        this.startSRBCommand(2127, 3);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(string2);
        this.flush();
        this.commandStatus();
        int n2 = this.returnInt();
        if (n2 < 0) {
            throw new SRBException(n2);
        }
    }

    synchronized String[] srbTapelibMntCart(String string, int n) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbTapelibMntCart");
        }
        this.startSRBCommand(5000, 3);
        this.sendArg(string);
        this.sendArg(n);
        this.flush();
        this.commandStatus();
        int n2 = this.returnInt();
        if (n2 < 0) {
            throw new SRBException(n2);
        }
        return null;
    }

    synchronized void srbTapelibDismntCart(String string) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbTapelibDismntCart");
        }
        this.startSRBCommand(5001, 2);
        this.sendArg(string);
        this.flush();
        this.commandStatus();
        int n = this.returnInt();
        if (n < 0) {
            throw new SRBException(n);
        }
    }

    synchronized void srbRegInternalCompObj(String string, String string2, int n, int n2, String string3, String string4, long l, long l2, int n3, int n4, int n5, String string5) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbRegInternalCompObj");
        }
        this.startSRBCommand(5102, 12);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(n);
        this.sendArg(n2);
        this.sendArg(string3);
        this.sendArg(string4);
        this.sendArg(l);
        this.sendArg(l2);
        this.sendArg(n3);
        this.sendArg(n4);
        this.sendArg(n5);
        this.sendArg(string5);
        this.flush();
        this.commandStatus();
        int n6 = this.returnInt();
        if (n6 < 0) {
            throw new SRBException(n6);
        }
    }

    synchronized void srbRmIntCompObj(String string, String string2, int n, int n2, int n3, int n4) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbRmIntCompObj");
        }
        this.startSRBCommand(5101, 6);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(n);
        this.sendArg(n2);
        this.sendArg(n3);
        this.sendArg(n4);
        this.flush();
        this.commandStatus();
        int n5 = this.returnInt();
        if (n5 < 0) {
            throw new SRBException(n5);
        }
    }

    synchronized void srbRmCompObj(String string, String string2, int n, int n2) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbRmCompObj");
        }
        this.startSRBCommand(5104, 4);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(n);
        this.sendArg(n2);
        this.flush();
        this.commandStatus();
        int n3 = this.returnInt();
        if (n3 < 0) {
            throw new SRBException(n3);
        }
    }

    synchronized void srbModInternalCompObj(String string, String string2, int n, int n2, int n3, int n4, String string3, String string4, String string5, String string6, int n5) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbModInternalCompObj");
        }
        this.startSRBCommand(5105, 11);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(n);
        this.sendArg(n2);
        this.sendArg(n3);
        this.sendArg(n4);
        this.sendArg(string3);
        this.sendArg(string4);
        this.sendArg(string5);
        this.sendArg(string6);
        this.sendArg(n5);
        this.flush();
        this.commandStatus();
        int n6 = this.returnInt();
        if (n6 < 0) {
            throw new SRBException(n6);
        }
    }

    synchronized void srbModifyRescInfo(int n, String string, int n2, String string2, String string3, String string4, String string5) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbModifyRescInfo");
        }
        this.startSRBCommand(2140, 7);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(n2);
        this.sendArg(string2);
        this.sendArg(string3);
        this.sendArg(string4);
        this.sendArg(string5);
        this.flush();
        this.commandStatus();
        int n3 = this.returnInt();
        if (n3 < 0) {
            throw new SRBException(n3);
        }
    }

    synchronized void srbRegisterLocation(String string, String string2, String string3, String string4, String string5) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbRegisterLocation");
        }
        this.startSRBCommand(2142, 5);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.sendArg(string4);
        this.sendArg(string5);
        this.flush();
        this.commandStatus();
        int n = this.returnInt();
        if (n < 0) {
            throw new SRBException(n);
        }
    }

    synchronized void srbIngestToken(String string, String string2, String string3) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbIngestToken");
        }
        this.startSRBCommand(2143, 3);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.flush();
        this.commandStatus();
        int n = this.returnInt();
        if (n < 0) {
            throw new SRBException(n);
        }
    }

    synchronized void srbRegisterResource(String string, String string2, String string3, String string4, String string5, int n) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbRegisterResource");
        }
        this.startSRBCommand(2144, 6);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.sendArg(string4);
        this.sendArg(string5);
        this.sendArg(n);
        this.flush();
        this.commandStatus();
        int n2 = this.returnInt();
        if (n2 < 0) {
            throw new SRBException(n2);
        }
    }

    synchronized void srbRegisterLogicalResource(String string, String string2, String string3, String string4) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbRegisterLogicalResource");
        }
        this.startSRBCommand(2145, 4);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.sendArg(string4);
        this.flush();
        this.commandStatus();
        int n = this.returnInt();
        if (n < 0) {
            throw new SRBException(n);
        }
    }

    synchronized void srbRegisterReplicateResourceInfo(String string, String string2, String string3, String string4) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbRegisterReplicateResourceInfo");
        }
        this.startSRBCommand(2146, 4);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.sendArg(string4);
        this.flush();
        this.commandStatus();
        int n = this.returnInt();
        if (n < 0) {
            throw new SRBException(n);
        }
    }

    synchronized void srbDeleteValue(int n, String string) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbDeleteValue");
        }
        this.startSRBCommand(2147, 2);
        this.sendArg(n);
        this.sendArg(string);
        this.flush();
        this.commandStatus();
        int n2 = this.returnInt();
        if (n2 < 0) {
            throw new SRBException(n2);
        }
    }

    synchronized void srbBulkRegister(int n, String string, SRBMetaDataRecordList[] sRBMetaDataRecordListArray) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbBulkRegister");
        }
        this.startSRBCommand(2138, 3);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(sRBMetaDataRecordListArray);
        this.flush();
        this.commandStatus();
        int n2 = this.returnInt();
        if (n2 < 0) {
            throw new SRBException(n2);
        }
        this.status();
    }

    synchronized InputStream srbExecCommand(String string, String string2, String string3, int n, int n2, int n3) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbExecCommand");
        }
        ServerSocket serverSocket = new ServerSocket();
        if (n2 >= 0) {
            do {
                if (n2 > n3) {
                    throw new IOException("The bind operation failed, all ports already bound.");
                }
                try {
                    serverSocket = new ServerSocket(n2);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                ++n2;
            } while (!serverSocket.isBound());
        } else {
            serverSocket = new ServerSocket(0);
        }
        int n4 = serverSocket.getLocalPort();
        String string4 = this.srbConnection.getLocalAddress().getHostAddress();
        Socket socket = null;
        DataInputStream dataInputStream = null;
        this.startSRBCommand(2011, 12);
        this.sendArg(1);
        this.sendArg(n);
        this.sendArg(n4);
        this.sendArg(0);
        this.sendArg(0);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.sendArg(string4);
        this.sendArg("");
        this.sendArg("");
        this.sendArg("");
        this.flush();
        socket = serverSocket.accept();
        dataInputStream = new DataInputStream(socket.getInputStream());
        this.commandStatus();
        this.returnInt();
        return dataInputStream;
    }

    synchronized InputStream srbExecCommand(String string, String string2, String string3, String string4, int n, int n2, int n3) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbExecCommand");
        }
        ServerSocket serverSocket = new ServerSocket();
        if (n2 >= 0) {
            do {
                if (n2 > n3) {
                    throw new IOException("The bind operation failed, all ports already bound.");
                }
                try {
                    serverSocket = new ServerSocket(n2);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                ++n2;
            } while (!serverSocket.isBound());
        } else {
            serverSocket = new ServerSocket(0);
        }
        int n4 = serverSocket.getLocalPort();
        int n5 = 1;
        String string5 = this.srbConnection.getLocalAddress().getHostAddress();
        Socket socket = null;
        DataInputStream dataInputStream = null;
        this.startSRBCommand(2011, 12);
        this.sendArg(1);
        this.sendArg(n);
        this.sendArg(n4);
        this.sendArg(n5);
        this.sendArg(0);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.sendArg(string5);
        this.sendArg(string4);
        this.sendArg("");
        this.sendArg("");
        this.flush();
        socket = serverSocket.accept();
        dataInputStream = new DataInputStream(socket.getInputStream());
        this.commandStatus();
        this.returnInt();
        return dataInputStream;
    }

    synchronized void srbSyncData(int n, String string, String string2, String string3) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbSyncData");
        }
        this.startSRBCommand(2139, 4);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.flush();
        this.commandStatus();
        int n2 = this.returnInt();
        if (n2 < 0) {
            throw new SRBException(n2);
        }
    }

    synchronized int srbContainerOpen(int n, String string, int n2) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbContainerOpen");
        }
        this.startSRBCommand(2130, 3);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(n2);
        this.flush();
        this.commandStatus();
        return this.returnInt();
    }

    synchronized void srbContainerClose(int n) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbContainerClose");
        }
        this.startSRBCommand(2131, 1);
        this.sendArg(n);
        this.flush();
        this.commandStatus();
        int n2 = this.returnInt();
        if (n2 < 0) {
            throw new SRBException(n2);
        }
    }

    synchronized long srbObjCopy(String string, String string2, String string3, String string4, String string5) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbObjCopy");
        }
        this.startSRBCommand(2133, 5);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.sendArg(string4);
        this.sendArg(string5);
        this.flush();
        this.commandStatus();
        return this.returnLong();
    }

    synchronized long srbObjPut(String string, String string2, String string3, String string4, String string5, String string6, long l, int n, int n2) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbObjPut " + string + " " + string2);
        }
        this.totalBytesMoved = 0L;
        this.bytesMoved = 0L;
        if (l == 0L) {
            this.srbObjCreate(0, string, string4, string3, string2, "", 0L);
            return 0L;
        }
        short s = (short)(Math.random() * 32767.0);
        String string7 = "r";
        LocalRandomAccessFile localRandomAccessFile = new LocalRandomAccessFile(string6, string7);
        ServerSocket serverSocket = null;
        float f = SRBAccount.getVersionNumber();
        if (f < 2.0f) {
            throw new UnsupportedOperationException("Parallel upload not supported on this SRB server version.");
        }
        if (n >= 0) {
            do {
                if (n > n2) {
                    throw new IOException("The bind operation failed, all ports already bound.");
                }
                try {
                    serverSocket = new ServerSocket(n);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                ++n;
            } while (!serverSocket.isBound());
        } else {
            serverSocket = new ServerSocket(0);
        }
        int n3 = serverSocket.getLocalPort();
        ParallelManager parallelManager = new ParallelManager(serverSocket, s, localRandomAccessFile, l, string7);
        Thread thread = new Thread(parallelManager);
        thread.start();
        if (f == 2.0f) {
            this.startSRBCommand(2135, 8);
            this.sendArg(string);
            this.sendArg(string2);
            this.sendArg(string3);
            this.sendArg(this.srbConnection.getLocalAddress().getHostAddress());
            this.sendArg(s << 16 & 0x7FFF0000 | n3);
            this.sendArg(string4);
            this.sendArg(string5);
            this.sendArg(l);
        } else {
            this.startSRBCommand(2135, 9);
            this.sendArg(string);
            this.sendArg(string2);
            this.sendArg(string3);
            this.sendArg(this.srbConnection.getLocalAddress().getHostAddress());
            this.sendArg(s << 16 & 0x7FFF0000 | n3);
            this.sendArg(string4);
            this.sendArg(string5);
            this.sendArg(l);
            this.sendArg(1);
        }
        this.flush();
        this.commandStatus();
        long l2 = this.returnLong();
        if (l2 >= 0L) {
            try {
                if (thread.isAlive()) {
                    thread.join();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        localRandomAccessFile.close();
        if (l2 < 0L) {
            if (l2 == -99999999L) {
                return l2;
            }
            try {
                byte[] byArray = new byte[8];
                Host.copyInt(l2, byArray);
                l2 = Host.castToUnsignedInt(byArray);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            throw new SRBException("", (int)l2);
        }
        return l2;
    }

    synchronized long srbObjGet(String string, String string2, long l, GeneralFile generalFile, int n, int n2, boolean bl) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbObjGet");
        }
        this.totalBytesMoved = 0L;
        this.bytesMoved = 0L;
        short s = (short)(Math.random() * 32767.0);
        String string3 = "rw";
        GeneralRandomAccessFile generalRandomAccessFile = FileFactory.newRandomAccessFile(generalFile, string3);
        if (bl && generalFile.length() > l) {
            try {
                generalRandomAccessFile.setLength(l);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                generalFile.delete();
                generalRandomAccessFile = FileFactory.newRandomAccessFile(generalFile, "rw");
            }
            catch (IOException iOException) {
                generalFile.delete();
                generalRandomAccessFile = FileFactory.newRandomAccessFile(generalFile, "rw");
            }
        } else if (!bl) {
            generalRandomAccessFile.seek(generalRandomAccessFile.length());
        }
        ServerSocket serverSocket = null;
        if (n >= 0) {
            do {
                if (n > n2) {
                    throw new IOException("The bind operation failed, all ports already bound.");
                }
                try {
                    serverSocket = new ServerSocket(n);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                ++n;
            } while (!serverSocket.isBound());
        } else {
            serverSocket = new ServerSocket(0);
        }
        int n3 = serverSocket.getLocalPort();
        ParallelManager parallelManager = new ParallelManager(serverSocket, s, generalRandomAccessFile, l, string3);
        Thread thread = new Thread(parallelManager);
        thread.start();
        this.startSRBCommand(2137, 4);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(this.srbConnection.getLocalAddress().getHostAddress());
        this.sendArg(s << 16 & 0x7FFF0000 | n3);
        this.flush();
        this.commandStatus();
        long l2 = this.returnLong();
        if (l2 > 0L) {
            try {
                if (thread.isAlive()) {
                    thread.join();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            generalRandomAccessFile.close();
        } else if (l2 < 0L) {
            throw new SRBException("", (int)l2);
        }
        return l2;
    }

    long getBytesMoved() {
        return this.bytesMoved;
    }

    synchronized void srbGetMcatZone(String string, String string2, String string3) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbGetMcatZone");
        }
        this.startSRBCommand(2151, 2);
        this.sendArg(string);
        this.sendArg(string2);
        this.flush();
        this.commandStatus();
        int n = this.returnInt();
        if (n < 0) {
            throw new SRBException(n);
        }
    }

    synchronized void srbSetupSessionPublicKey(String string) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbSetupSessionPublicKey");
        }
        this.startSRBCommand(2149, 1);
        this.sendArg(0);
        this.flush();
        this.commandStatus();
        int n = this.returnInt();
        if (n < 0) {
            throw new SRBException(n);
        }
    }

    synchronized void srbSetupSession(String string) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbSetupSession");
        }
        this.startSRBCommand(2148, 1);
        this.sendArg(string);
        this.flush();
        this.commandStatus();
        int n = this.returnInt();
        if (n < 0) {
            throw new SRBException(n);
        }
    }

    synchronized void srbBulkLoad(int n, String string, SRBMetaDataRecordList[] sRBMetaDataRecordListArray) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbBulkLoad");
        }
        this.startSRBCommand(2150, 3);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(sRBMetaDataRecordListArray);
        this.flush();
        this.commandStatus();
        int n2 = this.returnInt();
        if (n2 < 0) {
            throw new SRBException(n2);
        }
    }

    synchronized void srbBulkUnload(int n, int n2, String string, String string2) throws IOException {
        int n3;
        if (DEBUG > 0) {
            System.out.println("\n srbBulkUnload");
        }
        this.totalBytesMoved = 0L;
        this.bytesMoved = 0L;
        int n4 = 0;
        Socket[] socketArray = null;
        InputStream[] inputStreamArray = null;
        OutputStream[] outputStreamArray = null;
        SRBMetaDataRecordList[] sRBMetaDataRecordListArray = null;
        int n5 = 1;
        int[] nArray = null;
        int[] nArray2 = null;
        byte[] byArray = null;
        byte[] byArray2 = null;
        String string3 = null;
        InputStream inputStream = this.in;
        TransferThread[] transferThreadArray = null;
        Thread[] threadArray = null;
        this.startSRBCommand(2158, 3);
        this.sendArg(n);
        this.sendArg(n2);
        this.sendArg(string);
        this.flush();
        this.commandStatus();
        n4 = this.readInt();
        byArray = this.read(4);
        n4 = Host.castToInt(byArray);
        if (n4 == -99999999) {
            this.singlePortBulkUnload = true;
            n5 = 1;
            this.status();
        } else {
            if (n4 < 0) {
                throw new SRBException(n4);
            }
            n5 = Host.castToInt(this.read(4));
            nArray = new int[n5];
            nArray2 = new int[n5];
            byArray = new byte[4];
            byArray2 = new byte[4];
            n3 = 0;
            while (n3 < n5) {
                byArray[2] = this.read();
                byArray[3] = this.read();
                nArray[n3] = Host.castToInt(byArray);
                byArray2[2] = this.read();
                byArray2[3] = this.read();
                nArray2[n3] = Host.castToInt(byArray2);
                ++n3;
            }
            string3 = this.readString();
            this.status();
            socketArray = new Socket[n5];
            inputStreamArray = new InputStream[n5];
            outputStreamArray = new OutputStream[n5];
            int n6 = 0;
            while (n6 < n5) {
                try {
                    socketArray[n6] = new Socket(string3, nArray2[n6]);
                    inputStreamArray[n6] = socketArray[n6].getInputStream();
                    outputStreamArray[n6] = socketArray[n6].getOutputStream();
                }
                catch (ConnectException connectException) {
                    ConnectException connectException2 = new ConnectException("Bulk download connection cannot be made to: " + string3 + " at port: " + nArray2[n6]);
                    connectException2.initCause(connectException);
                    throw connectException2;
                }
                catch (SocketException socketException) {
                    SocketException socketException2 = new SocketException("A bulk download socket error occured when connecting to: " + string3 + " at port: " + nArray2[n6]);
                    socketException2.initCause(socketException);
                    throw socketException2;
                }
                ++n6;
            }
        }
        transferThreadArray = new TransferThread[n5];
        threadArray = new Thread[n5];
        if (n4 == -99999999) {
            sRBMetaDataRecordListArray = this.returnSRBMetaDataRecordList(true, true);
            if (sRBMetaDataRecordListArray != null) {
                transferThreadArray[0] = new TransferThread(this.srbConnection, sRBMetaDataRecordListArray, string2, string);
                threadArray[0] = new Thread(transferThreadArray[0]);
                threadArray[0].start();
            }
        } else {
            inputStream = this.in;
            n3 = 0;
            while (n3 < n5) {
                outputStreamArray[n3].write(byArray);
                this.in = inputStreamArray[n3];
                this.read(4);
                sRBMetaDataRecordListArray = this.returnSRBMetaDataRecordList(true, true);
                this.in = inputStream;
                transferThreadArray[n3] = new TransferThread(socketArray[n3], sRBMetaDataRecordListArray, string2, string);
                threadArray[n3] = new Thread(transferThreadArray[n3]);
                threadArray[n3].start();
                ++n3;
            }
        }
        try {
            n3 = 0;
            while (n3 < threadArray.length) {
                if (threadArray[n3] != null && threadArray[n3].isAlive()) {
                    threadArray[n3].join();
                }
                ++n3;
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
        }
        if (this.singlePortBulkUnload) {
            this.singlePortBulkUnload = false;
        }
    }

    synchronized void srbModifyZone(int n, String string, String string2, String string3, String string4, String string5, String string6, int n2) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbModifyZone");
        }
        this.startSRBCommand(2152, 8);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.sendArg(string4);
        this.sendArg(string5);
        this.sendArg(string6);
        this.sendArg(n2);
        this.flush();
        this.commandStatus();
        int n3 = this.returnInt();
        if (n3 < 0) {
            throw new SRBException(n3);
        }
    }

    synchronized MetaDataRecordList[] srbBulkQueryAnswer(int n, String string, MetaDataRecordList metaDataRecordList, int n2) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbBulkQueryAnswer");
        }
        this.startSRBCommand(2153, 3);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(n2);
        this.flush();
        this.commandStatus();
        return this.returnSRBMetaDataRecordList();
    }

    synchronized void srbBulkMcatIngest(int n, String string, SRBMetaDataRecordList[] sRBMetaDataRecordListArray) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbBulkMcatIngest");
        }
        this.startSRBCommand(2154, 3);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(sRBMetaDataRecordListArray);
        this.flush();
        this.commandStatus();
        int n2 = this.returnInt();
        if (n2 < 0) {
            throw new SRBException(n2);
        }
    }

    synchronized void srbBackupData(int n, String string, String string2, String string3, int n2) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbBackupData");
        }
        this.startSRBCommand(2159, 5);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.sendArg(n2);
        this.flush();
        this.commandStatus();
        int n3 = this.returnInt();
        if (n3 < 0) {
            throw new SRBException(n3);
        }
    }

    synchronized String srbObjChksum(String string, String string2, int n, String string3) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbObjChksum");
        }
        this.startSRBCommand(2015, 4);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(n);
        this.sendArg(string3);
        this.flush();
        this.commandStatus();
        int n2 = this.readInt();
        if (n2 < 0) {
            throw new SRBException(n2);
        }
        String string4 = "";
        int n3 = 0;
        while (n3 < 8) {
            string4 = string4 + new String(this.read(1));
            ++n3;
        }
        this.read(n2 - 8);
        this.status();
        return string4;
    }

    synchronized void srbModifyUserNonPriv(int n, String string, String string2, String string3, String string4, String string5, String string6, int n2) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbModifyUserNonPriv");
        }
        this.startSRBCommand(2161, 8);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.sendArg(string4);
        this.sendArg(string5);
        this.sendArg(string6);
        this.sendArg(n2);
        this.flush();
        this.commandStatus();
        int n3 = this.returnInt();
        if (n3 < 0) {
            throw new SRBException(n3);
        }
    }

    synchronized void srbModifyResource(int n, String string, String string2, String string3, String string4, String string5, int n2) throws IOException {
        if (DEBUG > 0) {
            System.out.println("\n srbModifyResource");
        }
        this.startSRBCommand(2162, 7);
        this.sendArg(n);
        this.sendArg(string);
        this.sendArg(string2);
        this.sendArg(string3);
        this.sendArg(string4);
        this.sendArg(string5);
        this.sendArg(n2);
        this.flush();
        this.commandStatus();
        int n3 = this.returnInt();
        if (n3 < 0) {
            throw new SRBException(n3);
        }
    }

    static {
        try {
            DEBUG = new Integer(System.getProperty("jargon.debug", "0"));
        }
        catch (NumberFormatException numberFormatException) {
            DEBUG = 0;
        }
        singleServerPort = false;
    }

    class TransferThread
    implements Runnable {
        static final int READ = 1;
        static final int WRITE = 2;
        static final int PUT = 3;
        static final int GET = 4;
        static final int DONE = 0;
        private Socket transferSocket;
        private GeneralRandomAccessFile raf;
        private long srcSize;
        private ServerSocket listener;
        private SRBMetaDataRecordList[] rl;
        private String directoryPath;
        private String sourcePath;
        private ParallelManager syncObject;
        int length;
        int threadID;

        TransferThread(ParallelManager parallelManager, Socket socket, GeneralRandomAccessFile generalRandomAccessFile, long l, ServerSocket serverSocket, int n) {
            this.threadID = n;
            this.transferSocket = socket;
            this.raf = generalRandomAccessFile;
            this.srcSize = l;
            this.listener = serverSocket;
            this.syncObject = parallelManager;
        }

        TransferThread(Socket socket, SRBMetaDataRecordList[] sRBMetaDataRecordListArray, String string, String string2) throws IOException {
            this.transferSocket = socket;
            this.rl = sRBMetaDataRecordListArray;
            this.directoryPath = string;
            this.sourcePath = string2;
            this.srcSize = -1L;
            this.listener = null;
            this.raf = this.correctedRAFPath(0);
            this.length = sRBMetaDataRecordListArray[0].getIntValue(sRBMetaDataRecordListArray[0].getFieldIndex("size"));
        }

        private GeneralRandomAccessFile correctedRAFPath(int n) throws IOException {
            LocalFile localFile;
            String string = this.rl[n].getValue("directory name").toString();
            if (!string.equals(this.sourcePath)) {
                string = string.substring(this.sourcePath.length() + 1);
                localFile = new LocalFile(this.directoryPath, string);
            } else {
                localFile = new LocalFile(this.directoryPath);
            }
            ((GeneralFile)localFile).mkdirs();
            return FileFactory.newRandomAccessFile(FileFactory.newFile(localFile, this.rl[n].getValue("file name").toString()), "rw");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public synchronized void run() {
            try {
                var1_1 = new DataInputStream(this.transferSocket.getInputStream());
                var2_3 = this.transferSocket.getOutputStream();
                var8_4 = null;
                var9_5 = 0;
                var10_6 = 0;
                var11_7 = 1448;
                var3_8 = var1_1.readInt();
                var6_9 = var1_1.readInt();
                var8_4 = new byte[8];
                var1_1.read(var8_4);
                var4_10 = Host.castToUnsignedLong(var8_4);
                if (var4_10 < 0L) {
                    return;
                }
                if (var6_9 <= 0L) {
                    return;
                }
                var8_4 = var6_9 >= 0x7FFFFFFFL ? new byte[0x7FFFFFFE] : new byte[(int)var6_9];
                block9: while (var6_9 > 0L) {
                    switch (var3_8) {
                        case 4: {
                            if (this.listener != null) ** GOTO lbl63
                            var10_6 = 0;
                            if (var6_9 <= (long)var11_7) ** GOTO lbl33
                            while (var6_9 > (long)(var10_6 + var11_7 - 1)) {
                                var10_6 += var1_1.read(var8_4, var10_6, var11_7);
                            }
                            while (var6_9 - (long)var10_6 - 1L > 0L) {
                                var10_6 += var1_1.read(var8_4, var10_6, (int)var6_9 - var10_6);
                            }
                            ** GOTO lbl34
lbl-1000:
                            // 1 sources

                            {
                                var10_6 += var1_1.read(var8_4, var10_6, (int)var6_9 - var10_6);
lbl33:
                                // 2 sources

                                ** while (var6_9 - (long)var10_6 > 0L)
                            }
lbl34:
                            // 2 sources

                            SRBCommands.this.bytesMoved += (long)var10_6;
                            this.raf.seek(var4_10);
                            if (this.length >= var10_6) {
                                this.raf.write(var8_4);
                                this.length -= var10_6;
                            } else {
                                var4_10 = 0L;
                                while (this.length < var10_6) {
                                    this.raf.write(var8_4, (int)var4_10, this.length);
                                    var4_10 += (long)this.length;
                                    var10_6 -= this.length;
                                    if (++var9_5 >= this.rl.length) continue;
                                    this.length = this.rl[var9_5].getIntValue(this.rl[var9_5].getFieldIndex("size"));
                                    this.raf = this.correctedRAFPath(var9_5);
                                }
                                this.raf.write(var8_4, (int)var4_10, var10_6);
                                this.length -= var10_6;
                            }
                            var10_6 = 0;
                            var3_8 = var1_1.readInt();
                            var6_9 = var1_1.readInt();
                            var8_4 = new byte[8];
                            var1_1.read(var8_4);
                            if (var4_10 < 0L || var6_9 <= 0L) continue block9;
                            if (var6_9 >= 0x7FFFFFFFL) {
                                var8_4 = new byte[0x7FFFFFFE];
                                break;
                            }
                            var8_4 = new byte[(int)var6_9];
                            break;
lbl63:
                            // 1 sources

                            var12_11 = this.syncObject;
                            synchronized (var12_11) {
                                var10_6 = 0;
                                if (var6_9 <= (long)var11_7) ** GOTO lbl76
                                while (var6_9 > (long)(var10_6 + var11_7 - 1)) {
                                    var10_6 += var1_1.read(var8_4, var10_6, var11_7);
                                }
                                while (var6_9 - (long)var10_6 - 1L > 0L) {
                                    var10_6 += var1_1.read(var8_4, var10_6, (int)var6_9 - var10_6);
                                }
                                ** GOTO lbl77
lbl-1000:
                                // 1 sources

                                {
                                    var10_6 += var1_1.read(var8_4, var10_6, (int)var6_9 - var10_6);
lbl76:
                                    // 2 sources

                                    ** while (var6_9 - (long)var10_6 > 0L)
                                }
lbl77:
                                // 2 sources

                                SRBCommands.this.bytesMoved += (long)var10_6;
                                var10_6 = 0;
                                if (this.raf.getFilePointer() != var4_10) {
                                    this.raf.seek(var4_10);
                                }
                                if (var6_9 > 0L) {
                                    this.raf.write(var8_4);
                                }
                                var3_8 = var1_1.readInt();
                                var6_9 = var1_1.readInt();
                                var8_4 = new byte[8];
                                var1_1.read(var8_4);
                                var4_10 = Host.castToUnsignedLong(var8_4);
                                if (var4_10 < 0L) {
                                    break;
                                }
                                if (var6_9 <= 0L) {
                                    break;
                                }
                                var8_4 = var6_9 >= 0x7FFFFFFFL ? new byte[0x7FFFFFFE] : new byte[(int)var6_9];
                                break;
                            }
                        }
                        case 3: {
                            this.raf.seek(var4_10);
                            SRBCommands.this.bytesMoved += (long)this.raf.read(var8_4);
                            var2_3.write(var8_4);
                            var3_8 = var1_1.readInt();
                            var6_9 = var1_1.readInt();
                            var8_4 = new byte[8];
                            var1_1.read(var8_4);
                            var4_10 = Host.castToUnsignedLong(var8_4);
                            if (var4_10 < 0L || var6_9 <= 0L || var6_9 == (long)var8_4.length) continue block9;
                            if (var6_9 >= 0x7FFFFFFFL) {
                                var8_4 = new byte[0x7FFFFFFE];
                                break;
                            }
                            var8_4 = new byte[(int)var6_9];
                            break;
                        }
                        default: {
                            var6_9 = 0L;
                        }
                    }
                }
                SRBCommands.this.totalBytesMoved += SRBCommands.this.bytesMoved;
                if (SRBCommands.this.totalBytesMoved >= this.srcSize && this.listener != null) {
                    this.listener.close();
                }
                if (this.syncObject != null) {
                    this.syncObject.threadComplete(this.threadID);
                }
            }
            catch (IOException var1_2) {
                throw new RuntimeException("IOException in thread.", var1_2);
            }
        }
    }

    class ParallelManager
    implements Runnable {
        private ServerSocket listener;
        private short cookie;
        private GeneralRandomAccessFile raf;
        private long srcSize;
        private boolean parallelComplete = false;
        private boolean[] threads = new boolean[5];
        private String mode;

        ParallelManager(ServerSocket serverSocket, short s, GeneralRandomAccessFile generalRandomAccessFile, long l, String string) {
            this.listener = serverSocket;
            this.cookie = s;
            this.raf = generalRandomAccessFile;
            this.srcSize = l;
            this.mode = string;
            SRBCommands.this.bytesMoved = 0L;
        }

        void threadComplete(int n) {
            this.threads[n] = false;
            int n2 = 0;
            while (n2 < this.threads.length) {
                if (this.threads[n2]) {
                    return;
                }
                ++n2;
            }
            this.parallelComplete = true;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            int n = 0;
            boolean bl = false;
            Socket socket = null;
            Object var4_4 = null;
            Thread[] threadArray = new Thread[5];
            try {
                while (!this.parallelComplete) {
                    socket = this.listener.accept();
                    DataInputStream dataInputStream = new DataInputStream(socket.getInputStream());
                    int n2 = dataInputStream.readInt();
                    if (n2 != this.cookie) continue;
                    this.raf = FileFactory.newRandomAccessFile(this.raf.getFile(), this.mode);
                    this.threads[n] = true;
                    TransferThread transferThread = new TransferThread(this, socket, this.raf, this.srcSize, this.listener, n);
                    threadArray[n] = new Thread(transferThread);
                    threadArray[n].start();
                    ++n;
                }
            }
            catch (SocketException socketException) {
                try {
                    n = 0;
                    while (true) {
                        if (n >= threadArray.length) {
                            return;
                        }
                        if (threadArray[n] != null && threadArray[n].isAlive()) {
                            threadArray[n].join();
                        }
                        ++n;
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                    return;
                }
            }
            catch (IOException iOException) {
                throw new RuntimeException("IOException in thread.");
            }
            try {
                n = 0;
                while (true) {
                    if (n >= threadArray.length) {
                        return;
                    }
                    if (threadArray[n] != null && threadArray[n].isAlive()) {
                        threadArray[n].join();
                    }
                    ++n;
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }
    }
}

