/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.community.client.delegate;

import java.net.URL;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.astrogrid.community.common.config.CommunityConfig;
import org.astrogrid.community.common.policy.data.AccountData;
import org.astrogrid.community.common.policy.data.GroupData;
import org.astrogrid.community.common.policy.data.PolicyPermission;
import org.astrogrid.community.common.policy.data.ResourceData;
import org.astrogrid.community.common.policy.manager.PolicyManager;
import org.astrogrid.community.common.policy.manager.PolicyManagerServiceLocator;

public class AdministrationDelegate {
    private static Log log = LogFactory.getLog((Class)AdministrationDelegate.class);
    PolicyManager service = null;
    private static final String REGEX_SECUREPORT = ":\\d+";

    public AdministrationDelegate() {
        try {
            this.service = this.getService(CommunityConfig.getManagerUrl());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.service = null;
        }
    }

    private String getSecureURL() {
        String communitySecurity = CommunityConfig.getProperty((String)"community.security", (String)"on");
        if (communitySecurity == null || !communitySecurity.equals("on")) {
            return CommunityConfig.getManagerUrl();
        }
        String policyURL = CommunityConfig.getProperty((String)"policy.manager.secure.url");
        if (policyURL != null && policyURL.trim().length() > 0) {
            return policyURL;
        }
        policyURL = CommunityConfig.getManagerUrl();
        log.debug((Object)("manager url = " + policyURL));
        String securePort = CommunityConfig.getProperty((String)"community.secure.port");
        log.debug((Object)("the secure port = " + securePort));
        if (securePort == null || securePort.length() <= 0) {
            return null;
        }
        policyURL = policyURL.replaceAll("http", "https");
        Pattern p = Pattern.compile(REGEX_SECUREPORT);
        Matcher m = p.matcher(policyURL);
        policyURL = m.replaceAll(":" + securePort);
        log.debug((Object)("The PolicyURL = " + policyURL));
        return policyURL;
    }

    public PolicyPermission addPermission(String resource, String group, String action) throws Exception {
        return this.service.addPermission(resource, group, action);
    }

    public boolean delPermission(String resource, String group, String action) throws Exception {
        return this.service.delPermission(resource, group, action);
    }

    public boolean addGroupMember(String account, String group) throws Exception {
        return null != this.service.addGroupMember(account, group);
    }

    public boolean delGroupMember(String account, String group) throws Exception {
        return null != this.service.delGroupMember(account, group);
    }

    public AccountData addAccount(String name) throws Exception {
        return this.service.addAccount(name);
    }

    public boolean delAccount(String name) throws Exception {
        return null != this.service.delAccount(name);
    }

    public AccountData getAccount(String name) throws Exception {
        return this.service.getAccount(name);
    }

    public ArrayList getAccountList() throws Exception {
        return this.createArrayList(this.service.getLocalAccounts());
    }

    private ArrayList createArrayList(Object[] list) {
        ArrayList<Object> al = null;
        if (list != null && list.length > 0) {
            al = new ArrayList<Object>(list.length);
            for (int i = 0; i < list.length; ++i) {
                al.add(list[i]);
            }
        }
        return al;
    }

    public AccountData setAccount(AccountData ad) throws Exception {
        String policyURL = this.getSecureURL();
        if (policyURL == null) {
            throw new Exception("A Secure ssl connection is required for updating an account, and cannot be found.");
        }
        PolicyManager secureService = this.getService(policyURL);
        return secureService.setAccount(ad);
    }

    public ResourceData addResource(String name) throws Exception {
        return this.service.addResource();
    }

    public ResourceData delResource(String name) throws Exception {
        return this.service.delResource(name);
    }

    public ResourceData getResource(String name) throws Exception {
        return this.service.getResource(name);
    }

    public ArrayList getResourceList() throws Exception {
        return new ArrayList();
    }

    public ResourceData setResource(ResourceData ad) throws Exception {
        return this.service.setResource(ad);
    }

    public ArrayList getGroupList() throws Exception {
        return this.createArrayList(this.service.getLocalGroups());
    }

    public boolean delGroup(String ident) throws Exception {
        return null != this.service.delGroup(ident);
    }

    public GroupData addGroup(String ident) throws Exception {
        return this.service.addGroup(ident);
    }

    public GroupData getGroup(String ident) throws Exception {
        return this.service.getGroup(ident);
    }

    public GroupData setGroup(GroupData groupData) throws Exception {
        return this.service.setGroup(groupData);
    }

    public ArrayList getGroupMembers(String group) throws Exception {
        return this.createArrayList(this.service.getGroupMembers(group));
    }

    private PolicyManager getService(String targetEndPoint) throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"setUp()");
        PolicyManagerServiceLocator locator = null;
        PolicyManager service = null;
        locator = new PolicyManagerServiceLocator();
        service = locator.getPolicyManager(new URL(targetEndPoint));
        log.debug((Object)"----\"----");
        log.debug((Object)"");
        return service;
    }

    static {
        CommunityConfig.loadConfig();
    }
}

