/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.community.client.delegate;

import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.astrogrid.community.common.config.CommunityConfig;
import org.astrogrid.community.common.policy.data.PolicyCredentials;
import org.astrogrid.community.common.policy.data.PolicyPermission;
import org.astrogrid.community.common.policy.service.PolicyService;
import org.astrogrid.community.common.policy.service.PolicyServiceServiceLocator;

public class PolicyServiceDelegate {
    private static Log log = LogFactory.getLog((Class)PolicyServiceDelegate.class);
    private PolicyService service = null;
    PolicyPermission perm = null;

    public PolicyServiceDelegate() {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"PolicyServiceDelegate()");
        try {
            this.service = this.getService(CommunityConfig.getServiceUrl());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.service = null;
        }
        log.debug((Object)"----\"----");
        log.debug((Object)"");
    }

    public boolean checkPermissions(String account, String group, String resource, String action) throws Exception {
        return this.checkPermissions(new PolicyCredentials(account, group), resource, action);
    }

    public boolean checkPermissions(PolicyCredentials credentials, String resource, String action) throws Exception {
        this.perm = null;
        if (null != this.service) {
            this.perm = this.service.checkPermissions(credentials, resource, action);
        }
        return null != this.perm ? this.perm.isValid() : false;
    }

    public PolicyPermission getPolicyPermission() {
        return this.perm;
    }

    private PolicyService getService(String targetEndPoint) throws Exception {
        log.debug((Object)"");
        log.debug((Object)"----\"----");
        log.debug((Object)"setUp()");
        log.debug((Object)("  Target : '" + targetEndPoint + "'"));
        if (null == targetEndPoint || targetEndPoint.length() <= 0) {
            targetEndPoint = CommunityConfig.getServiceUrl();
        }
        log.debug((Object)("  Target : '" + targetEndPoint + "'"));
        PolicyServiceServiceLocator locator = null;
        PolicyService service = null;
        locator = new PolicyServiceServiceLocator();
        service = locator.getPolicyService(new URL(targetEndPoint));
        log.debug((Object)"----\"----");
        log.debug((Object)"");
        return service;
    }

    static {
        CommunityConfig.loadConfig();
    }
}

