/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.community.client.policy.manager;

import java.rmi.RemoteException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.astrogrid.community.client.policy.manager.PolicyManagerDelegate;
import org.astrogrid.community.client.service.CommunityServiceCoreDelegate;
import org.astrogrid.community.common.exception.CommunityIdentifierException;
import org.astrogrid.community.common.exception.CommunityPolicyException;
import org.astrogrid.community.common.exception.CommunityResourceException;
import org.astrogrid.community.common.exception.CommunityServiceException;
import org.astrogrid.community.common.policy.data.AccountData;
import org.astrogrid.community.common.policy.data.GroupData;
import org.astrogrid.community.common.policy.data.GroupMemberData;
import org.astrogrid.community.common.policy.data.PolicyPermission;
import org.astrogrid.community.common.policy.data.ResourceData;
import org.astrogrid.community.common.policy.manager.PolicyManager;
import org.astrogrid.community.common.service.CommunityService;

public class PolicyManagerCoreDelegate
extends CommunityServiceCoreDelegate
implements PolicyManager,
PolicyManagerDelegate {
    private static Log log = LogFactory.getLog((Class)PolicyManagerCoreDelegate.class);
    private PolicyManager manager = null;

    protected PolicyManagerCoreDelegate() {
    }

    protected PolicyManager getPolicyManager() {
        return this.manager;
    }

    protected void setPolicyManager(PolicyManager manager) {
        this.setCommunityService((CommunityService)manager);
        this.manager = manager;
    }

    public AccountData addAccount(String ident) throws CommunityServiceException, CommunityIdentifierException, CommunityPolicyException {
        if (null != this.manager) {
            try {
                return this.manager.addAccount(ident);
            }
            catch (RemoteException ouch) {
                this.policyException(ouch);
                this.serviceException(ouch);
                this.identifierException(ouch);
                throw new CommunityServiceException("WebService call failed - " + ouch, (Throwable)ouch);
            }
        }
        throw new CommunityServiceException("Service not initialised");
    }

    public AccountData addAccount(AccountData account) throws CommunityServiceException, CommunityIdentifierException, CommunityPolicyException {
        if (null != this.manager) {
            try {
                return this.manager.addAccount(account);
            }
            catch (RemoteException ouch) {
                this.policyException(ouch);
                this.serviceException(ouch);
                this.identifierException(ouch);
                throw new CommunityServiceException("WebService call failed - " + ouch, (Throwable)ouch);
            }
        }
        throw new CommunityServiceException("Service not initialised");
    }

    public AccountData getAccount(String ident) throws CommunityServiceException, CommunityIdentifierException, CommunityPolicyException {
        if (null != this.manager) {
            try {
                return this.manager.getAccount(ident);
            }
            catch (RemoteException ouch) {
                this.policyException(ouch);
                this.serviceException(ouch);
                this.identifierException(ouch);
                throw new CommunityServiceException("WebService call failed - " + ouch, (Throwable)ouch);
            }
        }
        throw new CommunityServiceException("Service not initialised");
    }

    public AccountData setAccount(AccountData account) throws CommunityServiceException, CommunityIdentifierException, CommunityPolicyException {
        if (null != this.manager) {
            try {
                return this.manager.setAccount(account);
            }
            catch (RemoteException ouch) {
                this.policyException(ouch);
                this.serviceException(ouch);
                this.identifierException(ouch);
                throw new CommunityServiceException("WebService call failed - " + ouch, (Throwable)ouch);
            }
        }
        throw new CommunityServiceException("Service not initialised");
    }

    public AccountData delAccount(String ident) throws CommunityServiceException, CommunityIdentifierException, CommunityPolicyException {
        if (null != this.manager) {
            try {
                return this.manager.delAccount(ident);
            }
            catch (RemoteException ouch) {
                this.policyException(ouch);
                this.serviceException(ouch);
                this.identifierException(ouch);
                throw new CommunityServiceException("WebService call failed - " + ouch, (Throwable)ouch);
            }
        }
        throw new CommunityServiceException("Service not initialised");
    }

    public Object[] getLocalAccounts() throws CommunityServiceException {
        if (null != this.manager) {
            try {
                return this.manager.getLocalAccounts();
            }
            catch (RemoteException ouch) {
                this.serviceException(ouch);
                throw new CommunityServiceException("WebService call failed - " + ouch, (Throwable)ouch);
            }
        }
        throw new CommunityServiceException("Service not initialised");
    }

    public GroupData addGroup(String ident) throws CommunityServiceException, CommunityIdentifierException, CommunityPolicyException {
        if (null != this.manager) {
            try {
                return this.manager.addGroup(ident);
            }
            catch (RemoteException ouch) {
                this.policyException(ouch);
                this.serviceException(ouch);
                this.identifierException(ouch);
                throw new CommunityServiceException("WebService call failed - " + ouch, (Throwable)ouch);
            }
        }
        throw new CommunityServiceException("Service not initialised");
    }

    public GroupData addGroup(GroupData data) throws CommunityServiceException, CommunityIdentifierException, CommunityPolicyException {
        if (null != this.manager) {
            try {
                return this.manager.addGroup(data);
            }
            catch (RemoteException ouch) {
                this.policyException(ouch);
                this.serviceException(ouch);
                this.identifierException(ouch);
                throw new CommunityServiceException("WebService call failed - " + ouch, (Throwable)ouch);
            }
        }
        throw new CommunityServiceException("Service not initialised");
    }

    public GroupData getGroup(String ident) throws CommunityServiceException, CommunityIdentifierException, CommunityPolicyException {
        if (null != this.manager) {
            try {
                return this.manager.getGroup(ident);
            }
            catch (RemoteException ouch) {
                this.policyException(ouch);
                this.serviceException(ouch);
                this.identifierException(ouch);
                throw new CommunityServiceException("WebService call failed - " + ouch, (Throwable)ouch);
            }
        }
        throw new CommunityServiceException("Service not initialised");
    }

    public GroupData setGroup(GroupData data) throws CommunityServiceException, CommunityIdentifierException, CommunityPolicyException {
        if (null != this.manager) {
            try {
                return this.manager.setGroup(data);
            }
            catch (RemoteException ouch) {
                this.policyException(ouch);
                this.serviceException(ouch);
                this.identifierException(ouch);
                throw new CommunityServiceException("WebService call failed - " + ouch, (Throwable)ouch);
            }
        }
        throw new CommunityServiceException("Service not initialised");
    }

    public GroupData delGroup(String ident) throws CommunityServiceException, CommunityIdentifierException, CommunityPolicyException {
        if (null != this.manager) {
            try {
                return this.manager.delGroup(ident);
            }
            catch (RemoteException ouch) {
                this.policyException(ouch);
                this.serviceException(ouch);
                this.identifierException(ouch);
                throw new CommunityServiceException("WebService call failed - " + ouch, (Throwable)ouch);
            }
        }
        throw new CommunityServiceException("Service not initialised");
    }

    public Object[] getLocalGroups() throws CommunityServiceException {
        if (null != this.manager) {
            try {
                return this.manager.getLocalGroups();
            }
            catch (RemoteException ouch) {
                this.serviceException(ouch);
                throw new CommunityServiceException("WebService call failed - " + ouch, (Throwable)ouch);
            }
        }
        throw new CommunityServiceException("Service not initialised");
    }

    public Object[] getLocalAccountGroups(String account) throws CommunityServiceException, CommunityIdentifierException {
        if (null != this.manager) {
            try {
                return this.manager.getLocalAccountGroups(account);
            }
            catch (RemoteException ouch) {
                this.serviceException(ouch);
                this.identifierException(ouch);
                throw new CommunityServiceException("WebService call failed - " + ouch, (Throwable)ouch);
            }
        }
        throw new CommunityServiceException("Service not initialised");
    }

    public ResourceData addResource() throws CommunityServiceException {
        if (null != this.manager) {
            try {
                return this.manager.addResource();
            }
            catch (RemoteException ouch) {
                this.serviceException(ouch);
                throw new CommunityServiceException("WebService call failed - " + ouch, (Throwable)ouch);
            }
        }
        throw new CommunityServiceException("Service not initialised");
    }

    public ResourceData getResource(String ident) throws CommunityIdentifierException, CommunityResourceException, CommunityServiceException {
        if (null != this.manager) {
            try {
                return this.manager.getResource(ident);
            }
            catch (RemoteException ouch) {
                this.serviceException(ouch);
                this.resourceException(ouch);
                this.identifierException(ouch);
                throw new CommunityServiceException("WebService call failed - " + ouch, (Throwable)ouch);
            }
        }
        throw new CommunityServiceException("Service not initialised");
    }

    public ResourceData setResource(ResourceData resource) throws CommunityIdentifierException, CommunityResourceException, CommunityServiceException {
        if (null != this.manager) {
            try {
                return this.manager.setResource(resource);
            }
            catch (RemoteException ouch) {
                this.serviceException(ouch);
                this.resourceException(ouch);
                this.identifierException(ouch);
                throw new CommunityServiceException("WebService call failed - " + ouch, (Throwable)ouch);
            }
        }
        throw new CommunityServiceException("Service not initialised");
    }

    public ResourceData delResource(String ident) throws CommunityIdentifierException, CommunityResourceException, CommunityServiceException {
        if (null != this.manager) {
            try {
                return this.manager.delResource(ident);
            }
            catch (RemoteException ouch) {
                this.serviceException(ouch);
                this.resourceException(ouch);
                this.identifierException(ouch);
                throw new CommunityServiceException("WebService call failed - " + ouch, (Throwable)ouch);
            }
        }
        throw new CommunityServiceException("Service not initialised");
    }

    public PolicyPermission addPermission(String resource, String group, String action) throws CommunityServiceException, CommunityIdentifierException, CommunityPolicyException {
        PolicyPermission result = null;
        if (null != this.manager) {
            try {
                result = this.manager.addPermission(resource, group, action);
            }
            catch (RemoteException ouch) {
                // empty catch block
            }
        }
        return result;
    }

    public PolicyPermission getPermission(String resource, String group, String action) {
        PolicyPermission result = null;
        if (null != this.manager) {
            try {
                result = this.manager.getPermission(resource, group, action);
            }
            catch (RemoteException ouch) {
                // empty catch block
            }
        }
        return result;
    }

    public PolicyPermission setPermission(PolicyPermission permission) {
        PolicyPermission result = null;
        if (null != this.manager) {
            try {
                result = this.manager.setPermission(permission);
            }
            catch (RemoteException remoteException) {
                // empty catch block
            }
        }
        return result;
    }

    public boolean delPermission(String resource, String group, String action) throws CommunityServiceException, CommunityIdentifierException, CommunityPolicyException {
        boolean result = false;
        if (null != this.manager) {
            try {
                result = this.manager.delPermission(resource, group, action);
            }
            catch (RemoteException ouch) {
                // empty catch block
            }
        }
        return result;
    }

    public GroupMemberData addGroupMember(String account, String group) throws CommunityServiceException, CommunityIdentifierException, CommunityPolicyException {
        if (null != this.manager) {
            try {
                return this.manager.addGroupMember(account, group);
            }
            catch (RemoteException ouch) {
                this.policyException(ouch);
                this.serviceException(ouch);
                this.identifierException(ouch);
                throw new CommunityServiceException("WebService call failed - " + ouch, (Throwable)ouch);
            }
        }
        throw new CommunityServiceException("Service not initialised");
    }

    public GroupMemberData delGroupMember(String account, String group) throws CommunityServiceException, CommunityPolicyException, CommunityIdentifierException {
        if (null != this.manager) {
            try {
                return this.manager.delGroupMember(account, group);
            }
            catch (RemoteException ouch) {
                this.policyException(ouch);
                this.serviceException(ouch);
                this.identifierException(ouch);
                throw new CommunityServiceException("WebService call failed - " + ouch, (Throwable)ouch);
            }
        }
        throw new CommunityServiceException("Service not initialised");
    }

    public Object[] getGroupMembers(String group) throws CommunityServiceException, CommunityPolicyException, CommunityIdentifierException {
        if (null != this.manager) {
            try {
                return this.manager.getGroupMembers(group);
            }
            catch (RemoteException ouch) {
                this.policyException(ouch);
                this.serviceException(ouch);
                this.identifierException(ouch);
                throw new CommunityServiceException("WebService call failed - " + ouch, (Throwable)ouch);
            }
        }
        throw new CommunityServiceException("Service not initialised");
    }
}

