/*
 * Decompiled with CFR 0.152.
 */
package org.astrogrid.community.client.security.service;

import java.rmi.RemoteException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.astrogrid.community.client.security.service.SecurityServiceDelegate;
import org.astrogrid.community.client.service.CommunityServiceCoreDelegate;
import org.astrogrid.community.common.exception.CommunityIdentifierException;
import org.astrogrid.community.common.exception.CommunitySecurityException;
import org.astrogrid.community.common.exception.CommunityServiceException;
import org.astrogrid.community.common.security.data.SecurityToken;
import org.astrogrid.community.common.security.service.SecurityService;
import org.astrogrid.community.common.service.CommunityService;

public class SecurityServiceCoreDelegate
extends CommunityServiceCoreDelegate
implements SecurityService,
SecurityServiceDelegate {
    private static Log log = LogFactory.getLog((Class)SecurityServiceCoreDelegate.class);
    private SecurityService service = null;

    protected SecurityService getSecurityService() {
        return this.service;
    }

    protected void setSecurityService(SecurityService service) {
        this.setCommunityService((CommunityService)service);
        this.service = service;
    }

    public SecurityToken checkPassword(String account, String pass) throws CommunityServiceException, CommunitySecurityException, CommunityIdentifierException {
        if (null != this.service) {
            try {
                return this.service.checkPassword(account, pass);
            }
            catch (RemoteException ouch) {
                this.serviceException(ouch);
                this.securityException(ouch);
                this.identifierException(ouch);
                throw new CommunityServiceException("WebService call failed - " + ouch, (Throwable)ouch);
            }
        }
        throw new CommunityServiceException("Service not initialised");
    }

    public SecurityToken checkToken(SecurityToken token) throws CommunityServiceException, CommunitySecurityException, CommunityIdentifierException {
        if (null != this.service) {
            try {
                return this.service.checkToken(token);
            }
            catch (RemoteException ouch) {
                token.setStatus(0);
                this.serviceException(ouch);
                this.securityException(ouch);
                this.identifierException(ouch);
                throw new CommunityServiceException("WebService call failed - " + ouch, (Throwable)ouch);
            }
        }
        throw new CommunityServiceException("Service not initialised");
    }

    public Object[] splitToken(SecurityToken token, int count) throws CommunityServiceException, CommunitySecurityException, CommunityIdentifierException {
        if (null != this.service) {
            try {
                return this.service.splitToken(token, count);
            }
            catch (RemoteException ouch) {
                this.serviceException(ouch);
                this.securityException(ouch);
                this.identifierException(ouch);
                throw new CommunityServiceException("WebService call failed - " + ouch, (Throwable)ouch);
            }
        }
        throw new CommunityServiceException("Service not initialised");
    }
}

