/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.hds;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import uk.ac.starlink.array.AccessMode;
import uk.ac.starlink.array.ArrayBuilder;
import uk.ac.starlink.array.ArrayImpl;
import uk.ac.starlink.array.BadHandler;
import uk.ac.starlink.array.BridgeNDArray;
import uk.ac.starlink.array.NDArray;
import uk.ac.starlink.array.NDShape;
import uk.ac.starlink.array.Type;
import uk.ac.starlink.hds.ArrayStructure;
import uk.ac.starlink.hds.HDSArrayImpl;
import uk.ac.starlink.hds.HDSException;
import uk.ac.starlink.hds.HDSObject;
import uk.ac.starlink.hds.HDSPackage;
import uk.ac.starlink.hds.HDSReference;
import uk.ac.starlink.hds.HDSType;
import uk.ac.starlink.hds.LocalHDS;

public class HDSArrayBuilder
implements ArrayBuilder {
    private static HDSArrayBuilder instance = new HDSArrayBuilder();

    private HDSArrayBuilder() {
    }

    public static HDSArrayBuilder getInstance() {
        if (HDSPackage.isAvailable()) {
            return instance;
        }
        throw new LinkageError("Native code for the JNIHDS package is not installed");
    }

    public NDArray makeNDArray(URL url, AccessMode mode) throws IOException {
        LocalHDS lobj = LocalHDS.getReadableHDS(url);
        if (lobj == null) {
            return null;
        }
        HDSReference href = lobj.getHDSReference();
        final File file = href.getContainerFile();
        final boolean isTemp = lobj.isTemporary();
        try {
            HDSObject aryObj = href.getObject(HDSReference.hdsMode(mode));
            ArrayStructure ary = new ArrayStructure(aryObj);
            HDSArrayImpl impl = new HDSArrayImpl(ary, mode){

                public void close() throws IOException {
                    super.close();
                    if (isTemp) {
                        file.delete();
                    }
                }
            };
            aryObj.datAnnul();
            return new BridgeNDArray((ArrayImpl)impl, url);
        }
        catch (HDSException e) {
            if (isTemp) {
                file.delete();
            }
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    public NDArray makeNDArray(ArrayStructure ary, AccessMode mode) throws HDSException {
        return new BridgeNDArray((ArrayImpl)new HDSArrayImpl(ary, mode));
    }

    public NDArray makeNewNDArray(URL url, NDShape shape, Type type, BadHandler bh) throws IOException {
        try {
            LocalHDS lobj = LocalHDS.getNewHDS(url, "ARRAY");
            if (lobj == null) {
                return null;
            }
            HDSReference href = lobj.getHDSReference();
            HDSObject aryObj = href.getObject("WRITE");
            HDSType htype = HDSType.fromJavaType(type);
            ArrayStructure ary = new ArrayStructure(aryObj, shape, htype);
            HDSArrayImpl impl = new HDSArrayImpl(ary, AccessMode.WRITE);
            aryObj.datAnnul();
            return new BridgeNDArray((ArrayImpl)impl, url);
        }
        catch (HDSException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }
}

