/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.hds;

import java.io.IOException;
import java.nio.Buffer;
import uk.ac.starlink.array.AccessMode;
import uk.ac.starlink.array.NioArrayImpl;
import uk.ac.starlink.array.Type;
import uk.ac.starlink.hds.ArrayStructure;
import uk.ac.starlink.hds.HDSException;
import uk.ac.starlink.hds.HDSObject;
import uk.ac.starlink.hds.HDSType;

class HDSArrayImpl
extends NioArrayImpl {
    private HDSObject aryobj;

    public HDSArrayImpl(ArrayStructure ary, AccessMode mode) throws HDSException {
        this(ary, ary.getType().getJavaType(), mode);
    }

    public HDSArrayImpl(ArrayStructure ary, Type mapType, AccessMode mode) throws HDSException {
        this(ary, mapType, HDSType.fromJavaType(mapType), mode);
    }

    private HDSArrayImpl(ArrayStructure ary, Type mapType, HDSType hType, AccessMode mode) throws HDSException {
        super((NioArrayImpl.BufferGetter)new BufGet(ary.getData(), hType, mode), ary.getShape(), mapType, hType.getBadValue());
        this.aryobj = ary.getHDSObject().datClone();
        this.aryobj.datPrmry(true);
    }

    public void close() throws IOException {
        super.close();
        try {
            if (this.aryobj.datValid()) {
                this.aryobj.datAnnul();
            }
        }
        catch (HDSException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    private static class BufGet
    implements NioArrayImpl.BufferGetter {
        private final HDSObject hobj;
        private final HDSType htype;
        private final String mode;
        private final boolean readonly;

        public BufGet(HDSObject hobj, HDSType htype, AccessMode mode) {
            this.hobj = hobj;
            this.htype = htype;
            if (mode == AccessMode.READ) {
                this.readonly = true;
                this.mode = "READ";
            } else if (mode == AccessMode.UPDATE) {
                this.readonly = false;
                this.mode = "UPDATE";
            } else if (mode == AccessMode.WRITE) {
                this.readonly = false;
                this.mode = "WRITE/BAD";
            } else {
                throw new AssertionError();
            }
        }

        public Buffer getBuffer() throws IOException {
            try {
                return this.hobj.datMapv(this.htype.getName(), this.mode);
            }
            catch (HDSException e) {
                throw (IOException)new IOException(e.getMessage()).initCause(e);
            }
        }

        public void releaseBuffer() throws IOException {
            try {
                this.hobj.datUnmap();
            }
            catch (HDSException e) {
                throw (IOException)new IOException(e.getMessage()).initCause(e);
            }
        }

        public boolean isReadOnly() {
            return this.readonly;
        }
    }
}

