/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.hds;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.StringTokenizer;
import uk.ac.starlink.array.AccessMode;
import uk.ac.starlink.hds.HDSException;
import uk.ac.starlink.hds.HDSObject;

public class HDSReference
implements Cloneable {
    private File containerFile;
    private String containerName;
    private ArrayList pathList = new ArrayList();

    public HDSReference(File container) {
        this.setContainerFile(container);
    }

    private void setContainerFile(File container) {
        this.containerFile = container;
        String cf = this.containerFile.toString();
        String exten = cf.substring(cf.length() - 4);
        if (!exten.equalsIgnoreCase(".sdf")) {
            throw new IllegalArgumentException("HDS filename does not end in \".sdf\"");
        }
        String cname = this.containerFile.getAbsolutePath();
        this.containerName = cname.substring(0, cname.length() - 4);
    }

    public HDSReference(File container, String[] path) {
        this.setContainerFile(container);
        int i = 0;
        while (i < path.length) {
            this.push(path[i]);
            ++i;
        }
    }

    public HDSReference(File container, String path) {
        this.setContainerFile(container);
        if (path != null) {
            StringTokenizer st = new StringTokenizer(path, ".");
            while (st.hasMoreTokens()) {
                this.push(st.nextToken());
            }
        }
    }

    public HDSReference(String path) {
        boolean found = false;
        int lastSlash = path.lastIndexOf(File.pathSeparatorChar);
        int pos = path.length();
        while (pos > lastSlash + 1) {
            File file = new File(path.substring(0, pos) + ".sdf");
            if (file.exists()) {
                this.setContainerFile(file);
                String subPath = path.substring(pos);
                StringTokenizer st = new StringTokenizer(subPath, ".");
                while (st.hasMoreTokens()) {
                    this.push(st.nextToken());
                }
                found = true;
            }
            pos = path.lastIndexOf(46, pos - 1);
        }
        if (!found) {
            int nextDot = path.indexOf(46, lastSlash + 1);
            if (nextDot > 0) {
                File file = new File(path.substring(0, nextDot) + ".sdf");
                this.setContainerFile(file);
                String subPath = path.substring(nextDot);
                StringTokenizer st = new StringTokenizer(subPath, ".");
                while (st.hasMoreTokens()) {
                    this.push(st.nextToken());
                }
            } else {
                throw new IllegalArgumentException("Cannot parse HDS path \"" + path + '\"');
            }
        }
    }

    public HDSReference(URL url) {
        this(HDSReference.getFileFromURL(url), url.getRef());
    }

    private static File getFileFromURL(URL url) {
        String protocol = url.getProtocol();
        if (protocol.equals("file")) {
            String fileName = url.getFile();
            fileName = fileName.replaceAll("%20", " ");
            return new File(fileName);
        }
        throw new UnsupportedOperationException("URL protocol '" + protocol + "' not supported");
    }

    public HDSReference(HDSObject hobj) throws HDSException {
        String[] trace = new String[2];
        hobj.hdsTrace(trace);
        String path = trace[0];
        String file = trace[1];
        this.setContainerFile(new File(file));
        StringTokenizer st = new StringTokenizer(path, ".");
        if (st.hasMoreTokens()) {
            st.nextToken();
        }
        while (st.hasMoreTokens()) {
            this.push(st.nextToken());
        }
    }

    public File getContainerFile() {
        return this.containerFile;
    }

    public String getContainerName() {
        return this.containerName;
    }

    public String[] getPath() {
        return this.pathList.toArray(new String[0]);
    }

    public URL getURL() {
        URL url;
        StringBuffer frag = new StringBuffer();
        int i = 0;
        while (i < this.pathList.size()) {
            frag.append(i > 0 ? "." : "").append((String)this.pathList.get(i));
            ++i;
        }
        try {
            url = this.containerFile.toURL();
            url = new URL(url, "#" + frag.toString());
        }
        catch (MalformedURLException e) {
            throw new AssertionError((Object)("Unexpected malformed URL for " + this));
        }
        return url;
    }

    public HDSObject getObject(String accessMode) throws HDSException {
        HDSObject cntnr = HDSObject.hdsOpen(this.containerName, accessMode);
        HDSObject e1 = cntnr.datClone();
        e1.datPrmry(false);
        int i = 0;
        while (i < this.pathList.size()) {
            HDSObject e2;
            e1 = e2 = e1.datFind((String)this.pathList.get(i));
            ++i;
        }
        e1.datPrmry(true);
        return e1;
    }

    public String toString() {
        StringBuffer s = new StringBuffer(this.containerName);
        int i = 0;
        while (i < this.pathList.size()) {
            s.append(".").append(this.pathList.get(i));
            ++i;
        }
        return s.toString();
    }

    public void push(String pathEl) {
        this.pathList.add(pathEl);
    }

    public String pop() {
        return (String)this.pathList.remove(this.pathList.size() - 1);
    }

    public Object clone() {
        try {
            HDSReference copy = (HDSReference)super.clone();
            copy.pathList = (ArrayList)this.pathList.clone();
            return copy;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }

    static String hdsMode(AccessMode mode) {
        if (mode == AccessMode.READ) {
            return "READ";
        }
        if (mode == AccessMode.WRITE) {
            return "WRITE";
        }
        if (mode == AccessMode.UPDATE) {
            return "UPDATE";
        }
        return null;
    }
}

