/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.hds;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import uk.ac.starlink.hds.HDSException;
import uk.ac.starlink.hds.HDSObject;
import uk.ac.starlink.hds.HDSReference;

class LocalHDS {
    private final URL container;
    private final String[] hdsPath;
    private HDSReference href;
    private boolean isTemporary;

    private LocalHDS(URL url) {
        String frag = url.getRef();
        if (frag == null) {
            this.container = url;
            this.hdsPath = new String[0];
        } else {
            String base = url.toExternalForm();
            try {
                this.container = new URL(base.substring(0, base.indexOf(35)));
            }
            catch (MalformedURLException e) {
                throw new AssertionError((Object)e);
            }
            StringTokenizer st = new StringTokenizer(frag, ".");
            this.hdsPath = new String[st.countTokens()];
            int i = 0;
            while (i < this.hdsPath.length) {
                this.hdsPath[i] = st.nextToken();
                ++i;
            }
        }
    }

    public HDSReference getHDSReference() {
        return this.href;
    }

    public boolean isTemporary() {
        return this.isTemporary;
    }

    public static LocalHDS getReadableHDS(URL url) throws IOException {
        if (!url.getPath().endsWith(".sdf")) {
            return null;
        }
        LocalHDS lobj = new LocalHDS(url);
        if (lobj.container.getProtocol().equals("file")) {
            boolean isTemp = false;
            String fileName = lobj.container.getPath();
            File file = new File(fileName = fileName.replaceAll("%20", " "));
            if (!file.exists()) {
                throw new FileNotFoundException("No such file '" + file + "'");
            }
            if (!file.canRead()) {
                throw new IOException("File not readable '" + file + "'");
            }
            lobj.href = new HDSReference(new File(file.getAbsolutePath()), lobj.hdsPath);
            lobj.isTemporary = false;
            return lobj;
        }
        File file = null;
        try {
            file = File.createTempFile("HDS", ".sdf");
            file.deleteOnExit();
            LocalHDS.copyStreams(lobj.container.openStream(), new FileOutputStream(file));
        }
        catch (IOException e) {
            if (file != null) {
                file.delete();
            }
            throw e;
        }
        lobj.href = new HDSReference(new File(file.getAbsolutePath()), lobj.hdsPath);
        lobj.isTemporary = true;
        return lobj;
    }

    public static LocalHDS getNewHDS(URL url, String type) throws HDSException, IOException {
        if (!url.getPath().endsWith(".sdf")) {
            return null;
        }
        LocalHDS lobj = new LocalHDS(url);
        lobj.isTemporary = false;
        if (!lobj.container.getProtocol().equals("file")) {
            throw new UnsupportedOperationException("Remote writable HDS files not yet supported");
        }
        File file = new File(lobj.container.getPath());
        if (lobj.hdsPath.length == 0) {
            if (file.exists()) {
                file.delete();
            }
            String cname = file.getName();
            cname = cname.substring(0, Math.min(cname.length() - 4, HDSObject.DAT__SZNAM));
            HDSObject newobj = HDSObject.hdsNew(file.getPath(), cname, type, new long[0]);
            lobj.href = new HDSReference(newobj);
            return lobj;
        }
        HDSReference href = new HDSReference(file, lobj.hdsPath);
        href.pop();
        HDSObject parent = href.getObject("WRITE");
        String newName = lobj.hdsPath[lobj.hdsPath.length - 1];
        if (parent.datThere(newName)) {
            parent.datErase(newName);
        }
        parent.datNew(newName, type, new long[0]);
        lobj.href = href;
        return lobj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private static void copyStreams(InputStream istrm, OutputStream ostrm) throws IOException {
        try {
            int b;
            if (!(istrm instanceof BufferedInputStream)) {
                istrm = new BufferedInputStream(istrm);
            }
            if (!(ostrm instanceof BufferedOutputStream)) {
                ostrm = new BufferedOutputStream(ostrm);
            }
            while ((b = istrm.read()) >= 0) {
                void var2_2;
                ostrm.write((int)var2_2);
            }
            ostrm.flush();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            istrm.close();
            ostrm.close();
            throw throwable;
        }
        istrm.close();
        ostrm.close();
    }
}

