/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.sog;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class ExceptionDialog {
    private JPanel messagesArea = null;
    private JLabel message = null;
    private JTextArea textArea = null;
    private JButton details = null;
    private JScrollPane scrollPane = null;
    private JPanel dummyPanel = null;

    public ExceptionDialog(Component parent, Exception e) {
        this.initUI();
        this.makeReports(e);
        Object[] options = new Object[]{"OK", "Show details"};
        final JOptionPane pane = new JOptionPane(this.messagesArea, 0, 0, null, options, null);
        final JDialog dialog = pane.createDialog(parent, "Error");
        dialog.setResizable(true);
        pane.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                block7: {
                    Object selected;
                    block8: {
                        String prop = e.getPropertyName();
                        if (e.getSource() != pane) break block7;
                        if (prop.equals("value")) break block8;
                        if (!prop.equals("inputValue")) break block7;
                    }
                    if ((selected = e.getNewValue()) instanceof String) {
                        if (((String)selected).equals("OK")) {
                            dialog.dispose();
                        } else {
                            ExceptionDialog.this.showDetails();
                            dialog.setVisible(true);
                        }
                    } else {
                        ExceptionDialog.this.showDetails();
                        dialog.setVisible(true);
                    }
                }
            }
        });
        dialog.show();
        dialog.dispose();
    }

    protected void initUI() {
        this.messagesArea = new JPanel(new BorderLayout());
        this.message = new JLabel();
        this.textArea = new JTextArea(4, 40);
        this.textArea.setEditable(false);
        this.scrollPane = new JScrollPane(this.textArea);
        this.dummyPanel = new JPanel();
        this.dummyPanel.setPreferredSize(new Dimension(100, 50));
        this.messagesArea.add((Component)this.message, "North");
        this.messagesArea.add((Component)this.dummyPanel, "Center");
    }

    protected void makeReports(Exception e) {
        this.message.setText(e.getMessage());
        this.textArea.setText(e.getMessage() + "\n");
        StackTraceElement[] elements = e.getStackTrace();
        int i = 0;
        while (i < elements.length) {
            this.textArea.append(elements[i].toString() + "\n");
            ++i;
        }
        this.textArea.setCaretPosition(0);
    }

    protected void showDetails() {
        this.messagesArea.remove(this.dummyPanel);
        this.messagesArea.add((Component)this.scrollPane, "Center");
    }

    public static void main(String[] args) {
        Exception e = new Exception("An exception");
        ExceptionDialog exceptionDialog = new ExceptionDialog(null, e);
    }
}

