/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.sog.photom;

import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.Ellipse2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;

public class AnnulusArea
implements Shape {
    private Ellipse2D.Double aperture = new Ellipse2D.Double();
    private Ellipse2D.Double inner = new Ellipse2D.Double();
    private Ellipse2D.Double outer = new Ellipse2D.Double();
    private Area mainArea = new Area();
    private double innerscale = 2.0;
    private double outerscale = 3.0;
    private boolean invert = false;
    private double[] srcPts = new double[4];
    private double[] dstPts = new double[4];

    public AnnulusArea(double radius) {
        this.setRadius(radius);
    }

    public AnnulusArea(double radius, double xcentre, double ycentre, double innerscale, double outerscale) {
        this.setValues(radius, xcentre, ycentre, innerscale, outerscale);
    }

    protected void updateShapes(double radius, double xcentre, double ycentre) {
        this.centreEllipse(this.aperture, radius, xcentre, ycentre);
        this.centreEllipse(this.inner, radius * this.innerscale, xcentre, ycentre);
        this.centreEllipse(this.outer, radius * this.outerscale, xcentre, ycentre);
        this.mainArea.reset();
        if (this.invert) {
            this.mainArea.add(new Area(this.outer));
            this.centreEllipse(this.outer, radius * this.outerscale * 0.999, xcentre, ycentre);
            this.mainArea.subtract(new Area(this.outer));
            this.mainArea.add(new Area(this.inner));
            this.mainArea.subtract(new Area(this.aperture));
        } else {
            this.mainArea.add(new Area(this.outer));
            this.mainArea.subtract(new Area(this.inner));
            this.mainArea.add(new Area(this.aperture));
        }
    }

    protected void updateShapes() {
        this.updateShapes(this.getRadius(), this.aperture.getCenterX(), this.aperture.getCenterY());
    }

    protected void updateShapes(double radius) {
        this.updateShapes(radius, this.aperture.getCenterX(), this.aperture.getCenterY());
    }

    protected void updateShapes(double xcentre, double ycentre) {
        this.updateShapes(this.getRadius(), xcentre, ycentre);
    }

    protected void centreEllipse(Ellipse2D.Double ell, double radius, double xcentre, double ycentre) {
        double xo = xcentre - radius;
        double yo = ycentre - radius;
        double dr = radius * 2.0;
        ell.setFrame(xo, yo, dr, dr);
    }

    public void setValues(double radius, double xcentre, double ycentre, double innerscale, double outerscale) {
        this.innerscale = innerscale;
        this.outerscale = outerscale;
        this.updateShapes(radius, xcentre, ycentre);
    }

    public void setPosition(Point2D.Double pt) {
        this.updateShapes(pt.x, pt.y);
    }

    public void setPosition(double xcentre, double ycentre) {
        this.updateShapes(xcentre, ycentre);
    }

    public Point2D.Double getPosition() {
        return new Point2D.Double(this.aperture.getCenterX(), this.aperture.getCenterY());
    }

    public double getRadius() {
        return 0.5 * this.aperture.width;
    }

    public void setRadius(double radius) {
        this.updateShapes(radius);
    }

    public double getInnerscale() {
        return this.innerscale;
    }

    public void setInnerscale(double innerscale) {
        this.innerscale = innerscale;
        this.updateShapes();
    }

    public double getOuterscale() {
        return this.outerscale;
    }

    public void setOuterscale(double outerscale) {
        this.outerscale = outerscale;
        this.updateShapes();
    }

    public void setInverted(boolean invert) {
        this.invert = invert;
    }

    public boolean getInverted() {
        return this.invert;
    }

    public void transform(AffineTransform at) {
        this.srcPts[0] = this.aperture.getCenterX();
        this.srcPts[1] = this.aperture.getCenterY();
        double radius = this.getRadius();
        this.srcPts[2] = this.srcPts[0] + radius;
        this.srcPts[3] = this.srcPts[1] + radius;
        at.transform(this.srcPts, 0, this.dstPts, 0, 2);
        this.updateShapes(this.dstPts[2] - this.dstPts[0], this.dstPts[0], this.dstPts[1]);
    }

    public void translate(double x, double y) {
        this.updateShapes(this.aperture.getCenterX() + x, this.aperture.getCenterY() + y);
    }

    public Rectangle getBounds() {
        return this.mainArea.getBounds();
    }

    public Rectangle2D getBounds2D() {
        return this.mainArea.getBounds2D();
    }

    public boolean contains(double x, double y) {
        return this.mainArea.contains(x, y);
    }

    public boolean contains(Point2D p) {
        return this.mainArea.contains(p);
    }

    public boolean intersects(double x, double y, double w, double h) {
        return this.mainArea.intersects(x, y, w, h);
    }

    public boolean intersects(Rectangle2D r) {
        return this.mainArea.intersects(r);
    }

    public boolean contains(double x, double y, double w, double h) {
        return this.mainArea.contains(x, y, w, h);
    }

    public boolean contains(Rectangle2D r) {
        return this.mainArea.contains(r);
    }

    public PathIterator getPathIterator(AffineTransform at) {
        return this.mainArea.getPathIterator(at);
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.mainArea.getPathIterator(at, flatness);
    }
}

