/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.sog.photom;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import org.w3c.dom.Element;
import uk.ac.starlink.sog.photom.BasePhotom;
import uk.ac.starlink.sog.photom.PhotomEncoderAndDecoder;
import uk.ac.starlink.util.PrimitiveXMLEncodeDecode;

public class PhotomList
extends PrimitiveXMLEncodeDecode
implements ChangeListener {
    private int index = -1;
    private ArrayList list = new ArrayList();
    private Class theClass = null;
    private boolean building = false;
    protected EventListenerList listeners = new EventListenerList();
    static /* synthetic */ Class class$javax$swing$event$ChangeListener;

    protected int add(BasePhotom basePhotom) {
        ++this.index;
        this.list.add(this.index, basePhotom);
        if (this.theClass == null) {
            this.theClass = basePhotom.getClass();
        } else if (!this.theClass.getName().equals(basePhotom.getClass().getName())) {
            throw new ArrayStoreException("Attempt to store photometry object of differing class");
        }
        basePhotom.addChangeListener(this);
        this.setCurrent(this.index);
        this.fireChanged();
        return this.index;
    }

    public void add(Collection list) {
        Iterator i = list.iterator();
        this.building = true;
        while (i.hasNext()) {
            this.add((BasePhotom)i.next());
        }
        this.enableChangeListeners();
        this.building = false;
        this.fireChanged();
    }

    protected void enableChangeListeners() {
        int size = this.list.size();
        if (size > 0) {
            int i = 0;
            while (i < size) {
                BasePhotom current = (BasePhotom)this.list.get(i);
                current.removeChangeListener(this);
                current.addChangeListener(this);
                ++i;
            }
        }
    }

    protected void disableChangeListeners() {
        int size = this.list.size();
        if (size > 0) {
            int i = 0;
            while (i < size) {
                BasePhotom current = (BasePhotom)this.list.get(i);
                current.removeChangeListener(this);
                ++i;
            }
        }
    }

    public boolean remove(BasePhotom basePhotom) {
        int index = this.list.indexOf(basePhotom);
        if (index == -1) {
            return false;
        }
        return this.remove(index);
    }

    public boolean remove(int index) {
        try {
            this.list.remove(index);
        }
        catch (Exception e) {
            return false;
        }
        if (this.index == index) {
            this.index = -1;
        }
        this.fireChanged();
        return true;
    }

    public int size() {
        return this.list.size();
    }

    public void setCurrent(int index) {
        int oldindex = this.index;
        this.index = index < 0 ? 0 : (index > this.list.size() ? this.list.size() - 1 : index);
        if (index != oldindex) {
            this.fireChanged();
        }
    }

    public BasePhotom getCurrent() {
        if (this.index != -1 && this.index < this.list.size()) {
            return (BasePhotom)this.list.get(this.index);
        }
        return null;
    }

    public BasePhotom get(int index) {
        return (BasePhotom)this.list.get(index);
    }

    public int indexOf(Object object) {
        return this.list.indexOf(object);
    }

    public int getRowCount() {
        return this.size();
    }

    public int getColumnCount() {
        if (this.size() == 0) {
            return BasePhotom.getNumberValues();
        }
        return this.get(0).getSpecificNumberValues();
    }

    public Object getValueAt(int row, int column) {
        BasePhotom basePhotom = this.get(row);
        return basePhotom.getValue(column);
    }

    public String getColumnName(int index) {
        if (this.size() == 0) {
            return BasePhotom.getDescription(index);
        }
        return this.get(0).getSpecificDescription(index);
    }

    public void addChangeListener(ChangeListener l) {
        this.listeners.add(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = PhotomList.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listeners.remove(class$javax$swing$event$ChangeListener == null ? (class$javax$swing$event$ChangeListener = PhotomList.class$("javax.swing.event.ChangeListener")) : class$javax$swing$event$ChangeListener, l);
    }

    protected void fireChanged() {
        if (!this.building) {
            Object[] la = this.listeners.getListenerList();
            ChangeEvent e = null;
            int i = la.length - 2;
            while (i >= 0) {
                if (la[i] == (class$javax$swing$event$ChangeListener == null ? PhotomList.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) {
                    if (e == null) {
                        e = new ChangeEvent(this);
                    }
                    ((ChangeListener)la[i + 1]).stateChanged(e);
                }
                i -= 2;
            }
        }
    }

    public void write(File file) {
        try {
            PhotomEncoderAndDecoder.save(this, file);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void read(File file) {
        if (file.exists() && file.canRead()) {
            ArrayList oldList = this.list;
            int oldIndex = this.index;
            this.list = new ArrayList();
            this.index = -1;
            this.building = true;
            try {
                PhotomEncoderAndDecoder.read(file, this);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.list = oldList;
                this.index = oldIndex;
            }
            oldList = null;
            this.building = false;
            this.fireChanged();
        }
    }

    public void encode(Element rootElement) {
        int size = this.list.size();
        if (size > 0) {
            PrimitiveXMLEncodeDecode.addChildElement((Element)rootElement, (String)"class", (String)this.theClass.getName());
            Element localRoot = PrimitiveXMLEncodeDecode.addChildElement((Element)rootElement, (String)"list");
            int i = 0;
            while (i < size) {
                BasePhotom current = (BasePhotom)this.list.get(i);
                current.encode(PrimitiveXMLEncodeDecode.addChildElement((Element)localRoot, (String)current.getTagName()));
                ++i;
            }
        }
    }

    public void decode(Element rootElement) {
        List children = PrimitiveXMLEncodeDecode.getChildElements((Element)rootElement);
        int size = children.size();
        Element element = null;
        Element classElement = null;
        Element listElement = null;
        String name = null;
        int i = 0;
        while (i < size) {
            element = (Element)children.get(i);
            name = PrimitiveXMLEncodeDecode.getElementName((Element)element);
            if (name.equals("class")) {
                classElement = element;
            } else if (name.equals("list")) {
                listElement = element;
            }
            ++i;
        }
        if (classElement == null) {
            throw new IllegalArgumentException("no class definition in PhotomList root element");
        }
        if (listElement == null) {
            throw new IllegalArgumentException("no objects defined in PhotomList root element");
        }
        try {
            this.getClass();
            this.theClass = Class.forName(PrimitiveXMLEncodeDecode.getElementValue(classElement));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Cannot find class: " + PrimitiveXMLEncodeDecode.getElementValue((Element)classElement));
        }
        children = PrimitiveXMLEncodeDecode.getChildElements(listElement);
        size = children.size();
        if (size > 0) {
            BasePhotom basePhotom = null;
            try {
                basePhotom = (BasePhotom)this.theClass.newInstance();
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Cannot create instances of class: " + PrimitiveXMLEncodeDecode.getElementValue((Element)element));
            }
            this.list = new ArrayList();
            this.index = -1;
            BasePhotom copy = null;
            this.building = true;
            int i2 = 0;
            while (i2 < size) {
                element = (Element)children.get(i2);
                copy = (BasePhotom)basePhotom.clone();
                copy.decode(element);
                this.add(copy);
                ++i2;
            }
            this.building = false;
            this.fireChanged();
        }
    }

    public void setFromString(String name, String value) {
    }

    public String getTagName() {
        return "photomlist";
    }

    public void stateChanged(ChangeEvent e) {
        this.fireChanged();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

