/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.sog.photom;

import java.net.MalformedURLException;
import java.net.URL;
import java.rmi.RemoteException;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.ServiceException;
import javax.xml.transform.TransformerException;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.XMLType;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import uk.ac.starlink.ndx.Ndx;
import uk.ac.starlink.sog.photom.AperturePhotometry;
import uk.ac.starlink.sog.photom.PhotomList;
import uk.ac.starlink.sog.photom.PhotometryGlobals;
import uk.ac.starlink.util.SourceReader;

public class PhotometryWorker {
    private static URL endpoint = null;
    private static String defaultEndpoint = "http://localhost:8083/services/PhotomWSServices";

    public PhotometryWorker() {
        this.establishEndpoint();
    }

    protected void establishEndpoint() {
        block5: {
            String userEndpoint = System.getProperty("photom.webservice");
            endpoint = null;
            if (userEndpoint != null) {
                try {
                    endpoint = new URL(userEndpoint);
                }
                catch (MalformedURLException e) {
                    e.printStackTrace();
                    endpoint = null;
                }
            }
            if (endpoint != null) break block5;
            try {
                endpoint = new URL(defaultEndpoint);
            }
            catch (MalformedURLException e) {}
        }
    }

    public void calculate(Ndx ndx, PhotomList photomList, PhotometryGlobals globals, AperturePhotometry aperturePhotometry) throws ServiceException {
        Element ndxElement;
        if (!ndx.isPersistent()) {
            throw new ServiceException("Virtual NDX " + ndx + " cannot be displayed externally");
        }
        try {
            ndxElement = (Element)new SourceReader().getDOM(ndx.toXML(null));
        }
        catch (TransformerException e) {
            throw new ServiceException("Error getting XML from NDX", (Throwable)e);
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (Exception e) {
            throw new ServiceException("Error converting PhotomList to XML", (Throwable)e);
        }
        Document document = builder.newDocument();
        Element photomListElement = document.createElement(photomList.getTagName());
        photomList.encode(photomListElement);
        Element globalsElement = document.createElement(globals.getTagName());
        globals.encode(globalsElement);
        Service service = new Service();
        Call call = (Call)service.createCall();
        call.setTargetEndpointAddress(endpoint);
        call.setOperationName("autophotom");
        call.addParameter("ndx", XMLType.SOAP_ELEMENT, ParameterMode.IN);
        call.addParameter("photomlist", XMLType.SOAP_ELEMENT, ParameterMode.IN);
        call.addParameter("globals", XMLType.SOAP_ELEMENT, ParameterMode.IN);
        call.setReturnType(XMLType.SOAP_ELEMENT);
        Object[] args = new Object[]{ndxElement, photomListElement, globalsElement};
        try {
            Element result = (Element)call.invoke(args);
            photomList.decode(result);
            aperturePhotometry.calculationsDone();
        }
        catch (RemoteException e) {
            throw new ServiceException("Failed to invoke photometry service: " + e.getCause().getMessage(), e.getCause());
        }
    }
}

