/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.astrogrid;

import java.io.IOException;
import java.util.Map;
import org.astrogrid.community.common.security.data.SecurityToken;
import org.astrogrid.store.Ivorn;
import org.astrogrid.store.tree.TreeClient;
import org.astrogrid.store.tree.TreeClientException;
import uk.ac.starlink.astrogrid.MyspaceBranch;
import uk.ac.starlink.connect.Branch;
import uk.ac.starlink.connect.Connection;
import uk.ac.starlink.connect.Connector;

class TreeClientConnection
extends Connection {
    private final TreeClient tc_;
    private final Branch root_;

    public TreeClientConnection(Connector connector, Map authValues, TreeClient tc, final Ivorn ivorn) throws TreeClientException {
        super(connector, authValues);
        this.tc_ = tc;
        this.root_ = new MyspaceBranch(this.tc_.getRoot()){

            public String toString() {
                return ivorn.toString();
            }
        };
        this.setLogoutOnExit(true);
    }

    public void logOut() throws IOException {
        try {
            this.tc_.logout();
        }
        catch (TreeClientException e) {
            throw (IOException)new IOException(e.getMessage()).initCause(e);
        }
    }

    public boolean isConnected() {
        SecurityToken token = this.tc_.getToken();
        return token == null ? false : token.isValid();
    }

    public Branch getRoot() {
        return this.root_;
    }
}

