/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.astrogrid;

import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.astrogrid.community.common.exception.CommunityException;
import org.astrogrid.community.common.ivorn.CommunityAccountIvornFactory;
import org.astrogrid.store.Ivorn;
import org.astrogrid.store.tree.TreeClient;
import org.astrogrid.store.tree.TreeClientException;
import org.astrogrid.store.tree.TreeClientFactory;
import uk.ac.starlink.astrogrid.TreeClientConnection;
import uk.ac.starlink.connect.AuthKey;
import uk.ac.starlink.connect.Connection;
import uk.ac.starlink.connect.Connector;
import uk.ac.starlink.util.Loader;

public class TreeClientConnector
implements Connector {
    public static final String USER_PROPERTY = "user.name";
    public static final String COMMUNITY_PROPERTY = "org.astrogrid.community.ident";
    public static final String REGISTRY_PROPERTY = "org.astrogrid.registry.query.endpoint";
    private static Icon icon_;
    private static Logger logger_;
    private static final AuthKey REGISTRY_KEY;
    private static final AuthKey COMMUNITY_KEY;
    private static final AuthKey USER_KEY;
    private static final AuthKey PASSWORD_KEY;
    private static final AuthKey[] AUTH_KEYS;

    public String getName() {
        return "MySpace";
    }

    public AuthKey[] getKeys() {
        return (AuthKey[])AUTH_KEYS.clone();
    }

    public Icon getIcon() {
        URL url;
        if (icon_ == null && (url = this.getClass().getResource("AGlogo.gif")) != null) {
            icon_ = new ImageIcon(url);
        }
        return icon_;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Connection logIn(Map authValues) throws IOException {
        TreeClientConnection treeClientConnection;
        TreeClient tc;
        try {
            tc = new TreeClientFactory().createClient();
        }
        catch (Throwable th) {
            throw (IOException)new IOException("Required classes not present").initCause(th);
        }
        String community = (String)authValues.get(COMMUNITY_KEY);
        String user = (String)authValues.get(USER_KEY);
        char[] password = (char[])authValues.get(PASSWORD_KEY);
        try {
            try {
                Ivorn ivorn = TreeClientConnector.getIvorn(community, user);
                tc.login(ivorn, password == null ? "" : new String(password));
                treeClientConnection = new TreeClientConnection(this, authValues, tc, ivorn);
                Object var9_11 = null;
                if (password == null) return treeClientConnection;
            }
            catch (TreeClientException e) {
                throw (IOException)new IOException(e.getMessage()).initCause(e);
            }
            catch (CommunityException e) {
                throw (IOException)new IOException(e.getMessage()).initCause(e);
            }
        }
        catch (Throwable throwable) {
            Object var9_12 = null;
            if (password == null) throw throwable;
            Arrays.fill(password, ' ');
            throw throwable;
        }
        Arrays.fill(password, ' ');
        return treeClientConnection;
    }

    public static Ivorn getIvorn(String community, String user) throws CommunityException {
        return CommunityAccountIvornFactory.createIvorn((String)community, (String)user);
    }

    static {
        logger_ = Logger.getLogger("uk.ac.starlink.astrogrid");
        REGISTRY_KEY = new AuthKey("Registry");
        COMMUNITY_KEY = new AuthKey("Community");
        USER_KEY = new AuthKey("User");
        PASSWORD_KEY = new AuthKey("Password");
        AUTH_KEYS = new AuthKey[]{REGISTRY_KEY, COMMUNITY_KEY, USER_KEY, PASSWORD_KEY};
        PASSWORD_KEY.setHidden(true);
        REGISTRY_KEY.setRequired(true);
        try {
            Loader.loadProperties();
            USER_KEY.setDefault(System.getProperty(USER_PROPERTY));
            COMMUNITY_KEY.setDefault(System.getProperty(COMMUNITY_PROPERTY));
            REGISTRY_KEY.setDefault(System.getProperty(REGISTRY_PROPERTY));
        }
        catch (SecurityException e) {
            logger_.info("Security manager blocks reading default AG login fields");
        }
        if (REGISTRY_KEY.getDefault() == null) {
            REGISTRY_KEY.setDefault("http://grendel02.roe.ac.uk:8080/astrogrid-registry-SNAPSHOT/services/RegistryQuery");
        }
    }
}

